/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import java.util.Arrays;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMXMBeanAttributeEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMXMBeanAttributeEvent.class);
    static final long serialVersionUID = 2762124106750886602L;

    public JMXMBeanAttributeEvent() {
        this.set("eventName", "JMX_MBEAN_ATTRIBUTES");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMXMBeanAttributeEvent(ObjectName name, Object attrs, String action, String outcome, String reason) {
        block19: {
            this();
            try {
                if (name != null) {
                    this.set("target.jmx.mbean.name", name.toString());
                }
                if (action != null) {
                    if (action.equals("setAttribute") || action.equals("getAttribute")) {
                        this.set("target.jmx.mbean.attribute.name", attrs.toString());
                    } else if (action.equals("setAttributes") || action.equals("getAttributes")) {
                        StringBuffer buf = new StringBuffer();
                        AttributeList al = (AttributeList)attrs;
                        for (int i = 0; i < al.size(); ++i) {
                            if (((Attribute)al.get(i)).getValue() == null || ((Attribute)al.get(i)).getValue().getClass() == null) continue;
                            if (((Attribute)al.get(i)).getValue().getClass().isArray()) {
                                buf.append("[").append(((Attribute)al.get(i)).getName()).append(" = ");
                                if (((Attribute)al.get(i)).getValue() instanceof long[]) {
                                    buf.append("[").append(Arrays.toString((long[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof boolean[]) {
                                    buf.append("[").append(Arrays.toString((boolean[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof byte[]) {
                                    buf.append("[").append(Arrays.toString((byte[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof int[]) {
                                    buf.append("[").append(Arrays.toString((int[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof short[]) {
                                    buf.append("[").append(Arrays.toString((short[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof char[]) {
                                    buf.append("[").append(Arrays.toString((char[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof float[]) {
                                    buf.append("[").append(Arrays.toString((float[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (((Attribute)al.get(i)).getValue() instanceof double[]) {
                                    buf.append("[").append(Arrays.toString((double[])((Attribute)al.get(i)).getValue())).append("]");
                                    continue;
                                }
                                if (!(((Attribute)al.get(i)).getValue() instanceof Object[])) continue;
                                buf.append("[").append(this.unravelArray(buf, ((Attribute)al.get(i)).getValue())).append("]");
                                continue;
                            }
                            buf.append("[").append(((Attribute)al.get(i)).getName()).append(" = ").append(((Attribute)al.get(i)).getValue()).append("]");
                        }
                        this.set("target.jmx.mbean.attribute.names", buf.toString());
                    }
                    this.set("target.jmx.mbean.action", action);
                }
                this.set("observer.name", "JMXService");
                this.set("target.typeURI", "server/mbean");
                this.set("target.realm", AuditUtils.getRealmName());
                if (outcome.equals("success")) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", 200);
                    this.set("reason.reasonType", reason);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", 201);
                    this.set("reason.reasonType", reason);
                }
            }
            catch (Exception buf) {
                void e;
                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.security.audit.event.JMXMBeanAttributeEvent", (String)"104", (Object)((Object)this), (Object[])new Object[]{name, attrs, action, outcome, reason});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMXMBeanAttributeEvent", (Object[])new Object[]{e});
            }
        }
    }

    public StringBuffer unravelArray(StringBuffer buf, Object param) {
        if (param instanceof long[]) {
            buf.append("[").append(Arrays.toString((long[])param)).append("]");
        } else if (param instanceof boolean[]) {
            buf.append("[").append(Arrays.toString((boolean[])param)).append("]");
        } else if (param instanceof int[]) {
            buf.append("[").append(Arrays.toString((int[])param)).append("]");
        } else if (param instanceof byte[]) {
            buf.append("[").append(Arrays.toString((byte[])param)).append("]");
        } else if (param instanceof short[]) {
            buf.append("[").append(Arrays.toString((short[])param)).append("]");
        } else if (param instanceof char[]) {
            buf.append("[").append(Arrays.toString((char[])param)).append("]");
        } else if (param instanceof float[]) {
            buf.append("[").append(Arrays.toString((float[])param)).append("]");
        } else if (param instanceof double[]) {
            buf.append("[").append(Arrays.toString((double[])param)).append("]");
        } else if (param instanceof Object[]) {
            buf.append("[").append(this.unravelArray(buf, param)).append("]");
        }
        return buf;
    }
}

