/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAFAuthorizationDetailsEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationDetailsEvent.class);
    static final long serialVersionUID = -4250365223524019545L;

    public SAFAuthorizationDetailsEvent() {
        this.set("eventName", "SECURITY_SAF_AUTHZ_DETAILS");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    public SAFAuthorizationDetailsEvent(int safReturnCode, int racfReturnCode, int racfReasonCode, String userSecurityName, String applid, String safProfile, String safClass, Boolean authDecision, String principalName) {
        this();
        AuditEvent.STD_TARGET.remove("target.typeURI");
        this.set("target.saf.return.code", safReturnCode);
        this.set("target.racf.return.code", racfReturnCode);
        this.set("target.racf.reason.code", racfReasonCode);
        if (userSecurityName != null) {
            this.set("target.user.security.name", userSecurityName);
        }
        if (applid != null) {
            this.set("target.applid", applid);
        }
        if (safProfile != null) {
            this.set("target.saf.profile", safProfile);
        }
        if (safClass != null) {
            this.set("target.saf.class", safClass);
        }
        if (authDecision != null) {
            if (authDecision.booleanValue()) {
                this.set("outcome", "success");
                this.set("target.authorization.decision", true);
            } else {
                this.set("outcome", "failure");
                this.set("target.authorization.decision", false);
            }
        }
        if (principalName != null) {
            this.set("target.credential.token", principalName);
        }
    }
}

