/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.streams.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;

@Dependent
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ReactiveStreamsEngineProducer {
    private static final TraceComponent tc = Tr.register(ReactiveStreamsEngineProducer.class);
    static final long serialVersionUID = -5655643793027204172L;

    @Produces
    @ApplicationScoped
    public ReactiveStreamsEngine getEngine() {
        Iterator<ReactiveStreamsEngine> engines = ServiceLoader.load(ReactiveStreamsEngine.class).iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Engines has next came out at " + engines.hasNext()), (Object[])new Object[0]);
        }
        if (engines.hasNext()) {
            return engines.next();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"Unable to ServiceLoad ReactiveStreamsEngine from Producer.", (Object[])new Object[0]));
    }

    public void closeReactiveStreamsEngine(@Disposes ReactiveStreamsEngine context) {
    }
}

