/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.util.concurrent.CountDownLatch;

public class H2WriteQEntry {
    private static final TraceComponent tc = Tr.register(H2WriteQEntry.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    WsByteBuffer buf = null;
    WsByteBuffer[] bufs = null;
    long minToWrite;
    int timeout;
    int priority = 0;
    FrameTypes frameType = FrameTypes.UNKNOWN;
    int payloadLength = 0;
    CountDownLatch writeCompleteLatch = null;
    boolean servicedOnQ = true;
    int streamID = 0;

    public H2WriteQEntry(WsByteBuffer inBuf, WsByteBuffer[] inBufs, long inMin, int inTimeout, FrameTypes fType, int inPayloadLength, int inStreamID) {
        this.buf = inBuf;
        this.bufs = inBufs;
        this.minToWrite = inMin;
        this.timeout = inTimeout;
        this.frameType = fType;
        this.payloadLength = inPayloadLength;
        this.streamID = inStreamID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("H2WriteQEntry constructor for entry: " + this.hashCode()), (Object[])new Object[0]);
        }
    }

    public void armWriteCompleteLatch() {
        this.writeCompleteLatch = new CountDownLatch(1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch armed: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
        }
    }

    public void waitWriteCompleteLatch() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch await: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
            }
            this.writeCompleteLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void hitWriteCompleteLatch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch hit countDown: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
        }
        this.writeCompleteLatch.countDown();
    }

    public boolean getServicedOnQ() {
        return this.servicedOnQ;
    }

    public void setServicedOnQ(boolean x) {
        this.servicedOnQ = x;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int x) {
        this.priority = x;
    }

    public WsByteBuffer getBuffer() {
        return this.buf;
    }

    public WsByteBuffer[] getBuffers() {
        return this.bufs;
    }

    public long getMinToWrite() {
        return this.minToWrite;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getStreamID() {
        return this.streamID;
    }

    public FrameTypes getFrameType() {
        return this.frameType;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }
}

