/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BundleInstallOriginBundleListener
implements BundleListener,
Callable<Void> {
    private static final TraceComponent tc = Tr.register(BundleInstallOriginBundleListener.class);
    private static final String storagePath = "bundle.origin.cache";
    private final Bundle featureManager;
    private final BundleContext ctx;
    private final File bundleOriginCache;
    private volatile ConcurrentHashMap<String, Set<String>> bundleOrigins = new ConcurrentHashMap();
    private ScheduledFuture<?> futurePurge = null;
    private final int purgeDelay = 5;
    static final long serialVersionUID = -8573035903904486631L;

    BundleInstallOriginBundleListener(BundleContext ctx) {
        this.ctx = ctx;
        this.featureManager = ctx.getBundle();
        this.bundleOriginCache = this.featureManager.getDataFile(storagePath);
        this.bundleOrigins = this.loadCacheFromDisk(true);
        this.delayPurge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private synchronized ConcurrentHashMap<String, Set<String>> loadCacheFromDisk(boolean newInstance) {
        ConcurrentHashMap loadedOrigins = new ConcurrentHashMap();
        if (this.bundleOriginCache != null && this.bundleOriginCache.exists()) {
            this.debug("Found existing bundle origin cache", this.bundleOriginCache.toString(), this.bundleOriginCache);
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(this.bundleOriginCache);
                ois = new ObjectInputStream(fis);
                loadedOrigins = (ConcurrentHashMap)ois.readObject();
                this.debug("Repopulated origins cache from disk", loadedOrigins);
                if (newInstance) {
                    HashSet<String> installerBundlesToRemove = new HashSet<String>();
                    for (Map.Entry bundleOriginEntry : loadedOrigins.entrySet()) {
                        String installerBundleLocation = (String)bundleOriginEntry.getKey();
                        Bundle installerBundle = this.ctx.getBundle(installerBundleLocation);
                        if (installerBundle != null) continue;
                        this.debug("Installer bundle has been removed", installerBundleLocation);
                        installerBundlesToRemove.add(installerBundleLocation);
                    }
                    for (String installerBundleLocation : installerBundlesToRemove) {
                        this.processUninstalledInstallerBundle(installerBundleLocation);
                    }
                }
            }
            catch (FileNotFoundException installerBundlesToRemove) {
                FFDCFilter.processException((Throwable)installerBundlesToRemove, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"127", (Object)this, (Object[])new Object[]{newInstance});
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"118", (Object[])new Object[]{this.bundleOriginCache});
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"132", (Object)this, (Object[])new Object[]{newInstance});
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException installerBundlesToRemove) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException installerBundlesToRemove) {}
                }
            }
        }
        return loadedOrigins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheIfPurged() {
        if (this.bundleOrigins == null) {
            BundleInstallOriginBundleListener bundleInstallOriginBundleListener = this;
            synchronized (bundleInstallOriginBundleListener) {
                if (this.bundleOrigins == null) {
                    this.bundleOrigins = this.loadCacheFromDisk(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public void bundleChanged(BundleEvent event) {
        boolean store = false;
        switch (event.getType()) {
            case 1: {
                Bundle installerBundle = event.getOrigin();
                if (this.featureManager.equals(installerBundle)) break;
                this.loadCacheIfPurged();
                String installingBundleSN = installerBundle.getLocation();
                Set installeeBundles = Collections.synchronizedSet(new HashSet());
                Set<String> existingInstalleeBundles = this.bundleOrigins.putIfAbsent(installingBundleSN, installeeBundles);
                if (existingInstalleeBundles == null) {
                    existingInstalleeBundles = installeeBundles;
                }
                existingInstalleeBundles.add(event.getBundle().getLocation());
                store = true;
                this.delayPurge();
                break;
            }
            case 16: {
                this.loadCacheIfPurged();
                Bundle uninstalledBundle = event.getBundle();
                store = this.processUninstalledInstallerBundle(uninstalledBundle.getLocation());
                this.delayPurge();
                break;
            }
        }
        if (store) {
            File file = this.bundleOriginCache;
            synchronized (file) {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    boolean created = this.bundleOriginCache.createNewFile();
                    if (created || this.bundleOriginCache.exists()) {
                        fos = new FileOutputStream(this.bundleOriginCache);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(this.bundleOrigins);
                    }
                }
                catch (FileNotFoundException created) {
                    FFDCFilter.processException((Throwable)created, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"215", (Object)this, (Object[])new Object[]{event});
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"201", (Object[])new Object[]{this.bundleOrigins, this.bundleOriginCache});
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException created) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException created) {}
                    }
                }
            }
        }
    }

    private boolean processUninstalledInstallerBundle(String installerBundleLocation) {
        Set<String> bundleLocationsToUninstall = this.bundleOrigins.remove(installerBundleLocation);
        if (bundleLocationsToUninstall != null) {
            this.debug("Installer bundle at location {0} had installees that need to be uninstalled", installerBundleLocation);
            Set<String> unsuccessfulUninstallLocations = this.uninstallInstalleeBundles(bundleLocationsToUninstall);
            if (!unsuccessfulUninstallLocations.isEmpty()) {
                this.bundleOrigins.put(installerBundleLocation, unsuccessfulUninstallLocations);
                this.debug("Not all installees were removed", unsuccessfulUninstallLocations);
            }
            return true;
        }
        return false;
    }

    private Set<String> uninstallInstalleeBundles(Set<String> installeeBundleLocationsToUninstall) {
        HashSet<String> unsuccessfulUninstallLocations = new HashSet<String>();
        for (String installeeBundleLocation : installeeBundleLocationsToUninstall) {
            Bundle installeeBundleToUninstall = this.ctx.getBundle(installeeBundleLocation);
            if (installeeBundleToUninstall == null) continue;
            try {
                installeeBundleToUninstall.uninstall();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"281", (Object)this, (Object[])new Object[]{installeeBundleLocationsToUninstall});
                unsuccessfulUninstallLocations.add(installeeBundleLocation);
                BundleStartLevel bsl = (BundleStartLevel)installeeBundleToUninstall.adapt(BundleStartLevel.class);
                bsl.setStartLevel(Integer.MAX_VALUE);
            }
        }
        return unsuccessfulUninstallLocations;
    }

    private void debug(String msg, Object ... objs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)msg, (Object[])objs);
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void delayPurge() {
        ServiceReference sesRef;
        if (FrameworkState.isStopping()) {
            return;
        }
        if (this.futurePurge != null) {
            this.futurePurge.cancel(false);
        }
        if ((sesRef = this.ctx.getServiceReference(ScheduledExecutorService.class)) != null) {
            try {
                ScheduledExecutorService executorService = (ScheduledExecutorService)this.ctx.getService(sesRef);
                this.futurePurge = executorService.schedule(this, 5L, TimeUnit.MINUTES);
            }
            catch (Throwable throwable) {
                block11: {
                    try {
                        this.ctx.ungetService(sesRef);
                    }
                    catch (IllegalStateException e) {
                        if (!tc.isEventEnabled()) break block11;
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException while releasing ServiceReference<ScheduledExecutorService> sesRef - the bundle is stopped or in an otherwise invalid so we shouldn't care", (Object[])new Object[]{e});
                    }
                }
                throw throwable;
            }
            try {
                this.ctx.ungetService(sesRef);
            }
            catch (IllegalStateException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"IllegalStateException while releasing ServiceReference<ScheduledExecutorService> sesRef - the bundle is stopped or in an otherwise invalid so we shouldn't care", (Object[])new Object[]{e});
                }
            }
        }
    }

    @Override
    public synchronized Void call() throws Exception {
        this.futurePurge = null;
        this.bundleOrigins = null;
        return null;
    }
}

