/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ApiRegion;
import com.ibm.ws.kernel.feature.internal.BundleInstallStatus;
import com.ibm.ws.kernel.feature.internal.BundleLifecycleStatus;
import com.ibm.ws.kernel.feature.internal.BundleList;
import com.ibm.ws.kernel.feature.internal.FeatureManager;
import com.ibm.ws.kernel.feature.internal.PackageInspectorImpl;
import com.ibm.ws.kernel.feature.internal.RefreshBundlesListener;
import com.ibm.ws.kernel.feature.internal.ShutdownHookManager;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.LibertyBootRuntime;
import com.ibm.ws.kernel.provisioning.packages.SharedPackageInspector;
import com.ibm.ws.kernel.service.util.ResolutionReportHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Provisioner {
    private static final TraceComponent tc = Tr.register(Provisioner.class);
    private static final String BUNDLE_LOC_FEATURE_TAG = "feature@";
    static final String BUNDLE_LOC_REFERENCE_TAG = "reference:";
    private final String BUNDLE_LOC_FILE_REFERENCE_TAG = "reference:file:";
    private static final String BUNDLE_LOC_PROD_EXT_TAG = "productExtension:";
    private static final String REGION_EXTENSION_PREFIX = "liberty.extension.";
    private static final String REGION_PRODUCT_HUB = "liberty.product.api.spi.hub";
    private static final Pattern INVALID_REGION_CHARS = Pattern.compile("[:=\\n*?\"\\\\]");
    private static final String COMMON_ALL_NAMESPACE_FILTER = "(!(|(org.eclipse.equinox.allow.all.namespace=osgi.wiring.package)(org.eclipse.equinox.allow.all.namespace=osgi.wiring.bundle)(org.eclipse.equinox.allow.all.namespace=osgi.wiring.host)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle.lifecycle)))";
    private static final String COMMON_OSGI_APPS_ALL_NAMESPACE_FILTER = "(!(|(org.eclipse.equinox.allow.all.namespace=osgi.wiring.package)(org.eclipse.equinox.allow.all.namespace=osgi.wiring.bundle)(org.eclipse.equinox.allow.all.namespace=osgi.wiring.host)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle.lifecycle)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.service)(org.eclipse.equinox.allow.all.namespace=osgi.service)))";
    private static final String[] COMMON_OSGI_APPS_SERVICE_REQUIREMENTS = new String[]{"(objectClass=javax.transaction.TransactionSynchronizationRegistry)", "(objectClass=javax.transaction.UserTransaction)", "(osgi.jndi.url.scheme=*)", "(osgi.jndi.service.name=*)"};
    private static final String COMMON_BUNDLE_NAMESPACE_FILTER = "(|(osgi.wiring.bundle=system.bundle)(osgi.wiring.bundle=org.eclipse.osgi))";
    private static final String PACKAGE_AND_BUNDLE_FILTER = "(!(|(org.eclipse.equinox.allow.all.namespace=osgi.wiring.package)(org.eclipse.equinox.allow.all.namespace=org.eclipse.equinox.allow.bundle)))";
    private static final String THREAD_CONTEXT_FILTER = "(thread-context=true)";
    private static final String REGION_KERNEL = "org.eclipse.equinox.region.kernel";
    private final FeatureManager featureManager;
    private final Region kernelRegion;
    private final Set<String> apiPackagesToIgnore;
    private final Field dynamicMissRefField;
    private final boolean libertyBoot;
    static final long serialVersionUID = -4883058022030021136L;

    /*
     * WARNING - void declaration
     */
    public Provisioner(FeatureManager mgr, Set<String> apiPackagesToIgnore) throws IllegalStateException {
        this.featureManager = mgr;
        final RegionDigraph original = mgr.getDigraph();
        Region systemRegion = original.getRegion(mgr.bundleContext.getBundle("System Bundle"));
        if ("system.bundle".equals(systemRegion.getName()) && systemRegion.getBundleIds().size() > 1) {
            try {
                ApiRegion.update(this.featureManager.getDigraph(), new Callable<RegionDigraph>(){
                    static final long serialVersionUID = 6001948132838794864L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public RegionDigraph call() throws Exception {
                        RegionDigraph copy;
                        try {
                            copy = original.copy();
                        }
                        catch (BundleException bundleException) {
                            void e;
                            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner$1", (String)"184", (Object)this, (Object[])new Object[0]);
                            throw e;
                        }
                        Region fromSystemRegion = copy.getRegion("system.bundle");
                        Region toKernelRegion = copy.getRegion(Provisioner.REGION_KERNEL);
                        Iterator iterator = fromSystemRegion.getBundleIds().iterator();
                        while (iterator.hasNext()) {
                            long bundleId = (Long)iterator.next();
                            if (bundleId <= 0L) continue;
                            fromSystemRegion.removeBundle(bundleId);
                            toKernelRegion.addBundle(bundleId);
                        }
                        return copy;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"200", (Object)this, (Object[])new Object[]{mgr, apiPackagesToIgnore});
                throw new IllegalStateException((Throwable)e);
            }
        }
        this.kernelRegion = original.getRegion(mgr.bundleContext.getBundle());
        if (apiPackagesToIgnore == null) {
            apiPackagesToIgnore = Collections.emptySet();
        }
        this.apiPackagesToIgnore = apiPackagesToIgnore;
        Field tmpField = null;
        try {
            tmpField = ModuleWiring.class.getDeclaredField("dynamicMissRef");
            tmpField.setAccessible(true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"214", (Object)this, (Object[])new Object[]{mgr, apiPackagesToIgnore});
            throw new RuntimeException((Throwable)e);
        }
        this.dynamicMissRefField = tmpField;
        this.libertyBoot = Boolean.parseBoolean(mgr.bundleContext.getProperty("wlp.liberty.boot"));
    }

    public void installBundles(BundleContext bContext, final BundleList bundleList, final BundleInstallStatus installStatus, final int minStartLevel, final int defaultStartLevel, final int defaultInitialStartLevel, final WsLocationAdmin locSvc) {
        if (bundleList == null || bundleList.isEmpty()) {
            return;
        }
        final FrameworkWiring fwkWiring = (FrameworkWiring)this.featureManager.bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        final File bootFile = this.getBootJar();
        bundleList.foreach(new BundleList.FeatureResourceHandler(){
            static final long serialVersionUID = 7664404176159686203L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={IllegalStateException.class, Exception.class})
            public boolean handle(FeatureResource fr) {
                Bundle bundle = null;
                WsResource resource = null;
                String urlString = fr.getLocation();
                try {
                    String bundleRepositoryType = fr.getBundleRepositoryType();
                    BundleRepositoryRegistry.BundleRepositoryHolder bundleRepositoryHolder = Provisioner.this.featureManager.getBundleRepositoryHolder(bundleRepositoryType);
                    if (bundleRepositoryHolder == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Bundle repository not found for type=" + bundleRepositoryType), (Object[])new Object[0]);
                        }
                        Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_BUNDLE_ERROR", (Object[])new Object[]{fr.getMatchString()});
                        installStatus.addMissingBundle(fr);
                        return true;
                    }
                    String productName = bundleRepositoryHolder.getFeatureType();
                    bundle = Provisioner.this.libertyBoot ? this.installLibertyBootBundle(productName, fr, fwkWiring) : this.installFeatureBundle(urlString, productName, bundleRepositoryHolder, fr);
                    if (bundle == null) {
                        return true;
                    }
                    BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
                    BundleRevision bRev = (BundleRevision)bundle.adapt(BundleRevision.class);
                    int level = 0;
                    if ((bRev.getTypes() & 1) != 1) {
                        level = bsl.getStartLevel();
                        if (level == defaultInitialStartLevel) {
                            int newLevel;
                            int sl = fr.getStartLevel();
                            int n = sl == 0 ? defaultStartLevel : (newLevel = sl < minStartLevel ? minStartLevel : sl);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Changing the start level of bundle {0} from {1} to the current level of {2}", (Object[])new Object[]{bundle, level, newLevel});
                            }
                            level = newLevel;
                            bsl.setStartLevel(level);
                        }
                        installStatus.addBundleToStart(bundle);
                    }
                    File bundleFile = this.getBundleFile(bundle);
                    resource = locSvc.asResource(bundleFile, bundleFile.isFile());
                    bundleList.createAssociation(fr, bundle, resource, level);
                }
                catch (IllegalStateException e) {
                    installStatus.markContextInvalid(e);
                    return false;
                }
                catch (Exception e) {
                    installStatus.addInstallException("INSTALL " + urlString + " (resolved from: " + fr + ")", e);
                }
                return true;
            }

            private File getBundleFile(Bundle bundle) {
                if (Provisioner.this.libertyBoot) {
                    return bootFile;
                }
                String location = bundle.getLocation();
                int index = location.indexOf(Provisioner.BUNDLE_LOC_REFERENCE_TAG);
                location = location.substring(index + Provisioner.BUNDLE_LOC_REFERENCE_TAG.length());
                return new File(URI.create(location));
            }

            private Bundle installLibertyBootBundle(String productName, FeatureResource fr, FrameworkWiring fwkWiring2) throws BundleException, IOException {
                Region current;
                LibertyBootRuntime libertyBoot = Provisioner.this.featureManager.getLibertyBoot();
                if (libertyBoot == null) {
                    throw new IllegalStateException("No LibertBootRuntime service available!");
                }
                Bundle bundle = libertyBoot.installBootBundle(fr.getSymbolicName(), fr.getVersionRange(), Provisioner.BUNDLE_LOC_FEATURE_TAG);
                if (bundle == null) {
                    installStatus.addMissingBundle(fr);
                    return null;
                }
                Region productRegion = Provisioner.this.getProductRegion(productName);
                if (!productRegion.equals(current = Provisioner.this.featureManager.getDigraph().getRegion(bundle))) {
                    current.removeBundle(bundle);
                    productRegion.addBundle(bundle);
                }
                return bundle;
            }

            private Bundle installFeatureBundle(String urlString, String productName, BundleRepositoryRegistry.BundleRepositoryHolder bundleRepositoryHolder, FeatureResource fr) throws BundleException, IOException {
                Bundle bundle = this.fetchInstalledBundle(urlString, productName);
                if (bundle == null) {
                    ContentBasedLocalBundleRepository lbr = bundleRepositoryHolder.getBundleRepository();
                    File bundleFile = lbr.selectBundle(urlString, fr.getSymbolicName(), fr.getVersionRange());
                    if (bundleFile == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Bundle not matched", (Object[])new Object[]{lbr, fr});
                        }
                        Tr.error((TraceComponent)tc, (String)"UPDATE_MISSING_BUNDLE_ERROR", (Object[])new Object[]{fr.getMatchString()});
                        installStatus.addMissingBundle(fr);
                        return null;
                    }
                    URI uri = bundleFile.toURI();
                    urlString = uri.toURL().toString();
                    urlString = PathUtils.normalize((String)urlString);
                    urlString = Provisioner.BUNDLE_LOC_REFERENCE_TAG + urlString;
                    String location = Provisioner.getBundleLocation(urlString, productName);
                    Region productRegion = Provisioner.this.getProductRegion(productName);
                    bundle = productRegion.installBundleAtLocation(location, new URL(urlString).openStream());
                }
                return bundle;
            }

            private Bundle fetchInstalledBundle(String urlString, String productName) {
                String location = Provisioner.getBundleLocation(Provisioner.BUNDLE_LOC_REFERENCE_TAG + urlString, productName);
                Bundle b = ((Provisioner)Provisioner.this).featureManager.bundleContext.getBundle(location);
                if (b != null && b.getState() == 1) {
                    b = null;
                }
                return b;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private File getBootJar() {
        if (!this.libertyBoot) {
            return null;
        }
        ProtectionDomain pd = this.getClass().getProtectionDomain();
        if (pd == null) {
            throw new IllegalStateException("No protection domain for boot jar.");
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            throw new IllegalStateException("No code source for boot jar.");
        }
        URL loc = cs.getLocation();
        String spec = loc.toExternalForm();
        if ("jar".equals(loc.getProtocol())) {
            int bangSlash;
            while ((bangSlash = spec.lastIndexOf("!/")) != -1) {
                spec = spec.substring(0, bangSlash);
            }
            spec = spec.substring(4);
        }
        if (!spec.startsWith("file:")) {
            throw new IllegalStateException("The code source for the boot jar does not come from a file:" + loc);
        }
        try {
            return new File(new URI(spec));
        }
        catch (URISyntaxException bangSlash) {
            void e;
            FFDCFilter.processException((Throwable)bangSlash, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"446", (Object)this, (Object[])new Object[0]);
            throw new IllegalStateException((Throwable)e);
        }
    }

    static File getFile(URL url) {
        String path;
        try {
            if (url.getAuthority() != null) {
                url = new URL("file://" + url.toString().substring("file:".length()));
            }
            path = new File(url.toURI()).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"464", null, (Object[])new Object[]{url});
            path = null;
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"466", null, (Object[])new Object[]{url});
            path = null;
        }
        if (path == null) {
            path = url.getPath();
        }
        return new File(Provisioner.normalizePathDrive(path));
    }

    static String normalizePathDrive(String path) {
        if (File.separatorChar == '\\' && path.length() > 1 && path.charAt(1) == ':' && path.charAt(0) >= 'a' && path.charAt(0) <= 'z') {
            path = Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    @FFDCIgnore(value={BundleException.class})
    public BundleLifecycleStatus preStartBundles(List<Bundle> installedBundles) {
        BundleLifecycleStatus startStatus = new BundleLifecycleStatus();
        if (installedBundles == null || installedBundles.size() == 0) {
            return startStatus;
        }
        for (Bundle b : installedBundles) {
            int state;
            if (b == null || (state = b.getState()) == 1 || state >= 8) continue;
            try {
                b.start(2);
            }
            catch (BundleException e) {
                startStatus.addStartException(b, e);
            }
        }
        return startStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveBundles(BundleContext bContext, List<Bundle> bundlesToResolve) {
        if (bundlesToResolve == null || bundlesToResolve.size() == 0) {
            return;
        }
        boolean allResolved = true;
        int resolveMask = 60;
        for (Bundle bundle : bundlesToResolve) {
            allResolved &= (bundle.getState() & resolveMask) != 0;
        }
        if (allResolved) {
            return;
        }
        FrameworkWiring wiring = this.adaptSystemBundle(bContext, FrameworkWiring.class);
        if (wiring != null) {
            ResolutionReportHelper rrh = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                rrh = new ResolutionReportHelper();
                rrh.startHelper(bContext);
            }
            try {
                wiring.resolveBundles(bundlesToResolve);
            }
            finally {
                if (rrh != null) {
                    rrh.stopHelper();
                    Tr.debug((Object)this, (TraceComponent)tc, (String)rrh.getResolutionReportString(), (Object[])new Object[0]);
                }
            }
        }
    }

    @FFDCIgnore(value={IllegalStateException.class, Exception.class})
    public BundleLifecycleStatus uninstallBundles(final BundleContext bundleContext, final BundleList removeBundles, final BundleInstallStatus installStatus, ShutdownHookManager shutdownHook) {
        final ArrayList bundlesToUninstall = new ArrayList();
        removeBundles.foreach(new BundleList.FeatureResourceHandler(){
            static final long serialVersionUID = -866914808040603677L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={Exception.class})
            public boolean handle(FeatureResource fr) {
                try {
                    Bundle b = removeBundles.getBundle(bundleContext, fr);
                    if (b != null && b.getBundleId() > 0L) {
                        bundlesToUninstall.add(b);
                    }
                }
                catch (Exception e) {
                    installStatus.addInstallException("UNINSTALL " + fr.getLocation(), e);
                }
                return true;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        Collections.sort(bundlesToUninstall, Collections.reverseOrder(BundleInstallStatus.sortByStartLevel));
        for (Bundle bundleToUninstall : bundlesToUninstall) {
            try {
                bundleToUninstall.uninstall();
            }
            catch (IllegalStateException e) {
                if (FrameworkState.isValid()) continue;
                break;
            }
            catch (Exception e) {
                installStatus.addInstallException("UNINSTALL " + bundleToUninstall.getLocation(), e);
            }
        }
        RefreshBundlesListener listener = new RefreshBundlesListener(shutdownHook);
        FrameworkWiring wiring = this.adaptSystemBundle(bundleContext, FrameworkWiring.class);
        if (wiring != null) {
            wiring.refreshBundles(null, new FrameworkListener[]{listener});
            listener.waitForComplete();
        }
        return listener.getStatus();
    }

    public static String getBundleLocation(String urlString, String productName) {
        String productNameInfo = productName != null && !productName.isEmpty() ? BUNDLE_LOC_PROD_EXT_TAG + productName + ":" : "";
        return BUNDLE_LOC_FEATURE_TAG + productNameInfo + urlString;
    }

    private String getRegionName(String productName) {
        if (productName == null || productName.isEmpty()) {
            return this.kernelRegion.getName();
        }
        return REGION_EXTENSION_PREFIX + INVALID_REGION_CHARS.matcher(productName).replaceAll("-");
    }

    private Region getProductRegion(String productName) throws BundleException {
        RegionDigraph digraph = this.featureManager.getDigraph();
        return digraph.getRegion(this.getRegionName(productName));
    }

    Set<String> createAndUpdateProductRegions() throws BundleException {
        final HashSet<String> products = new HashSet<String>();
        final HashMap<String, LinkedHashSet<String>> productAPIServiceMap = new HashMap<String, LinkedHashSet<String>>();
        for (ProvisioningFeatureDefinition featureDef : this.featureManager.getInstalledFeatureDefinitions()) {
            products.add(featureDef.getBundleRepositoryType());
            String featureApiServices = featureDef.getApiServices();
            if (featureApiServices == null || featureApiServices.isEmpty()) continue;
            LinkedHashSet<String> productApiServices = (LinkedHashSet<String>)productAPIServiceMap.get(featureDef.getBundleRepositoryType());
            if (productApiServices == null) {
                productApiServices = new LinkedHashSet<String>();
                productAPIServiceMap.put(featureDef.getBundleRepositoryType(), productApiServices);
            }
            productApiServices.add(featureApiServices);
        }
        if (products.isEmpty()) {
            return Collections.emptySet();
        }
        products.add("");
        final HashSet<String> productRegionsToRemove = new HashSet<String>();
        ApiRegion.update(this.featureManager.getDigraph(), new Callable<RegionDigraph>(){
            static final long serialVersionUID = 4149885878161425195L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public RegionDigraph call() throws Exception {
                RegionDigraph copy;
                productRegionsToRemove.clear();
                try {
                    copy = Provisioner.this.featureManager.getDigraph().copy();
                }
                catch (BundleException bundleException) {
                    void e;
                    FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner$4", (String)"697", (Object)this, (Object[])new Object[0]);
                    throw e;
                }
                for (Region region : copy) {
                    if (!region.getName().startsWith(Provisioner.REGION_EXTENSION_PREFIX)) continue;
                    productRegionsToRemove.add(region.getName());
                }
                Provisioner.this.createSystemBundleRegion(copy);
                Provisioner.this.primeAPIRegions(copy);
                for (String productName : products) {
                    String productRegionName = Provisioner.this.getRegionName(productName);
                    Region existing = copy.getRegion(productRegionName);
                    Set existingBundles = Collections.emptySet();
                    Set existingEdges = Collections.emptySet();
                    if (existing != null) {
                        existingBundles = existing.getBundleIds();
                        existingEdges = existing.getEdges();
                        copy.removeRegion(existing);
                    }
                    Region newProductRegion = Provisioner.this.createProductRegion(productName, productRegionName, (Set)productAPIServiceMap.get(productName), copy, existingBundles, existingEdges);
                    productRegionsToRemove.remove(newProductRegion.getName());
                }
                return copy;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        });
        return productRegionsToRemove;
    }

    private void createSystemBundleRegion(RegionDigraph digraph) throws BundleException {
        Bundle systemBundle = this.featureManager.bundleContext.getBundle("System Bundle");
        if (digraph.getRegion(systemBundle).getName().equals("system.bundle")) {
            return;
        }
        digraph.getRegion(systemBundle).removeBundle(systemBundle);
        Region systemBundleRegion = digraph.createRegion("system.bundle");
        systemBundleRegion.addBundle(systemBundle);
    }

    private void primeAPIRegions(RegionDigraph digraph) throws BundleException {
        Region productHub = digraph.getRegion(REGION_PRODUCT_HUB);
        if (productHub == null) {
            productHub = digraph.createRegion(REGION_PRODUCT_HUB);
        }
        RegionFilterBuilder builder = digraph.createRegionFilterBuilder();
        builder.allowAll("org.eclipse.equinox.allow.service");
        RegionFilter filter = builder.build();
        for (ApiRegion apiRegion : ApiRegion.values()) {
            Region regionApiHub = digraph.getRegion(apiRegion.getRegionName());
            if (regionApiHub != null) continue;
            regionApiHub = digraph.createRegion(apiRegion.getRegionName());
            productHub.connectRegion(regionApiHub, filter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Region createProductRegion(String productName, String productRegionName, Set<String> productApiServices, RegionDigraph digraph, Set<Long> bundleIds, Set<RegionDigraph.FilteredRegion> edges) throws BundleException {
        Region productRegion = digraph.createRegion(productRegionName);
        for (Long bundleId : bundleIds) {
            productRegion.addBundle(bundleId.longValue());
        }
        try {
            this.connectToProductHub(productName, productRegion, digraph);
            this.connectToGatewayHubs(productName, productRegion, productApiServices, digraph);
            for (RegionDigraph.FilteredRegion edge : edges) {
                Region head = edge.getRegion();
                if (REGION_PRODUCT_HUB.equals(head.getName()) || "system.bundle".equals(head.getName())) continue;
                digraph.connect(productRegion, edge.getFilter(), edge.getRegion());
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"785", (Object)this, (Object[])new Object[]{productName, productRegionName, productApiServices, digraph, bundleIds, edges});
            throw new IllegalArgumentException((Throwable)e);
        }
        return productRegion;
    }

    private void connectToGatewayHubs(String productName, Region productRegion, Set<String> productApiServices, RegionDigraph digraph) throws BundleException, InvalidSyntaxException {
        ArrayList<String> ibmApiFilters = new ArrayList<String>();
        ArrayList<String> strictSpecApiFilters = new ArrayList<String>();
        ArrayList<String> thirdPartyApiFilters = new ArrayList<String>();
        ArrayList<String> stableApiFilters = new ArrayList<String>();
        ArrayList<String> userDefinedApiFilters = new ArrayList<String>();
        ArrayList<String> internalApiFilters = new ArrayList<String>();
        ArrayList<String> osgiAppsAPIFilters = new ArrayList<String>();
        Iterator<String> gatewayPackages = this.featureManager.packageInspector.getGatewayPackages(productName);
        while (gatewayPackages.hasNext()) {
            String packageName = gatewayPackages.next();
            if (this.apiPackagesToIgnore.contains(packageName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("ignoring API/SPI package due to bootstrap property override: " + packageName), (Object[])new Object[0]);
                continue;
            }
            String clause = "(osgi.wiring.package=" + packageName + ")";
            osgiAppsAPIFilters.add(clause);
            SharedPackageInspector.PackageType type = this.featureManager.packageInspector.getExportedPackageType(packageName);
            if (type.isInternalApi()) {
                internalApiFilters.add(clause);
                continue;
            }
            if (type.isIbmApi()) {
                ibmApiFilters.add(clause);
            }
            if (type.isStrictSpecApi()) {
                strictSpecApiFilters.add(clause);
            }
            if (type.isThirdPartyApi()) {
                thirdPartyApiFilters.add(clause);
            }
            if (type.isStableApi()) {
                stableApiFilters.add(clause);
            }
            if (!type.isUserDefinedApi()) continue;
            userDefinedApiFilters.add(clause);
        }
        this.connectGatewayRegion(ApiRegion.ALL, osgiAppsAPIFilters, productRegion, productApiServices, digraph);
        this.connectGatewayRegion(ApiRegion.IBM, ibmApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.SPEC, strictSpecApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.THIRD_PARTY, thirdPartyApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.STABLE, stableApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.USER, userDefinedApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.INTERNAL, internalApiFilters, productRegion, null, digraph);
        this.connectGatewayRegion(ApiRegion.THREAD_CONTEXT, Collections.singletonList(THREAD_CONTEXT_FILTER), productRegion, null, digraph);
    }

    private void connectGatewayRegion(ApiRegion apiRegion, List<String> packageFilters, Region productRegion, Set<String> productApiServices, RegionDigraph digraph) throws InvalidSyntaxException, BundleException {
        RegionFilterBuilder toProductBuilder = digraph.createRegionFilterBuilder();
        if (productApiServices != null) {
            toProductBuilder.allow("org.eclipse.equinox.allow.all", COMMON_OSGI_APPS_ALL_NAMESPACE_FILTER);
        } else {
            toProductBuilder.allow("org.eclipse.equinox.allow.all", COMMON_ALL_NAMESPACE_FILTER);
        }
        toProductBuilder.allow("osgi.wiring.bundle", COMMON_BUNDLE_NAMESPACE_FILTER);
        for (String packageFilter : packageFilters) {
            toProductBuilder.allow("osgi.wiring.package", packageFilter);
        }
        if (productApiServices != null) {
            for (String apiServices : productApiServices) {
                ManifestElement[] serviceElements = ManifestElement.parseHeader((String)"IBM-API-Service", (String)apiServices);
                if (serviceElements == null) continue;
                for (ManifestElement serviceElement : serviceElements) {
                    StringBuilder serviceFilterBuilder = new StringBuilder();
                    serviceFilterBuilder.append("(").append("objectClass").append("=").append(serviceElement.getValue()).append(")");
                    Enumeration attrKeys = serviceElement.getKeys();
                    if (attrKeys != null && attrKeys.hasMoreElements()) {
                        serviceFilterBuilder.insert(0, "(&");
                        while (attrKeys.hasMoreElements()) {
                            String attrKey = (String)attrKeys.nextElement();
                            String attrValue = serviceElement.getAttribute(attrKey);
                            serviceFilterBuilder.append("(").append(attrKey).append("=").append(attrValue).append(")");
                        }
                        serviceFilterBuilder.append(")");
                    }
                    toProductBuilder.allow("osgi.service", serviceFilterBuilder.toString());
                    toProductBuilder.allow("org.eclipse.equinox.allow.service", serviceFilterBuilder.toString());
                }
            }
            for (String commonServiceFilter : COMMON_OSGI_APPS_SERVICE_REQUIREMENTS) {
                toProductBuilder.allow("osgi.service", commonServiceFilter);
                toProductBuilder.allow("org.eclipse.equinox.allow.service", commonServiceFilter);
            }
        }
        Region regionApiHub = digraph.getRegion(apiRegion.getRegionName());
        regionApiHub.connectRegion(productRegion, toProductBuilder.build());
    }

    private void connectToProductHub(String productName, Region productRegion, RegionDigraph digraph) throws BundleException, InvalidSyntaxException {
        Region productHub = digraph.getRegion(REGION_PRODUCT_HUB);
        if (productHub == null) {
            productHub = digraph.createRegion(REGION_PRODUCT_HUB);
        }
        RegionFilterBuilder toHubBuilder = digraph.createRegionFilterBuilder();
        RegionFilterBuilder toProductBuilder = digraph.createRegionFilterBuilder();
        toHubBuilder.allowAll("org.eclipse.equinox.allow.all");
        productRegion.connectRegion(productHub, toHubBuilder.build());
        toProductBuilder.allow("org.eclipse.equinox.allow.all", COMMON_ALL_NAMESPACE_FILTER);
        toProductBuilder.allow("osgi.wiring.bundle", COMMON_BUNDLE_NAMESPACE_FILTER);
        toProductBuilder.allowAll("org.eclipse.equinox.allow.bundle.lifecycle");
        Iterator<String> productPackages = this.featureManager.packageInspector.getExtensionPackages(productName);
        while (productPackages.hasNext()) {
            toProductBuilder.allow("osgi.wiring.package", "(osgi.wiring.package=" + productPackages.next() + ")");
        }
        if (productRegion.getName().equals(this.kernelRegion.getName())) {
            toProductBuilder.allow("osgi.wiring.package", "(bundle-symbolic-name=system.bundle)");
            Region systemBundleRegion = digraph.getRegion("system.bundle");
            RegionFilterBuilder toKernelfromSystemBuilder = digraph.createRegionFilterBuilder();
            toKernelfromSystemBuilder.allowAll("org.eclipse.equinox.allow.all");
            systemBundleRegion.connectRegion(productRegion, toKernelfromSystemBuilder.build());
            RegionFilterBuilder toSystemFromKernelBuilder = digraph.createRegionFilterBuilder();
            if (this.featureManager.packageInspector.listKernelBlackListApiPackages().hasNext()) {
                StringBuffer buf = new StringBuffer();
                Iterator<String> kernelBlackListExport = this.featureManager.packageInspector.listKernelBlackListApiPackages();
                while (kernelBlackListExport.hasNext()) {
                    String pack = kernelBlackListExport.next();
                    buf.append("(osgi.wiring.package=" + pack + ")");
                }
                String apiPackagesToFilterOut = "(!(|" + buf.toString() + "))";
                toSystemFromKernelBuilder.allow("osgi.wiring.package", apiPackagesToFilterOut);
                toSystemFromKernelBuilder.allow("org.eclipse.equinox.allow.all", PACKAGE_AND_BUNDLE_FILTER);
            } else {
                toSystemFromKernelBuilder.allowAll("org.eclipse.equinox.allow.all");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"System bundle region filter : {0}", (Object[])new Object[]{toSystemFromKernelBuilder.build().getSharingPolicy()});
            }
            productRegion.connectRegion(systemBundleRegion, toSystemFromKernelBuilder.build());
        }
        productHub.connectRegion(productRegion, toProductBuilder.build());
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private <T> T adaptSystemBundle(BundleContext bundleContext, Class<T> target) {
        try {
            Bundle systemBundle = bundleContext.getBundle("System Bundle");
            if (systemBundle != null) {
                return (T)systemBundle.adapt(target);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    void removeStaleProductRegions(final Set<String> regionsToRemove) throws BundleException {
        if (regionsToRemove.isEmpty()) {
            return;
        }
        final RegionDigraph digraph = this.featureManager.getDigraph();
        final HashSet<Long> orphanIDs = new HashSet<Long>();
        for (String regionName : regionsToRemove) {
            Region toRemove = digraph.getRegion(regionName);
            if (toRemove == null) continue;
            orphanIDs.addAll(toRemove.getBundleIds());
        }
        this.uninstallOphans(orphanIDs);
        ApiRegion.update(this.featureManager.getDigraph(), new Callable<RegionDigraph>(){
            static final long serialVersionUID = 4011973307359781L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public RegionDigraph call() throws Exception {
                RegionDigraph copy;
                try {
                    copy = digraph.copy();
                }
                catch (BundleException bundleException) {
                    void e;
                    FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner$5", (String)"1048", (Object)this, (Object[])new Object[0]);
                    throw e;
                }
                for (String regionName : regionsToRemove) {
                    Region toRemove = copy.getRegion(regionName);
                    if (toRemove == null) continue;
                    orphanIDs.addAll(toRemove.getBundleIds());
                    copy.removeRegion(toRemove);
                }
                return copy;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class);
            }
        });
        this.uninstallOphans(orphanIDs);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private void uninstallOphans(Set<Long> orphanIDs) {
        BundleContext systemContext = this.featureManager.bundleContext.getBundle("System Bundle").getBundleContext();
        for (Long ophanId : orphanIDs) {
            Bundle ophanBundle = systemContext.getBundle(ophanId.longValue());
            if (ophanBundle == null) continue;
            try {
                ophanBundle.uninstall();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"1084", (Object)this, (Object[])new Object[]{orphanIDs});
            }
        }
    }

    void refreshGatewayBundles(ShutdownHookManager shutdownHook) {
        BundleContext systemContext = this.featureManager.bundleContext.getBundle("System Bundle").getBundleContext();
        LinkedHashSet<Bundle> needsRefresh = new LinkedHashSet<Bundle>();
        RegionDigraph digraph = this.featureManager.getDigraph();
        for (Bundle b : systemContext.getBundles()) {
            String bsn = b.getSymbolicName();
            if (bsn == null || !bsn.startsWith("gateway.bundle.")) continue;
            Region gatewayRegion = digraph.getRegion(b);
            BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
            if (wiring == null) continue;
            List packageWires = wiring.getRequiredWires("osgi.wiring.package");
            for (BundleWire packageWire : packageWires) {
                if (this.isPackageAccessible(gatewayRegion, packageWire.getCapability())) continue;
                needsRefresh.add(b);
            }
            if (needsRefresh.contains(b)) continue;
            this.clearPackageMisses(wiring);
        }
        this.refreshBundles(needsRefresh, shutdownHook);
    }

    private boolean isPackageAccessible(Region gatewayRegion, final BundleCapability packageCapability) {
        final AtomicBoolean found = new AtomicBoolean(false);
        gatewayRegion.visitSubgraph(new RegionDigraphVisitor(){
            static final long serialVersionUID = -8787622736112040759L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public boolean visit(Region region) {
                boolean capabilityInRegion = region.contains(packageCapability.getRevision().getBundle());
                if (capabilityInRegion) {
                    found.set(true);
                    return false;
                }
                return true;
            }

            public boolean preEdgeTraverse(RegionFilter filter) {
                return filter.isAllowed(packageCapability);
            }

            public void postEdgeTraverse(RegionFilter arg0) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(6.class);
            }
        });
        return found.get();
    }

    private void clearPackageMisses(BundleWiring wiring) {
        try {
            AtomicReference dynamicMissRef = (AtomicReference)this.dynamicMissRefField.get(wiring);
            dynamicMissRef.set(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"1156", (Object)this, (Object[])new Object[]{wiring});
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.kernel.feature.internal.Provisioner", (String)"1158", (Object)this, (Object[])new Object[]{wiring});
        }
    }

    private void refreshBundles(Collection<Bundle> needsRefresh, ShutdownHookManager shutdownHook) {
        if (!needsRefresh.isEmpty()) {
            RefreshBundlesListener listener = new RefreshBundlesListener(shutdownHook);
            FrameworkWiring wiring = this.adaptSystemBundle(this.featureManager.bundleContext, FrameworkWiring.class);
            if (wiring != null) {
                wiring.refreshBundles(needsRefresh, new FrameworkListener[]{listener});
                listener.waitForComplete();
            }
        }
    }

    public void refreshFeatureBundles(PackageInspectorImpl packageInspector, BundleContext bundleContext, ShutdownHookManager shutdownHook) {
        Set<String> blackList = this.returnSet(packageInspector.listKernelBlackListApiPackages());
        if (blackList.isEmpty()) {
            return;
        }
        ArrayList<Bundle> needsRefresh = new ArrayList<Bundle>();
        BundleWiring systemBundleWiring = (BundleWiring)bundleContext.getBundle("System Bundle").adapt(BundleWiring.class);
        List systemPackages = systemBundleWiring.getProvidedWires("osgi.wiring.package");
        for (BundleWire bw : systemPackages) {
            BundleCapability cap = bw.getCapability();
            String pkg = (String)cap.getAttributes().get("osgi.wiring.package");
            if (!blackList.contains(pkg)) continue;
            needsRefresh.add(bw.getRequirerWiring().getBundle());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Bundles requiring refresh, wired to system bundle : {0}", (Object[])new Object[]{needsRefresh});
        }
        this.refreshBundles(needsRefresh, shutdownHook);
    }

    private Set<String> returnSet(Iterator<String> iterator) {
        HashSet<String> hash = new HashSet<String>();
        if (iterator.hasNext()) {
            Iterator<String> it = iterator;
            while (it.hasNext()) {
                hash.add(it.next());
            }
            return hash;
        }
        return Collections.emptySet();
    }
}

