/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.VersionRange;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FeatureResourceImpl
implements FeatureResource {
    private static final TraceComponent tc = Tr.register(FeatureResourceImpl.class);
    private final String _symbolicName;
    private final Map<String, String> _rawAttributes;
    private final String _featureName;
    private final String _bundleRepositoryType;
    private String matchString = null;
    private final AtomicReference<VersionRange> _range = new AtomicReference();
    private final AtomicReference<List<String>> _osList = new AtomicReference();
    private final AtomicReference<Map<String, String>> _attributes = new AtomicReference();
    private final AtomicReference<Map<String, String>> _directives = new AtomicReference();
    private final AtomicInteger _startLevel = new AtomicInteger(-1);
    private final AtomicReference<List<String>> _tolerates = new AtomicReference();
    private volatile SubsystemContentType _type = null;
    static final long serialVersionUID = -4696358663124693959L;

    public FeatureResourceImpl(String key, Map<String, String> value, String bundleRepositoryType, String featureName) {
        this._symbolicName = key;
        this._rawAttributes = value;
        this._bundleRepositoryType = bundleRepositoryType;
        this._featureName = featureName;
    }

    @Override
    public String getSymbolicName() {
        return this._symbolicName;
    }

    @Override
    @Trivial
    public VersionRange getVersionRange() {
        String range;
        VersionRange result = this._range.get();
        if (result == null && !this._range.compareAndSet(null, result = VersionUtility.stringToVersionRange((String)(range = this._rawAttributes.get("version"))))) {
            result = this._range.get();
        }
        return result;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> result = this._attributes.get();
        if (result == null) {
            result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this._rawAttributes.entrySet()) {
                String key = entry.getKey();
                if (key.endsWith(":")) continue;
                result.put(key, entry.getValue());
            }
            if (!this._attributes.compareAndSet(null, result = Collections.unmodifiableMap(result))) {
                result = this._attributes.get();
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getDirectives() {
        Map<String, String> result = this._directives.get();
        if (result == null) {
            result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this._rawAttributes.entrySet()) {
                String key = entry.getKey();
                if (!key.endsWith(":")) continue;
                result.put(key.substring(0, key.length() - 1), entry.getValue());
            }
            if (!this._directives.compareAndSet(null, result = Collections.unmodifiableMap(result))) {
                result = this._directives.get();
            }
        }
        return result;
    }

    @Override
    public String getLocation() {
        return this._rawAttributes.get("location:");
    }

    @Override
    public List<String> getOsList() {
        List<String> result = this._osList.get();
        if (result == null) {
            String osData = this._rawAttributes.get("os");
            if (osData == null) {
                osData = "";
            }
            String[] parts = osData.split(",");
            result = new ArrayList<String>();
            for (String p : parts) {
                if ("".equals(p.trim())) continue;
                result.add(p.trim());
            }
            if (!this._osList.compareAndSet(null, result)) {
                result = this._osList.get();
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    @Override
    public boolean isType(SubsystemContentType type) {
        SubsystemContentType thisType = this.getType();
        return thisType == type;
    }

    @Override
    public SubsystemContentType getType() {
        SubsystemContentType result = this._type;
        if (result == null) {
            result = this._type = SubsystemContentType.fromString(this.getRawType());
        }
        return result;
    }

    @Override
    public String getRawType() {
        return this._rawAttributes.get("type");
    }

    public String toString() {
        if (this.matchString == null) {
            this.matchString = this._symbolicName + '/' + this.getVersionRange();
        }
        return this.matchString;
    }

    @Override
    public int getStartLevel() {
        int result = this._startLevel.get();
        if (result == -1) {
            result = 12;
            String phase = this._rawAttributes.get("start-phase:");
            result = this.setStartLevel(phase, result);
            if (!this._startLevel.compareAndSet(-1, result)) {
                result = this._startLevel.get();
            }
        }
        return result;
    }

    private int setStartLevel(String phase, int original) {
        if (phase == null) {
            return original;
        }
        if ("APPLICATION".equals(phase)) {
            return 18;
        }
        if ("APPLICATION_LATE".equals(phase)) {
            return 19;
        }
        if ("APPLICATION_EARLY".equals(phase)) {
            return 17;
        }
        if ("SERVICE".equals(phase)) {
            return 9;
        }
        if ("SERVICE_LATE".equals(phase)) {
            return 10;
        }
        if ("SERVICE_EARLY".equals(phase)) {
            return 8;
        }
        if ("CONTAINER".equals(phase)) {
            return 12;
        }
        if ("CONTAINER_LATE".equals(phase)) {
            return 13;
        }
        if ("CONTAINER_EARLY".equals(phase)) {
            return 11;
        }
        Tr.warning((TraceComponent)tc, (String)"INVALID_START_PHASE_WARNING", (Object[])new Object[]{phase, this._symbolicName, this._featureName});
        return original;
    }

    @Override
    public String getExtendedAttributes() {
        return this.getDirectives().get("ibm.zos.extended.attributes");
    }

    @Override
    public String setExecutablePermission() {
        return this.getDirectives().get("ibm.executable");
    }

    @Override
    public String getFileEncoding() {
        return this.getDirectives().get("ibm.file.encoding");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        result = 31 * result + (this.getVersionRange() == null ? 0 : this.getVersionRange().hashCode());
        result = 31 * result + (this._symbolicName == null ? 0 : this._symbolicName.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureResourceImpl other = (FeatureResourceImpl)obj;
        return Objects.equals(this._symbolicName, other._symbolicName) && this._type == other._type && Objects.equals(this.getVersionRange(), other.getVersionRange()) && Objects.equals(this.getLocation(), other.getLocation()) && Objects.equals(this.getOsList(), other.getOsList()) && Objects.equals(this.getTolerates(), other.getTolerates()) && Objects.equals(this.getRequireJava(), other.getRequireJava());
    }

    @Override
    public String getMatchString() {
        return this.toString();
    }

    @Override
    public String getBundleRepositoryType() {
        return this._bundleRepositoryType;
    }

    @Override
    public List<String> getTolerates() {
        List<String> result = this._tolerates.get();
        if (result == null) {
            String tolerates = this._rawAttributes.get("ibm.tolerates:");
            if (tolerates == null) {
                tolerates = "";
            }
            String[] parts = tolerates.split(",");
            result = new ArrayList<String>();
            for (String p : parts) {
                if ("".equals(p.trim())) continue;
                result.add(p.trim());
            }
            if (!this._tolerates.compareAndSet(null, result)) {
                result = this._tolerates.get();
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    @Override
    public Integer getRequireJava() {
        String requireJava = this._rawAttributes.get("require-java:");
        return requireJava == null ? null : Integer.valueOf(requireJava);
    }
}

