/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class Content
implements Iterable<Entry> {
    public abstract Manifest getManifest() throws IOException;

    public abstract Entry getEntry(String var1);

    public abstract String getName();

    protected abstract int size();

    public void close() throws IOException {
    }

    public abstract boolean isExtracted();

    public static Content build(File f) throws IOException {
        if (f.isDirectory()) {
            return new DirectoryContent(f);
        }
        return new JarContent(new JarFile(f));
    }

    public static class DirectoryContent
    extends Content {
        private final File root;
        private final List<Entry> entries = new ArrayList<Entry>();

        public DirectoryContent(File root) {
            this.root = root;
            this.addEntries(root, "", this.entries);
        }

        private void addEntries(File file, String pathPrefix, List<Entry> results) {
            for (String path : file.list()) {
                File child = new File(file, path);
                String childPath = pathPrefix.isEmpty() ? path : pathPrefix + '/' + path;
                results.add(new FileEntry(child, childPath));
                if (!child.isDirectory()) continue;
                this.addEntries(child, childPath, results);
            }
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.entries.iterator();
        }

        @Override
        public Manifest getManifest() throws IOException {
            FileInputStream in = new FileInputStream(new File(this.root, "META-INF/MANIFEST.MF"));
            try {
                Manifest manifest = new Manifest(in);
                return manifest;
            }
            finally {
                ((InputStream)in).close();
            }
        }

        @Override
        public Entry getEntry(String path) {
            File file = new File(this.root, path);
            if (file.exists()) {
                return new FileEntry(file, path);
            }
            return null;
        }

        @Override
        public String getName() {
            return this.root.toString();
        }

        @Override
        protected int size() {
            return 0;
        }

        @Override
        public boolean isExtracted() {
            return true;
        }

        public class FileEntry
        implements Entry {
            private final File file;
            private final String path;

            public FileEntry(File file, String path) {
                this.path = path;
                this.file = file;
            }

            @Override
            public String getName() {
                return this.path;
            }

            @Override
            public boolean isDirectory() {
                return this.file.isDirectory();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(this.file);
            }
        }
    }

    public static class JarContent
    extends Content {
        private final JarFile jar;
        private final List<Entry> entries = new ArrayList<Entry>();

        public JarContent(JarFile jar) {
            this.jar = jar;
            Enumeration<JarEntry> eJarEntries = this.jar.entries();
            while (eJarEntries.hasMoreElements()) {
                JarEntry jarEntry = eJarEntries.nextElement();
                this.entries.add(new JarContentEntry(jarEntry));
            }
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.entries.iterator();
        }

        @Override
        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        @Override
        public Entry getEntry(String path) {
            JarEntry jarEntry = this.jar.getJarEntry(path);
            if (jarEntry != null) {
                return new JarContentEntry(jarEntry);
            }
            return null;
        }

        @Override
        public String getName() {
            return this.jar.getName();
        }

        @Override
        protected int size() {
            return this.jar.size();
        }

        @Override
        public void close() throws IOException {
            this.jar.close();
        }

        @Override
        public boolean isExtracted() {
            return false;
        }

        public class JarContentEntry
        implements Entry {
            private final JarEntry jarEntry;

            public JarContentEntry(JarEntry jarEntry) {
                this.jarEntry = jarEntry;
            }

            @Override
            public String getName() {
                return this.jarEntry.getName();
            }

            @Override
            public boolean isDirectory() {
                return this.jarEntry.isDirectory();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return JarContent.this.jar.getInputStream(this.jarEntry);
            }
        }
    }

    public static interface Entry {
        public String getName();

        public boolean isDirectory();

        public InputStream getInputStream() throws IOException;
    }
}

