/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.jar.JarFile;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.ShutdownHook;
import wlp.lib.extract.StreamReader;

public class SelfExtractRun
extends SelfExtract {
    private static int platformType = SelfExtractUtils.getPlatform();

    private static String getUserHome() {
        String home = platformType == 3 ? System.getenv("HOME") : System.getProperty("user.home");
        return home;
    }

    private static String getServerName() {
        return extractor.getServerName();
    }

    private static String createIfNeeded(String dir) {
        File f = new File(dir);
        if (f.exists()) {
            return dir;
        }
        boolean success = f.mkdirs();
        if (success) {
            return dir;
        }
        return null;
    }

    private static String jarFileName() {
        SelfExtractRun.createExtractor();
        String fullyQualifiedFileName = SelfExtractRun.extractor.container.getName();
        int lastSeparator = fullyQualifiedFileName.lastIndexOf(File.separatorChar);
        String simpleFileName = fullyQualifiedFileName.substring(lastSeparator + 1);
        int dotIdx = simpleFileName.lastIndexOf(46);
        if (dotIdx != -1) {
            return simpleFileName.substring(0, simpleFileName.lastIndexOf(46));
        }
        return simpleFileName;
    }

    private static String createTempDirectory(String baseDir, String fileStem) {
        Long nano = new Long(System.nanoTime());
        return baseDir + File.separator + fileStem + nano;
    }

    private static String getExtractDirectory() {
        SelfExtractRun.createExtractor();
        String containerPath = SelfExtractRun.extractor.container.getName();
        File containerFile = new File(containerPath);
        if (containerFile.isDirectory()) {
            extractor.allowNonEmptyInstallDirectory(true);
            return containerFile.getAbsolutePath();
        }
        String extractDirVar = System.getenv("WLP_JAR_EXTRACT_DIR");
        if (extractDirVar != null && extractDirVar.length() > 0) {
            String retVal = SelfExtractRun.createIfNeeded(extractDirVar.trim());
            return retVal;
        }
        String extractDirVarRoot = System.getenv("WLP_JAR_EXTRACT_ROOT");
        if (extractDirVarRoot == null || extractDirVarRoot.length() == 0) {
            extractDirVarRoot = SelfExtractRun.getUserHome() + File.separator + "wlpExtract";
        }
        SelfExtractRun.createIfNeeded(extractDirVarRoot);
        try {
            String basedir = new File(extractDirVarRoot).getAbsolutePath();
            return SelfExtractRun.createTempDirectory(basedir, SelfExtractRun.jarFileName() + "_");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create temp directory under: " + extractDirVarRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disable2PC(String extractDirectory, String serverName) throws IOException {
        String fileName = extractDirectory + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + serverName + File.separator + "jvm.options";
        BufferedReader br = null;
        BufferedWriter bw = null;
        StringBuffer sb = new StringBuffer();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new IOException("Failed to create file " + fileName);
                }
            } else {
                String sCurrentLine;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
                while ((sCurrentLine = br.readLine()) != null) {
                    sb.append(sCurrentLine + "\n");
                }
            }
            String content = "-Dcom.ibm.tx.jta.disable2PC=true";
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsoluteFile()), "UTF-8"));
            bw.write(sb.toString());
            bw.write(content);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    private static int runServer(String extractDirectory, String serverName, String[] args) throws IOException, InterruptedException {
        int rc = 0;
        Runtime rt = Runtime.getRuntime();
        String action = "run";
        if (System.getenv("WLP_JAR_DEBUG") != null) {
            action = "debug";
        }
        if (System.getenv("WLP_JAR_ENABLE_2PC") == null) {
            SelfExtractRun.disable2PC(extractDirectory, serverName);
        }
        String cmd = extractDirectory + File.separator + "wlp" + File.separator + "bin" + File.separator + "server " + action + " " + serverName;
        if (args.length > 0) {
            StringBuilder appArgs = new StringBuilder(" --");
            for (String arg : args) {
                appArgs.append(" ").append(arg);
            }
            cmd = cmd + appArgs.toString();
        }
        System.out.println(cmd);
        if (platformType != 1) {
            if (platformType == 2) {
                cmd = "cmd /k " + cmd;
            } else if (platformType == 3) {
                cmd = "bash -c  \"" + cmd.replace('\\', '/') + '\"';
            }
        }
        Process proc = rt.exec(cmd, SelfExtractUtils.runEnv(extractDirectory), null);
        StreamReader errorReader = new StreamReader(proc.getErrorStream(), "ERROR");
        errorReader.start();
        StreamReader outputReader = new StreamReader(proc.getInputStream(), "OUTPUT");
        outputReader.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook(platformType, extractDirectory, serverName, outputReader, errorReader)));
        rc = proc.waitFor();
        return rc;
    }

    public static void main(String[] args) {
        String extractDirectory = SelfExtractRun.getExtractDirectory();
        if (extractDirectory == null) {
            throw new RuntimeException("Failed to run jar because unable to create extraction directory.");
        }
        String[] newArgs = new String[]{extractDirectory};
        int rc = SelfExtractRun.doMain(newArgs);
        if (rc == 0) {
            try {
                String serverName = SelfExtractRun.getServerName();
                rc = SelfExtractRun.shouldRunInJVM(extractDirectory, serverName) ? SelfExtractRun.runServerInline(extractDirectory, serverName, args) : SelfExtractRun.runServer(extractDirectory, serverName, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run jar due to error " + e.getMessage(), e);
            }
        }
        System.exit(rc);
    }

    private static int runServerInline(String extractDirectory, String serverName, String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        File serverLaunchJar = new File(extractDirectory, "wlp/bin/tools/ws-server.jar");
        JarFile jar = new JarFile(serverLaunchJar);
        String className = jar.getManifest().getMainAttributes().getValue("Main-Class");
        jar.close();
        URLClassLoader cl = new URLClassLoader(new URL[]{new URL("file:" + serverLaunchJar.getAbsolutePath())});
        SelfExtractRun.setContextClassLoader(cl);
        Properties props = System.getProperties();
        props.setProperty("user.dir", new File(extractDirectory, "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + serverName).getAbsolutePath());
        props.setProperty("LOG_DIR", extractDirectory + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + serverName + File.separator + "logs");
        Class<?> clazz = cl.loadClass(className);
        ArrayList<String> argList = new ArrayList<String>(args.length + 2);
        argList.add(serverName);
        if (args.length > 0) {
            argList.add("--");
            argList.addAll(Arrays.asList(args));
        }
        Method m = clazz.getDeclaredMethod("main", String[].class);
        SelfExtractRun.attachJavaAgent(extractDirectory);
        m.invoke(null, new Object[]{argList.toArray(new String[0])});
        return 0;
    }

    private static void attachJavaAgent(String extractDir) {
        if (!System.getProperty("java.specification.version").startsWith("1.")) {
            return;
        }
        File javaAgent = new File(extractDir, "wlp/bin/tools/ws-javaagent.jar");
        if (javaAgent.exists()) {
            String javaHome = System.getProperty("java.home");
            File f = new File(javaHome, "lib/tools.jar");
            if (!f.exists()) {
                f = new File(javaHome, "../lib/tools.jar");
            }
            if (f.exists()) {
                URL thisJar = SelfExtractRun.class.getProtectionDomain().getCodeSource().getLocation();
                try {
                    URL toolsJar = new URL("file:" + f.getCanonicalPath());
                    URLClassLoader cl = new URLClassLoader(new URL[]{thisJar, toolsJar}, null);
                    Class<?> clazz = cl.loadClass("wlp.lib.extract.AgentAttach");
                    Method m = clazz.getDeclaredMethod("attach", String.class);
                    Object result = m.invoke(null, (Object[])new String[]{javaAgent.getAbsolutePath()});
                    if (result != null) {
                        SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", result);
                    }
                }
                catch (MalformedURLException mue) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", mue);
                }
                catch (ClassNotFoundException cnfe) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", nsme);
                }
                catch (IllegalAccessException iae) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", iae);
                }
                catch (InvocationTargetException ite) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", ite.getCause());
                }
                catch (IOException ioe) {
                    SelfExtractRun.err("UNABLE_TO_ATTACH_AGENT", ioe);
                }
            } else {
                SelfExtractRun.err("UNABLE_TO_FIND_TOOLS_JAR");
            }
        } else {
            SelfExtractRun.err("UNABLE_TO_FIND_JAVA_AGENT");
        }
    }

    private static boolean shouldRunInJVM(String extractDir, String serverName) {
        boolean result = System.getenv("WLP_JAR_DEBUG") == null;
        boolean outputMessage = true;
        if (result) {
            File serverDir = new File(extractDir, "wlp/usr/servers/" + serverName);
            result &= !new File(serverDir, "configDropins/defaults/jvm.options").exists();
            result &= !new File(serverDir, "jvm.options").exists();
            result &= !new File(serverDir, "configDropins/overrides/jvm.options").exists();
            result &= !new File(extractDir, "wlp/etc/jvm.options").exists();
        } else if (outputMessage) {
            SelfExtractRun.out("RUN_IN_CHILD_JVM_DEBUG");
            outputMessage = false;
        }
        if (result) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            String vendor = rt.getVmVendor();
            String version = rt.getSpecVersion();
            if (version.startsWith("1") && vendor.toLowerCase().contains("ibm")) {
                result = rt.getInputArguments().contains("-XX:+EnableHCR");
            }
        } else if (outputMessage) {
            SelfExtractRun.out("RUN_IN_CHILD_JVM_JVM_OPTIONS");
            outputMessage = false;
        }
        if (result) {
            result &= SelfExtractRun.isAttachAvailable();
        } else if (outputMessage) {
            SelfExtractRun.out("RUN_IN_CHILD_JVM_IBM_AGENT_ISSUE");
            outputMessage = false;
        }
        if (!result && outputMessage) {
            SelfExtractRun.out("RUN_IN_CHILD_JVM_JRE");
        }
        return result;
    }

    private static boolean isAttachAvailable() {
        if (System.getProperty("java.specification.version").startsWith("1.")) {
            String javaHome = System.getProperty("java.home");
            if (new File(javaHome, "lib/tools.jar").exists()) {
                return true;
            }
            return new File(javaHome, "../lib/tools.jar").exists();
        }
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void setContextClassLoader(final ClassLoader newLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(newLoader);
                return null;
            }
        });
    }
}

