/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.PolicyExecutorImpl;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={PolicyExecutorProvider.class, ServerQuiesceListener.class})
public class PolicyExecutorProvider
implements ServerQuiesceListener {
    @Reference(target="(component.name=com.ibm.ws.threading)")
    private ExecutorService globalExecutor;
    private final ConcurrentHashMap<String, PolicyExecutorImpl> policyExecutors = new ConcurrentHashMap();
    static final long serialVersionUID = 6186764642483384733L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PolicyExecutor create(Map<String, Object> props) {
        PolicyExecutorImpl executor = new PolicyExecutorImpl((ExecutorServiceImpl)this.globalExecutor, (String)props.get("config.displayId"), null, this.policyExecutors);
        executor.updateConfig(props);
        return executor;
    }

    public PolicyExecutor create(String identifier) {
        return new PolicyExecutorImpl((ExecutorServiceImpl)this.globalExecutor, "PolicyExecutorProvider-" + identifier, null, this.policyExecutors);
    }

    public PolicyExecutor create(String fullIdentifier, String owner) {
        return new PolicyExecutorImpl((ExecutorServiceImpl)this.globalExecutor, fullIdentifier, owner, this.policyExecutors);
    }

    public void introspectPolicyExecutors(PrintWriter out) {
        for (PolicyExecutorImpl executor : this.policyExecutors.values()) {
            executor.introspect(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopping() {
        ConcurrentHashMap<String, PolicyExecutorImpl> existingExecutors = new ConcurrentHashMap<String, PolicyExecutorImpl>();
        ConcurrentHashMap<String, PolicyExecutorImpl> concurrentHashMap = this.policyExecutors;
        synchronized (concurrentHashMap) {
            existingExecutors.putAll(this.policyExecutors);
        }
        for (PolicyExecutor pe : existingExecutors.values()) {
            pe.shutdown();
        }
    }

    public void shutdownNow(String owner) {
        for (PolicyExecutorImpl executor : this.policyExecutors.values()) {
            if (!owner.equals(executor.owner)) continue;
            executor.shutdownNow();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PolicyExecutorProvider.class);
    }
}

