/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConcurrentServiceReferenceSetMap<K, V> {
    private final String referenceName;
    private final AtomicReference<ComponentContext> contextRef = new AtomicReference();
    private final ConcurrentMap<K, ConcurrentServiceReferenceSet<V>> elementMap = new ConcurrentHashMap<K, ConcurrentServiceReferenceSet<V>>();
    static final long serialVersionUID = 3989241656374722006L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConcurrentServiceReferenceSetMap(String name) {
        this.referenceName = name;
    }

    public void activate(ComponentContext context) {
        if (this.contextRef.get() != null) {
            throw new IllegalStateException("already activated");
        }
        this.contextRef.set(context);
    }

    public void deactivate(ComponentContext context) {
        if (this.contextRef.get() == null) {
            throw new IllegalStateException("not activated");
        }
        this.contextRef.set(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[refName=" + this.referenceName + ", isEmpty=" + this.elementMap.isEmpty() + ", isActive=" + (this.contextRef.get() != null) + "]";
    }

    public boolean putReference(K key, ServiceReference<V> reference) {
        if (key == null || reference == null) {
            return false;
        }
        ConcurrentServiceReferenceSet<V> csrs = (ConcurrentServiceReferenceSet<V>)this.elementMap.get(key);
        if (csrs == null) {
            ConcurrentServiceReferenceSet<V> newSet = new ConcurrentServiceReferenceSet<V>(this.referenceName, this.contextRef);
            ConcurrentServiceReferenceSet currentSet = this.elementMap.putIfAbsent(key, newSet);
            csrs = currentSet == null ? newSet : currentSet;
        }
        return csrs.addReference(reference);
    }

    public boolean removeReference(K key, ServiceReference<V> reference) {
        if (key == null) {
            return false;
        }
        ConcurrentServiceReferenceSet csrs = (ConcurrentServiceReferenceSet)this.elementMap.get(key);
        if (csrs == null) {
            return false;
        }
        return csrs.removeReference(reference);
    }

    public boolean isEmpty() {
        boolean empty = true;
        boolean done = false;
        while (empty && !done) {
            for (ConcurrentServiceReferenceSet s : this.elementMap.values()) {
                empty &= s.isEmpty();
            }
            done = true;
        }
        return empty;
    }

    public Iterator<V> getServices(K key) {
        ComponentContext ctx = this.contextRef.get();
        if (ctx == null || key == null) {
            return null;
        }
        ConcurrentServiceReferenceSet e = (ConcurrentServiceReferenceSet)this.elementMap.get(key);
        if (e == null || e.isEmpty()) {
            return null;
        }
        return e.getServices();
    }

    public Iterator<ServiceAndServiceReferencePair<V>> getServicesWithReferences(K key) {
        ComponentContext ctx = this.contextRef.get();
        if (ctx == null || key == null) {
            return null;
        }
        ConcurrentServiceReferenceSet e = (ConcurrentServiceReferenceSet)this.elementMap.get(key);
        if (e == null || e.isEmpty()) {
            return null;
        }
        return e.getServicesWithReferences();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentServiceReferenceSetMap.class);
    }
}

