/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.opentracing.OpentracingContext;
import com.ibm.ws.opentracing.OpentracingUserFeatureAccessService;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpentracingTracerManager {
    private static final TraceComponent tc = Tr.register(OpentracingTracerManager.class);
    private static final Map<String, Tracer> applicationTracers = new HashMap<String, Tracer>();
    private static final ApplicationTracersLock applicationTracersLock = new ApplicationTracersLock();
    private static final ThreadLocal<OpentracingContext> OPEN_TRACING_CONTEXT_VAR = new OpentracingThreadLocal();
    static final long serialVersionUID = -30597724681878015L;

    @Trivial
    private static Tracer getTracer(String appName) {
        return applicationTracers.get(appName);
    }

    @Trivial
    private static Tracer putTracer(String appName, Tracer tracer) {
        return applicationTracers.put(appName, tracer);
    }

    @Trivial
    private static Tracer removeTracer(String appName, Tracer tracer) {
        return applicationTracers.remove(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @ManualTrace
    private static Tracer ensureTracer(String appName) {
        String tracerCase;
        Tracer tracer;
        String methodName = "ensureTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{appName});
        }
        ApplicationTracersLock applicationTracersLock = OpentracingTracerManager.applicationTracersLock;
        synchronized (applicationTracersLock) {
            tracer = OpentracingTracerManager.getTracer(appName);
            if (tracer == null) {
                tracer = OpentracingTracerManager.createTracer(appName);
                OpentracingTracerManager.putTracer(appName, tracer);
                tracerCase = "newly created";
            } else {
                tracerCase = "previously created";
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + tracerCase + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    @Trivial
    private static Tracer createTracer(String appName) {
        return OpentracingUserFeatureAccessService.getTracerInstance(appName);
    }

    @Trivial
    @ManualTrace
    public static Tracer getTracer() {
        String tracerCase;
        String methodName = "getTracer";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        OpentracingContext tracerContext = OpentracingTracerManager.getOpentracingContext();
        String appName = tracerContext.getAppName();
        Tracer tracer = tracerContext.getTracer();
        if (tracer != null) {
            tracerCase = "previously stored for " + appName;
        } else {
            appName = OpentracingUtils.lookupAppName();
            tracer = OpentracingTracerManager.ensureTracer(appName);
            tracerContext.setTracer(appName, tracer);
            tracerCase = "newly stored for " + appName;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            long threadId = currentThread.getId();
            Tr.exit((TraceComponent)tc, (String)(methodName + " (" + tracerCase + ") in (" + threadName + ":" + Long.toString(threadId) + ")"), (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    @Trivial
    private static OpentracingContext getOpentracingContext() {
        return OPEN_TRACING_CONTEXT_VAR.get();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class OpentracingThreadLocal
    extends InheritableThreadLocal<OpentracingContext> {
        static final long serialVersionUID = -7741692698163985022L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private OpentracingThreadLocal() {
        }

        @Override
        protected OpentracingContext initialValue() {
            return new OpentracingContext();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OpentracingThreadLocal.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ApplicationTracersLock {
        static final long serialVersionUID = -5885845560963861891L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ApplicationTracersLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationTracersLock.class);
        }
    }
}

