/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.Server;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OB.UpcallReturn;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;

public final class CollocatedServer
extends Server
implements UpcallReturn {
    static final Logger logger = Logger.getLogger(CollocatedServer.class.getName());
    private int nextRequestId_ = 0;
    private Object nextRequestIdMutex_ = new Object();
    private Hashtable callMap_ = new Hashtable(13);
    private boolean destroy_ = false;
    private boolean hold_ = true;
    private OAInterface oaInterface_;

    public CollocatedServer(OAInterface oaInterface, int concModel) {
        super(concModel);
        this.oaInterface_ = oaInterface;
    }

    @Override
    public synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration e = this.callMap_.keys();
        while (e.hasMoreElements()) {
            Downcall down = (Downcall)this.callMap_.get(e.nextElement());
            Assert._OB_assert(down != null);
            Assert._OB_assert(down.pending());
            down.setFailureException((SystemException)new INITIALIZE("ORB has been destroyed", 1095974913, CompletionStatus.COMPLETED_NO));
        }
        this.callMap_.clear();
        this.notifyAll();
    }

    @Override
    public synchronized void hold() {
        Assert._OB_assert(!this.destroy_);
        logger.fine("Collocated server placed in hold state");
        this.hold_ = true;
        this.notifyAll();
    }

    @Override
    public synchronized void activate() {
        Assert._OB_assert(!this.destroy_);
        logger.fine("Collocated server activated");
        this.hold_ = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Downcall down, boolean b) {
        Upcall up;
        logger.fine("Sending a request");
        down.allowWaiting();
        CollocatedServer collocatedServer = this;
        synchronized (collocatedServer) {
            while (this.hold_ && !this.destroy_) {
                try {
                    logger.fine("Waiting for hold to be released");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.destroy_) {
                down.setFailureException((SystemException)((Object)new TRANSIENT("Collocated server has already been destroyed", 0, CompletionStatus.COMPLETED_NO)));
                return true;
            }
            ProfileInfo profileInfo = down.profileInfo();
            int reqId = down.requestId();
            String op = down.operation();
            OutputStream out = down.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            ServiceContext[] requestSCL = down.getRequestSCL();
            if (op.charAt(0) == '_' && op.equals("_locate")) {
                IORHolder ior = new IORHolder();
                switch (this.oaInterface_.findByKey(profileInfo.key, ior)) {
                    case 0: {
                        down.setSystemException((SystemException)new OBJECT_NOT_EXIST());
                        break;
                    }
                    case 1: {
                        InputStream in = new InputStream(buf, 0, false);
                        down.setNoException(in);
                        break;
                    }
                    case 2: {
                        down.setLocationForward(ior.value, false);
                        break;
                    }
                    case 3: {
                        down.setLocationForward(ior.value, true);
                        break;
                    }
                    default: {
                        Assert._OB_assert(false);
                    }
                }
                return true;
            }
            if (down.responseExpected()) {
                this.callMap_.put(new Integer(reqId), down);
                down.setPending();
                up = this.oaInterface_.createUpcall(this, profileInfo, null, reqId, op, new InputStream(buf, 0, false), requestSCL);
            } else {
                down.setNoException(null);
                up = this.oaInterface_.createUpcall(null, profileInfo, null, reqId, op, new InputStream(buf, 0, false), requestSCL);
            }
        }
        up.invoke();
        return !down.responseExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(Downcall down, boolean block) {
        logger.fine("Receiving a request");
        try {
            return down.waitUntilCompleted(block);
        }
        catch (SystemException ex) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                this.callMap_.remove(new Integer(down.requestId()));
                down.setFailureException(ex);
                return true;
            }
        }
    }

    public boolean sendReceive(Downcall down) {
        this.send(down, true);
        return this.receive(down, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            return this.nextRequestId_++;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        return this.oaInterface_.getUsableProfiles(ior, policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upcallBeginReply(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(0);
        if (replySCL.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (down != null) {
                    down.setReplySCL(replySCL);
                }
            }
        }
    }

    @Override
    public synchronized void upcallEndReply(Upcall upcall) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            OutputStream out = upcall.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            InputStream in = new InputStream(buf, 0, false);
            down.setNoException(in);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upcallBeginUserException(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(0);
        if (replySCL.length > 0) {
            CollocatedServer collocatedServer = this;
            synchronized (collocatedServer) {
                Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
                if (down != null) {
                    down.setReplySCL(replySCL);
                }
            }
        }
    }

    @Override
    public synchronized void upcallEndUserException(Upcall upcall) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            OutputStream out = upcall.output();
            Buffer buf = new Buffer();
            buf.consume(out._OB_buffer());
            InputStream in = new InputStream(buf, 0, false);
            down.setUserException(in);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    @Override
    public void upcallUserException(Upcall upcall, UserException ex, ServiceContext[] replySCL) {
        this.upcallBeginUserException(upcall, replySCL);
        OutputStream out = upcall.output();
        try {
            Assert._OB_assert(false);
        }
        catch (SystemException e) {
            try {
                upcall.marshalEx(e);
            }
            catch (LocationForward f) {
                Assert._OB_assert(ex);
            }
        }
        this.upcallEndUserException(upcall);
    }

    @Override
    public synchronized void upcallSystemException(Upcall upcall, SystemException ex, ServiceContext[] replySCL) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            if (replySCL.length > 0) {
                down.setReplySCL(replySCL);
            }
            down.setSystemException(ex);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    @Override
    public synchronized void upcallForward(Upcall upcall, IOR ior, boolean perm, ServiceContext[] replySCL) {
        Downcall down = (Downcall)this.callMap_.get(new Integer(upcall.requestId()));
        if (down != null) {
            if (replySCL.length > 0) {
                down.setReplySCL(replySCL);
            }
            down.setLocationForward(ior, perm);
            this.callMap_.remove(new Integer(down.requestId()));
        }
    }

    @Override
    public boolean replySent() {
        return true;
    }
}

