/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.MessageWriter;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.WsocWriteCallback;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LinkWrite {
    private static final TraceComponent tc = Tr.register(LinkWrite.class);
    private HashMap<Class<?>, Encoder> binaryEncoders = null;
    private HashMap<Class<?>, Encoder> textEncoders = null;
    private HashMap<Class<?>, Encoder> binaryStreamEncoders = null;
    private HashMap<Class<?>, Encoder> textStreamEncoders = null;
    private TCPWriteRequestContext tcpWriteContext = null;
    private MessageWriter messageWriter = null;
    private boolean wsocSendOutstanding = false;
    private SendHandler wsocSendHandler = null;
    private final SendResult SendResultGood = new SendResult();
    private EndpointConfig endpointConfig = null;
    private boolean shouldMaskData = false;
    private WsocConnLink connLink = null;
    static final long serialVersionUID = -4500812965031525076L;

    public void initialize(TCPWriteRequestContext _wrc, EndpointConfig _epc, WsocConnLink _link, boolean _shouldMaskData) {
        this.tcpWriteContext = _wrc;
        this.endpointConfig = _epc;
        this.connLink = _link;
        this.shouldMaskData = _shouldMaskData;
    }

    public void frameCleanup() {
        this.messageWriter.frameCleanup();
    }

    public void processWrite(TCPWriteRequestContext wsc) {
        if (this.wsocSendOutstanding) {
            this.wsocSendOutstanding = false;
            if (this.wsocSendHandler != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("calling onResult on SendHandler: " + this.wsocSendHandler), (Object[])new Object[0]);
                }
                this.wsocSendHandler.onResult(this.SendResultGood);
            }
        }
    }

    public void processError(TCPWriteRequestContext wsc, Throwable ioe) {
        if (wsc != null) {
            this.messageWriter.frameCleanup();
        }
        if (this.wsocSendOutstanding) {
            this.wsocSendOutstanding = false;
            if (this.wsocSendHandler != null) {
                SendResult result = new SendResult(ioe);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("calling onResult on SendHandler: " + this.wsocSendHandler), (Object[])new Object[0]);
                }
                this.wsocSendHandler.onResult(result);
            }
        }
    }

    public void destroy(Exception e) {
        if (this.binaryEncoders != null) {
            this.destroyEncoders(this.binaryEncoders);
        }
        if (this.textEncoders != null) {
            this.destroyEncoders(this.textEncoders);
        }
        if (this.binaryStreamEncoders != null) {
            this.destroyEncoders(this.binaryStreamEncoders);
        }
        if (this.textStreamEncoders != null) {
            this.destroyEncoders(this.textStreamEncoders);
        }
    }

    private void destroyEncoders(Map<?, Encoder> _encoders) {
        Iterator<Map.Entry<?, Encoder>> it = _encoders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, Encoder> entry = it.next();
            Encoder en = entry.getValue();
            en.destroy();
            it.remove();
        }
    }

    @FFDCIgnore(value={IOException.class})
    public boolean cancelWriteBufferAsync() {
        try {
            this.messageWriter.cancelMessageAsync();
            return true;
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("caught IOException: " + e), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @FFDCIgnore(value={IOException.class})
    public void writeBuffer(@Sensitive WsByteBuffer buffer, OpcodeType ot, MessageWriter.WRITE_TYPE writeType, SendHandler handler, int timeout) throws IOException {
        if (this.messageWriter == null) {
            WsocWriteCallback writeCallback = this.connLink.getWriteCallback();
            this.messageWriter = new MessageWriter();
            this.messageWriter.initialize(this.tcpWriteContext, writeCallback, this.shouldMaskData);
        }
        try {
            if (writeType == MessageWriter.WRITE_TYPE.ASYNC) {
                this.wsocSendHandler = handler;
                this.wsocSendOutstanding = true;
            }
            this.messageWriter.WriteMessage(buffer, ot, timeout, writeType);
        }
        catch (IOException x) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException: " + x.getMessage()), (Object[])new Object[0]);
            }
            if (writeType == MessageWriter.WRITE_TYPE.ASYNC) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unexpectedly Caught IOException on Async Write code path: " + x), (Object[])new Object[0]);
                }
                this.wsocSendOutstanding = false;
                RuntimeException re = new RuntimeException(x);
                throw re;
            }
            throw x;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeObject(@Sensitive Object objectToWrite, MessageWriter.WRITE_TYPE writeType, SendHandler handler, boolean fromOnMessage) throws EncodeException, IOException {
        List<Class> encoders;
        Class<?> clazzToWrite = objectToWrite.getClass();
        if (this.messageWriter == null) {
            WsocWriteCallback writeCallback = this.connLink.getWriteCallback();
            this.messageWriter = new MessageWriter();
            this.messageWriter.initialize(this.tcpWriteContext, writeCallback, this.shouldMaskData);
        }
        if (writeType == MessageWriter.WRITE_TYPE.ASYNC) {
            this.wsocSendHandler = handler;
            this.wsocSendOutstanding = true;
        }
        if ((encoders = this.endpointConfig.getEncoders()) == null) {
            encoders = Collections.emptyList();
        }
        boolean encoderUsed = false;
        for (Class encoder : encoders) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("looking at encoder: " + encoder), (Object[])new Object[0]);
            }
            if (encoderUsed) break;
            ArrayList<Type> interfaces = new ArrayList<Type>();
            Utils.getAllInterfaces(encoder, interfaces);
            Object[] ta = interfaces.toArray();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ta[]: " + Arrays.toString(ta)), (Object[])new Object[0]);
            }
            for (Object t : ta) {
                Class<?> clazz = Utils.getCodingClass((Type)t);
                if (clazz == null || clazzToWrite == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encoding looking at clazz: " + clazz), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("with clazzToWrite: " + clazzToWrite), (Object[])new Object[0]);
                }
                if (!clazz.isAssignableFrom(clazzToWrite) || (encoderUsed = this.writeUsingEncoderFromCache(objectToWrite, clazz, writeType))) continue;
                Encoder en = null;
                try {
                    en = (Encoder)encoder.newInstance();
                }
                catch (Exception exception) {
                    void e;
                    Object[] objectArray = new Object[4];
                    objectArray[0] = "<sensitive java.lang.Object>";
                    objectArray[1] = writeType;
                    objectArray[2] = handler;
                    objectArray[3] = fromOnMessage;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.LinkWrite", (String)"258", (Object)this, (Object[])objectArray);
                    throw new EncodeException(objectToWrite, e.getMessage(), e.getCause());
                }
                if (en instanceof Encoder.Binary) {
                    encoderUsed = this.writeUsingEncoderBinary(objectToWrite, clazz, writeType, (Encoder.Binary)en, true);
                    continue;
                }
                if (en instanceof Encoder.Text) {
                    encoderUsed = this.writeUsingEncoderText(objectToWrite, clazz, writeType, (Encoder.Text)en, true);
                    continue;
                }
                if (en instanceof Encoder.BinaryStream) {
                    encoderUsed = this.writeUsingEncoderBinaryStream(objectToWrite, clazz, writeType, (Encoder.BinaryStream)en, true);
                    continue;
                }
                if (!(en instanceof Encoder.TextStream)) continue;
                encoderUsed = this.writeUsingEncoderTextStream(objectToWrite, clazz, writeType, (Encoder.TextStream)en, true);
            }
        }
        if (!encoderUsed) {
            WsByteBuffer wsBuffer;
            byte[] ba;
            Object data;
            if (objectToWrite instanceof String) {
                data = (String)objectToWrite;
                ba = ((String)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Character) {
                data = (Character)objectToWrite;
                ba = ((Character)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Boolean) {
                data = (Boolean)objectToWrite;
                ba = ((Boolean)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Short) {
                data = (Short)objectToWrite;
                ba = ((Short)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Integer) {
                data = (Integer)objectToWrite;
                ba = ((Integer)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Long) {
                data = (Long)objectToWrite;
                ba = ((Long)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Float) {
                data = (Float)objectToWrite;
                ba = ((Float)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Double) {
                data = (Double)objectToWrite;
                ba = ((Double)data).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba, writeType);
            } else if (objectToWrite instanceof Byte) {
                byte[] ba2 = ((Byte)objectToWrite).toString().getBytes(Utils.UTF8_CHARSET);
                this.writeTextMessage(ba2, writeType);
            } else if (objectToWrite instanceof byte[]) {
                wsBuffer = this.connLink.getBufferManager().wrap((byte[])objectToWrite);
                this.messageWriter.WriteMessage(wsBuffer, OpcodeType.BINARY_WHOLE, -1, writeType);
            } else if (objectToWrite instanceof ByteBuffer) {
                wsBuffer = this.connLink.getBufferManager().wrap((ByteBuffer)objectToWrite);
                this.messageWriter.WriteMessage(wsBuffer, OpcodeType.BINARY_WHOLE, -1, writeType);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can not send data, no encoder found: ", (Object[])new Object[0]);
                }
                EncodeException encodeException = new EncodeException(objectToWrite, "Can not send data, no encoder found");
                this.connLink.callOnError((Throwable)encodeException);
            }
        }
    }

    private boolean writeUsingEncoderText(@Sensitive Object objectToWrite, Class<?> encoderClass, MessageWriter.WRITE_TYPE writeType, Encoder.Text _en, boolean addToCache) throws IOException, EncodeException {
        int timeout = -1;
        Encoder.Text en = _en;
        if (en == null && this.textEncoders != null) {
            en = (Encoder.Text)this.textEncoders.get(encoderClass);
        }
        if (en != null) {
            String s = en.encode(objectToWrite);
            byte[] ba = s.getBytes(Utils.UTF8_CHARSET);
            WsByteBuffer buffer = this.connLink.getBufferManager().wrap(ba);
            this.messageWriter.WriteMessage(buffer, OpcodeType.TEXT_WHOLE, timeout, writeType);
            if (addToCache) {
                if (this.textEncoders == null) {
                    this.textEncoders = new HashMap();
                }
                en.init(this.endpointConfig);
                this.textEncoders.put(encoderClass, (Encoder)en);
            }
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={IOException.class})
    private boolean writeUsingEncoderTextStream(@Sensitive Object objectToWrite, Class encoderClass, MessageWriter.WRITE_TYPE writeType, Encoder.TextStream _en, boolean addToCache) throws IOException, EncodeException {
        int timeout = -1;
        Encoder.TextStream en = _en;
        if (en == null && this.textStreamEncoders != null) {
            en = (Encoder.TextStream)this.textStreamEncoders.get(encoderClass);
        }
        if (en != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(bos);
            en.encode(objectToWrite, (Writer)osw);
            try {
                osw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] ba = bos.toByteArray();
            WsByteBuffer buffer = this.connLink.getBufferManager().wrap(ba);
            this.messageWriter.WriteMessage(buffer, OpcodeType.TEXT_WHOLE, timeout, writeType);
            if (addToCache) {
                if (this.textStreamEncoders == null) {
                    this.textStreamEncoders = new HashMap();
                }
                en.init(this.endpointConfig);
                this.textStreamEncoders.put(encoderClass, (Encoder)en);
            }
            return true;
        }
        return false;
    }

    private boolean writeUsingEncoderBinary(@Sensitive Object objectToWrite, Class encoderClass, MessageWriter.WRITE_TYPE writeType, Encoder.Binary _en, boolean addToCache) throws IOException, EncodeException {
        int timeout = -1;
        Encoder.Binary en = _en;
        if (en == null && this.binaryEncoders != null) {
            en = (Encoder.Binary)this.binaryEncoders.get(encoderClass);
        }
        if (en != null) {
            ByteBuffer b = en.encode(objectToWrite);
            WsByteBuffer buffer = this.connLink.getBufferManager().wrap(b);
            this.messageWriter.WriteMessage(buffer, OpcodeType.BINARY_WHOLE, timeout, writeType);
            if (addToCache) {
                if (this.binaryEncoders == null) {
                    this.binaryEncoders = new HashMap();
                }
                en.init(this.endpointConfig);
                this.binaryEncoders.put(encoderClass, (Encoder)en);
            }
            return true;
        }
        return false;
    }

    private boolean writeUsingEncoderBinaryStream(@Sensitive Object objectToWrite, Class encoderClass, MessageWriter.WRITE_TYPE writeType, Encoder.BinaryStream _en, boolean addToCache) throws IOException, EncodeException {
        int timeout = -1;
        Encoder.BinaryStream en = _en;
        if (en == null && this.binaryStreamEncoders != null) {
            en = (Encoder.BinaryStream)this.binaryStreamEncoders.get(encoderClass);
        }
        if (en != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            en.encode(objectToWrite, (OutputStream)bos);
            byte[] ba = bos.toByteArray();
            WsByteBuffer buffer = this.connLink.getBufferManager().wrap(ba);
            this.messageWriter.WriteMessage(buffer, OpcodeType.BINARY_WHOLE, timeout, writeType);
            if (addToCache) {
                if (this.binaryStreamEncoders == null) {
                    this.binaryStreamEncoders = new HashMap();
                }
                en.init(this.endpointConfig);
                this.binaryStreamEncoders.put(encoderClass, (Encoder)en);
            }
            return true;
        }
        return false;
    }

    private boolean writeUsingEncoderFromCache(@Sensitive Object objectToWrite, Class encoderClass, MessageWriter.WRITE_TYPE writeType) throws IOException, EncodeException {
        Encoder.Text en;
        if (this.textEncoders != null && (en = (Encoder.Text)this.textEncoders.get(encoderClass)) != null) {
            return this.writeUsingEncoderText(objectToWrite, encoderClass, writeType, en, false);
        }
        if (this.textStreamEncoders != null && (en = (Encoder.TextStream)this.textStreamEncoders.get(encoderClass)) != null) {
            return this.writeUsingEncoderTextStream(objectToWrite, encoderClass, writeType, (Encoder.TextStream)en, false);
        }
        if (this.binaryEncoders != null && (en = (Encoder.Binary)this.binaryEncoders.get(encoderClass)) != null) {
            return this.writeUsingEncoderBinary(objectToWrite, encoderClass, writeType, (Encoder.Binary)en, false);
        }
        if (this.binaryStreamEncoders != null && (en = (Encoder.BinaryStream)this.binaryStreamEncoders.get(encoderClass)) != null) {
            return this.writeUsingEncoderBinaryStream(objectToWrite, encoderClass, writeType, (Encoder.BinaryStream)en, false);
        }
        return false;
    }

    private void writeTextMessage(byte[] byteArray, MessageWriter.WRITE_TYPE type) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        WsByteBuffer wsBuffer = this.connLink.getBufferManager().wrap(buffer);
        this.messageWriter.WriteMessage(wsBuffer, OpcodeType.TEXT_WHOLE, -1, type);
    }
}

