/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.EndpointMethodHelper;
import com.ibm.ws.wsoc.FrameFormatException;
import com.ibm.ws.wsoc.FrameReadProcessor;
import com.ibm.ws.wsoc.FrameState;
import com.ibm.ws.wsoc.MaxMessageException;
import com.ibm.ws.wsoc.MessageReadInfo;
import com.ibm.ws.wsoc.MethodData;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WsocBufferException;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.WsocReadCallback;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MessageReader {
    private static final TraceComponent tc = Tr.register(MessageReader.class);
    private static final int BUFFER_ARRAY_INITIAL_SIZE = 10;
    private static final int BUFFER_ARRAY_GROWTH_SIZE = 10;
    boolean shouldReadMaskedData = true;
    boolean needNewFrameProcessor = false;
    FrameReadProcessor frameProcessor = new FrameReadProcessor();
    FSeqState frameSequenceState = FSeqState.EXPECTING_NEW;
    WsByteBuffer nextMessageBuf = null;
    OpcodeType firstFrameOpcodeType = null;
    WsByteBuffer[] payloadBuffers = null;
    int payloadCountOfBuffers = 0;
    int messageCompletePayloadSize = 0;
    WsByteBuffer[] payloadBuffers_Control = null;
    int payloadCountOfBuffers_Control = 0;
    int messageCompletePayloadSize_Control = 0;
    OpcodeType controlOpcodeType = null;
    FrameReadProcessor[] fpList = new FrameReadProcessor[10];
    int countOfIOFrames = 0;
    WsocReadCallback callback = null;
    WsocConnLink connLink = null;
    static final long serialVersionUID = 4590660918513883833L;

    public void initialize(WsocReadCallback _cb, WsocConnLink _link, boolean _shouldReadMaskedData) {
        this.callback = _cb;
        this.connLink = _link;
        this.shouldReadMaskedData = _shouldReadMaskedData;
        this.frameProcessor.initialize(this.shouldReadMaskedData);
    }

    public void resetControlFrameParameters(boolean releaseBuffers) {
        this.payloadCountOfBuffers_Control = 0;
        this.messageCompletePayloadSize_Control = 0;
        if (releaseBuffers) {
            this.frameProcessor.releaseBuffers();
        }
    }

    public void reset() {
        if (this.nextMessageBuf == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"reset called - no left over buffers.", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset called - but will still process data left over for the next message.", (Object[])new Object[0]);
        }
        this.resetControlFrameParameters(false);
        this.frameSequenceState = FSeqState.EXPECTING_NEW;
        this.firstFrameOpcodeType = null;
        this.payloadCountOfBuffers = 0;
        this.messageCompletePayloadSize = 0;
        if (this.countOfIOFrames > 0) {
            for (int i = 0; i < this.countOfIOFrames; ++i) {
                if (this.fpList[i] == null) continue;
                this.fpList[i].reset(true);
            }
        } else {
            this.frameProcessor.reset(true);
        }
        this.fpList = new FrameReadProcessor[10];
        this.countOfIOFrames = 0;
    }

    public void setFrameSequenceState(FSeqState x) {
        this.frameSequenceState = x;
    }

    public MessageReadInfo processRead(TCPReadRequestContext rrc, boolean txtPartialAvailable, boolean binaryPartialAvailable, boolean anticipatingCloseFrame) throws FrameFormatException, WsocBufferException, MaxMessageException {
        WsByteBuffer currentBuf = null;
        if (rrc != null) {
            currentBuf = rrc.getBuffer();
        }
        if (currentBuf == null) {
            currentBuf = this.nextMessageBuf;
            this.nextMessageBuf = null;
        } else {
            currentBuf.flip();
        }
        if (this.needNewFrameProcessor) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"creating a new FrameReadProcessor", (Object[])new Object[0]);
            }
            this.frameProcessor = new FrameReadProcessor();
            this.frameProcessor.initialize(this.shouldReadMaskedData);
            this.needNewFrameProcessor = false;
        }
        int nextMessagePosition = this.frameProcessor.processNextBuffer(currentBuf);
        FrameState frameState = this.frameProcessor.getFrameState();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frame state is: " + (Object)((Object)frameState) + " frameSequenceState is: " + (Object)((Object)this.frameSequenceState) + " nextMessagePosition is: " + nextMessagePosition), (Object[])new Object[0]);
        }
        if (nextMessagePosition >= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"slicing buffer, since this buffer contains end of old message and start of the next", (Object[])new Object[0]);
            }
            int oldPosition = currentBuf.position();
            currentBuf.position(nextMessagePosition);
            this.nextMessageBuf = currentBuf.slice();
            currentBuf.position(oldPosition);
            currentBuf.limit(nextMessagePosition);
        } else {
            this.nextMessageBuf = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frameSequenceState before: " + (Object)((Object)this.frameSequenceState)), (Object[])new Object[0]);
        }
        if (!(this.frameSequenceState != FSeqState.EXPECTING_NEW && this.frameSequenceState != FSeqState.EXPECTING_PARTIAL_OR_LAST || frameState != FrameState.FIND_PAYLOAD && frameState != FrameState.PAYLOAD_COMPLETE)) {
            this.verifyAndSetFrameVariables(this.frameProcessor);
        }
        this.processMaxMessageSize(this.frameProcessor.getPayloadLength());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frameSequenceState after: " + (Object)((Object)this.frameSequenceState)), (Object[])new Object[0]);
        }
        if (anticipatingCloseFrame && this.frameProcessor.getPayloadLength() >= 126L) {
            MessageReadInfo mri = new MessageReadInfo(MessageReadInfo.State.CLOSE_FRAME_ERROR, this.firstFrameOpcodeType, nextMessagePosition >= 0);
            return mri;
        }
        if (frameState == FrameState.PAYLOAD_COMPLETE) {
            if (this.shouldReadMaskedData) {
                this.frameProcessor.unmaskPayload();
            }
            if (!this.frameProcessor.getControlFrame()) {
                if (this.countOfIOFrames >= this.fpList.length) {
                    int originalSize = this.fpList.length;
                    FrameReadProcessor[] temp = new FrameReadProcessor[originalSize + 10];
                    System.arraycopy(this.fpList, 0, temp, 0, originalSize);
                    this.fpList = temp;
                }
                this.fpList[this.countOfIOFrames] = this.frameProcessor;
                ++this.countOfIOFrames;
                this.needNewFrameProcessor = true;
                if (this.frameSequenceState == FSeqState.FIRST_AND_LAST || this.frameSequenceState == FSeqState.LAST_OF_MULTIPLE) {
                    this.gatherUpAllFramesAndPayload();
                    MessageReadInfo info = new MessageReadInfo(MessageReadInfo.State.COMPLETE, this.firstFrameOpcodeType, nextMessagePosition >= 0);
                    return info;
                }
                if (this.countOfIOFrames == 1) {
                    if (this.firstFrameOpcodeType == OpcodeType.TEXT_WHOLE && txtPartialAvailable) {
                        this.gatherUpAllFramesAndPayload();
                    } else if (this.firstFrameOpcodeType == OpcodeType.BINARY_WHOLE && binaryPartialAvailable) {
                        this.gatherUpAllFramesAndPayload();
                    }
                    MessageReadInfo info = new MessageReadInfo(MessageReadInfo.State.PARTIAL_COMPLETE, this.firstFrameOpcodeType, nextMessagePosition >= 0);
                    return info;
                }
            } else {
                this.gatherUpPayload_Control();
                if (this.frameSequenceState != FSeqState.FIRST_AND_LAST && this.frameSequenceState != FSeqState.EXPECTING_NEW) {
                    OpcodeType ot = this.frameProcessor.getControlOpcodeType();
                    MessageReadInfo info = new MessageReadInfo(MessageReadInfo.State.CONTROL_MESSAGE_EMBEDDED, ot, nextMessagePosition >= 0);
                    this.needNewFrameProcessor = true;
                    return info;
                }
                MessageReadInfo info = new MessageReadInfo(MessageReadInfo.State.COMPLETE, this.firstFrameOpcodeType, nextMessagePosition >= 0);
                this.needNewFrameProcessor = true;
                return info;
            }
        }
        MessageReadInfo info = new MessageReadInfo(MessageReadInfo.State.FRAME_INCOMPLETE, this.firstFrameOpcodeType, nextMessagePosition >= 0);
        return info;
    }

    public void removeFirstFrameFromProcessor() {
        this.fpList[0].reset(true);
        this.countOfIOFrames = 0;
        this.payloadCountOfBuffers = 0;
        this.messageCompletePayloadSize = 0;
    }

    public void releaseBuffers() {
        if (this.payloadBuffers != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("release payload buffers.  number to release is: " + this.payloadCountOfBuffers), (Object[])new Object[0]);
            }
            for (int i = 0; i < this.payloadCountOfBuffers; ++i) {
                this.payloadBuffers[i].release();
            }
            this.payloadBuffers = null;
            this.payloadCountOfBuffers = 0;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("release buffers from frame list.  number to release is: " + this.countOfIOFrames), (Object[])new Object[0]);
            }
            if (this.countOfIOFrames > 0) {
                for (int i = 0; i < this.countOfIOFrames; ++i) {
                    this.fpList[i].releaseBuffers();
                }
            } else {
                this.frameProcessor.releaseBuffers();
            }
        }
    }

    @Sensitive
    public WsByteBuffer[] getMessagePayload() {
        return this.payloadBuffers;
    }

    public int getMessageCompletePayloadSize() {
        return this.messageCompletePayloadSize;
    }

    @Sensitive
    public WsByteBuffer[] getMessagePayload_Control() {
        return this.payloadBuffers_Control;
    }

    public int getMessageCompletePayloadSize_Control() {
        return this.messageCompletePayloadSize_Control;
    }

    private WsByteBufferPoolManager getBufferManager() {
        return ServiceManager.getBufferPoolManager();
    }

    private void gatherUpPayload_Control() {
        int countOfBuffers = this.frameProcessor.getFrameBufferListSize();
        if (countOfBuffers > 0) {
            this.payloadBuffers_Control = new WsByteBuffer[countOfBuffers];
            this.payloadCountOfBuffers_Control = 0;
            for (int j = 0; j < countOfBuffers; ++j) {
                this.payloadBuffers_Control[this.payloadCountOfBuffers_Control] = this.frameProcessor.getBufferAtIndex(j);
                ++this.payloadCountOfBuffers_Control;
            }
            for (WsByteBuffer buf : this.payloadBuffers_Control) {
                if (buf == null) continue;
                this.messageCompletePayloadSize_Control += buf.limit() - buf.position();
            }
        }
    }

    private void gatherUpAllFramesAndPayload() {
        int i;
        int countOfBuffers = 0;
        for (i = 0; i < this.countOfIOFrames; ++i) {
            countOfBuffers += this.fpList[i].getFrameBufferListSize();
        }
        if (countOfBuffers > 0) {
            this.payloadBuffers = new WsByteBuffer[countOfBuffers];
            this.payloadCountOfBuffers = 0;
            for (i = 0; i < this.countOfIOFrames; ++i) {
                int size = this.fpList[i].getFrameBufferListSize();
                for (int j = 0; j < size; ++j) {
                    this.payloadBuffers[this.payloadCountOfBuffers] = this.fpList[i].getBufferAtIndex(j);
                    ++this.payloadCountOfBuffers;
                }
            }
            for (WsByteBuffer buf : this.payloadBuffers) {
                if (buf == null) continue;
                this.messageCompletePayloadSize += buf.limit() - buf.position();
            }
        }
    }

    private void verifyAndSetFrameVariables(FrameReadProcessor fp) throws FrameFormatException {
        byte maskFlag;
        boolean embeddedControlFrame = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frameSequenceState upon entry is: " + (Object)((Object)this.frameSequenceState)), (Object[])new Object[0]);
        }
        if (fp.getControlFrame() && this.frameSequenceState != FSeqState.FIRST_AND_LAST && this.frameSequenceState != FSeqState.EXPECTING_NEW) {
            embeddedControlFrame = true;
        }
        if (!embeddedControlFrame) {
            byte opcode;
            byte fin = fp.getFin();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("fin is: " + fin), (Object[])new Object[0]);
            }
            if (fin == 1) {
                if (this.frameSequenceState == FSeqState.EXPECTING_NEW) {
                    this.frameSequenceState = FSeqState.FIRST_AND_LAST;
                } else if (this.frameSequenceState == FSeqState.FIRST_OF_MULTIPLE || this.frameSequenceState == FSeqState.MIDDLE_OF_MULTIPLE || this.frameSequenceState == FSeqState.EXPECTING_PARTIAL_OR_LAST) {
                    this.frameSequenceState = FSeqState.LAST_OF_MULTIPLE;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because of an error processing FIN of 1."), (Object[])new Object[0]);
                    }
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"fin1.processing.error", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
                    FrameFormatException ffe = new FrameFormatException(msg);
                    throw ffe;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("frameSequenceState is now: " + (Object)((Object)this.frameSequenceState)), (Object[])new Object[0]);
                }
            } else if (this.frameSequenceState == FSeqState.EXPECTING_NEW) {
                this.frameSequenceState = FSeqState.FIRST_OF_MULTIPLE;
            } else if (this.frameSequenceState == FSeqState.FIRST_OF_MULTIPLE) {
                this.frameSequenceState = FSeqState.MIDDLE_OF_MULTIPLE;
            } else if (this.frameSequenceState != FSeqState.MIDDLE_OF_MULTIPLE && this.frameSequenceState != FSeqState.EXPECTING_PARTIAL_OR_LAST) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because of an error processing FIN of 0."), (Object[])new Object[0]);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"fin0.processing.error", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
                FrameFormatException ffe = new FrameFormatException(msg);
                throw ffe;
            }
            if ((opcode = fp.getOpcode()) >= 3 && opcode <= 7 || opcode >= 11 && opcode <= 15) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because of an invalid opcode " + opcode + " in the message frame."), (Object[])new Object[0]);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.opcode", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName(), opcode});
                FrameFormatException ffe = new FrameFormatException(msg);
                throw ffe;
            }
            if (opcode == 0 && this.frameSequenceState == FSeqState.FIRST_AND_LAST) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because of an invalid continue opcode with unfragmented message."), (Object[])new Object[0]);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.continue.opcode", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
                FrameFormatException ffe = new FrameFormatException(msg);
                throw ffe;
            }
            if (opcode != 0 && this.frameSequenceState != FSeqState.FIRST_AND_LAST && this.frameSequenceState != FSeqState.FIRST_OF_MULTIPLE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because of an invalid non-zero opcode on non-first frame. opcode: " + opcode), (Object[])new Object[0]);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.nonzero.opcode", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
                FrameFormatException ffe = new FrameFormatException(msg);
                throw ffe;
            }
            if (opcode == 1) {
                this.firstFrameOpcodeType = OpcodeType.TEXT_WHOLE;
            } else if (opcode == 2) {
                this.firstFrameOpcodeType = OpcodeType.BINARY_WHOLE;
            } else if (opcode == 8) {
                this.firstFrameOpcodeType = OpcodeType.CONNECTION_CLOSE;
            } else if (opcode == 9) {
                this.firstFrameOpcodeType = OpcodeType.PING;
            } else if (opcode == 10) {
                this.firstFrameOpcodeType = OpcodeType.PONG;
            }
        }
        if ((maskFlag = fp.getMaskFlag()) == 0 && this.shouldReadMaskedData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " because the mask flag is not set correctly in the message frame.  maskFlag: 0x00 serverSide: true"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"incorrect.maskflag", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
            FrameFormatException ffe = new FrameFormatException(msg);
            throw ffe;
        }
        if (maskFlag == 1 && !this.shouldReadMaskedData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception occurred while reading an incoming WebSocket message in ServerEndpoint class " + this.connLink.getEndpoint().getClass().getName() + " Mask Flag is not set to a correct value.  maskFlag: 0x01 serverSide: false"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.maskflag.value", (Object[])new Object[]{this.connLink.getEndpoint().getClass().getName()});
            FrameFormatException ffe = new FrameFormatException(msg);
            throw ffe;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frameSequenceState upon exit is: " + (Object)((Object)this.frameSequenceState)), (Object[])new Object[0]);
        }
    }

    private void processMaxMessageSize(long payLoadSize) throws MaxMessageException {
        Class<?> inputType;
        AnnotatedEndpoint ae = null;
        Long maxMessageSize = -1L;
        if (!(this.connLink.getEndpoint() instanceof AnnotatedEndpoint)) {
            if (this.firstFrameOpcodeType == OpcodeType.BINARY_WHOLE || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_FIRST || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_CONTINUATION || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_LAST) {
                maxMessageSize = this.connLink.getMaxBinaryMessageBufferSize();
            } else if (this.firstFrameOpcodeType == OpcodeType.TEXT_WHOLE || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_FIRST || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_CONTINUATION || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_LAST) {
                maxMessageSize = this.connLink.getMaxTextMessageBufferSize();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processMaxMessageSize: Not AE. payLoadSize passed in: " + payLoadSize + " maxMessageSize: " + maxMessageSize), (Object[])new Object[0]);
            }
            if (maxMessageSize != -1L && payLoadSize > maxMessageSize) {
                String reasonPhrase = "Invalid incoming WebSocket message. Message is too big. Message size: " + payLoadSize + " but max message size for this Session is: " + maxMessageSize;
                throw new MaxMessageException(reasonPhrase);
            }
            return;
        }
        ae = (AnnotatedEndpoint)this.connLink.getEndpoint();
        MethodData methodData = null;
        EndpointMethodHelper epMethodHelper = null;
        if (this.firstFrameOpcodeType == OpcodeType.BINARY_WHOLE) {
            epMethodHelper = ae.getOnMessageBinaryMethod();
        } else if (this.firstFrameOpcodeType == OpcodeType.TEXT_WHOLE) {
            epMethodHelper = ae.getOnMessageTextMethod();
        }
        if (epMethodHelper == null) {
            return;
        }
        methodData = epMethodHelper.getMethodData();
        maxMessageSize = methodData.getMaxMessageSize();
        if (maxMessageSize == -1L) {
            if (this.firstFrameOpcodeType == OpcodeType.BINARY_WHOLE || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_FIRST || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_CONTINUATION || this.firstFrameOpcodeType == OpcodeType.BINARY_PARTIAL_LAST) {
                maxMessageSize = this.connLink.getMaxBinaryMessageBufferSize();
            } else if (this.firstFrameOpcodeType == OpcodeType.TEXT_WHOLE || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_FIRST || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_CONTINUATION || this.firstFrameOpcodeType == OpcodeType.TEXT_PARTIAL_LAST) {
                maxMessageSize = this.connLink.getMaxTextMessageBufferSize();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processMaxMessageSize: Is AE. payLoadSize passed in: " + payLoadSize + " maxMessageSize: " + maxMessageSize), (Object[])new Object[0]);
        }
        if ((inputType = methodData.getMessageType()).equals(String.class) || inputType.equals(ByteBuffer.class) || inputType.equals(byte[].class)) {
            int booleanIndex = methodData.getMsgBooleanPairIndex();
            if (booleanIndex >= 0) {
                return;
            }
        } else {
            if (inputType.equals(Reader.class)) {
                return;
            }
            if (inputType.equals(InputStream.class)) {
                return;
            }
        }
        if (maxMessageSize != -1L && payLoadSize > maxMessageSize) {
            if (this.firstFrameOpcodeType == OpcodeType.BINARY_WHOLE) {
                epMethodHelper = ae.getOnMessageBinaryMethod();
            } else if (this.firstFrameOpcodeType == OpcodeType.TEXT_WHOLE) {
                epMethodHelper = ae.getOnMessageTextMethod();
            }
            String reasonPhrase = Tr.formatMessage((TraceComponent)tc, (String)"invalid.message.toobig", (Object[])new Object[]{epMethodHelper.getMethod().getDeclaringClass().getName(), payLoadSize, maxMessageSize, epMethodHelper.getMethod().getName()});
            throw new MaxMessageException(reasonPhrase);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class FSeqState
    extends Enum<FSeqState> {
        public static final /* enum */ FSeqState EXPECTING_NEW;
        public static final /* enum */ FSeqState EXPECTING_PARTIAL_OR_LAST;
        public static final /* enum */ FSeqState FIRST_AND_LAST;
        public static final /* enum */ FSeqState FIRST_OF_MULTIPLE;
        public static final /* enum */ FSeqState MIDDLE_OF_MULTIPLE;
        public static final /* enum */ FSeqState LAST_OF_MULTIPLE;
        private static final /* synthetic */ FSeqState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static FSeqState[] values() {
            return (FSeqState[])$VALUES.clone();
        }

        public static FSeqState valueOf(String name) {
            return Enum.valueOf(FSeqState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FSeqState.class);
            EXPECTING_NEW = new FSeqState();
            EXPECTING_PARTIAL_OR_LAST = new FSeqState();
            FIRST_AND_LAST = new FSeqState();
            FIRST_OF_MULTIPLE = new FSeqState();
            MIDDLE_OF_MULTIPLE = new FSeqState();
            LAST_OF_MULTIPLE = new FSeqState();
            $VALUES = new FSeqState[]{EXPECTING_NEW, EXPECTING_PARTIAL_OR_LAST, FIRST_AND_LAST, FIRST_OF_MULTIPLE, MIDDLE_OF_MULTIPLE, LAST_OF_MULTIPLE};
        }
    }
}

