/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.ShadowClassLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.FeatureSuggestion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHookFactory;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AppClassLoader
extends ContainerClassLoader
implements SpringLoader {
    static final TraceComponent tc;
    static final List<SearchLocation> PARENT_FIRST_SEARCH_ORDER;
    static final String CLASS_LOADING_TRACE_PREFIX = "com.ibm.ws.class.load.";
    static final String DEFAULT_PACKAGE = "default.package";
    final ConcurrentMap<String, TraceComponent> perPackageClassLoadingTraceComponents = new ConcurrentHashMap<String, TraceComponent>();
    protected final ClassLoaderConfiguration config;
    private volatile List<Library> privateLibraries;
    private final Iterable<LibertyLoader> delegateLoaders;
    private final List<File> nativeLibraryFiles = new ArrayList<File>();
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    private final DeclaredApiAccess apiAccess;
    private final ClassGenerator generator;
    private final ConcurrentHashMap<String, ProtectionDomain> protectionDomains = new ConcurrentHashMap();
    protected final ClassLoader parent;
    private final ClassLoaderHook hook;
    static final long serialVersionUID = 7911131531697267209L;

    private TraceComponent registerClassLoadingTraceComponent(String pkg) {
        TraceComponent tc = Tr.register((String)(CLASS_LOADING_TRACE_PREFIX + pkg), AppClassLoader.class, (String)null);
        this.perPackageClassLoadingTraceComponents.put(pkg, tc);
        return tc;
    }

    private TraceComponent getClassLoadingTraceComponent(String pkg) {
        TraceComponent tc = (TraceComponent)this.perPackageClassLoadingTraceComponents.get(pkg);
        return tc == null ? this.registerClassLoadingTraceComponent(pkg) : tc;
    }

    AppClassLoader(ClassLoader parent, ClassLoaderConfiguration config, List<Container> containers, DeclaredApiAccess access, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig) {
        super(containers, parent, redefiner, globalConfig);
        this.parent = parent;
        this.config = config;
        this.apiAccess = access;
        for (Container container : config.getNativeLibraryContainers()) {
            this.addNativeLibraryContainer(container);
        }
        this.privateLibraries = Providers.getPrivateLibraries(config);
        this.delegateLoaders = Providers.getDelegateLoaders(config, this.apiAccess);
        this.generator = generator;
        this.hook = ClassLoaderHookFactory.getClassLoaderHook((ClassLoader)this);
    }

    Iterable<LibertyLoader> getDelegateLoaders() {
        return this.delegateLoaders;
    }

    Iterable<SearchLocation> getSearchOrder() {
        return PARENT_FIRST_SEARCH_ORDER;
    }

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        this.transformers.add(cft);
        if (this.parent instanceof AppClassLoader) {
            if (Util.isGlobalSharedLibraryLoader((AppClassLoader)this.parent)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"addTransformer - skipping parent loader because it is a GlobalSharedLibrary", (Object[])new Object[0]);
                }
            } else {
                return ((AppClassLoader)this.parent).addTransformer(cft);
            }
        }
        return true;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new ShadowClassLoader(this);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.apiAccess.getApiTypeVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final URL findResource(String name) {
        URL result = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            result = super.findResource(name);
            if (result == null) {
                result = this.findResourceCommonLibraryClassLoaders(name);
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            CompositeEnumeration enumerations = new CompositeEnumeration(super.findResources(name));
            CompositeEnumeration<URL> compositeEnumeration = this.findResourcesCommonLibraryClassLoaders(name, (CompositeEnumeration<URL>)enumerations);
            return compositeEnumeration;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            final String f_name = name;
            final ClassLoader f_parent = this.parent;
            Enumeration<URL> eURL = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){
                static final long serialVersionUID = 5468342255214973221L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Enumeration<URL> run() throws Exception {
                    return f_parent.getResources(f_name);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            return new CompositeEnumeration(eURL).add(this.findResources(name));
        }
        catch (PrivilegedActionException f_name) {
            FFDCFilter.processException((Throwable)f_name, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"236", (Object)this, (Object[])new Object[]{name});
            return null;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.parent instanceof GatewayClassLoader ? ((GatewayClassLoader)this.parent).getBundle() : (this.parent instanceof LibertyLoader ? ((LibertyLoader)this.parent).getBundle() : null);
    }

    boolean removeTransformer(ClassFileTransformer transformer) {
        if (this.parent instanceof AppClassLoader) {
            ((AppClassLoader)this.parent).removeTransformer(transformer);
        }
        return this.transformers.remove(transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        ContainerClassLoader.ByteResourceInformation byteResourceInformation;
        if (this.transformers.isEmpty()) {
            Class<?> clazz = null;
            Object token = ThreadIdentityManager.runAsServer();
            try {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    clazz = this.findLoadedClass(name);
                    if (clazz == null) {
                        ContainerClassLoader.ByteResourceInformation byteResInfo = this.findClassBytes(name);
                        clazz = this.definePackageAndClass(name, byteResInfo, byteResInfo.getBytes());
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                clazz = this.findClassCommonLibraryClassLoaders(name);
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
            }
            return clazz;
        }
        try {
            byteResourceInformation = this.findClassBytes(name);
        }
        catch (ClassNotFoundException cnfe) {
            return this.findClassCommonLibraryClassLoaders(name);
        }
        byte[] bytes = this.transformClassBytes(byteResourceInformation.getBytes(), name);
        return this.definePackageAndClass(name, byteResourceInformation, bytes);
    }

    /*
     * WARNING - void declaration
     */
    byte[] transformClassBytes(byte[] originalBytes, String name) throws ClassNotFoundException {
        byte[] bytes = originalBytes;
        for (ClassFileTransformer transformer : this.transformers) {
            try {
                byte[] newBytes = transformer.transform(this, name, null, this.config.getProtectionDomain(), bytes);
                if (newBytes != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        if (bytes == newBytes) {
                            Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but returned an unaltered byte array"), (Object[])new Object[0]);
                        } else {
                            Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " successfully transformed the class bytes"), (Object[])new Object[0]);
                        }
                    }
                    bytes = newBytes;
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but did not alter the loaded bytes"), (Object[])new Object[0]);
            }
            catch (IllegalClassFormatException newBytes) {
                void ex;
                FFDCFilter.processException((Throwable)newBytes, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"323", (Object)this, (Object[])new Object[]{originalBytes, name});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bad transform - transformer: " + transformer + " attempting to transform class: " + name), (Object[])new Object[]{ex});
                }
                throw new ClassNotFoundException(name, (Throwable)ex);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> definePackageAndClass(String name, ContainerClassLoader.ByteResourceInformation byteResourceInformation, byte[] bytes) throws ClassFormatError {
        URL sharedClassCacheURL;
        TraceComponent cltc;
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex != -1) {
            String packageName = name.substring(0, lastDotIndex);
            if (this.getPackage(packageName) == null) {
                this.definePackage(byteResourceInformation, packageName);
                cltc = this.registerClassLoadingTraceComponent(packageName);
            } else {
                cltc = this.getClassLoadingTraceComponent(packageName);
            }
        } else {
            cltc = this.getClassLoadingTraceComponent(DEFAULT_PACKAGE);
        }
        URL resourceURL = byteResourceInformation.getResourceUrl();
        ProtectionDomain pd = this.getClassSpecificProtectionDomain(name, resourceURL);
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(name, bytes, 0, bytes.length, pd);
        }
        catch (Throwable throwable) {
            if (cltc.isDebugEnabled()) {
                String path;
                String loc = "" + byteResourceInformation.getResourceUrl();
                if (loc.endsWith(path = byteResourceInformation.getResourcePath())) {
                    loc = loc.substring(0, loc.length() - path.length());
                }
                if (loc.endsWith("!/")) {
                    loc = loc.substring(0, loc.length() - 2);
                }
                String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
                Tr.debug((TraceComponent)cltc, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
            }
            throw throwable;
        }
        if (cltc.isDebugEnabled()) {
            String path;
            String loc = "" + byteResourceInformation.getResourceUrl();
            if (loc.endsWith(path = byteResourceInformation.getResourcePath())) {
                loc = loc.substring(0, loc.length() - path.length());
            }
            if (loc.endsWith("!/")) {
                loc = loc.substring(0, loc.length() - 2);
            }
            String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
            Tr.debug((TraceComponent)cltc, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
        }
        if (!byteResourceInformation.foundInClassCache() && this.hook != null && (sharedClassCacheURL = AppClassLoader.getSharedClassCacheURL(resourceURL, byteResourceInformation.getResourcePath())) != null && Arrays.equals(bytes, byteResourceInformation.getBytes())) {
            this.hook.storeClass(sharedClassCacheURL, clazz);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Called shared class cache to store class", (Object[])new Object[]{clazz.getName(), sharedClassCacheURL});
            }
        }
        return clazz;
    }

    @Trivial
    private ProtectionDomain getClassSpecificProtectionDomain(final String name, final URL resourceUrl) {
        ProtectionDomain pd = this.config.getProtectionDomain();
        try {
            pd = AccessController.doPrivileged(new PrivilegedExceptionAction<ProtectionDomain>(){
                static final long serialVersionUID = 6345733571557497029L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ProtectionDomain run() {
                    return AppClassLoader.this.getClassSpecificProtectionDomainPrivileged(name, resourceUrl);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"392", (Object)this, (Object[])new Object[]{name, resourceUrl});
            return this.config.getProtectionDomain();
        }
        return pd;
    }

    private ProtectionDomain getClassSpecificProtectionDomainPrivileged(String className, URL resourceUrl) {
        ProtectionDomain pd;
        ProtectionDomain pdFromConfig = this.config.getProtectionDomain();
        try {
            URLConnection conn = resourceUrl.openConnection();
            URL containerUrl = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFileURL() : (conn instanceof WSJarURLConnection ? ((WSJarURLConnection)conn).getFile().toURI().toURL() : new URL(resourceUrl.toString().replace(Util.convertClassNameToResourceName(className), "")));
            String containerUrlString = containerUrl.toString();
            pd = this.protectionDomains.get(containerUrlString);
            if (pd == null) {
                CodeSource cs = new CodeSource(containerUrl, pdFromConfig.getCodeSource().getCertificates());
                pd = new ProtectionDomain(cs, pdFromConfig.getPermissions());
                this.protectionDomains.putIfAbsent(containerUrlString, pd);
                pd = this.protectionDomains.get(containerUrlString);
            }
        }
        catch (IOException conn) {
            FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"425", (Object)this, (Object[])new Object[]{className, resourceUrl});
            pd = pdFromConfig;
        }
        return pd;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private void definePackage(ContainerClassLoader.ByteResourceInformation byteResourceInformation, String packageName) {
        Manifest manifest = byteResourceInformation.getManifest();
        try {
            if (manifest == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                this.definePackage(packageName, manifest, byteResourceInformation.getResourceUrl());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    final ContainerClassLoader.ByteResourceInformation findClassBytes(String className) throws ClassNotFoundException {
        String resourceName = Util.convertClassNameToResourceName(className);
        try {
            ContainerClassLoader.ByteResourceInformation result = this.findClassBytes(className, resourceName, this.hook);
            if (result == null) {
                String message = String.format("Could not find class '%s' as resource '%s'", className, resourceName);
                throw new ClassNotFoundException(message);
            }
            return result;
        }
        catch (IOException result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"466", (Object)this, (Object[])new Object[]{className});
            Tr.error((TraceComponent)tc, (String)"cls.class.file.not.readable", (Object[])new Object[]{className, resourceName});
            String message = String.format("Could not read class '%s' as resource '%s'", className, resourceName);
            ClassFormatError error = new ClassFormatError(message);
            error.initCause((Throwable)e);
            throw error;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object token = ThreadIdentityManager.runAsServer();
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                Class<?> clazz = this.findOrDelegateLoadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                Class<?> generatedClass = this.generateClass(name);
                if (generatedClass != null) {
                    Class<?> clazz2 = generatedClass;
                    return clazz2;
                }
                throw FeatureSuggestion.getExceptionWithSuggestion(e);
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
            }
        }
    }

    @Trivial
    Class<?> generateClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> generatedClass = null;
        if (this.generator != null && (bytes = this.generator.generateClass(name, this)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("defining generated class " + name), (Object[])new Object[0]);
            }
            generatedClass = this.defineClass(name, bytes, 0, bytes.length, this.config.getProtectionDomain());
        }
        return generatedClass;
    }

    protected Class<?> findOrDelegateLoadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name, false);
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private Class<?> findClassCommonLibraryClassLoaders(String name) throws ClassNotFoundException {
        for (LibertyLoader cl : this.delegateLoaders) {
            try {
                return cl.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    private URL findResourceCommonLibraryClassLoaders(String name) {
        for (LibertyLoader cl : this.delegateLoaders) {
            URL url = cl.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private CompositeEnumeration<URL> findResourcesCommonLibraryClassLoaders(String name, CompositeEnumeration<URL> enumerations) throws IOException {
        for (LibertyLoader cl : this.delegateLoaders) {
            enumerations.add(cl.findResources(name));
        }
        return enumerations;
    }

    @Override
    protected void lazyInit() {
        if (this.privateLibraries != null) {
            for (Library lib : this.privateLibraries) {
                this.copyLibraryElementsToClasspath(lib);
            }
        }
        this.privateLibraries = null;
    }

    private void copyLibraryElementsToClasspath(Library library) {
        Collection<File> files = library.getFiles();
        this.addToClassPath(library.getContainers());
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                this.nativeLibraryFiles.add(file);
            }
        }
        for (Fileset fileset : library.getFilesets()) {
            for (File file : fileset.getFileset()) {
                this.nativeLibraryFiles.add(file);
            }
        }
    }

    private static boolean isWindows(String basename) {
        return basename.endsWith(".dll") || basename.endsWith(".DLL");
    }

    private static boolean checkLib(final File f, String basename) {
        boolean fExists = System.getSecurityManager() == null ? f.exists() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 5532053704902245852L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return f.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        }).booleanValue();
        return fExists && (f.getName().equals(basename) || AppClassLoader.isWindows(basename) && f.getName().equalsIgnoreCase(basename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String findLibrary(String libname) {
        if (libname == null || libname.length() == 0) {
            return null;
        }
        String path = super.findLibrary(libname);
        if (path != null) {
            return path;
        }
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String psLibname = System.mapLibraryName(libname);
            for (File f : this.nativeLibraryFiles) {
                if (!AppClassLoader.checkLib(f, psLibname)) continue;
                String string = f.getAbsolutePath();
                return string;
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return null;
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.config.getId();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(AppClassLoader.class);
        PARENT_FIRST_SEARCH_ORDER = Util.freeze(Util.list(SearchLocation.PARENT, SearchLocation.SELF, SearchLocation.DELEGATES));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class SearchLocation
    extends Enum<SearchLocation> {
        public static final /* enum */ SearchLocation PARENT;
        public static final /* enum */ SearchLocation SELF;
        public static final /* enum */ SearchLocation DELEGATES;
        private static final /* synthetic */ SearchLocation[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static SearchLocation[] values() {
            return (SearchLocation[])$VALUES.clone();
        }

        public static SearchLocation valueOf(String name) {
            return Enum.valueOf(SearchLocation.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SearchLocation.class);
            PARENT = new SearchLocation();
            SELF = new SearchLocation();
            DELEGATES = new SearchLocation();
            $VALUES = new SearchLocation[]{PARENT, SELF, DELEGATES};
        }
    }
}

