/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ClassLoaderConfigurationImpl
implements ClassLoaderConfiguration {
    private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;
    private boolean delegateLast;
    private boolean includeAppExtensions;
    private ClassLoaderIdentity id;
    private ClassLoaderIdentity parentId;
    private List<String> sharedLibraries = new ArrayList<String>();
    private List<String> commonLibraries = Collections.emptyList();
    private List<String> providers = Collections.emptyList();
    private List<Container> nativeLibraryContainers = Collections.emptyList();
    private ProtectionDomain protectionDomain = DEFAULT_PROTECTION_DOMAIN;
    static final long serialVersionUID = 9091690180200375339L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ClassLoaderConfigurationImpl() {
    }

    @Override
    public ClassLoaderConfiguration setDelegateToParentAfterCheckingLocalClasspath(boolean delegateLast) {
        this.delegateLast = delegateLast;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setId(ClassLoaderIdentity id) {
        this.id = id;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setParentId(ClassLoaderIdentity id) {
        this.parentId = id;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setSharedLibraries(List<String> libs) {
        this.sharedLibraries = libs == null ? Collections.emptyList() : libs;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setSharedLibraries(String ... libs) {
        return this.setSharedLibraries(libs == null ? null : Arrays.asList(libs));
    }

    @Override
    public ClassLoaderConfiguration addSharedLibraries(List<String> libs) {
        for (String lib : libs) {
            if (this.sharedLibraries.contains(lib)) continue;
            this.sharedLibraries.add(lib);
        }
        return this;
    }

    @Override
    public ClassLoaderConfiguration addSharedLibraries(String ... libs) {
        return libs == null ? this : this.addSharedLibraries(Arrays.asList(libs));
    }

    @Override
    public ClassLoaderConfiguration setCommonLibraries(List<String> libs) {
        this.commonLibraries = libs == null ? Collections.emptyList() : libs;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setCommonLibraries(String ... libs) {
        return this.setCommonLibraries(libs == null ? null : Arrays.asList(libs));
    }

    @Override
    public ClassLoaderConfiguration setClassProviders(List<String> providers) {
        this.providers = providers == null ? Collections.emptyList() : providers;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setClassProviders(String ... providers) {
        return this.setClassProviders(providers == null ? null : Arrays.asList(providers));
    }

    @Override
    public ClassLoaderConfiguration setNativeLibraryContainers(List<Container> containers) {
        this.nativeLibraryContainers = containers == null ? Collections.emptyList() : containers;
        return this;
    }

    @Override
    public ClassLoaderConfiguration setNativeLibraryContainers(Container ... containers) {
        return this.setNativeLibraryContainers(containers == null ? null : Arrays.asList(containers));
    }

    @Override
    @Trivial
    public boolean getDelegateToParentAfterCheckingLocalClasspath() {
        return this.delegateLast;
    }

    @Override
    @Trivial
    public ClassLoaderIdentity getId() {
        return this.id;
    }

    @Override
    @Trivial
    public ClassLoaderIdentity getParentId() {
        return this.parentId;
    }

    @Override
    @Trivial
    public List<String> getSharedLibraries() {
        return Collections.unmodifiableList(this.sharedLibraries);
    }

    @Override
    @Trivial
    public List<String> getCommonLibraries() {
        return Collections.unmodifiableList(this.commonLibraries);
    }

    @Override
    public List<String> getClassProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    @Override
    @Trivial
    public List<Container> getNativeLibraryContainers() {
        return Collections.unmodifiableList(this.nativeLibraryContainers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(" [child of ").append(this.parentId).append("]").append(" privateLibraries = ").append(this.sharedLibraries).append(" commonLibraries = ").append(this.commonLibraries).append(" providers = ").append(this.providers).append(" nativeLibraries = ").append(this.nativeLibraryContainers);
        return sb.toString();
    }

    @Override
    @Trivial
    public ClassLoaderConfiguration setProtectionDomain(ProtectionDomain domain) {
        this.protectionDomain = domain;
        return this;
    }

    @Override
    @Trivial
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public ClassLoaderConfiguration setIncludeAppExtensions(boolean include) {
        this.includeAppExtensions = include;
        return this;
    }

    @Override
    public boolean getIncludeAppExtensions() {
        return this.includeAppExtensions;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassLoaderConfigurationImpl.class);
        DEFAULT_PROTECTION_DOMAIN = new ProtectionDomain(new CodeSource((URL)null, (Certificate[])null), null);
    }
}

