/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.config;

import com.ibm.ws.kernel.instrument.serialfilter.config.Config;
import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigSetting;
import com.ibm.ws.kernel.instrument.serialfilter.config.PermissionMode;
import com.ibm.ws.kernel.instrument.serialfilter.config.SpecifierFormat;
import com.ibm.ws.kernel.instrument.serialfilter.config.ValidationMode;
import com.ibm.ws.kernel.instrument.serialfilter.digest.Checksums;
import com.ibm.ws.kernel.instrument.serialfilter.util.CallStackWalker;
import com.ibm.ws.kernel.instrument.serialfilter.util.MessageUtil;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.ConcurrentTrie;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.Trie;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ConfigImpl
implements Config {
    private static final Checksums CHECKSUMS = Checksums.getInstance();
    private static final Class<Externalizable> EXTERN = Externalizable.class;
    private static final Class<Serializable> SERIAL = Serializable.class;
    private static final Map<? super String, ? extends ConfigSetting<String, Boolean>> MODES_BY_NAME = ConfigImpl.createModesMap();
    private final ConcurrentTrie<ValidationMode> validationModes = new ConcurrentTrie();
    private final ConcurrentTrie<PermissionMode> permissions = new ConcurrentTrie();
    private final List<Initializer> initializers;
    private ValidationMode defaultValidationMode;
    private static final String DEFAULT_KEY = SpecifierFormat.internalize("*");
    static final Initializer SET_DEFAULT_CONFIG = new Initializer(){

        @Override
        void init(ConfigImpl cfg) {
            Logger log = Logger.getLogger(ConfigImpl.class.getName());
            Properties props = new Properties();
            props.setProperty("*", "REJECT");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting default configuration *=REJECT");
            }
            cfg.load(props);
        }
    };
    static final Initializer READ_INTERNAL_CONFIG = new Initializer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void init(ConfigImpl cfg) {
            Logger log = Logger.getLogger(ConfigImpl.class.getName());
            String defaultConfigPropsFile = "default.properties";
            InputStream in = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return ConfigImpl.class.getResourceAsStream("default.properties");
                }
            });
            if (in == null) {
                throw new Error("Could not read internal configuration file");
            }
            Properties props = new Properties();
            try {
                props.load(in);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reading default config from " + in);
                }
                cfg.load(props);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Finished reading default config.");
                }
            }
            catch (IOException e) {
                log.severe(MessageUtil.format("SF_ERROR_DEFAULT_CONFIGURATION", in, e.getMessage()));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    };
    static final Initializer READ_SYSTEM_CONFIG = new Initializer(){

        @Override
        void init(ConfigImpl cfg) {
            Logger log = Logger.getLogger(ConfigImpl.class.getName());
            String filename = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("com.ibm.websphere.serialfilter.config.file");
                }
            });
            if (filename == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No configuration file specified for serialization validation.");
                }
                return;
            }
            final File f = new File(filename);
            if (!f.isFile()) {
                log.severe(MessageUtil.format("SF_ERROR_SYSTEM_CONFIGURATION_NOT_FIND", filename));
                return;
            }
            try {
                Properties props = new Properties();
                FileReader fileReader = AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                    @Override
                    public FileReader run() throws IOException {
                        return new FileReader(f);
                    }
                });
                props.load(fileReader);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reading system config from " + filename);
                }
                cfg.load(props);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Finished reading system config.");
                }
            }
            catch (PrivilegedActionException e) {
                log.severe(MessageUtil.format("SF_ERROR_SYSTEM_CONFIGURATION", filename, e));
            }
            catch (IOException e) {
                log.severe(MessageUtil.format("SF_ERROR_SYSTEM_CONFIGURATION", filename, e));
            }
        }
    };

    private static Map<String, ConfigSetting<String, Boolean>> createModesMap() {
        HashMap<String, ConfigSetting<String, Boolean>> result = new HashMap<String, ConfigSetting<String, Boolean>>();
        for (ValidationMode validationMode : ValidationMode.values()) {
            result.put(validationMode.name(), validationMode);
        }
        for (Enum enum_ : PermissionMode.values()) {
            result.put(enum_.name(), (ConfigSetting<String, Boolean>)((Object)enum_));
        }
        return result;
    }

    ConfigImpl(Initializer ... initializers) {
        this.initializers = Collections.unmodifiableList(new ArrayList<Initializer>(Arrays.asList(initializers)));
        this.init();
    }

    private void init() {
        for (Initializer init : this.initializers) {
            init.init(this);
        }
        this.defaultValidationMode = this.validationModes.get(DEFAULT_KEY);
        if (this.defaultValidationMode == null) {
            String message = MessageUtil.format("SF_ERROR_NO_DEFAULT_MODE", new Object[0]);
            Logger.getLogger(ConfigImpl.class.getName()).severe(message);
            throw new Error(message);
        }
        this.validationModes.remove(DEFAULT_KEY);
    }

    @Override
    public void reset() {
        this.permissions.clear();
        this.validationModes.clear();
        this.init();
    }

    @Override
    public ValidationMode getDefaultMode() {
        return this.defaultValidationMode;
    }

    @Override
    public boolean allows(Class<?> cls, Class<?>[] toSkip) {
        return this.allows(cls, toSkip, false);
    }

    @Override
    public boolean allows(Class<?> cls, Class<?>[] toSkip, boolean isDiscovery) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        if (cls != toSkip[0]) {
            if (this.isForbidden(cls)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Denied : " + cls);
                }
                if (isDiscovery) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info(MessageUtil.format("SF_INFO_NOT_ON_WHITELIST", cls.getName()));
                    }
                } else {
                    log.severe(MessageUtil.format("SF_ERROR_NOT_PERMIT", cls.getName()));
                }
                return false;
            }
            Class<? extends Serializable> iface = this.externalizableOrSerializable(cls);
            for (Class<?> c = cls.getSuperclass(); c != null && iface.isAssignableFrom(c); c = c.getSuperclass()) {
                if (!this.isForbidden(c)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Denied : " + cls + " because of super class : " + c);
                }
                if (isDiscovery) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info(MessageUtil.format("SF_INFO_NOT_ON_WHITELIST", c.getName()));
                    }
                } else {
                    log.severe(MessageUtil.format("SF_ERROR_NOT_PERMIT_SUPERCLASS", cls.getName(), c.getName()));
                }
                return false;
            }
        }
        toSkip[0] = cls.getSuperclass();
        return true;
    }

    private Class<? extends Serializable> externalizableOrSerializable(Class<?> cls) {
        return EXTERN.isAssignableFrom(cls) ? EXTERN : SERIAL;
    }

    private boolean isForbidden(Class<?> c) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        String cName = c.getName();
        String name = SpecifierFormat.internalize(cName);
        Trie.Entry<PermissionMode> e = this.permissions.getLongestPrefixEntry(name);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Searching on class " + c + " returns " + SpecifierFormat.externalize((String)e.getKey()) + "=" + e.getValue());
        }
        return ((PermissionMode)e.getValue()).isProhibitive;
    }

    @Override
    public ValidationMode getModeForStack(Class<?> caller) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        if (this.validationModes.isEmpty()) {
            return this.defaultValidationMode;
        }
        CallStackWalker stack = CallStackWalker.forCurrentThread().skipTo(ObjectInputStream.class);
        LinkedHashSet streamClasses = new LinkedHashSet();
        for (Class<?> c = caller; c != InputStream.class; c = c.getSuperclass()) {
            streamClasses.add(c);
        }
        while (stack.size() > 0 && streamClasses.contains(stack.topClass()) && "<init>".equals(stack.topMethod())) {
            stack.pop();
        }
        while (stack.size() > 0) {
            ValidationMode modeForCaller;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Searching for validation mode setting for " + stack.topClass().getName() + '#' + stack.topMethod());
            }
            if ((modeForCaller = this.getModeForMethod(stack)) != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found validation mode " + modeForCaller + " for caller method " + stack.topClass().getName() + '#' + stack.topMethod());
                }
                return modeForCaller;
            }
            stack.pop();
        }
        for (Class clazz : streamClasses) {
            ValidationMode modeForStream;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Searching for validation mode setting for " + clazz.getName());
            }
            if ((modeForStream = this.getValidationMode(clazz.getName())) == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found validation mode " + modeForStream + " for stream class " + stack.topClass());
            }
            return modeForStream;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("No mode configured, returning default validation    mode: " + this.defaultValidationMode);
        }
        return this.defaultValidationMode;
    }

    private ValidationMode getModeForMethod(CallStackWalker stack) {
        return this.getValidationMode(stack.topClass().getName() + "#" + stack.topMethod());
    }

    @Override
    public ValidationMode getValidationMode(String s) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        SpecifierFormat f = SpecifierFormat.fromString(s);
        switch (f) {
            case CLASS: 
            case METHOD: {
                return this.validationModes.getLongestPrefixValue(SpecifierFormat.internalize(s));
            }
            case METHOD_PREFIX: 
            case PREFIX: {
                log.severe(MessageUtil.format("SF_ERROR_GET_MODE_VALUE_PREFIX", s));
                return null;
            }
            case DIGEST: {
                log.severe(MessageUtil.format("SF_ERROR_GET_MODE_VALUE_DIGEST", s));
                return null;
            }
        }
        log.severe(MessageUtil.format("SF_ERROR_GET_MODE_VALUE_UNKNOWN", s));
        return null;
    }

    @Override
    public boolean setValidationMode(ValidationMode mode, String s) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Setting validation mode " + mode + " for '" + s + "'");
        }
        SpecifierFormat f = SpecifierFormat.fromString(s);
        switch (f) {
            case CLASS: 
            case METHOD: 
            case METHOD_PREFIX: 
            case PREFIX: {
                return mode != this.validationModes.put(SpecifierFormat.internalize(s), mode);
            }
            case DIGEST: {
                log.severe(MessageUtil.format("SF_ERROR_SET_MODE_VALUE_DIGEST", s));
                return false;
            }
        }
        log.severe(MessageUtil.format("SF_ERROR_SET_MODE_VALUE_UNKNOWN", s));
        return false;
    }

    @Override
    public boolean setPermission(PermissionMode mode, String s) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Setting permission " + mode + " for '" + s + "'");
        }
        SpecifierFormat f = SpecifierFormat.fromString(s);
        switch (f) {
            case CLASS: 
            case PREFIX: 
            case DIGEST: {
                return mode == this.permissions.put(SpecifierFormat.internalize(s), mode);
            }
            case METHOD: 
            case METHOD_PREFIX: {
                log.severe(MessageUtil.format("SF_ERROR_SET_PERMISSION_VALUE_METHOD", s));
                return false;
            }
        }
        log.severe(MessageUtil.format("SF_ERROR_SET_PERMISSION_VALUE_UNKNOWN", s));
        return false;
    }

    @Override
    public void load(Properties props) {
        Logger log = Logger.getLogger(ConfigImpl.class.getName());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                log.severe(MessageUtil.format("SF_ERROR_LOAD_PROPERTY_KEY", entry.getKey()));
                continue;
            }
            if (!(entry.getValue() instanceof String)) {
                log.severe(MessageUtil.format("SF_ERROR_LOAD_PROPERTY_VALUE", entry.getValue()));
            }
            String key = (String)entry.getKey();
            for (String val : ((String)entry.getValue()).trim().split(" *[ ,] *")) {
                ConfigSetting<String, Boolean> mode = MODES_BY_NAME.get(val);
                if (mode == null) {
                    log.severe(MessageUtil.format("SF_ERROR_LOAD_PROPERTY_NOT_MATCH", val, entry));
                    continue;
                }
                mode.apply(this, key);
            }
        }
    }

    static abstract class Initializer {
        Initializer() {
        }

        abstract void init(ConfigImpl var1);
    }
}

