/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.validators;

import com.ibm.ws.kernel.instrument.serialfilter.config.Config;
import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigHolder;
import com.ibm.ws.kernel.instrument.serialfilter.config.ValidationMode;
import com.ibm.ws.kernel.instrument.serialfilter.validators.ClassValidator;
import com.ibm.ws.kernel.instrument.serialfilter.validators.DiscoveringClassValidator;
import com.ibm.ws.kernel.instrument.serialfilter.validators.EnforcingClassValidator;
import com.ibm.ws.kernel.instrument.serialfilter.validators.InactiveClassValidator;
import com.ibm.ws.kernel.instrument.serialfilter.validators.RejectingClassValidator;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassValidatorFactory
extends ConfigHolder {
    private final Config config;

    ClassValidatorFactory(Config config) {
        super(config);
        this.config = config;
    }

    @Override
    public Map<Class<?>, Class<?>> apply(ObjectInputStream caller) throws Exception {
        return this.createValidator(caller);
    }

    private ClassValidator createValidator(ObjectInputStream caller) {
        Logger log = Logger.getLogger(ClassValidatorFactory.class.getName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Creating validator for " + caller.getClass().getName());
        }
        ValidationMode mode = this.config.getModeForStack(caller.getClass());
        ClassValidator cv = this.getValidator(mode);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Validator : " + cv);
        }
        return cv;
    }

    private ClassValidator getValidator(ValidationMode mode) {
        switch (mode) {
            case INACTIVE: {
                return InactiveClassValidator.INSTANCE;
            }
            case DISCOVER: {
                return new DiscoveringClassValidator(this.config);
            }
            case ENFORCE: {
                return new EnforcingClassValidator(this.config);
            }
            case REJECT: {
                return new RejectingClassValidator();
            }
        }
        throw new IllegalArgumentException("Unexpected mode: " + mode);
    }
}

