/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.cdi.internal.archive.liberty.ApplicationImpl;
import com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl;
import com.ibm.ws.cdi.internal.archive.liberty.CDILibertyRuntime;
import com.ibm.ws.cdi.internal.archive.liberty.ExtensionArchiveImpl;
import com.ibm.ws.cdi.internal.archive.liberty.ExtensionContainerInfo;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchive;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RuntimeFactory {
    private final CDILibertyRuntime services;
    private final ConcurrentHashMap<ApplicationInfo, Application> applications = new ConcurrentHashMap();
    private final ConcurrentHashMap<Bundle, ExtensionArchive> extensionArchives = new ConcurrentHashMap();
    static final long serialVersionUID = 2131813182526779345L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RuntimeFactory(CDILibertyRuntime services) {
        this.services = services;
    }

    private Container getContainerForBundle(Bundle bundle) {
        File cacheDir = bundle.getDataFile("cache");
        if (!FileUtils.ensureDirExists((File)cacheDir)) {
            return null;
        }
        File cacheDirAdapt = bundle.getDataFile("cacheAdapt");
        if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
            return null;
        }
        File cacheDirOverlay = bundle.getDataFile("cacheOverlay");
        if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
            return null;
        }
        ArtifactContainer artifactContainer = this.getServices().getArtifactContainerFactory().getContainer(cacheDir, (Object)bundle);
        Container container = this.getServices().getAdaptableModuleFactory().getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
        return container;
    }

    public Application newApplication(ApplicationInfo appInfo) throws CDIException {
        Application oldApplication;
        Application application = this.applications.get(appInfo);
        if (application == null && (oldApplication = this.applications.putIfAbsent(appInfo, application = new ApplicationImpl(appInfo, this))) != null) {
            application = oldApplication;
        }
        return application;
    }

    public Application removeApplication(ApplicationInfo appInfo) {
        return this.applications.remove(appInfo);
    }

    public CDIArchive newArchive(ApplicationImpl application, ContainerInfo containerInfo, ArchiveType archiveType, ClassLoader classLoader) {
        CDIArchiveImpl archive = new CDIArchiveImpl(application, containerInfo, archiveType, classLoader, this);
        return archive;
    }

    public ExtensionArchive getExtensionArchiveForBundle(Bundle bundle, Set<String> extraClasses, Set<String> extraAnnotations, boolean applicationBDAsVisible, boolean extClassesOnly) throws CDIException {
        ExtensionArchive extensionArchive = null;
        extensionArchive = this.extensionArchives.get(bundle);
        if (extensionArchive == null) {
            ExtensionContainerInfo containerInfo;
            ExtensionArchive oldExtensionArchive;
            Container container = this.getContainerForBundle(bundle);
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader loader = bundleWiring.getClassLoader();
            if (container != null && (oldExtensionArchive = this.extensionArchives.putIfAbsent(bundle, extensionArchive = new ExtensionArchiveImpl(containerInfo = new ExtensionContainerInfo(container, loader, CDIServiceUtils.getSymbolicNameWithoutMinorOrMicroVersionPart((String)bundle.getSymbolicName()) + "_" + CDIServiceUtils.getOSGIVersionForBndName((Version)bundle.getVersion()), extraClasses, extraAnnotations, applicationBDAsVisible, extClassesOnly), this))) != null) {
                extensionArchive = oldExtensionArchive;
            }
        }
        return extensionArchive;
    }

    public CDILibertyRuntime getServices() {
        return this.services;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RuntimeFactory.class);
    }
}

