/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class KeystoreConfig {
    private static final TraceComponent tc = Tr.register(KeystoreConfig.class);
    private final String pid;
    private final String id;
    private final AtomicServiceReference<WsLocationAdmin> locSvc;
    private WSKeyStore wsKeyStore = null;
    private Dictionary<String, Object> properties = null;
    private ServiceRegistration<KeystoreConfig> registration = null;

    public KeystoreConfig(String pid, String id, AtomicServiceReference<WsLocationAdmin> locSvc) {
        this.pid = pid;
        this.id = id;
        this.locSvc = locSvc;
    }

    public String getPid() {
        return this.pid;
    }

    public String getId() {
        return this.id;
    }

    public WSKeyStore getKeyStore() {
        return this.wsKeyStore;
    }

    public String resolveString(String path) {
        return ((WsLocationAdmin)this.locSvc.getServiceWithException()).resolveString(path);
    }

    public String getServerName() {
        return ((WsLocationAdmin)this.locSvc.getServiceWithException()).getServerName();
    }

    synchronized boolean updateKeystoreConfig(Dictionary<String, Object> props) {
        String location;
        this.properties = props;
        if (this.id != null) {
            this.properties.put("com.ibm.ssl.alias", this.id);
        }
        if ((location = (String)this.properties.get("location")) != null) {
            this.properties.put("com.ibm.ssl.keyStore", ((WsLocationAdmin)this.locSvc.getServiceWithException()).resolveString(location));
        }
        try {
            this.wsKeyStore = new WSKeyStore(this.id, this.properties, this);
            KeyStoreManager.getInstance().addKeyStoreToMap(this.id, this.wsKeyStore);
            KeyStoreManager.getInstance().addKeyStoreToMap(this.pid, this.wsKeyStore);
            return true;
        }
        catch (Exception e) {
            this.wsKeyStore = null;
            return false;
        }
    }

    synchronized void updateRegistration(BundleContext ctx) {
        if (this.registration == null) {
            this.registration = ctx.registerService(KeystoreConfig.class, (Object)this, this.properties);
        } else {
            this.registration.setProperties(this.properties);
        }
    }

    synchronized void unregister() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }
}

