/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScopeFactory;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LibertyRecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogAccessControllerImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogComponentImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecLogServiceImpl {
    private static TraceComponent tc;
    private String _recoveryGroup = null;
    private boolean _isPeerRecoverySupported = false;
    private static boolean _readyToStart;
    private static boolean _recoveryLogDSReady;
    static final long serialVersionUID = 8839886021823178097L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public RecLogServiceImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecLogServiceImpl", (Object)this);
        }
    }

    public void initialize(String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)serverName);
        }
        String installDirectory = "dir";
        Configuration.serverName(serverName);
        Configuration.WASInstallDirectory(installDirectory);
        Configuration.localFailureScope(new FileFailureScope());
        Configuration.isZOS(false);
        Configuration.setRecoveryLogComponent(new RecoveryLogComponentImpl());
        Configuration.setAccessController(new RecoveryLogAccessControllerImpl());
        FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.FILE_FAILURE_SCOPE_ID, FileFailureScope.class, new FileFailureScopeFactory());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"activate", (Object)this);
        }
    }

    public void unsetRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetRecoveryLogFactory, factory: " + fac), (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startRecovery(RecoveryLogFactory fac) {
        block11: {
            RecoveryDirector director;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"startRecovery", (Object)fac);
                }
                director = null;
                try {
                    director = RecoveryDirectorFactory.recoveryDirector();
                    director.setRecoveryLogFactory(fac);
                    ((RecoveryDirectorImpl)director).driveLocalRecovery();
                }
                catch (RecoveryFailedException recoveryFailedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"113", (Object)this, (Object[])new Object[]{fac});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.startRecovery", (String)"421", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local recovery failed.");
                    }
                }
                catch (InternalLogException exc) {
                    void ile;
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"119", (Object)this, (Object[])new Object[]{fac});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.startRecovery", (String)"478", (Object)this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"Local recovery not attempted.", (Object)ile);
                }
            }
            if (director != null && this._isPeerRecoverySupported && this.checkPeersAtStartup()) {
                try {
                    if (director instanceof LibertyRecoveryDirectorImpl) {
                        ((LibertyRecoveryDirectorImpl)director).drivePeerRecovery();
                    }
                }
                catch (RecoveryFailedException ile) {
                    void exc;
                    FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"134", (Object)this, (Object[])new Object[]{fac});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl.startRecovery", (String)"421", (Object)this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Local peer failed.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startRecovery");
        }
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryGroup", (Object)new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryGroup");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPeersAtStartup() {
        boolean checkAtStartup;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPeersAtStartup");
        }
        try {
            checkAtStartup = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -7575411395322914251L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.ibm.ws.recoverylog.spi.CheckPeersAtStartup");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.RecLogServiceImpl", (String)"204", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"checkPeersAtStartup", (Object)e);
            }
            checkAtStartup = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPeersAtStartup", (Object)checkAtStartup);
        }
        return checkAtStartup;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RecLogServiceImpl.class);
        tc = Tr.register(RecLogServiceImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        _readyToStart = false;
        _recoveryLogDSReady = false;
    }
}

