/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutor;
import com.ibm.ws.microprofile.faulttolerance20.impl.FutureShell;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AsyncFutureExecutor<R>
extends AsyncExecutor<Future<R>> {
    private static final TraceComponent tc = Tr.register(AsyncFutureExecutor.class);
    static final long serialVersionUID = -7856091484492012004L;

    public AsyncFutureExecutor(RetryPolicy retry, CircuitBreakerPolicy cbPolicy, TimeoutPolicy timeoutPolicy, FallbackPolicy fallbackPolicy, BulkheadPolicy bulkheadPolicy, ScheduledExecutorService executorService, WSContextService contextService, MetricRecorder metricRecorder) {
        super(retry, cbPolicy, timeoutPolicy, fallbackPolicy, bulkheadPolicy, executorService, contextService, metricRecorder);
    }

    @Override
    protected void setResult(AsyncExecutionContextImpl<Future<R>> executionContext, MethodResult<Future<R>> result) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Method {0} final fault tolerance result: {1}", (Object[])new Object[]{executionContext.getMethod(), result});
        }
        FutureShell resultWrapper = (FutureShell)executionContext.getResultWrapper();
        if (result.isFailure()) {
            CompletableFuture failureResult = new CompletableFuture();
            failureResult.completeExceptionally(result.getFailure());
            resultWrapper.setDelegate(failureResult);
        } else {
            resultWrapper.setDelegate(result.getResult());
        }
    }

    @Override
    protected Future<R> createEmptyResultWrapper(AsyncExecutionContextImpl<Future<R>> executionContext) {
        FutureShell resultWrapper = new FutureShell();
        resultWrapper.setCancellationCallback(executionContext::cancel);
        return resultWrapper;
    }
}

