/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialWebUtils {
    public static final TraceComponent tc = Tr.register(SocialWebUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = -8572482189033500801L;

    protected ReferrerURLCookieHandler getCookieHandler() {
        WebAppSecurityConfig config = this.getWebAppSecurityConfig();
        if (config != null) {
            return config.createReferrerURLCookieHandler();
        }
        return new ReferrerURLCookieHandler(config);
    }

    WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
    }

    /*
     * WARNING - void declaration
     */
    public void doClientSideRedirect(HttpServletResponse response, String reqUrlCookieName, String loginURL) throws SocialLoginException {
        response.setStatus(200);
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.web.utils.SocialWebUtils", (String)"58", (Object)this, (Object[])new Object[]{response, reqUrlCookieName, loginURL});
            throw new SocialLoginException((Exception)e);
        }
        pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        pw.println("<head>");
        pw.println(this.createJavaScriptForRedirect(reqUrlCookieName, loginURL));
        pw.println("<title>Redirect To OP</title> ");
        pw.println("</head>");
        pw.println("<body></body>");
        pw.println("</html>");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/html; charset=UTF-8");
        pw.close();
    }

    protected String createJavaScriptForRedirect(String reqUrlCookieName, String loginURL) {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("var loc=window.location.href;").append("document.cookie=\"").append(reqUrlCookieName).append("=\"").append("+encodeURI(loc)+").append("\"; path=/;");
        WebAppSecurityConfig webAppSecurityConfig = this.getWebAppSecurityConfig();
        if (webAppSecurityConfig != null && webAppSecurityConfig.getSSORequiresSSL()) {
            sb.append(" secure;");
        }
        sb.append("\"</script>");
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("window.location.replace(\"" + loginURL + "\")").append("</script>");
        String js = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createJavaScriptForRedirect returns [" + js + "]"), (Object[])new Object[0]);
        }
        return js;
    }

    @Sensitive
    public String getAndClearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie[] cookies = request.getCookies();
        String value = CookieHelper.getCookieValue((Cookie[])cookies, (String)cookieName);
        CookieHelper.clearCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName, (Cookie[])cookies);
        return value;
    }

    public String getRequestUrlWithEncodedQueryString(HttpServletRequest req) {
        StringBuffer reqURL = req.getRequestURL();
        if (req.getQueryString() != null) {
            reqURL.append("?");
            reqURL.append(this.getUrlEncodedQueryString(req));
        }
        return reqURL.toString();
    }

    public String getUrlEncodedQueryString(HttpServletRequest req) {
        StringBuilder qs = new StringBuilder();
        Map params = req.getParameterMap();
        if (!params.isEmpty()) {
            qs.append(this.getUrlEncodedQueryStringFromParameterMap(params));
        }
        return qs.toString();
    }

    public String getUrlEncodedQueryStringFromParameterMap(Map<String, String[]> params) {
        StringBuilder qs = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String[]> param = iter.next();
            qs.append(this.getUrlEncodedParameterAndValues(param.getKey(), param.getValue()));
            if (!iter.hasNext() || qs.charAt(qs.length() - 1) == '&') continue;
            qs.append("&");
        }
        return qs.toString();
    }

    public String getUrlEncodedParameterAndValues(String key, String[] values) {
        StringBuilder paramAndValue = new StringBuilder();
        paramAndValue.append(WebUtils.urlEncode((String)key));
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                paramAndValue.append("=" + WebUtils.urlEncode((String)value));
                if (i >= values.length - 1) continue;
                paramAndValue.append("&" + WebUtils.urlEncode((String)key));
            }
        }
        return paramAndValue.toString();
    }

    public String getLoginHint(HttpServletRequest request) {
        String loginHint = this.getLoginHintFromHeader(request);
        if (loginHint != null && !loginHint.isEmpty()) {
            return loginHint;
        }
        loginHint = this.getLoginHintFromCookie(request);
        if (loginHint != null && !loginHint.isEmpty()) {
            return loginHint;
        }
        loginHint = this.getLoginHintFromParameter(request);
        if (loginHint != null && !loginHint.isEmpty()) {
            return loginHint;
        }
        return loginHint;
    }

    String getLoginHintFromHeader(HttpServletRequest request) {
        String loginHint = request.getHeader("social_login_hint");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("specifiedService(header) id:" + loginHint), (Object[])new Object[0]);
        }
        return loginHint;
    }

    String getLoginHintFromCookie(HttpServletRequest request) {
        String loginHint = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"social_login_hint".equals(cookie.getName())) continue;
                loginHint = cookie.getValue();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("specifiedService(cookie) id:" + loginHint), (Object[])new Object[0]);
        }
        return loginHint;
    }

    String getLoginHintFromParameter(HttpServletRequest request) {
        String loginHint = request.getParameter("social_login_hint");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("specifiedService(param) id:" + loginHint), (Object[])new Object[0]);
        }
        return loginHint;
    }

    public void saveRequestUrlAndParameters(HttpServletRequest request, HttpServletResponse response) {
        String cookieName = "WASReqURL";
        ReferrerURLCookieHandler referrerURLCookieHandler = this.getCookieHandler();
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, this.getRequestUrlWithEncodedQueryString(request), request);
        response.addCookie(c);
        this.savePostParameters(request, response);
    }

    void savePostParameters(HttpServletRequest request, HttpServletResponse response) {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        PostParameterHelper pph = new PostParameterHelper(webAppSecConfig);
        pph.save(request, response);
    }

    public void removeRequestUrlAndParameters(HttpServletRequest request, HttpServletResponse response) {
        ReferrerURLCookieHandler referrerURLCookieHandler = this.getCookieHandler();
        referrerURLCookieHandler.invalidateReferrerURLCookie(request, response, "WASReqURL");
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        if (this.isPostDataSavedInCookie(webAppSecConfig)) {
            this.deleteCookie(request, response, "WASPostParam", webAppSecConfig);
        } else {
            this.removePostParameterSessionAttributes(request);
        }
    }

    boolean isPostDataSavedInCookie(WebAppSecurityConfig webAppSecConfig) {
        return "Cookie".equals(webAppSecConfig.getPostParamSaveMethod());
    }

    public void deleteCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, WebAppSecurityConfig webAppSecConfig) {
        ReferrerURLCookieHandler referrerURLCookieHandler = this.getCookieHandler();
        referrerURLCookieHandler.clearReferrerURLCookie(request, response, cookieName);
        Cookie paramCookie = this.createExpiredCookie(request, cookieName, webAppSecConfig);
        response.addCookie(paramCookie);
    }

    Cookie createExpiredCookie(HttpServletRequest request, String cookieName, WebAppSecurityConfig webAppSecConfig) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setPath(request.getRequestURI());
        cookie.setMaxAge(0);
        return this.setCookieFlagsBasedOnWebAppConfig(cookie, webAppSecConfig);
    }

    Cookie setCookieFlagsBasedOnWebAppConfig(Cookie cookie, WebAppSecurityConfig webAppSecConfig) {
        if (webAppSecConfig.getHttpOnlyCookies()) {
            cookie.setHttpOnly(true);
        }
        if (webAppSecConfig.getSSORequiresSSL()) {
            cookie.setSecure(true);
        }
        return cookie;
    }

    void removePostParameterSessionAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("INITIAL_URL");
            session.removeAttribute("PARAM_VALUES");
            session.removeAttribute("PARAM_NAMES");
        }
    }
}

