/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileData {
    static final TraceComponent tc = Tr.register(ZipFileData.class);
    private static final boolean ZIP_REAPER_COLLECT_TIMINGS = ZipCachingProperties.ZIP_REAPER_COLLECT_TIMINGS;
    public static final boolean CLOSE_ONCE = false;
    public static final boolean CLOSE_ALL = true;
    protected final String path;
    private ZipFile zipFile;
    private long zipLength;
    private long zipLastModified;
    private static final long UNKNOWN_ZIP_LENGTH = -1L;
    private static final long UNUSED_ZIP_LAST_MODIFIED = -1L;
    protected ZipFileState zipFileState;
    protected long initialAt;
    protected long finalAt;
    protected int openCount;
    protected int closeCount;
    protected int openToPendCount;
    protected int pendToOpenCount;
    protected int pendToFullCloseCount;
    protected int fullCloseToOpenCount;
    protected long firstOpenAt;
    protected long lastLastOpenAt;
    protected long lastOpenAt;
    protected long firstPendAt;
    protected long lastPendAt;
    protected long firstFullCloseAt;
    protected long lastFullCloseAt;
    protected long openDuration;
    protected long pendToOpenDuration;
    protected long pendToFullCloseDuration;
    protected long fullCloseToOpenDuration;
    protected boolean expireQuickly;
    static final long serialVersionUID = 2183752562472877932L;

    @Trivial
    private static String toRelSec(long initialAt, long finalAt) {
        return ZipCachingProperties.toRelSec(initialAt, finalAt);
    }

    @Trivial
    private static String toAbsSec(long eventAt) {
        return ZipCachingProperties.toAbsSec(eventAt);
    }

    @Trivial
    private static String dualTiming(long eventAt, long initialAt) {
        return ZipCachingProperties.dualTiming(eventAt, initialAt);
    }

    @Trivial
    private static String dualTiming(long eventAt) {
        return ZipCachingProperties.dualTiming(eventAt);
    }

    @Trivial
    private void timing(String text) {
        System.out.println("ZFR Path [ " + this.path + " ] " + text);
    }

    @Trivial
    private String openState() {
        return "Opens/Closes [ " + this.openCount + "/" + this.closeCount + " ]";
    }

    @Trivial
    private static String toCount(int count) {
        return ZipCachingProperties.toCount(count);
    }

    public ZipFileData(String path, long initialAt) throws IOException, ZipException {
        String methodName = "<init>";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Create [ " + path + " ]"});
        }
        this.path = path;
        this.setInitial(initialAt);
    }

    private void setInitial(long useInitialAt) {
        this.zipFileState = ZipFileState.FULLY_CLOSED;
        this.initialAt = useInitialAt;
        this.finalAt = -1L;
        this.openCount = 0;
        this.closeCount = 0;
        this.openToPendCount = 0;
        this.pendToOpenCount = 0;
        this.pendToFullCloseCount = 0;
        this.fullCloseToOpenCount = 0;
        this.firstOpenAt = -1L;
        this.lastLastOpenAt = -1L;
        this.lastOpenAt = -1L;
        this.firstPendAt = -1L;
        this.lastPendAt = -1L;
        this.firstFullCloseAt = -1L;
        this.lastFullCloseAt = -1L;
        this.openDuration = 0L;
        this.pendToOpenDuration = 0L;
        this.pendToFullCloseDuration = 0L;
        this.fullCloseToOpenDuration = 0L;
        if (ZIP_REAPER_COLLECT_TIMINGS) {
            this.timing(" Initial " + ZipFileData.dualTiming(useInitialAt));
        }
    }

    public void setFinal(long useFinalAt) {
        this.finalAt = useFinalAt;
        if (ZIP_REAPER_COLLECT_TIMINGS) {
            this.timing(" Final " + ZipFileData.dualTiming(useFinalAt));
        }
    }

    @Trivial
    public void enactOpen(long openAt) {
        String methodName = "enactOpen";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " On [ " + this.path + " ] at [ " + ZipFileData.toRelSec(this.initialAt, openAt) + " (s) ]"), (Object[])new Object[0]);
        }
        if (this.zipFileState == ZipFileState.OPEN) {
            this.openDuration += openAt - this.lastOpenAt;
            this.lastLastOpenAt = this.lastOpenAt;
            this.lastOpenAt = openAt;
            ++this.openCount;
        } else if (this.zipFileState == ZipFileState.PENDING) {
            long lastPendDuration = openAt - this.lastPendAt;
            this.pendToOpenDuration += lastPendDuration;
            ++this.pendToOpenCount;
            this.lastLastOpenAt = this.lastOpenAt;
            this.lastOpenAt = openAt;
            ++this.openCount;
            this.zipFileState = ZipFileState.OPEN;
            if (ZIP_REAPER_COLLECT_TIMINGS) {
                this.timing(" Pend Success [ " + ZipFileData.toAbsSec(lastPendDuration) + " (s) ]");
            }
        } else if (this.zipFileState == ZipFileState.FULLY_CLOSED) {
            if (this.firstOpenAt == -1L) {
                this.firstOpenAt = openAt;
            } else {
                long lastFullCloseDuration = openAt - this.lastFullCloseAt;
                this.fullCloseToOpenDuration += lastFullCloseDuration;
                if (ZIP_REAPER_COLLECT_TIMINGS) {
                    long lastPendDuration = this.lastPendAt == -1L ? 0L : this.lastFullCloseAt - this.lastPendAt;
                    this.timing(" Reopen; Pend [ " + ZipFileData.toAbsSec(lastPendDuration) + " (s) ]  Close [ " + ZipFileData.toAbsSec(lastFullCloseDuration) + " (s) ]");
                }
            }
            ++this.fullCloseToOpenCount;
            this.lastLastOpenAt = this.lastOpenAt;
            this.lastOpenAt = openAt;
            ++this.openCount;
            this.zipFileState = ZipFileState.OPEN;
        } else {
            throw this.unknownState();
        }
        if (ZIP_REAPER_COLLECT_TIMINGS) {
            this.timing(" Open " + ZipFileData.dualTiming(openAt, this.initialAt) + " " + this.openState());
        }
    }

    @Trivial
    public boolean enactClose(long closeAt, boolean closeAll) {
        String methodName = "enactClose";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " On [ " + this.path + " ] at [ " + ZipFileData.toRelSec(this.initialAt, closeAt) + " (s) ]"), (Object[])new Object[0]);
        }
        if (this.zipFileState == ZipFileState.OPEN) {
            boolean isLastClose;
            this.closeCount = closeAll ? this.openCount : ++this.closeCount;
            if (this.closeCount == this.openCount) {
                this.openDuration += closeAt - this.lastOpenAt;
                if (this.firstPendAt == -1L) {
                    this.firstPendAt = closeAt;
                }
                this.lastPendAt = closeAt;
                ++this.openToPendCount;
                this.zipFileState = ZipFileState.PENDING;
                isLastClose = true;
            } else {
                isLastClose = false;
            }
            if (ZIP_REAPER_COLLECT_TIMINGS) {
                this.timing(" Close " + ZipFileData.dualTiming(closeAt, this.initialAt) + " " + this.openState());
            }
            return isLastClose;
        }
        if (this.zipFileState == ZipFileState.PENDING) {
            throw this.illegalTransition(ZipFileAction.CLOSE);
        }
        if (this.zipFileState == ZipFileState.FULLY_CLOSED) {
            throw this.illegalTransition(ZipFileAction.CLOSE);
        }
        throw this.unknownState();
    }

    @Trivial
    public void enactFullClose(long fullCloseAt) {
        String methodName = "enactFullClose";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " On [ " + this.path + " ] at [ " + ZipFileData.toRelSec(this.initialAt, fullCloseAt) + " (s) ]"), (Object[])new Object[0]);
        }
        if (this.zipFileState == ZipFileState.OPEN) {
            throw this.illegalTransition(ZipFileAction.FULL_CLOSE);
        }
        if (this.zipFileState == ZipFileState.PENDING) {
            long lastPendDuration = fullCloseAt - this.lastPendAt;
            this.pendToFullCloseDuration += lastPendDuration;
            ++this.pendToFullCloseCount;
            if (this.firstFullCloseAt == -1L) {
                this.firstFullCloseAt = fullCloseAt;
            }
            this.lastFullCloseAt = fullCloseAt;
            this.zipFileState = ZipFileState.FULLY_CLOSED;
            if (ZIP_REAPER_COLLECT_TIMINGS) {
                this.timing(" Failed Pend [ " + ZipFileData.toAbsSec(lastPendDuration) + " (s) ]");
                this.timing(" Full Close [ " + ZipFileData.dualTiming(fullCloseAt, this.initialAt) + " (s) ]");
            }
        } else {
            if (this.zipFileState == ZipFileState.FULLY_CLOSED) {
                throw this.illegalTransition(ZipFileAction.FULL_CLOSE);
            }
            throw this.unknownState();
        }
    }

    @Trivial
    public void displayData() {
        if (!ZIP_REAPER_COLLECT_TIMINGS) {
            return;
        }
        System.out.println("ZFR ZipFile [ " + this.path + " ] Statistics:");
        String openText = this.lastLastOpenAt == -1L ? "   Open: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstOpenAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastOpenAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.openDuration) + " (s) ]" : "   Open: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstOpenAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastOpenAt) + " (s) ] Next Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastLastOpenAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.openDuration) + " (s) ]";
        System.out.println("ZFR " + openText);
        String pendingText = "   Pending: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstPendAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastPendAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openToPendCount) + " ]";
        System.out.println("ZFR " + pendingText);
        String pendingBeforeOpenText = "     Pending to Open: Count [ " + ZipFileData.toCount(this.pendToOpenCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.pendToOpenDuration) + " (s) ]";
        System.out.println("ZFR " + pendingBeforeOpenText);
        String pendingBeforeCloseText = "     Pending to Full Close: Count [ " + ZipFileData.toCount(this.pendToFullCloseCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.pendToFullCloseDuration) + " (s) ]";
        System.out.println("ZFR " + pendingBeforeCloseText);
        String closeText = "   Full Close: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstFullCloseAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastFullCloseAt) + " (s) ]";
        System.out.println("ZFR " + closeText);
        String closeBeforeOpenText = "     Full Close to Open: Count [ " + ZipFileData.toCount(this.fullCloseToOpenCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.fullCloseToOpenDuration) + " (s) ]";
        System.out.println(closeBeforeOpenText);
    }

    @Trivial
    protected IllegalStateException unknownState() {
        return new IllegalStateException("Unknown zip file state [ " + this.path + " ] [ " + (Object)((Object)this.zipFileState) + " ]");
    }

    @Trivial
    protected IllegalStateException illegalTransition(ZipFileAction zipFileAction) {
        return new IllegalStateException("Action [ " + (Object)((Object)zipFileAction) + " ] is not valid from zip file state [ " + this.path + " ] [ " + (Object)((Object)this.zipFileState) + " ]");
    }

    @Trivial
    protected ZipFile reacquireZipFile() throws IOException, ZipException {
        String methodName = "reacquireZipFile";
        File rawZipFile = new File(this.path);
        long newZipLength = FileUtils.fileLength((File)rawZipFile);
        long newZipLastModified = FileUtils.fileLastModified((File)rawZipFile);
        boolean zipFileChanged = false;
        if (newZipLength != this.zipLength) {
            zipFileChanged = true;
            if (this.openCount > this.closeCount) {
                Tr.warning((TraceComponent)tc, (String)"reaper.unexpected.length.change", (Object[])new Object[]{this.path, this.zipLength, newZipLength});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Zip [ " + this.path + " ]: Update length from [ " + Long.valueOf(this.zipLength) + " ] to [ " + Long.valueOf(newZipLength) + " ]"), (Object[])new Object[0]);
            }
        }
        if (newZipLastModified != this.zipLastModified) {
            zipFileChanged = true;
            if (this.openCount > this.closeCount) {
                Tr.warning((TraceComponent)tc, (String)"reaper.unexpected.lastmodified.change", (Object[])new Object[]{this.path, this.zipLastModified, newZipLastModified});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Zip [ " + this.path + " ]: Update last modified from [ " + Long.valueOf(this.zipLastModified) + " ] to [ " + Long.valueOf(newZipLastModified) + " ]"), (Object[])new Object[0]);
            }
        }
        if (zipFileChanged) {
            if (this.openCount > this.closeCount) {
                Tr.warning((TraceComponent)tc, (String)"reaper.reopen.active", (Object[])new Object[]{this.path});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Reopen [ " + this.path + " ]"), (Object[])new Object[0]);
            }
            ZipFile oldZipFile = this.closeZipFile();
            ZipFile zipFile = this.openZipFile(newZipLength, newZipLastModified);
        }
        return this.zipFile;
    }

    @Trivial
    protected ZipFile openZipFile() throws IOException, ZipException {
        return this.openZipFile(-1L, -1L);
    }

    @Trivial
    protected ZipFile openZipFile(long useZipLength, long useZipLastModified) throws IOException, ZipException {
        String methodName = "openZipFile";
        this.zipFile = ZipFileUtils.openZipFile(this.path);
        if (useZipLength == -1L) {
            File rawZipFile = new File(this.path);
            useZipLength = FileUtils.fileLength((File)rawZipFile);
            useZipLastModified = FileUtils.fileLastModified((File)rawZipFile);
        }
        this.zipLength = useZipLength;
        this.zipLastModified = useZipLastModified;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + this.path + " ] Length [ " + Long.valueOf(this.zipLength) + " ] Last modified [ " + Long.valueOf(this.zipLastModified) + " ]"), (Object[])new Object[0]);
        }
        return this.zipFile;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    protected ZipFile closeZipFile() {
        String methodName = "closeZipFile";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + this.path + " ]"), (Object[])new Object[0]);
        }
        if (this.zipFile == null) {
            throw new IllegalStateException("Null zip file [ " + this.path + " ]");
        }
        ZipFile useZipFile = this.zipFile;
        this.zipFile = null;
        this.zipLength = -1L;
        this.zipLastModified = -1L;
        try {
            ZipFileUtils.closeZipFile(this.path, useZipFile);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileData", (String)"589", (Object)this, (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + " Close failure [ " + this.path + " ] [ " + e.getMessage() + " ]"), (Object[])new Object[0]);
        }
        return useZipFile;
    }

    @Trivial
    public boolean isOpen() {
        return this.zipFileState == ZipFileState.OPEN;
    }

    @Trivial
    public boolean isPending() {
        return this.zipFileState == ZipFileState.PENDING;
    }

    @Trivial
    public boolean isFullyClosed() {
        return this.zipFileState == ZipFileState.FULLY_CLOSED;
    }

    @Trivial
    public int getActiveOpens() {
        return this.openCount - this.closeCount;
    }

    protected long expireAt(long firstDelay, long hitDelay) {
        return this.lastPendAt + (this.expireQuickly ? firstDelay : hitDelay);
    }

    protected boolean setExpireQuickly(long slowPendMin) {
        boolean useExpireQuickly = this.lastLastOpenAt == -1L ? true : this.lastOpenAt - this.lastLastOpenAt < slowPendMin;
        this.expireQuickly = useExpireQuickly;
        return useExpireQuickly;
    }

    @Trivial
    public void debugState() {
        String methodName = "debugState";
        if (!ZipCachingProperties.ZIP_REAPER_DEBUG_STATE || !tc.isInfoEnabled()) {
            return;
        }
        Tr.info((TraceComponent)tc, (String)(methodName + " ZipFile [ " + this.path + " ]:"), (Object[])new Object[0]);
        String spanText = " Span: Initial [ " + ZipFileData.toAbsSec(this.initialAt) + " (s) ] Final [ " + ZipFileData.toAbsSec(this.finalAt) + " (s) ] Duration [ " + ZipFileData.toAbsSec(this.finalAt - this.initialAt) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + spanText), (Object[])new Object[0]);
        String marginsText = "   Margin: To First Open [ " + ZipFileData.toAbsSec(this.firstOpenAt - this.initialAt) + " (s) ] From Last Close [ " + ZipFileData.toAbsSec(this.finalAt - this.lastFullCloseAt) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + marginsText), (Object[])new Object[0]);
        String openText = this.lastLastOpenAt == -1L ? "   Open: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstOpenAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastOpenAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.openDuration) + " (s) ]" : "   Open: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstOpenAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastOpenAt) + " (s) ] Next Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastLastOpenAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.openDuration) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + openText), (Object[])new Object[0]);
        String pendingText = "   Pending: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstPendAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastPendAt) + " (s) ] Count [ " + ZipFileData.toCount(this.openToPendCount) + " ]";
        Tr.info((TraceComponent)tc, (String)(methodName + pendingText), (Object[])new Object[0]);
        String pendingBeforeOpenText = "     Pending to Open: Count [ " + ZipFileData.toCount(this.pendToOpenCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.pendToOpenDuration) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + pendingBeforeOpenText), (Object[])new Object[0]);
        String pendingBeforeCloseText = "     Pending to Full Close: Count [ " + ZipFileData.toCount(this.pendToFullCloseCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.pendToFullCloseDuration) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + pendingBeforeCloseText), (Object[])new Object[0]);
        String closeText = "   Full Close: First [ " + ZipFileData.toRelSec(this.initialAt, this.firstFullCloseAt) + " (s) ] Last [ " + ZipFileData.toRelSec(this.initialAt, this.lastFullCloseAt) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + closeText), (Object[])new Object[0]);
        String closeBeforeOpenText = "     Full Close to Open: Count [ " + ZipFileData.toCount(this.fullCloseToOpenCount) + " ] Duration [ " + ZipFileData.toAbsSec(this.fullCloseToOpenDuration) + " (s) ]";
        Tr.info((TraceComponent)tc, (String)(methodName + closeBeforeOpenText), (Object[])new Object[0]);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ZipFileAction
    extends Enum<ZipFileAction> {
        public static final /* enum */ ZipFileAction OPEN;
        public static final /* enum */ ZipFileAction CLOSE;
        public static final /* enum */ ZipFileAction FULL_CLOSE;
        private static final /* synthetic */ ZipFileAction[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ZipFileAction[] values() {
            return (ZipFileAction[])$VALUES.clone();
        }

        public static ZipFileAction valueOf(String name) {
            return Enum.valueOf(ZipFileAction.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipFileAction.class);
            OPEN = new ZipFileAction();
            CLOSE = new ZipFileAction();
            FULL_CLOSE = new ZipFileAction();
            $VALUES = new ZipFileAction[]{OPEN, CLOSE, FULL_CLOSE};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ZipFileState
    extends Enum<ZipFileState> {
        public static final /* enum */ ZipFileState OPEN;
        public static final /* enum */ ZipFileState PENDING;
        public static final /* enum */ ZipFileState FULLY_CLOSED;
        private static final /* synthetic */ ZipFileState[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ZipFileState[] values() {
            return (ZipFileState[])$VALUES.clone();
        }

        public static ZipFileState valueOf(String name) {
            return Enum.valueOf(ZipFileState.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipFileState.class);
            OPEN = new ZipFileState();
            PENDING = new ZipFileState();
            FULLY_CLOSED = new ZipFileState();
            $VALUES = new ZipFileState[]{OPEN, PENDING, FULLY_CLOSED};
        }
    }
}

