/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileUtils;
import com.ibm.ws.artifact.zip.internal.FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileHandleImpl
implements ZipFileHandle {
    private static final TraceComponent tc = Tr.register(ZipFileHandleImpl.class);
    private final String path;
    private final File file;
    private final ZipFileLock zipFileLock = new ZipFileLock();
    private ZipFile zipFile;
    private int openCount;
    private static final ZipFileReaper zipFileReaper;
    private static final ZipEntriesLock zipEntriesLock;
    private static final Map<String, byte[]> zipEntries;
    private static final ByteArrayInputStream EMPTY_STREAM;
    static final long serialVersionUID = 2275421611381690737L;

    @Trivial
    ZipFileHandleImpl(String path) {
        this.path = path;
        this.file = new File(path);
    }

    @Trivial
    public String getPath() {
        return this.path;
    }

    @Trivial
    public File getFile() {
        return this.file;
    }

    @Trivial
    public long getLastModified() {
        return FileUtils.fileLastModified(this.getFile());
    }

    @Trivial
    private void debug(String methodName, String text) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        String message = methodName + " ZipFileHandle@0x" + Integer.toHexString(this.hashCode()) + " (" + this.path + ", " + Integer.toString(this.openCount) + ") " + text;
        Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public ZipFile open() throws IOException {
        String methodName = "open";
        ZipFileLock zipFileLock = this.zipFileLock;
        synchronized (zipFileLock) {
            if (this.zipFile == null) {
                this.debug(methodName, "Opening");
                this.zipFile = zipFileReaper == null ? ZipFileUtils.openZipFile(this.file) : zipFileReaper.open(this.path);
            }
            ++this.openCount;
            this.debug(methodName, "Opened");
            return this.zipFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public void close() {
        boolean extraClose;
        String methodName = "close";
        ZipFileLock zipFileLock = this.zipFileLock;
        synchronized (zipFileLock) {
            extraClose = this.openCount == 0;
            if (!extraClose) {
                this.debug(methodName, "Closing");
                --this.openCount;
                if (this.openCount == 0) {
                    if (zipFileReaper == null) {
                        ZipFile useZipFile = this.zipFile;
                        this.zipFile = null;
                        try {
                            useZipFile.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl", (String)"183", (Object)this, (Object[])new Object[0]);
                        }
                    } else {
                        this.zipFile = null;
                        zipFileReaper.close(this.path);
                    }
                }
                this.debug(methodName, "Closed");
            }
        }
        if (extraClose && tc.isDebugEnabled()) {
            this.debug(methodName, "Extra close");
            Exception e = new Exception();
            ByteArrayOutputStream stackStream = new ByteArrayOutputStream();
            PrintStream stackPrintStream = new PrintStream(stackStream);
            e.printStackTrace(stackPrintStream);
            Tr.debug((TraceComponent)tc, (String)stackStream.toString(), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public InputStream getInputStream(ZipFile useZipFile, String zipEntryName) throws IOException {
        ZipEntry zipEntry = useZipFile.getEntry(zipEntryName);
        if (zipEntry == null) {
            throw new FileNotFoundException("Zip file [ " + this.getPath() + " ] does not container entry [ " + zipEntryName + " ]");
        }
        return this.getInputStream(useZipFile, zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public InputStream getInputStream(ZipFile useZipFile, ZipEntry zipEntry) throws IOException {
        byte[] entryBytes;
        String doNotCacheReason;
        boolean doNotCache;
        String methodName = "getInputStream";
        String entryName = zipEntry.getName();
        if (zipEntry.isDirectory()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debug(methodName, "Entry [ " + entryName + " ] [ null ] (Not using cache: Directory entry)");
            }
            return null;
        }
        long entrySize = zipEntry.getSize();
        if (entrySize == 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debug(methodName, "Entry [ " + entryName + " ] [ empty stream ] (Not using cache: Empty entry)");
            }
            return EMPTY_STREAM;
        }
        if (zipEntries == null) {
            doNotCache = true;
            doNotCacheReason = "Do not cache: Entry cache disabled";
        } else if (entrySize > (long)ZipCachingProperties.ZIP_CACHE_ENTRY_LIMIT) {
            doNotCache = true;
            doNotCacheReason = "Do not cache: Too big";
        } else if (entryName.equals("META-INF/MANIFEST.MF")) {
            doNotCache = false;
            doNotCacheReason = "Cache META-INF/MANIFEST.MF";
        } else if (entryName.endsWith(".class")) {
            doNotCache = false;
            doNotCacheReason = "Cache .class resources";
        } else {
            doNotCache = true;
            doNotCacheReason = "Do not cache: Not manifest or class resource";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.debug(methodName, "Entry [ " + entryName + " ] [ non-null ] [ " + doNotCacheReason + " ]");
        }
        if (doNotCache) {
            return useZipFile.getInputStream(zipEntry);
        }
        String entryCacheKey = entryName + ":::" + Long.toString(zipEntry.getCrc()) + ":::" + Long.toString(this.getLastModified());
        ZipEntriesLock zipEntriesLock = ZipFileHandleImpl.zipEntriesLock;
        synchronized (zipEntriesLock) {
            entryBytes = zipEntries.get(entryCacheKey);
        }
        if (entryBytes == null) {
            try (InputStream inputStream = useZipFile.getInputStream(zipEntry);){
                entryBytes = ZipFileHandleImpl.read(inputStream, (int)entrySize, entryName);
            }
            ZipEntriesLock zipEntriesLock2 = ZipFileHandleImpl.zipEntriesLock;
            synchronized (zipEntriesLock2) {
                zipEntries.put(entryCacheKey, entryBytes);
            }
        }
        return new ByteArrayInputStream(entryBytes);
    }

    @Trivial
    private static byte[] read(InputStream inputStream, int expectedRead, String name) throws IOException {
        byte[] bytes = new byte[expectedRead];
        int remainingRead = expectedRead;
        int totalRead = 0;
        while (remainingRead > 0) {
            int nextRead = inputStream.read(bytes, totalRead, remainingRead);
            if (nextRead <= 0) {
                throw new IOException("Read only [ " + Integer.valueOf(totalRead) + " ] of expected [ " + Integer.valueOf(expectedRead) + " ] bytes from [ " + name + " ]");
            }
            remainingRead -= nextRead;
            totalRead += nextRead;
        }
        return bytes;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        int useMaxPending = ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING;
        zipFileReaper = useMaxPending == 0 ? null : new ZipFileReaper("zip cache reaper", ZipCachingProperties.ZIP_REAPER_DEBUG_STATE, ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MAX, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX);
        zipEntriesLock = new ZipEntriesLock();
        zipEntries = ZipCachingProperties.ZIP_CACHE_ENTRY_LIMIT == 0 || ZipCachingProperties.ZIP_CACHE_ENTRY_MAX == 0 ? null : new CacheHashMap<String, byte[]>(ZipCachingProperties.ZIP_CACHE_ENTRY_MAX);
        EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class CacheHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int ivMaxSize;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CacheHashMap(int maxSize) {
            this(maxSize, 16, 0.75f, true);
        }

        public CacheHashMap(int maxSize, int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
            this.ivMaxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.ivMaxSize;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CacheHashMap.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ZipEntriesLock {
        static final long serialVersionUID = -3391187476290344100L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipEntriesLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipEntriesLock.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ZipFileLock {
        static final long serialVersionUID = 6447548046968719527L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipFileLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ZipFileLock.class);
        }
    }
}

