/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.managedbean;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.managedbean.ManagedBeanBndComponentImpl;
import com.ibm.ws.javaee.ddmodel.managedbean.ManagedBeanBndDDParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={ContainerAdapter.class}, property={"service.vendor=IBM", "toType=com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd"})
public class ManagedBeanBndAdapter
implements ContainerAdapter<ManagedBeanBnd> {
    public static final String XML_BND_IN_EJB_MOD_NAME = "META-INF/ibm-managed-bean-bnd.xml";
    public static final String XML_BND_IN_WEB_MOD_NAME = "WEB-INF/ibm-managed-bean-bnd.xml";
    private static final String MODULE_NAME_INVALID = "module.name.invalid";
    private static final String MODULE_NAME_NOT_SPECIFIED = "module.name.not.specified";
    private static final TraceComponent tc = Tr.register(ManagedBeanBndAdapter.class);
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    volatile List<ManagedBeanBnd> configurations;
    static final long serialVersionUID = -7430742084322709165L;

    @FFDCIgnore(value={DDParser.ParseException.class})
    public ManagedBeanBnd adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        String ddEntryName = rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebModuleInfo.class) == null ? XML_BND_IN_EJB_MOD_NAME : XML_BND_IN_WEB_MOD_NAME;
        Entry ddEntry = containerToAdapt.getEntry(ddEntryName);
        ManagedBeanBndComponentImpl fromConfig = this.getConfigOverrides(rootOverlay, artifactContainer);
        if (ddEntry == null && fromConfig == null) {
            return null;
        }
        if (ddEntry != null) {
            try {
                ManagedBeanBnd fromApp = new ManagedBeanBndDDParser(containerToAdapt, ddEntry).parse();
                if (fromConfig == null) {
                    return fromApp;
                }
                fromConfig.setDelegate(fromApp);
                return fromConfig;
            }
            catch (DDParser.ParseException e) {
                throw new UnableToAdaptException((Throwable)e);
            }
        }
        return fromConfig;
    }

    private ManagedBeanBndComponentImpl getConfigOverrides(OverlayContainer rootOverlay, ArtifactContainer artifactContainer) throws UnableToAdaptException {
        if (this.configurations == null || this.configurations.isEmpty()) {
            return null;
        }
        ApplicationInfo appInfo = (ApplicationInfo)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), ApplicationInfo.class);
        ModuleInfo moduleInfo = null;
        if (appInfo == null && rootOverlay.getParentOverlay() != null) {
            moduleInfo = (ModuleInfo)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), ModuleInfo.class);
            if (moduleInfo == null) {
                return null;
            }
            appInfo = moduleInfo.getApplicationInfo();
        }
        NestedConfigHelper configHelper = null;
        if (appInfo != null && appInfo instanceof ExtendedApplicationInfo) {
            configHelper = ((ExtendedApplicationInfo)appInfo).getConfigHelper();
        }
        if (configHelper == null) {
            return null;
        }
        HashSet<String> configuredModuleNames = new HashSet<String>();
        String servicePid = (String)configHelper.get("service.pid");
        String extendsPid = (String)configHelper.get("ibm.extends.source.pid");
        for (ManagedBeanBnd config : this.configurations) {
            ManagedBeanBndComponentImpl configImpl = (ManagedBeanBndComponentImpl)config;
            String parentPid = (String)configImpl.getConfigAdminProperties().get("config.parentPID");
            if (!servicePid.equals(parentPid) && !parentPid.equals(extendsPid)) continue;
            if (moduleInfo == null) {
                return configImpl;
            }
            String moduleName = (String)configImpl.getConfigAdminProperties().get("moduleName");
            if (moduleName == null) {
                if (rootOverlay.getParentOverlay().getFromNonPersistentCache(MODULE_NAME_NOT_SPECIFIED, ManagedBeanBndAdapter.class) != null) continue;
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_NOT_SPECIFIED, (Object[])new Object[]{"managed-bean-bnd"});
                rootOverlay.getParentOverlay().addToNonPersistentCache(MODULE_NAME_NOT_SPECIFIED, ManagedBeanBndAdapter.class, (Object)MODULE_NAME_NOT_SPECIFIED);
                continue;
            }
            moduleName = this.stripExtension(moduleName);
            configuredModuleNames.add(moduleName);
            if (!moduleInfo.getName().equals(moduleName)) continue;
            return configImpl;
        }
        if (moduleInfo != null && !configuredModuleNames.isEmpty() && rootOverlay.getParentOverlay().getFromNonPersistentCache(MODULE_NAME_INVALID, ManagedBeanBndAdapter.class) == null) {
            HashSet<String> moduleNames = new HashSet<String>();
            Application app = (Application)appInfo.getContainer().adapt(Application.class);
            for (Module m : app.getModules()) {
                moduleNames.add(this.stripExtension(m.getModulePath()));
            }
            configuredModuleNames.removeAll(moduleNames);
            if (!configuredModuleNames.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_INVALID, (Object[])new Object[]{configuredModuleNames, "managed-bean-bnd"});
            }
            rootOverlay.getParentOverlay().addToNonPersistentCache(MODULE_NAME_INVALID, ManagedBeanBndAdapter.class, (Object)MODULE_NAME_INVALID);
        }
        return null;
    }

    private String stripExtension(String moduleName) {
        if (moduleName.endsWith(".war") || moduleName.endsWith(".jar")) {
            return moduleName.substring(0, moduleName.length() - 4);
        }
        return moduleName;
    }
}

