/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans.hash;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.security.enterprise.identitystore.Pbkdf2PasswordHash;

@Default
@Dependent
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Pbkdf2PasswordHashImpl
implements Pbkdf2PasswordHash {
    private static final TraceComponent tc = Tr.register(Pbkdf2PasswordHashImpl.class);
    private static final String PARAM_ALGORITHM = "Pbkdf2PasswordHash.Algorithm";
    private static final String PARAM_ITERATIONS = "Pbkdf2PasswordHash.Iterations";
    private static final String PARAM_SALTSIZE = "Pbkdf2PasswordHash.SaltSizeBytes";
    private static final String PARAM_KEYSIZE = "Pbkdf2PasswordHash.KeySizeBytes";
    private static final int DEFAULT_ALGORITHM = 1;
    private static final int DEFAULT_ITERATIONS = 2048;
    private static final int DEFAULT_SALTSIZE = 32;
    private static final int DEFAULT_KEYSIZE = 32;
    private static final int MINIMUM_ITERATIONS = 1024;
    private static final int MINIMUM_SALTSIZE = 16;
    private static final int MINIMUM_KEYSIZE = 16;
    private static final List<String> SUPPORTED_ALGORITHMS = Arrays.asList("PBKDF2WithHmacSHA224", "PBKDF2WithHmacSHA256", "PBKDF2WithHmacSHA384", "PBKDF2WithHmacSHA512");
    private int generateAlgorithm = 1;
    private int generateIterations = 2048;
    private int generateSaltSize = 32;
    private int generateKeySize = 32;
    static final long serialVersionUID = 8265946135746936410L;

    public void initialize(Map<String, String> params) {
        this.parseParams(params);
    }

    public String generate(@Sensitive char[] password) {
        byte[] salt = this.generateSalt(this.generateSaltSize);
        byte[] outputBytes = this.generate(SUPPORTED_ALGORITHMS.get(this.generateAlgorithm), this.generateIterations, this.generateKeySize, salt, password);
        return this.format(SUPPORTED_ALGORITHMS.get(this.generateAlgorithm), this.generateIterations, salt, outputBytes);
    }

    public boolean verify(@Sensitive char[] password, String hashedPassword) {
        String[] items = this.parseData(hashedPassword);
        byte[] originalHash = Base64Coder.base64DecodeString((String)items[3]);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("original Hash length : " + (originalHash != null ? Integer.valueOf(originalHash.length) : "null")), (Object[])new Object[0]);
        }
        if (originalHash == null) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_DATA", (Object[])new Object[]{Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_INVALID_HASH_VALUE", (Object[])new Object[0])});
            Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            throw new IllegalArgumentException(message);
        }
        byte[] salt = Base64Coder.base64DecodeString((String)items[2]);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("original Salt length : " + (salt != null ? Integer.valueOf(salt.length) : "null")), (Object[])new Object[0]);
        }
        if (salt == null) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_DATA", (Object[])new Object[]{Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_INVALID_SALT_VALUE", (Object[])new Object[0])});
            Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            throw new IllegalArgumentException(message);
        }
        byte[] calculatedHash = this.generate(items[0], Integer.parseInt(items[1]), originalHash.length, salt, password);
        return Arrays.equals(originalHash, calculatedHash);
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseData(String hashedPassword) throws IllegalArgumentException {
        items = hashedPassword.split(":");
        error = null;
        if (items.length == 4) {
            if (Pbkdf2PasswordHashImpl.SUPPORTED_ALGORITHMS.contains(items[0])) {
                try {
                    Integer.parseInt(items[1]);
                    return items;
                }
                catch (Exception var4_4) {
                    FFDCFilter.processException((Throwable)var4_4, (String)"com.ibm.ws.security.javaeesec.cdi.beans.hash.Pbkdf2PasswordHashImpl", (String)"125", (Object)this, (Object[])new Object[]{hashedPassword});
                    error = Tr.formatMessage((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)"JAVAEESEC_CDI_INVALID_ITERATION", (Object[])new Object[]{items[1]});
                    if (!Pbkdf2PasswordHashImpl.tc.isDebugEnabled()) ** GOTO lbl22
                    Tr.debug((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)("Invalid format: the iterations is not a number : " + items[1]), (Object[])new Object[0]);
                }
            } else {
                error = Tr.formatMessage((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)"JAVAEESEC_CDI_INVALID_ALGORITHM", (Object[])new Object[]{items[0]});
                if (Pbkdf2PasswordHashImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)("Invalid format: the hash algorithm is not supported : " + items[0]), (Object[])new Object[0]);
                }
            }
        } else {
            error = Tr.formatMessage((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)"JAVAEESEC_CDI_INVALID_ELEMENTS", (Object[])new Object[]{items.length});
            if (Pbkdf2PasswordHashImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)("Invalid format: the number of the elements is not 4 but " + items.length), (Object[])new Object[0]);
            }
        }
lbl22:
        // 6 sources

        message = Tr.formatMessage((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_DATA", (Object[])new Object[]{error});
        Tr.error((TraceComponent)Pbkdf2PasswordHashImpl.tc, (String)message, (Object[])new Object[0]);
        throw new IllegalArgumentException(message);
    }

    protected void parseParams(Map<String, String> params) {
        this.generateAlgorithm = this.indexOf(PARAM_ALGORITHM, 1, SUPPORTED_ALGORITHMS, params.get(PARAM_ALGORITHM));
        this.generateIterations = this.parseInt(PARAM_ITERATIONS, params.get(PARAM_ITERATIONS), 2048, 1024);
        this.generateSaltSize = this.parseInt(PARAM_SALTSIZE, params.get(PARAM_SALTSIZE), 32, 16);
        this.generateKeySize = this.parseInt(PARAM_KEYSIZE, params.get(PARAM_KEYSIZE), 32, 16);
    }

    private int indexOf(String name, int defaultValue, List<String> list, String value) {
        int output = defaultValue;
        if (value != null) {
            int index = SUPPORTED_ALGORITHMS.indexOf(value);
            if (index >= 0) {
                output = index;
            } else {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_PARAM", (Object[])new Object[]{value, name});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_PARAM", (Object[])new Object[]{value, name});
                throw new IllegalArgumentException(msg);
            }
        }
        return output;
    }

    private int parseInt(String name, String value, int defaultValue, int minimumValue) {
        int output = defaultValue;
        if (value != null) {
            try {
                output = Integer.parseInt(value);
                if (output < minimumValue) {
                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_BELOW_MINIMUM_PARAM", (Object[])new Object[]{value, name, minimumValue});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_BELOW_MINIMUM_PARAM", (Object[])new Object[]{value, name, minimumValue});
                    throw new IllegalArgumentException(msg);
                }
            }
            catch (NumberFormatException msg) {
                FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.security.javaeesec.cdi.beans.hash.Pbkdf2PasswordHashImpl", (String)"183", (Object)this, (Object[])new Object[]{name, value, defaultValue, minimumValue});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_PARAM", (Object[])new Object[]{value, name});
                String msg2 = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_PASSWORDHASH_INVALID_PARAM", (Object[])new Object[]{value, name});
                throw new IllegalArgumentException(msg2);
            }
        }
        return output;
    }

    private byte[] generateSalt(int size) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[size];
        random.nextBytes(salt);
        return salt;
    }

    private String format(String algorithm, int iterations, byte[] salt, byte[] value) {
        int COLON = 58;
        StringBuffer sb = new StringBuffer(algorithm);
        sb.append(':').append(iterations).append(':').append(Base64Coder.base64EncodeToString((byte[])salt)).append(':').append(Base64Coder.base64EncodeToString((byte[])value));
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] generate(String algorithm, int iterations, int keySize, byte[] salt, @Sensitive char[] password) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterations, keySize * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = skf.generateSecret(keySpec);
            return secretKey.getEncoded();
        }
        catch (Exception secretKey) {
            void e;
            Object[] objectArray = new Object[5];
            objectArray[0] = algorithm;
            objectArray[1] = iterations;
            objectArray[2] = keySize;
            objectArray[3] = salt;
            objectArray[4] = "<sensitive char[]>";
            FFDCFilter.processException((Throwable)secretKey, (String)"com.ibm.ws.security.javaeesec.cdi.beans.hash.Pbkdf2PasswordHashImpl", (String)"214", (Object)this, (Object[])objectArray);
            throw new RuntimeException((Throwable)e);
        }
    }

    protected String getAlgorithmString(int index) {
        return SUPPORTED_ALGORITHMS.get(index);
    }

    protected int getAlgorithm() {
        return this.generateAlgorithm;
    }

    protected int getIterations() {
        return this.generateIterations;
    }

    protected int getSaltSize() {
        return this.generateSaltSize;
    }

    protected int getKeySize() {
        return this.generateKeySize;
    }
}

