/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.javaeesec.ApplicationUtils;
import com.ibm.ws.security.javaeesec.cdi.beans.BasicHttpAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.beans.CustomFormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.beans.FormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.extensions.AutoApplySessionInterceptor;
import com.ibm.ws.security.javaeesec.cdi.extensions.DatabaseIdentityStoreBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.IdentityStoreHandlerBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.LdapIdentityStoreBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.ModulePropertiesProviderBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor;
import com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextProducer;
import com.ibm.ws.security.javaeesec.properties.ModuleProperties;
import com.ibm.ws.threadContext.ModuleMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import javax.security.enterprise.identitystore.PasswordHash;
import javax.security.enterprise.identitystore.Pbkdf2PasswordHash;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={WebSphereCDIExtension.class}, property={"api.classes=javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;javax.security.enterprise.identitystore.IdentityStore;javax.security.enterprise.identitystore.IdentityStoreHandler;javax.security.enterprise.identitystore.RememberMeIdentityStore;javax.security.enterprise.SecurityContext;com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider", "bean.defining.annotations=javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;javax.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;javax.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;javax.security.enterprise.authentication.mechanism.http.LoginToContinue;javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;javax.security.enterprise.identitystore.LdapIdentityStoreDefinition"}, immediate=true)
public class JavaEESecCDIExtension<T>
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(JavaEESecCDIExtension.class);
    private final Set<Bean> beansToAdd = new HashSet<Bean>();
    private boolean identityStoreHandlerRegistered = false;
    private boolean identityStoreRegistered = false;
    private final Map<String, ModuleProperties> moduleMap = new HashMap<String, ModuleProperties>();
    private final List<LdapIdentityStoreDefinition> ldapDefinitionList = new ArrayList<LdapIdentityStoreDefinition>();
    private final List<DatabaseIdentityStoreDefinition> databaseDefinitionList = new ArrayList<DatabaseIdentityStoreDefinition>();
    static final long serialVersionUID = 2763094261848980243L;

    public void processApplicationHAMClass(@Observes ProcessAnnotatedType<? extends HttpAuthenticationMechanism> processAnnotatedType, BeanManager beanManager) {
        this.processAnnotatedType(processAnnotatedType, beanManager);
    }

    public <T> void processAnnotatedHAMandIS(@Observes @WithAnnotations(value={BasicAuthenticationMechanismDefinition.class, FormAuthenticationMechanismDefinition.class, CustomFormAuthenticationMechanismDefinition.class, LdapIdentityStoreDefinition.class, DatabaseIdentityStoreDefinition.class, LoginToContinue.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        this.processAnnotatedType(processAnnotatedType, beanManager);
    }

    public <T> void processAnnotatedType(ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processAnnotatedType : instance : " + Integer.toHexString(this.hashCode()) + " BeanManager : " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processAnnotatedType : annotation : " + annotatedType), (Object[])new Object[0]);
        }
        Class javaClass = annotatedType.getJavaClass();
        boolean isAuthMechOverridden = this.isAuthMechOverridden();
        if (this.isApplicationAuthMech(javaClass)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found an application specific HttpAuthenticationMechanism : " + javaClass), (Object[])new Object[0]);
            }
            if (isAuthMechOverridden) {
                this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass);
            } else {
                Annotation ltc = annotatedType.getAnnotation(LoginToContinue.class);
                this.createModulePropertiesProviderBeanForApplicationAuthMechToAdd(beanManager, ltc, javaClass);
            }
        }
        Set annotations = annotatedType.getAnnotations();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Annotations found: " + annotation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Annotation class: ", (Object[])new Object[]{annotation.getClass()});
            }
            if (BasicAuthenticationMechanismDefinition.class.equals(annotationType = annotation.annotationType())) {
                if (isAuthMechOverridden) {
                    this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass);
                    continue;
                }
                this.createModulePropertiesProviderBeanForBasicToAdd(beanManager, annotation, annotationType, javaClass);
                continue;
            }
            if (FormAuthenticationMechanismDefinition.class.equals(annotationType) || CustomFormAuthenticationMechanismDefinition.class.equals(annotationType)) {
                if (isAuthMechOverridden) {
                    this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass);
                    continue;
                }
                this.createModulePropertiesProviderBeanForFormToAdd(beanManager, annotation, annotationType, javaClass);
                continue;
            }
            if (LdapIdentityStoreDefinition.class.equals(annotationType)) {
                this.createLdapIdentityStoreBeanToAdd(beanManager, annotation, annotationType);
                this.identityStoreRegistered = true;
                continue;
            }
            if (!DatabaseIdentityStoreDefinition.class.equals(annotationType)) continue;
            this.createDatabaseIdentityStoreBeanToAdd(beanManager, annotation, annotationType);
            this.identityStoreRegistered = true;
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType securityContextProducerType = beanManager.createAnnotatedType(SecurityContextProducer.class);
        beforeBeanDiscovery.addAnnotatedType(securityContextProducerType, SecurityContextProducer.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
        AnnotatedType autoApplySessionInterceptorType = beanManager.createAnnotatedType(AutoApplySessionInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(autoApplySessionInterceptorType, AutoApplySessionInterceptor.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
        AnnotatedType rememberMeInterceptorInterceptorType = beanManager.createAnnotatedType(RememberMeInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(rememberMeInterceptorInterceptorType, RememberMeInterceptor.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public <T> void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("afterBeanDiscovery : instance : " + Integer.toHexString(this.hashCode()) + " BeanManager : " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        try {
            this.verifyConfiguration();
            if (!this.identityStoreHandlerRegistered) {
                this.beansToAdd.add(new IdentityStoreHandlerBean(beanManager));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"registering the default IdentityStoreHandler.", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IdentityStoreHandler is not registered because a custom IdentityStoreHandler has been registered,", (Object[])new Object[0]);
            }
        }
        catch (DeploymentException deploymentException) {
            void de;
            FFDCFilter.processException((Throwable)deploymentException, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"182", (Object)this, (Object[])new Object[]{afterBeanDiscovery, beanManager});
            afterBeanDiscovery.addDefinitionError((Throwable)de);
        }
        if (!this.isEmptyModuleMap()) {
            ModulePropertiesProviderBean bean = new ModulePropertiesProviderBean(beanManager, this.moduleMap);
            this.beansToAdd.add(bean);
            ApplicationUtils.registerApplication((String)this.getApplicationName());
        }
        for (Bean bean : this.beansToAdd) {
            afterBeanDiscovery.addBean(bean);
        }
    }

    public void processBean(@Observes ProcessBean<?> processBean, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processBean : instance : " + Integer.toHexString(this.hashCode()) + " BeanManager : " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        if (!this.identityStoreHandlerRegistered && this.isIdentityStoreHandler(processBean)) {
            this.identityStoreHandlerRegistered = true;
        }
        if (!this.identityStoreRegistered && this.isIdentityStore(processBean)) {
            this.identityStoreRegistered = true;
        }
    }

    public void processBasicHttpAuthMechNeeded(@Observes ProcessBeanAttributes<BasicHttpAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(BasicHttpAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BasicHttpAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    public void processFormAuthMechNeeded(@Observes ProcessBeanAttributes<FormAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(FormAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FormAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    public void processCustomFormAuthMechNeeded(@Observes ProcessBeanAttributes<CustomFormAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(CustomFormAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CustomFormAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void createModulePropertiesProviderBeanForFormToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType, Class<?> annotatedClass) {
        try {
            Method loginToContinueMethod = annotationType.getMethod("loginToContinue", new Class[0]);
            Annotation ltcAnnotation = (Annotation)loginToContinueMethod.invoke((Object)annotation, new Object[0]);
            Properties props = this.parseLoginToContinue(ltcAnnotation);
            Class implClass = FormAuthenticationMechanismDefinition.class.equals(annotationType) ? FormAuthenticationMechanism.class : CustomFormAuthenticationMechanism.class;
            this.addAuthMech(annotatedClass, implClass, props);
        }
        catch (Exception loginToContinueMethod) {
            void e;
            FFDCFilter.processException((Throwable)loginToContinueMethod, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"260", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType, annotatedClass});
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForBasicToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType, Class annotatedClass) {
        try {
            Method realmNameMethod = annotationType.getMethod("realmName", new Class[0]);
            String realmName = (String)realmNameMethod.invoke((Object)annotation, new Object[0]);
            Properties props = new Properties();
            props.put("realmName", realmName);
            this.addAuthMech(annotatedClass, BasicHttpAuthenticationMechanism.class, props);
        }
        catch (Exception realmNameMethod) {
            void e;
            FFDCFilter.processException((Throwable)realmNameMethod, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"279", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType, annotatedClass});
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForApplicationAuthMechToAdd(BeanManager beanManager, Annotation ltc, Class implClass) {
        Properties props = null;
        if (ltc != null) {
            try {
                props = this.parseLoginToContinue(ltc);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"297", (Object)this, (Object[])new Object[]{beanManager, ltc, implClass});
                e.printStackTrace();
            }
        }
        this.addAuthMech(implClass, implClass, props);
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForGlobalLogin(BeanManager beanManager, Class annotatedClass) {
        try {
            Class implClass;
            Properties props;
            if (this.isAuthMechOverriddenByForm()) {
                props = this.getGlobalLoginFormProps();
                implClass = FormAuthenticationMechanism.class;
            } else {
                props = this.getGlobalLoginBasicProps();
                implClass = BasicHttpAuthenticationMechanism.class;
            }
            this.addAuthMech(annotatedClass, implClass, props);
        }
        catch (Exception props) {
            void e;
            FFDCFilter.processException((Throwable)props, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"323", (Object)this, (Object[])new Object[]{beanManager, annotatedClass});
            e.printStackTrace();
        }
    }

    private void addAuthMech(Class<?> annotatedClass, Class<?> implClass, Properties props) {
        Map<String, ModuleProperties> moduleMap = this.getModuleMap();
        String moduleName = this.getModuleFromClass(annotatedClass, moduleMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleName: " + moduleName), (Object[])new Object[0]);
        }
        if (moduleMap.containsKey(moduleName)) {
            moduleMap.get(moduleName).putToAuthMechMap(implClass, props);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Place the AuthMech to all modules since the module is not found  Module: " + moduleName), (Object[])new Object[0]);
            }
            for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
                entry.getValue().putToAuthMechMap(implClass, props);
            }
        }
    }

    private Map<Class<?>, Properties> getAuthMechs(String moduleName) {
        Map authMechs = null;
        Map<String, ModuleProperties> moduleMap = this.getModuleMap();
        if (moduleMap.containsKey(moduleName)) {
            authMechs = moduleMap.get(moduleName).getAuthMechMap();
        }
        return authMechs;
    }

    private Properties parseLoginToContinue(Annotation ltcAnnotation) throws Exception {
        Properties props = new Properties();
        Class<? extends Annotation> ltcAnnotationType = ltcAnnotation.annotationType();
        props.put("loginPage", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "loginPage"));
        props.put("errorPage", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "errorPage"));
        props.put("useForwardToLoginExpression", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "useForwardToLoginExpression"));
        props.put("useForwardToLogin", (Object)this.getAnnotatedBoolean(ltcAnnotation, ltcAnnotationType, "useForwardToLogin"));
        return props;
    }

    /*
     * WARNING - void declaration
     */
    private String getAnnotatedString(final Annotation annotation, final Class<? extends Annotation> annotationType, final String element) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = -280513778332454590L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                    return (String)annotationType.getMethod(element, new Class[0]).invoke((Object)annotation, new Object[0]);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"380", (Object)this, (Object[])new Object[]{annotation, annotationType, element});
            throw e.getException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean getAnnotatedBoolean(final Annotation annotation, final Class<? extends Annotation> annotationType, final String element) throws Exception {
        try {
            Boolean result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -4894770422010973215L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                    return (Boolean)annotationType.getMethod(element, new Class[0]).invoke((Object)annotation, new Object[0]);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            return result;
        }
        catch (PrivilegedActionException result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"394", (Object)this, (Object[])new Object[]{annotation, annotationType, element});
            throw e.getException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createLdapIdentityStoreBeanToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType) {
        try {
            Method[] methods;
            HashMap<String, Object> identityStoreProperties = new HashMap<String, Object>();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JavaEESec.createLdapISBeanToAdd", (Object[])new Object[0]);
            }
            for (Method m : methods = annotationType.getMethods()) {
                Tr.debug((TraceComponent)tc, (String)m.getName(), (Object[])new Object[0]);
                if (m.getName().equals("equals")) continue;
                identityStoreProperties.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            LdapIdentityStoreDefinition ldapDefinition = this.getInstanceOfAnnotation(identityStoreProperties);
            if (!this.containsLdapDefinition(ldapDefinition, this.ldapDefinitionList)) {
                this.ldapDefinitionList.add(ldapDefinition);
                LdapIdentityStoreBean bean = new LdapIdentityStoreBean(beanManager, ldapDefinition);
                this.beansToAdd.add(bean);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"registering the default LdapIdentityStore.", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the same annotation exists, skip registering..", (Object[])new Object[0]);
            }
        }
        catch (Exception identityStoreProperties) {
            void e;
            FFDCFilter.processException((Throwable)identityStoreProperties, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"426", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType});
            e.printStackTrace();
        }
    }

    private boolean containsLdapDefinition(LdapIdentityStoreDefinition ldapDefinition, List<LdapIdentityStoreDefinition> ldapDefinitionList) {
        for (LdapIdentityStoreDefinition lisd : ldapDefinitionList) {
            if (!this.equalsLdapDefinition(ldapDefinition, lisd)) continue;
            return true;
        }
        return false;
    }

    private LdapIdentityStoreDefinition getInstanceOfAnnotation(final Map<String, Object> overrides) {
        LdapIdentityStoreDefinition annotation = new LdapIdentityStoreDefinition(){
            static final long serialVersionUID = 2746903800761409095L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String bindDn() {
                return overrides != null && overrides.containsKey("bindDn") ? (String)overrides.get("bindDn") : "";
            }

            @Sensitive
            public String bindDnPassword() {
                return overrides != null && overrides.containsKey("bindDnPassword") ? (String)overrides.get("bindDnPassword") : "";
            }

            public String callerBaseDn() {
                return overrides != null && overrides.containsKey("callerBaseDn") ? (String)overrides.get("callerBaseDn") : "";
            }

            public String callerNameAttribute() {
                return overrides != null && overrides.containsKey("callerNameAttribute") ? (String)overrides.get("callerNameAttribute") : "uid";
            }

            public String callerSearchBase() {
                return overrides != null && overrides.containsKey("callerSearchBase") ? (String)overrides.get("callerSearchBase") : "";
            }

            public String callerSearchFilter() {
                return overrides != null && overrides.containsKey("callerSearchFilter") ? (String)overrides.get("callerSearchFilter") : "";
            }

            public LdapIdentityStoreDefinition.LdapSearchScope callerSearchScope() {
                return overrides != null && overrides.containsKey("callerSearchScope") ? (LdapIdentityStoreDefinition.LdapSearchScope)overrides.get("callerSearchScope") : LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
            }

            public String callerSearchScopeExpression() {
                return overrides != null && overrides.containsKey("callerSearchScopeExpression") ? (String)overrides.get("callerSearchScopeExpression") : "";
            }

            public String groupMemberAttribute() {
                return overrides != null && overrides.containsKey("groupMemberAttribute") ? (String)overrides.get("groupMemberAttribute") : "member";
            }

            public String groupMemberOfAttribute() {
                return overrides != null && overrides.containsKey("groupMemberOfAttribute") ? (String)overrides.get("groupMemberOfAttribute") : "memberOf";
            }

            public String groupNameAttribute() {
                return overrides != null && overrides.containsKey("groupNameAttribute") ? (String)overrides.get("groupNameAttribute") : "cn";
            }

            public String groupSearchBase() {
                return overrides != null && overrides.containsKey("groupSearchBase") ? (String)overrides.get("groupSearchBase") : "";
            }

            public String groupSearchFilter() {
                return overrides != null && overrides.containsKey("groupSearchFilter") ? (String)overrides.get("groupSearchFilter") : "";
            }

            public LdapIdentityStoreDefinition.LdapSearchScope groupSearchScope() {
                return overrides != null && overrides.containsKey("groupSearchScope") ? (LdapIdentityStoreDefinition.LdapSearchScope)overrides.get("groupSearchScope") : LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
            }

            public String groupSearchScopeExpression() {
                return overrides != null && overrides.containsKey("groupSearchScopeExpression") ? (String)overrides.get("groupSearchScopeExpression") : "";
            }

            public int maxResults() {
                return overrides != null && overrides.containsKey("maxResults") ? (Integer)overrides.get("maxResults") : 1000;
            }

            public String maxResultsExpression() {
                return overrides != null && overrides.containsKey("maxResultsExpression") ? (String)overrides.get("maxResultsExpression") : "";
            }

            public int priority() {
                return overrides != null && overrides.containsKey("priority") ? (Integer)overrides.get("priority") : 80;
            }

            public String priorityExpression() {
                return overrides != null && overrides.containsKey("priorityExpression") ? (String)overrides.get("priorityExpression") : "";
            }

            public int readTimeout() {
                return overrides != null && overrides.containsKey("readTimeout") ? (Integer)overrides.get("readTimeout") : 0;
            }

            public String readTimeoutExpression() {
                return overrides != null && overrides.containsKey("readTimeoutExpression") ? (String)overrides.get("readTimeoutExpression") : "";
            }

            public String url() {
                return overrides != null && overrides.containsKey("url") ? (String)overrides.get("url") : "";
            }

            public IdentityStore.ValidationType[] useFor() {
                IdentityStore.ValidationType[] validationTypeArray;
                if (overrides != null && overrides.containsKey("useFor")) {
                    validationTypeArray = (IdentityStore.ValidationType[])overrides.get("useFor");
                } else {
                    IdentityStore.ValidationType[] validationTypeArray2 = new IdentityStore.ValidationType[2];
                    validationTypeArray2[0] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                    validationTypeArray = validationTypeArray2;
                    validationTypeArray2[1] = IdentityStore.ValidationType.VALIDATE;
                }
                return validationTypeArray;
            }

            public String useForExpression() {
                return overrides != null && overrides.containsKey("useForExpression") ? (String)overrides.get("useForExpression") : "";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        return annotation;
    }

    protected boolean equalsLdapDefinition(LdapIdentityStoreDefinition lisd1, LdapIdentityStoreDefinition lisd2) {
        return lisd1.bindDn().equals(lisd2.bindDn()) && lisd1.bindDnPassword().equals(lisd2.bindDnPassword()) && lisd1.callerBaseDn().equals(lisd2.callerBaseDn()) && lisd1.callerNameAttribute().equals(lisd2.callerNameAttribute()) && lisd1.callerSearchBase().equals(lisd2.callerSearchBase()) && lisd1.callerSearchFilter().equals(lisd2.callerSearchFilter()) && lisd1.callerSearchScope().equals((Object)lisd2.callerSearchScope()) && lisd1.callerSearchScopeExpression().equals(lisd2.callerSearchScopeExpression()) && lisd1.groupMemberAttribute().equals(lisd2.groupMemberAttribute()) && lisd1.groupMemberOfAttribute().equals(lisd2.groupMemberOfAttribute()) && lisd1.groupNameAttribute().equals(lisd2.groupNameAttribute()) && lisd1.groupSearchBase().equals(lisd2.groupSearchBase()) && lisd1.groupSearchFilter().equals(lisd2.groupSearchFilter()) && lisd1.groupSearchScope().equals((Object)lisd2.groupSearchScope()) && lisd1.groupSearchScopeExpression().equals(lisd2.groupSearchScopeExpression()) && lisd1.maxResults() == lisd2.maxResults() && lisd1.maxResultsExpression().equals(lisd2.maxResultsExpression()) && lisd1.priority() == lisd2.priority() && lisd1.priorityExpression().equals(lisd2.priorityExpression()) && lisd1.readTimeout() == lisd2.readTimeout() && lisd1.readTimeoutExpression().equals(lisd2.readTimeoutExpression()) && lisd1.url().equals(lisd2.url()) && this.equalsUseFor(lisd1.useFor(), lisd2.useFor()) && lisd1.useForExpression().equals(lisd2.useForExpression());
    }

    private boolean equalsUseFor(IdentityStore.ValidationType[] vt1, IdentityStore.ValidationType[] vt2) {
        if (vt1 == vt2) {
            return true;
        }
        if (vt1.length == vt2.length && vt1.length == 1) {
            return vt1[0] == vt2[0];
        }
        List<IdentityStore.ValidationType> list1 = Arrays.asList(vt1);
        List<IdentityStore.ValidationType> list2 = Arrays.asList(vt2);
        return list1.contains(IdentityStore.ValidationType.PROVIDE_GROUPS) == list2.contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && list1.contains(IdentityStore.ValidationType.VALIDATE) == list2.contains(IdentityStore.ValidationType.VALIDATE);
    }

    /*
     * WARNING - void declaration
     */
    private void createDatabaseIdentityStoreBeanToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType) {
        block8: {
            try {
                Method[] methods;
                HashMap<String, Object> identityStoreProperties = new HashMap<String, Object>();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JavaEESec.createDatabaseIdentityStoreBeanToAdd", (Object[])new Object[0]);
                }
                for (Method m : methods = annotationType.getMethods()) {
                    Tr.debug((TraceComponent)tc, (String)m.getName(), (Object[])new Object[0]);
                    if (m.getName().equals("equals")) continue;
                    identityStoreProperties.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
                }
                DatabaseIdentityStoreDefinition databaseDefinition = this.getInstanceOfDBAnnotation(identityStoreProperties);
                if (!this.containsDatabaseDefinition(databaseDefinition, this.databaseDefinitionList)) {
                    DatabaseIdentityStoreBean bean = new DatabaseIdentityStoreBean(beanManager, databaseDefinition);
                    this.beansToAdd.add(bean);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"registering the default DatabaseIdentityStore.", (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the same annotation exists, skip registering..", (Object[])new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException identityStoreProperties) {
                void e;
                FFDCFilter.processException((Throwable)identityStoreProperties, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"645", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType});
                if (!tc.isEventEnabled()) break block8;
                Tr.event((TraceComponent)tc, (String)"unexpected", (Object[])new Object[]{e});
            }
        }
    }

    private boolean containsDatabaseDefinition(DatabaseIdentityStoreDefinition dbDefinition, List<DatabaseIdentityStoreDefinition> dbDefinitionList) {
        for (DatabaseIdentityStoreDefinition disd : dbDefinitionList) {
            if (!this.equalsDatabaseDefinition(dbDefinition, disd)) continue;
            return true;
        }
        return false;
    }

    protected boolean equalsDatabaseDefinition(DatabaseIdentityStoreDefinition disd1, DatabaseIdentityStoreDefinition disd2) {
        return disd1.callerQuery().equals(disd2.callerQuery()) && disd1.dataSourceLookup().equals(disd2.dataSourceLookup()) && disd1.groupsQuery().equals(disd2.groupsQuery()) && disd1.hashAlgorithm().equals(disd2.hashAlgorithm()) && this.equalsHashAlgorithmParameters(disd1.hashAlgorithmParameters(), disd2.hashAlgorithmParameters()) && disd1.priority() == disd2.priority() && disd1.priorityExpression().equals(disd2.priorityExpression()) && this.equalsUseFor(disd1.useFor(), disd2.useFor()) && disd1.useForExpression().equals(disd2.useForExpression());
    }

    private boolean equalsHashAlgorithmParameters(String[] params1, String[] params2) {
        if (params1 == params2) {
            return true;
        }
        if (params1.length != params2.length) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(params1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(params2));
        return set1.equals(set2);
    }

    protected boolean isIdentityStoreHandler(ProcessBean<?> processBean) {
        Set types;
        Bean bean = processBean.getBean();
        if (bean.getBeanClass() != IdentityStoreHandler.class && (types = bean.getTypes()).contains(IdentityStoreHandler.class)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a custom IdentityStoreHandler : " + bean.getBeanClass()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected boolean isIdentityStore(ProcessBean<?> processBean) {
        Set types;
        Bean bean = processBean.getBean();
        if (bean.getBeanClass() != IdentityStore.class && (types = bean.getTypes()).contains(IdentityStore.class)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a custom IdentityStore : " + bean.getBeanClass()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected Set<Bean> getBeansToAdd() {
        return this.beansToAdd;
    }

    protected boolean getIdentityStoreHandlerRegistered() {
        return this.identityStoreHandlerRegistered;
    }

    protected boolean getIdentityStoreRegistered() {
        return this.identityStoreRegistered;
    }

    protected boolean isApplicationAuthMech(Class<?> javaClass) {
        return HttpAuthenticationMechanism.class.isAssignableFrom(javaClass) && !BasicHttpAuthenticationMechanism.class.equals(javaClass) && !FormAuthenticationMechanism.class.equals(javaClass) && !CustomFormAuthenticationMechanism.class.equals(javaClass) && !HttpAuthenticationMechanism.class.equals(javaClass);
    }

    protected Map<String, ModuleProperties> getModuleMap() {
        if (this.moduleMap.isEmpty()) {
            this.initModuleMap();
        }
        return this.moduleMap;
    }

    protected void initModuleMap() {
        Map<String, URL> wml = this.getWebModuleMap();
        if (wml != null) {
            for (Map.Entry<String, URL> entry : wml.entrySet()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("moduleName : " + entry.getKey() + ", location : " + entry.getValue()), (Object[])new Object[0]);
                }
                this.moduleMap.put(entry.getKey(), new ModuleProperties(entry.getValue()));
            }
        }
    }

    protected Map<URL, ModuleMetaData> getModuleMetaDataMap() {
        return ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().getModuleMetaDataMap();
    }

    protected WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebConfigUtils.getWebAppSecurityConfig();
    }

    protected String getClassFileLocation(Class klass) {
        return klass.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    private DatabaseIdentityStoreDefinition getInstanceOfDBAnnotation(final Map<String, Object> overrides) {
        DatabaseIdentityStoreDefinition annotation = new DatabaseIdentityStoreDefinition(){
            static final long serialVersionUID = -2722289357385431127L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String callerQuery() {
                return overrides != null && overrides.containsKey("callerQuery") ? (String)overrides.get("callerQuery") : "";
            }

            public String dataSourceLookup() {
                return overrides != null && overrides.containsKey("dataSourceLookup") ? (String)overrides.get("dataSourceLookup") : "java:comp/DefaultDataSource";
            }

            public String groupsQuery() {
                return overrides != null && overrides.containsKey("groupsQuery") ? (String)overrides.get("groupsQuery") : "";
            }

            public Class<? extends PasswordHash> hashAlgorithm() {
                return overrides != null && overrides.containsKey("hashAlgorithm") ? (Class)overrides.get("hashAlgorithm") : Pbkdf2PasswordHash.class;
            }

            public String[] hashAlgorithmParameters() {
                return overrides != null && overrides.containsKey("hashAlgorithmParameters") ? (String[])overrides.get("hashAlgorithmParameters") : new String[]{};
            }

            public int priority() {
                return overrides != null && overrides.containsKey("priority") ? (Integer)overrides.get("priority") : 70;
            }

            public String priorityExpression() {
                return overrides != null && overrides.containsKey("priorityExpression") ? (String)overrides.get("priorityExpression") : "";
            }

            public IdentityStore.ValidationType[] useFor() {
                IdentityStore.ValidationType[] validationTypeArray;
                if (overrides != null && overrides.containsKey("useFor")) {
                    validationTypeArray = (IdentityStore.ValidationType[])overrides.get("useFor");
                } else {
                    IdentityStore.ValidationType[] validationTypeArray2 = new IdentityStore.ValidationType[2];
                    validationTypeArray2[0] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                    validationTypeArray = validationTypeArray2;
                    validationTypeArray2[1] = IdentityStore.ValidationType.VALIDATE;
                }
                return validationTypeArray;
            }

            public String useForExpression() {
                return overrides != null && overrides.containsKey("useForExpression") ? (String)overrides.get("useForExpression") : "";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(4.class);
            }
        };
        return annotation;
    }

    private boolean isEmptyModuleMap() {
        boolean result = this.moduleMap.isEmpty();
        if (!result) {
            for (Map.Entry<String, ModuleProperties> entry : this.moduleMap.entrySet()) {
                if (entry.getValue().getAuthMechMap().isEmpty()) {
                    result = true;
                    continue;
                }
                result = false;
                break;
            }
        }
        return result;
    }

    private Map<String, URL> getWebModuleMap() {
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        HashMap<String, URL> map = null;
        if (mmds != null) {
            map = new HashMap<String, URL>();
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData)) continue;
                String j2eeModuleName = mmd.getJ2EEName().getModule();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("j2ee module name  : " + j2eeModuleName), (Object[])new Object[0]);
                }
                map.put(j2eeModuleName, entry.getKey());
            }
        }
        return map;
    }

    private void verifyConfiguration() throws DeploymentException {
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        if (mmds != null) {
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                LoginConfiguration lc;
                String j2eeModuleName;
                Map<Class<?>, Properties> authMechs;
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData) || (authMechs = this.getAuthMechs(j2eeModuleName = mmd.getJ2EEName().getModule())) == null || authMechs.isEmpty()) continue;
                if (authMechs.size() != 1) {
                    String appName = mmd.getJ2EEName().getApplication();
                    String authMechNames = this.getAuthMechNames(authMechs);
                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_MULTIPLE_HTTPAUTHMECHS", (Object[])new Object[]{j2eeModuleName, appName, authMechNames});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_MULTIPLE_HTTPAUTHMECHS", (Object[])new Object[]{j2eeModuleName, appName, authMechNames});
                    throw new DeploymentException(msg);
                }
                SecurityMetadata smd = (SecurityMetadata)((WebModuleMetaData)mmd).getSecurityMetaData();
                if (smd == null || (lc = smd.getLoginConfiguration()) == null || lc.isAuthenticationMethodDefaulted()) continue;
                String appName = mmd.getJ2EEName().getApplication();
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_CONFIG_EXISTS", (Object[])new Object[]{j2eeModuleName, appName});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_CONFIG_EXISTS", (Object[])new Object[]{j2eeModuleName, appName});
                throw new DeploymentException(msg);
            }
        }
    }

    private String getAuthMechNames(Map<Class<?>, Properties> authMechs) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Class<?> authMech : authMechs.keySet()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(authMech.getName());
        }
        return result.toString();
    }

    private String getApplicationName() {
        String result = null;
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        if (mmds != null && !mmds.isEmpty()) {
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                J2EEName j2eeName;
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData) || (j2eeName = mmd.getJ2EEName()) == null) continue;
                result = j2eeName.getApplication();
                break;
            }
        }
        return result;
    }

    private String getModuleFromClass(Class<?> klass, Map<String, ModuleProperties> moduleMap) {
        String file = this.getClassFileLocation(klass);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("File name : " + file), (Object[])new Object[0]);
        }
        String moduleName = null;
        for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
            URL location = entry.getValue().getLocation();
            String filePath = location.getFile();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("location : " + filePath), (Object[])new Object[0]);
            }
            if (!location.getProtocol().equals("file") || !file.startsWith(filePath)) continue;
            moduleName = entry.getKey();
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("module name from the list  : " + moduleName), (Object[])new Object[0]);
            break;
        }
        if (moduleName == null) {
            moduleName = file;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("no match. use filename as module name : " + moduleName), (Object[])new Object[0]);
            }
        }
        return moduleName;
    }

    private Properties getGlobalLoginBasicProps() throws Exception {
        String realm = this.getWebAppSecurityConfig().getBasicAuthRealmName();
        Properties props = new Properties();
        if (realm == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"basicAuthenticationMechanismRealmName is not set. the default value defaultRealm is used.", (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The container provided BasicAuthenticationMechanism will be used with the realm name  : " + realm), (Object[])new Object[0]);
            }
            props.put("realmName", realm);
        }
        return props;
    }

    private Properties getGlobalLoginFormProps() throws Exception {
        String contextRoot;
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String loginURL = webAppSecConfig.getLoginFormURL();
        String errorURL = webAppSecConfig.getLoginErrorURL();
        if (loginURL == null || loginURL.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_NO_URL", (Object[])new Object[]{"loginFormURL"});
        }
        if (errorURL == null || errorURL.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_NO_URL", (Object[])new Object[]{"loginErrorURL"});
        }
        if ((contextRoot = webAppSecConfig.getLoginFormContextRoot()) == null) {
            contextRoot = this.getFirstPathElement(loginURL);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loginFormContextRoot is not set, use the first element of loginURL  : " + contextRoot), (Object[])new Object[0]);
            }
        } else {
            if (!this.validateContextRoot(contextRoot, loginURL)) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_INVALID_CONTEXT_ROOT", (Object[])new Object[]{contextRoot, loginURL, "loginFormURL"});
            }
            if (!this.validateContextRoot(contextRoot, errorURL)) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_INVALID_CONTEXT_ROOT", (Object[])new Object[]{contextRoot, errorURL, "loginErrorURL"});
            }
        }
        loginURL = this.FixUpUrl(loginURL, contextRoot);
        errorURL = this.FixUpUrl(errorURL, contextRoot);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The container provided FormAuthenticationMechanism will be used with the following attributes. login page  : " + loginURL + ", error page : " + errorURL + ", context root : " + contextRoot), (Object[])new Object[0]);
        }
        Properties props = new Properties();
        if (loginURL != null) {
            props.put("loginPage", loginURL);
        }
        if (errorURL != null) {
            props.put("errorPage", errorURL);
        }
        props.put("useForwardToLogin", (Object)true);
        props.put("useGlobalLogin", (Object)true);
        if (contextRoot != null) {
            props.put("formLoginContextRoot", contextRoot);
        }
        return props;
    }

    private boolean isAuthMechOverridden() {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String value = webAppSecConfig.getOverrideHttpAuthMethod();
        if (value != null) {
            if (value.equals("FORM") || value.equals("BASIC")) {
                return true;
            }
            if (value.equals("CLIENT_CERT") && (webAppSecConfig.getAllowFailOverToFormLogin() || webAppSecConfig.getAllowFailOverToBasicAuth())) {
                return true;
            }
        }
        return false;
    }

    private boolean isAuthMechOverriddenByForm() {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String value = webAppSecConfig.getOverrideHttpAuthMethod();
        if (value != null) {
            if (value.equals("FORM")) {
                return true;
            }
            if (value.equals("CLIENT_CERT") && webAppSecConfig.getAllowFailOverToFormLogin()) {
                return true;
            }
        }
        return false;
    }

    private String getFirstPathElement(String input) {
        String[] output = input.split("/");
        if (output[0].isEmpty()) {
            return "/" + output[1];
        }
        return "/" + output[0];
    }

    private boolean validateContextRoot(String contextRoot, String url) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url.startsWith(contextRoot) && url.charAt(contextRoot.length()) == '/';
    }

    private String FixUpUrl(String input, String contextRoot) {
        String output = input;
        if (input != null) {
            if (!input.startsWith("/")) {
                input = "/" + input;
            }
            if (input.startsWith(contextRoot) && input.charAt(contextRoot.length()) == '/') {
                output = input.substring(contextRoot.length());
            }
        }
        return output;
    }

    private boolean existAuthMech(Class authMechToExist) {
        Map authMechs = null;
        Map<String, ModuleProperties> moduleMap = this.getModuleMap();
        for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
            authMechs = entry.getValue().getAuthMechMap();
            for (Class authMech : authMechs.keySet()) {
                if (!authMech.equals(authMechToExist)) continue;
                return true;
            }
        }
        return false;
    }
}

