/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedWebModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.server.JaxRsRouterWebApp;
import com.ibm.ws.jaxrs20.server.internal.FileUtils;
import com.ibm.ws.jaxrs20.support.JaxRsMetaDataManager;
import com.ibm.ws.jaxrs20.support.JaxRsWebContainerManager;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.server.jaxRsWebContainerManager", service={JaxRsWebContainerManager.class}, property={"service.vendor=IBM"})
public class JaxRsWebContainerManagerImpl
implements JaxRsWebContainerManager {
    private static final TraceComponent tc = Tr.register(JaxRsWebContainerManagerImpl.class);
    private final AtomicServiceReference<ModuleHandler> webModuleHandlerRef = new AtomicServiceReference("webModuleHandler");
    private final AtomicServiceReference<ArtifactContainerFactory> artifactContainerFactoryRef = new AtomicServiceReference("artifactContainerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactoryRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("wsLocationAdmin");
    private final Map<J2EEName, File> moduleCacheBaseDirectoryMap = new ConcurrentHashMap<J2EEName, File>();
    private final AtomicServiceReference<FeatureProvisioner> _featureProvisioner = new AtomicServiceReference("featureProvisioner");
    private File cacheBaseDirectory;
    static final long serialVersionUID = -6047842791212726624L;

    protected void activate(ComponentContext cc) {
        this._featureProvisioner.activate(cc);
        this.webModuleHandlerRef.activate(cc);
        this.artifactContainerFactoryRef.activate(cc);
        this.adaptableModuleFactoryRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.cacheBaseDirectory = ((WsLocationAdmin)this.locationAdminRef.getServiceWithException()).getBundleFile((Object)this, "rs20routermodules");
        if (!FileUtils.ensureDirExists(this.cacheBaseDirectory) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{this.cacheBaseDirectory.getAbsolutePath()});
        }
    }

    protected void deactivate(ComponentContext cc) {
        for (File moduleCacheBaseDirectory : this.moduleCacheBaseDirectoryMap.values()) {
            FileUtils.recursiveDelete(moduleCacheBaseDirectory);
        }
        this.moduleCacheBaseDirectoryMap.clear();
        this.webModuleHandlerRef.deactivate(cc);
        this.artifactContainerFactoryRef.deactivate(cc);
        this.adaptableModuleFactoryRef.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
        this._featureProvisioner.deactivate(cc);
    }

    @Reference(name="featureProvisioner", service=FeatureProvisioner.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.setReference(ref);
    }

    protected void unsetFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this._featureProvisioner.unsetReference(ref);
    }

    @Reference(name="webModuleHandler", service=ModuleHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(type=web)")
    protected void setWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(ref);
    }

    protected void unsetWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(null);
    }

    @Reference(name="artifactContainerFactory", service=ArtifactContainerFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.setReference(ref);
    }

    protected void unsetArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.unsetReference(ref);
    }

    @Reference(name="adaptableModuleFactory", service=AdaptableModuleFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.unsetReference(ref);
    }

    @Reference(name="wsLocationAdmin", service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedWebModuleInfo createWebModuleInfo(ExtendedModuleInfo moduleInfo) throws UnableToAdaptException {
        try {
            ArtifactContainer artifactContainer;
            File dummyWebApplicationDirectory;
            File cacheOverlayDirectory;
            File cacheAdaptDirectory;
            File cacheDirectory;
            File moduleCacheBaseDirectory;
            if (this._featureProvisioner.getService() == null) {
                throw new RuntimeException("service " + FeatureProvisioner.class.getName() + " is not available");
            }
            boolean isJAXWSEnabled = false;
            Set features = ((FeatureProvisioner)this._featureProvisioner.getService()).getInstalledFeatures();
            for (String feature : features) {
                if (!feature.equals("jaxws-2.2")) continue;
                isJAXWSEnabled = true;
                break;
            }
            if (!FileUtils.ensureDirExists(moduleCacheBaseDirectory = new File(this.cacheBaseDirectory, UUID.randomUUID().toString())) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{moduleCacheBaseDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheDirectory = new File(moduleCacheBaseDirectory, "cache")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheAdaptDirectory = new File(moduleCacheBaseDirectory, "cacheAdapt")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheAdaptDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheOverlayDirectory = new File(moduleCacheBaseDirectory, "cacheOverlay")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheOverlayDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(dummyWebApplicationDirectory = new File(moduleCacheBaseDirectory, "router.war")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{dummyWebApplicationDirectory.getAbsolutePath()});
            }
            if ((artifactContainer = ((ArtifactContainerFactory)this.artifactContainerFactoryRef.getServiceWithException()).getContainer(cacheDirectory, (Object)dummyWebApplicationDirectory)) == null) {
                throw new IllegalStateException("");
            }
            Container moduleContainer = ((AdaptableModuleFactory)this.adaptableModuleFactoryRef.getServiceWithException()).getContainer(cacheAdaptDirectory, cacheOverlayDirectory, artifactContainer);
            JaxRsModuleMetaData jaxRsModuleMetaData = JaxRsMetaDataManager.getJaxRsModuleMetaData((ModuleMetaData)moduleInfo.getMetaData());
            if (jaxRsModuleMetaData == null) {
                return null;
            }
            Container appContainer = moduleInfo.getApplicationInfo().getContainer();
            NonPersistentCache appCache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo appCCI = (ApplicationClassesContainerInfo)appCache.getFromCache(ApplicationClassesContainerInfo.class);
            DeployedAppInfo deployedAppInfo = (DeployedAppInfo)appCCI;
            deployedAppInfo.getDeployedModule(moduleInfo);
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            overlayCache.addToCache(JaxRsModuleMetaData.class, (Object)jaxRsModuleMetaData);
            overlayCache.addToCache(WebApp.class, (Object)new JaxRsRouterWebApp(jaxRsModuleMetaData.getJ2EEName().toString() + "-Router-WebModule"));
            JaxRsModuleInfo jaxrsModuleInfo = (JaxRsModuleInfo)moduleInfo.getContainer().adapt(JaxRsModuleInfo.class);
            overlayCache.addToCache(JaxRsModuleInfo.class, (Object)jaxrsModuleInfo);
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String ejbModuleName = moduleInfo.getName();
            String webModuleName = ejbModuleName + "-RSRouter";
            String defaultContextRoot = jaxrsModuleInfo.isShareEJBJarWithJAXWS() && isJAXWSEnabled ? "/" + ejbModuleName + ".jaxrs" : "/" + ejbModuleName;
            final ClassLoader moduleClassLoader = moduleInfo.getClassLoader();
            ModuleClassLoaderFactory classPathFactory = new ModuleClassLoaderFactory(){
                static final long serialVersionUID = 2518301082168096581L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                    return moduleClassLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            WebModuleInfoImpl webModuleInfo = new WebModuleInfoImpl(appInfo, webModuleName, webModuleName, defaultContextRoot, moduleContainer, null, null, classPathFactory);
            ModuleMetaData webModuleMetaData = ((ModuleHandler)this.webModuleHandlerRef.getServiceWithException()).createModuleMetaData((ExtendedModuleInfo)webModuleInfo, deployedAppInfo);
            JaxRsMetaDataManager.setJaxRsModuleMetaData((ModuleMetaData)webModuleMetaData, (JaxRsModuleMetaData)jaxRsModuleMetaData);
            webModuleInfo.setMetaData(webModuleMetaData);
            this.moduleCacheBaseDirectoryMap.put(webModuleMetaData.getJ2EEName(), moduleCacheBaseDirectory);
            return webModuleInfo;
        }
        catch (MetaDataException isJAXWSEnabled) {
            void e;
            FFDCFilter.processException((Throwable)isJAXWSEnabled, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebContainerManagerImpl", (String)"265", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new IllegalStateException((Throwable)e);
        }
    }
}

