/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AORequestedTick;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.GatheringConsumerKey;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class JSRemoteConsumerPoint
extends ReentrantLock
implements AlarmListener,
DispatchableConsumerPoint {
    private static final long serialVersionUID = -4278192555858958128L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(JSRemoteConsumerPoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MPAlarmManager am;
    private AOStream parent;
    private JSConsumerManager dispatcher;
    private ConsumableKey[] cks;
    private ConsumableKey ck;
    private String selectionCriteriasAsString;
    private SelectionCriteria[] selectionCriterias;
    private boolean isready;
    private boolean temporarilyStopped;
    private boolean closed;
    private long idleTimeout;
    private Alarm idleHandler;
    private LinkedList listOfRequests;
    private HashMap<Long, AORequestedTick> tableOfRequests;
    private boolean _consumerSuspended = false;
    private int _suspendFlags = 0;
    private boolean gatherMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AOStream parent, String selectionCriteriasAsString, ConsumableKey[] consumerKeys, long idleTimeout, MPAlarmManager am, SelectionCriteria[] selectionCriterias) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{parent, selectionCriteriasAsString, consumerKeys, idleTimeout, am, selectionCriterias});
        }
        this.lock();
        try {
            this.parent = parent;
            this.selectionCriteriasAsString = selectionCriteriasAsString;
            this.cks = consumerKeys;
            this.ck = consumerKeys[0];
            this.selectionCriterias = selectionCriterias;
            this.isready = false;
            this.dispatcher = this.cks[0].getConsumerManager();
            this.temporarilyStopped = !this.dispatcher.getDestination().isReceiveAllowed();
            this.closed = false;
            this.listOfRequests = new LinkedList();
            this.tableOfRequests = new HashMap();
            this.idleTimeout = idleTimeout;
            this.am = am;
            if (this.ck instanceof GatheringConsumerKey) {
                this.gatherMessages = true;
            }
            if (idleTimeout > 0L) {
                this.idleHandler = am.create(idleTimeout, this);
            }
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public final void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        ArrayList<AORequestedTick> expiredTicks = new ArrayList<AORequestedTick>(this.tableOfRequests.size());
        this.closeInternal(expiredTicks);
        int length = expiredTicks.size();
        for (int i = 0; i < length; ++i) {
            AORequestedTick rt = expiredTicks.get(i);
            this.parent.expiredRequest(rt.tick);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeInternal(ArrayList<AORequestedTick> expiredTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeInternal");
        }
        ConsumableKey[] tempCks = null;
        this.lock();
        try {
            this.closed = true;
            if (this.cks != null) {
                tempCks = this.cks;
                this.cks = null;
            }
            if (this.idleHandler != null) {
                this.idleHandler.cancel();
                this.idleHandler = null;
            }
            AORequestedTick rt = (AORequestedTick)this.listOfRequests.getFirst();
            while (rt != null) {
                this.listOfRequests.remove(rt);
                boolean expired = rt.expire(true);
                if (!expired) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:293:1.43.2.26"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.closeInternal", (String)"1:299:1.43.2.26", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:306:1.43.2.26"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"closeInternal", (Object)((Object)e));
                    }
                    throw e;
                }
                expiredTicks.add(rt);
                rt = (AORequestedTick)this.listOfRequests.getFirst();
            }
            this.tableOfRequests.clear();
        }
        finally {
            this.unlock();
        }
        try {
            if (tempCks != null) {
                for (int i = 0; i < tempCks.length; ++i) {
                    tempCks[i].detach();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expiryAlarm(AORequestedTick requestedTick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiryAlarm", (Object)requestedTick);
        }
        boolean transitionOccured = false;
        ArrayList<AORequestedTick> satisfiedTicks = null;
        try {
            this.lock();
            try {
                if (this.closed) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"expiryAlarm");
                    }
                    return;
                }
                transitionOccured = this.cancelRequestInternal(requestedTick, true);
                if (transitionOccured && !this.listOfRequests.isEmpty()) {
                    satisfiedTicks = this.processQueuedMsgs(null);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            this.notifyException(e);
        }
        if (transitionOccured) {
            this.parent.expiredRequest(requestedTick.tick);
        }
        if (satisfiedTicks != null) {
            int length = satisfiedTicks.size();
            for (int i = 0; i < length; ++i) {
                AORequestedTick aotick = (AORequestedTick)satisfiedTicks.get(i);
                long tick = aotick.tick;
                SIMPMessage m = aotick.getMessage();
                this.parent.satisfiedRequest(tick, m);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiryAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AORequestedTick newRequest(long tick, long expiryTimeout) throws ClosedException, MessageStoreException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newRequest", (Object)new Object[]{tick, expiryTimeout});
        }
        SIMPMessage msg = null;
        AORequestedTick aotick = null;
        try {
            this.lock();
            try {
                if (this.closed) {
                    ClosedException e = new ClosedException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)e);
                    }
                    throw e;
                }
                if (this.idleHandler != null) {
                    this.idleHandler.cancel();
                    this.idleHandler = null;
                }
                if (!this.temporarilyStopped && !this.isready) {
                    this.ck.ready(Reliability.NONE);
                    this.isready = true;
                    msg = this.cks[0].getMessageLocked();
                    if (msg != null) {
                        this.ck.notReady();
                        this.isready = false;
                    }
                    if (msg == null || this.gatherMessages) {
                        long timeout = this.cks[0].waiting(this.convertTimeoutSIMPtoLCP(expiryTimeout), false);
                        if (msg == null && timeout != -1L && timeout != 0L) {
                            expiryTimeout = this.convertTimeoutLCPtoSIMP(timeout);
                        }
                    }
                }
                aotick = new AORequestedTick(this, tick, tick, expiryTimeout, this.am);
                if (msg != null) {
                    boolean satisfied = aotick.satisfy(msg);
                    if (!satisfied) {
                        msg.unlockMsg(msg.getLockID(), null, false);
                        msg = null;
                        if (this.idleTimeout > 0L) {
                            this.idleHandler = this.am.create(this.idleTimeout, this);
                        }
                    }
                } else {
                    this.listOfRequests.put(aotick);
                    this.tableOfRequests.put(tick, aotick);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (MessageStoreException e) {
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
            this.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)((Object)e));
            }
            throw e;
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)((Object)e));
            }
            throw e;
        }
        if (expiryTimeout == 0L && msg == null) {
            this.expiryAlarm(aotick);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)msg);
        }
        return aotick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelRequest(long tick) {
        Long objTick = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelRequest", (Object)objTick);
        }
        ArrayList<AORequestedTick> satisfiedTicks = null;
        try {
            this.lock();
            try {
                boolean transitionOccured;
                if (this.closed) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"cancelRequest");
                    }
                    return;
                }
                AORequestedTick requestedTick = this.tableOfRequests.get(objTick);
                if (requestedTick != null && (transitionOccured = this.cancelRequestInternal(requestedTick, false)) && !this.listOfRequests.isEmpty()) {
                    satisfiedTicks = this.processQueuedMsgs(null);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            this.notifyException(e);
        }
        if (satisfiedTicks != null) {
            int length = satisfiedTicks.size();
            for (int i = 0; i < length; ++i) {
                AORequestedTick aotick = (AORequestedTick)satisfiedTicks.get(i);
                this.parent.satisfiedRequest(aotick.tick, aotick.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelRequest");
        }
    }

    private boolean cancelRequestInternal(AORequestedTick requestedTick, boolean expiry) {
        boolean transitionOccured;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelRequestInternal", (Object)new Object[]{requestedTick, expiry});
        }
        if (transitionOccured = requestedTick.expire(!expiry)) {
            this.listOfRequests.remove(requestedTick);
            this.tableOfRequests.remove(requestedTick.objTick);
            if (this.listOfRequests.isEmpty()) {
                if (this.idleTimeout > 0L) {
                    this.idleHandler = this.am.create(this.idleTimeout, this);
                }
                if (this.isready) {
                    this.isready = false;
                    this.ck.notReady();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelRequestInternal", (Object)transitionOccured);
        }
        return transitionOccured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean put(SIMPMessage msg, boolean isOnItemStream) {
        ArrayList<AORequestedTick> satisfiedTicks;
        boolean returnValue;
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{msg, isOnItemStream});
            }
            returnValue = false;
            satisfiedTicks = new ArrayList<AORequestedTick>(5);
            AOStream aOStream = this.parent;
            // MONITORENTER : aOStream
            try {
                this.lock();
                try {
                    if (this.closed) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"put", (Object)Boolean.FALSE);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (!isOnItemStream) {
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:713:1.43.2.26"}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.put", (String)"1:718:1.43.2.26", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:724:1.43.2.26"});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"put", (Object)false);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.isready) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"put", (Object)false);
                        }
                        boolean e = false;
                        return e;
                    }
                    this.isready = false;
                    AORequestedTick rt = (AORequestedTick)this.listOfRequests.getFirst();
                    if (rt == null) break block24;
                    boolean locked = false;
                    try {
                        locked = msg.lockItemIfAvailable(this.cks[0].getGetCursor(msg).getLockID());
                    }
                    catch (MessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.put", (String)"1:761:1.43.2.26", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    if (!locked) {
                        msg = null;
                    }
                    if (msg != null) {
                        AORequestedTick satTick = this.satisfyRequest(rt, msg);
                        if (satTick != null) {
                            satisfiedTicks.add(satTick);
                        }
                        rt = null;
                        msg = null;
                        returnValue = true;
                    }
                    satisfiedTicks.addAll(this.processQueuedMsgs(rt));
                }
                finally {
                    this.unlock();
                }
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                this.notifyException(e);
            }
        }
        int length = satisfiedTicks.size();
        int i = 0;
        while (true) {
            if (i >= length) {
                // MONITOREXIT : aOStream
                if (!TraceComponent.isAnyTracingEnabled()) return returnValue;
                if (!tc.isEntryEnabled()) return returnValue;
                SibTr.exit((TraceComponent)tc, (String)"put", (Object)returnValue);
                return returnValue;
            }
            AORequestedTick aotick = (AORequestedTick)satisfiedTicks.get(i);
            this.parent.satisfiedRequest(aotick.tick, aotick.getMessage());
            ++i;
        }
    }

    private ArrayList<AORequestedTick> processQueuedMsgs(AORequestedTick rt) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processQueuedMsgs", (Object)rt);
        }
        ArrayList<AORequestedTick> satisfiedTicks = new ArrayList<AORequestedTick>();
        if (rt == null) {
            rt = (AORequestedTick)this.listOfRequests.getFirst();
        }
        try {
            if (rt != null) {
                this.ck.ready(Reliability.NONE);
                this.isready = true;
                while (rt != null) {
                    AORequestedTick satTick;
                    SIMPMessage msg = this.cks[0].getMessageLocked();
                    if (msg == null || this.gatherMessages) {
                        long timeout = rt.timeout;
                        if (timeout > 0L) {
                            timeout -= System.currentTimeMillis() - rt.requestTime;
                        }
                        if (timeout == -1L || timeout >= 0L) {
                            this.ck.waiting(this.convertTimeoutSIMPtoLCP(timeout), false);
                        }
                        if (msg == null) break;
                    }
                    if ((satTick = this.satisfyRequest(rt, msg)) != null) {
                        satisfiedTicks.add(satTick);
                    }
                    rt = (AORequestedTick)this.listOfRequests.getFirst();
                }
            }
            if (rt == null) {
                this.ck.notReady();
                this.isready = false;
                if (this.idleHandler == null && this.idleTimeout > 0L) {
                    this.idleHandler = this.am.create(this.idleTimeout, this);
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.processQueuedMsgs", (String)"1:886:1.43.2.26", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processQueuedMsgs", satisfiedTicks);
        }
        return satisfiedTicks;
    }

    private long convertTimeoutSIMPtoLCP(long simpTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertTimeoutSIMPtoLCP", (Object)simpTimeout);
        }
        long lcpTimeout = simpTimeout;
        if (simpTimeout == 0L) {
            lcpTimeout = -1L;
        } else if (simpTimeout == -1L) {
            lcpTimeout = 0L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertTimeoutSIMPtoLCP", (Object)lcpTimeout);
        }
        return lcpTimeout;
    }

    private long convertTimeoutLCPtoSIMP(long lcpTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertTimeoutLCPtoSIMP", (Object)lcpTimeout);
        }
        long simpTimeout = lcpTimeout;
        if (lcpTimeout == -1L) {
            simpTimeout = 0L;
        } else if (lcpTimeout == 0L) {
            simpTimeout = -1L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertTimeoutLCPtoSIMP", (Object)simpTimeout);
        }
        return simpTimeout;
    }

    @Override
    public void notifyException(Throwable e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyException", (Object)e);
        }
        this.close();
        this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.notifyException", (String)"1:961:1.43.2.26", (Object)this);
        SibTr.exception((TraceComponent)tc, (Throwable)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    @Override
    public void notifyReceiveAllowed(boolean isAllowed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{isAllowed});
        }
        ArrayList<AORequestedTick> satisfiedTicks = null;
        try {
            this.lock();
            try {
                if (!this.closed && isAllowed) {
                    this.temporarilyStopped = false;
                    satisfiedTicks = this.processQueuedMsgs(null);
                } else {
                    this.temporarilyStopped = true;
                    this.isready = false;
                    this.ck.notReady();
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (SINotPossibleInCurrentConfigurationException e) {
            this.notifyException(e);
        }
        if (satisfiedTicks != null) {
            int length = satisfiedTicks.size();
            for (int i = 0; i < length; ++i) {
                AORequestedTick aotick = satisfiedTicks.get(i);
                this.parent.satisfiedRequest(aotick.tick, aotick.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public SelectionCriteria[] getSelectionCriterias() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectionCriterias");
            SibTr.exit((TraceComponent)tc, (String)"getSelectionCriterias", (Object)this.selectionCriterias);
        }
        return this.selectionCriterias;
    }

    private AORequestedTick satisfyRequest(AORequestedTick aotick, SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"satisfyRequest", (Object)new Object[]{aotick, msg});
        }
        if (!aotick.satisfy(msg)) {
            aotick = null;
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:1061:1.43.2.26"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.satisfyRequest", (String)"1:1067:1.43.2.26", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:1073:1.43.2.26"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"satisfyRequest", (Object)((Object)e));
            }
            throw e;
        }
        this.listOfRequests.remove(aotick);
        this.tableOfRequests.remove(aotick.objTick);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"satisfyRequest");
        }
        return aotick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object thandle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
        }
        boolean doClose = false;
        AOStream aOStream = this.parent;
        synchronized (aOStream) {
            this.lock();
            try {
                if (this.idleHandler != null) {
                    if (!this.listOfRequests.isEmpty()) {
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:1121:1.43.2.26"}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint.alarm", (String)"1:1126:1.43.2.26", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint", "1:1132:1.43.2.26"});
                    } else {
                        this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
                        doClose = true;
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
        if (doClose) {
            this.close();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    @Override
    public boolean destinationMatches(DestinationHandler destinationHandlerToCompare, JSConsumerManager consumerDispatcher) {
        boolean matches;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationMatches", (Object)new Object[]{destinationHandlerToCompare, consumerDispatcher});
        }
        boolean bl = matches = consumerDispatcher.getDestination() == destinationHandlerToCompare;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationMatches", (Object)matches);
        }
        return matches;
    }

    @Override
    public DestinationHandler getNamedDestination(ConsumerDispatcher cd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination", (Object)cd);
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)cd.getDestination());
        }
        return cd.getDestination();
    }

    @Override
    public void checkForMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeConsumer(int suspendFlag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resumeConsumer", (Object)this);
        }
        ArrayList<AORequestedTick> satisfiedTicks = null;
        AOStream aOStream = this.parent;
        synchronized (aOStream) {
            try {
                this.lock();
                try {
                    if (this._consumerSuspended) {
                        this._suspendFlags &= ~suspendFlag;
                        if (this._suspendFlags == 0) {
                            this._consumerSuspended = false;
                            if (!this.closed) {
                                satisfiedTicks = this.processQueuedMsgs(null);
                            }
                        }
                    }
                }
                finally {
                    this.unlock();
                }
            }
            catch (SINotPossibleInCurrentConfigurationException e) {
                this.notifyException(e);
            }
            if (satisfiedTicks != null) {
                int length = satisfiedTicks.size();
                for (int i = 0; i < length; ++i) {
                    AORequestedTick aotick = (AORequestedTick)satisfiedTicks.get(i);
                    this.parent.satisfiedRequest(aotick.tick, aotick.getMessage());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resumeConsumer");
        }
    }

    @Override
    public boolean suspendConsumer(int suspendFlag) {
        boolean didSuspendConsumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"suspendConsumer", (Object)suspendFlag);
        }
        this.lock();
        try {
            if (!this.isConsumerSuspended(suspendFlag)) {
                this._consumerSuspended = true;
                this._suspendFlags |= suspendFlag;
                this.isready = false;
                this.ck.notReady();
                didSuspendConsumer = true;
            } else {
                didSuspendConsumer = false;
            }
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"suspendConsumer", (Object)didSuspendConsumer);
        }
        return didSuspendConsumer;
    }

    @Override
    public ConsumerManager getConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerManager");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerManager", (Object)this.dispatcher);
        }
        return this.dispatcher;
    }

    @Override
    public void closeSession(Throwable e) throws SIConnectionLostException, SIResourceException, SIErrorException {
    }

    @Override
    public boolean ignoreInitialIndoubts() {
        return true;
    }

    @Override
    public void implicitClose(SIBUuid12 deletedUuid, SIException exception, SIBUuid8 qpoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"implicitClose", (Object)new Object[]{deletedUuid, exception});
        }
        boolean closed = false;
        closed = deletedUuid != null ? this.ck.close(1, qpoint) : (exception != null ? this.ck.close(2, qpoint) : this.ck.close(3, qpoint));
        if (closed) {
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"implicitClose");
        }
    }

    @Override
    public boolean isConsumerSuspended(int suspendFlag) {
        boolean suspended;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isConsumerSuspended", (Object)suspendFlag);
        }
        this.lock();
        try {
            suspended = suspendFlag == 0 ? this._consumerSuspended : (this._suspendFlags == 0 ? false : (this._suspendFlags & suspendFlag) == suspendFlag);
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isConsumerSuspended", (Object)suspended);
        }
        return suspended;
    }

    @Override
    public ConsumableKey getConsumerKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerKey");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerKey", (Object)this.ck);
        }
        return this.ck;
    }

    @Override
    public boolean isGatheringConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGatheringConsumer");
            SibTr.exit((TraceComponent)tc, (String)"isGatheringConsumer", (Object)this.gatherMessages);
        }
        return this.gatherMessages;
    }
}

