/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.encryption.AuditCrypto;
import com.ibm.ws.security.audit.encryption.AuditKeyEncryptor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.audit.AuditDecryptionException;
import com.ibm.wsspi.security.audit.AuditEncryptingException;
import com.ibm.wsspi.security.audit.AuditSigning;
import com.ibm.wsspi.security.audit.AuditSigningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuditSigningImpl
implements AuditSigning {
    private static final TraceComponent tc = Tr.register(AuditSigningImpl.class, null, (String)"com.ibm.ejs.resources.security");
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    AuditCrypto crypto = null;
    String serverName = null;
    int aliasIncrement = 1;
    private static AuditSigningImpl as = null;
    private static String subjectDN = "CN=auditsigner, OU=SWG, O=IBM, C=US";
    private static String keyStoreName = "auditSignerKeyStore_";
    private static String certLabelPrefix = "auditcert";
    private static String CRYPTO_ALGORITHM = "SHA256withRSA";
    private Signature signature = null;
    private final byte[] sigBytes = null;
    private final int signerKeyStoreIncrement = 1;
    private final ObjectName mgmScopeObjName = null;
    AuditKeyEncryptor encryptor = null;
    private String signerName = null;
    private final String signerType;
    private final String signerProvider;
    private String signerKeyFileLocation = null;
    private final String signerPassword;
    private String signerAlias = null;
    static final long serialVersionUID = -5289899763318808665L;

    /*
     * WARNING - void declaration
     */
    public AuditSigningImpl(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditSigningException {
        this.signerType = null;
        this.signerProvider = null;
        this.signerPassword = null;
        try {
            this.initialize(keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"72", (Object)this, (Object[])new Object[]{keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias});
            Tr.error((TraceComponent)tc, (String)"security.audit.signing.init.error", (Object[])new Object[]{e});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditSigningException {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin != null) {
            this.serverName = locationAdmin.getServerName();
        }
        this.signerAlias = keyAlias;
        this.signerName = keyStoreName;
        this.signerKeyFileLocation = keyStorePath;
        this.crypto = new AuditCrypto();
        Object JCEProvider = null;
        try {
            this.signature = Signature.getInstance(CRYPTO_ALGORITHM);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"101", (Object)this, (Object[])new Object[]{keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias});
            Tr.error((TraceComponent)tc, (String)"security.audit.signing.init.error", (Object[])new Object[]{e});
            throw new AuditSigningException(e.getMessage());
        }
        long begin_time = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing audit signer at " + new Date(System.currentTimeMillis())), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Key generateSharedKey() throws java.security.KeyException {
        SecretKeySpec sharedKey = null;
        try {
            if (this.crypto != null) {
                AuditSigningImpl auditSigningImpl = this;
                sharedKey = new SecretKeySpec(auditSigningImpl.crypto.generate3DESKey(), 0, 24, "3DES");
            }
            if (sharedKey != null) {
                return sharedKey;
            }
            throw new KeyException("Key could not be generated.");
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"133", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditEncryptionImpl.generateKey", (String)"98", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error generating key.", (Object[])new Object[]{e});
            }
            if (e instanceof java.security.KeyException) {
                throw (java.security.KeyException)e;
            }
            throw new java.security.KeyException(e.getMessage(), (Throwable)e);
        }
    }

    public String generateAliasForSharedKey() {
        String alias = null;
        if (this.serverName != null) {
            alias = this.serverName + "Alias" + new Integer(this.aliasIncrement).toString();
        }
        ++this.aliasIncrement;
        return alias;
    }

    public byte[] encryptSharedKey(Key sharedKey, Key publicKey) throws IOException {
        byte[] encryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR!!! shared key is null!", (Object[])new Object[0]);
            }
            return null;
        }
        byte[] encodedPublicKey = publicKey.getEncoded();
        this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        byte[] encodedSharedKey = sharedKey.getEncoded();
        encryptedSharedKey = this.encryptor.encrypt(encodedSharedKey);
        return encryptedSharedKey;
    }

    public byte[] decryptSharedKey(byte[] sharedKey, Key pKey) throws IOException {
        byte[] encodedPublicKey;
        byte[] decryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR!!! shared key is null!", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.encryptor == null) {
            encodedPublicKey = pKey.getEncoded();
            this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        }
        encodedPublicKey = pKey.getEncoded();
        decryptedSharedKey = this.encryptor.decrypt(sharedKey);
        return decryptedSharedKey;
    }

    /*
     * WARNING - void declaration
     */
    public X509Certificate retrieveSignerCertificate() throws Exception {
        Object publicKey = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("signerAlias: " + this.signerAlias + " signerType: " + this.signerType + " signerProvider: " + this.signerProvider + " signerKeyFileLocation: " + this.signerKeyFileLocation), (Object[])new Object[0]);
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("JKS");
            InputStream is = AuditSigningImpl.openKeyStore(this.signerKeyFileLocation);
            X509Certificate cert = (X509Certificate)ks.getCertificate(this.signerAlias);
            return cert;
        }
        catch (MalformedURLException is) {
            void me;
            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"242", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: malformed URL", (Object[])new Object[]{me.getMessage()});
            }
            throw new Exception(me.getMessage());
        }
        catch (KeyStoreException me) {
            void ke;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"246", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            throw new Exception(ke.getMessage());
        }
        catch (IOException ke) {
            void ioe;
            FFDCFilter.processException((Throwable)ke, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"250", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            throw new Exception(ioe.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Key retrievePrivateSignerKey() throws Exception {
        KeyStore ks = null;
        Key k = null;
        try {
            ks = KeyStore.getInstance(this.signerType, this.signerProvider);
            InputStream is = AuditSigningImpl.openKeyStore(this.signerKeyFileLocation);
            ks.load(is, this.signerPassword.toCharArray());
            k = ks.getKey(this.signerAlias, this.signerPassword.toCharArray());
        }
        catch (NoSuchProviderException is) {
            void ne;
            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"274", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: no such provider.", (Object[])new Object[]{ne.getMessage()});
            }
            throw new Exception(ne.getMessage());
        }
        catch (MalformedURLException ne) {
            void me;
            FFDCFilter.processException((Throwable)ne, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"278", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: malformed URL", (Object[])new Object[]{me.getMessage()});
            }
            throw new Exception(me.getMessage());
        }
        catch (KeyStoreException me) {
            void ke;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"282", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            throw new Exception(ke.getMessage());
        }
        catch (UnrecoverableKeyException ke) {
            void uke;
            FFDCFilter.processException((Throwable)ke, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"286", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{uke.getMessage()});
            }
            throw new Exception(uke.getMessage());
        }
        catch (NoSuchAlgorithmException uke) {
            void ae;
            FFDCFilter.processException((Throwable)uke, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"290", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: no such algorithm", (Object[])new Object[]{ae.getMessage()});
            }
            throw new Exception(ae.getMessage());
        }
        catch (CertificateException ae) {
            void ce;
            FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"294", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting certificate.", (Object[])new Object[]{ce.getMessage()});
            }
            throw new Exception(ce.getMessage());
        }
        catch (IOException ce) {
            void ioe;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"298", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            throw new Exception(ioe.getMessage());
        }
        return k;
    }

    /*
     * WARNING - void declaration
     */
    public Key retrievePublicSignerKey() throws Exception {
        PublicKey publicKey = null;
        try {
            X509Certificate cert = this.retrieveSignerCertificate();
            publicKey = cert.getPublicKey();
            return publicKey;
        }
        catch (MalformedURLException cert) {
            void me;
            FFDCFilter.processException((Throwable)cert, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"322", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{me.getMessage()});
            }
            throw new Exception(me.getMessage());
        }
        catch (IOException me) {
            void ioe;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"326", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            throw new Exception(ioe.getMessage());
        }
        catch (Exception ioe) {
            void e;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"330", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{e.getMessage()});
            }
            throw new Exception(e.getMessage());
        }
    }

    public byte[] encrypt(byte[] data, Key sharedKey) throws AuditEncryptingException {
        if (data == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.encryption.data.error", (Object[])new Object[0]);
            throw new AuditEncryptingException("Invalid data passed into the encryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.invalid.shared.key.error", (Object[])new Object[0]);
            throw new AuditEncryptingException("Invalid shared key has been encountered.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] encryptedData = AuditCrypto.encrypt(data, sharedKey.getEncoded());
        return encryptedData;
    }

    public byte[] decrypt(byte[] data, Key sharedKey) throws AuditDecryptionException {
        if (data == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.decryption.data.error", (Object[])new Object[0]);
            throw new AuditDecryptionException("Invalid data passed into the decryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.invalid.shared.key.error", (Object[])new Object[0]);
            throw new AuditDecryptionException("An invalid shared key was detected.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] decryptedData = AuditCrypto.decrypt(data, sharedKey.getEncoded());
        return decryptedData;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] unsign(byte[] data, Key key) throws AuditSigningException {
        byte[] unsignedData = null;
        if (data != null) {
            try {
                unsignedData = this.decrypt(data, key);
            }
            catch (AuditDecryptionException auditDecryptionException) {
                void ade;
                FFDCFilter.processException((Throwable)auditDecryptionException, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"407", (Object)this, (Object[])new Object[]{data, key});
                throw new AuditSigningException((Exception)ade);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.audit.message.digest.error", (Object[])new Object[0]);
            throw new AuditSigningException("MessageDigest is invalid");
        }
        return unsignedData;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public byte[] sign(byte[] data, Key key) throws AuditSigningException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sign", (Object[])new Object[0]);
        }
        byte[] messageDigest = null;
        byte[] signedData = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"438", (Object)this, (Object[])new Object[]{data, key});
            throw new AuditSigningException((Exception)e);
        }
        if (data == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.signing.data.error", (Object[])new Object[0]);
            throw new AuditSigningException("Invalid data passed into signing algorithm");
        }
        md.reset();
        md.update(data);
        messageDigest = md.digest();
        if (messageDigest != null) {
            try {
                signedData = this.encrypt(messageDigest, key);
            }
            catch (AuditEncryptingException e) {
                void aee;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"453", (Object)this, (Object[])new Object[]{data, key});
                throw new AuditSigningException((Exception)aee);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.audit.message.digest.error", (Object[])new Object[0]);
            throw new AuditSigningException("MessageDigest is invalid");
        }
        return signedData;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public boolean verify(byte[] data, Key key) throws AuditSigningException {
        if (this.signature != null) {
            try {
                this.signature.initVerify((PublicKey)key);
                this.signature.update(data);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"verify");
                }
                return this.signature.verify(this.sigBytes);
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"483", (Object)this, (Object[])new Object[]{data, key});
                throw new AuditSigningException((Exception)ex);
            }
        }
        String msg = "Signature is null.  Cannot verify data.";
        throw new AuditSigningException(msg);
    }

    public String getSignerKeyFileLocation() {
        return this.signerKeyFileLocation;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        try {
            OpenKeyStoreAction action = new OpenKeyStoreAction(fileName);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException action) {
            void e;
            FFDCFilter.processException((Throwable)action, (String)"com.ibm.ws.security.audit.encryption.AuditSigningImpl", (String)"646", null, (Object[])new Object[]{fileName});
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;
        static final long serialVersionUID = 2180325333538092337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            return fis;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OpenKeyStoreAction.class);
        }
    }
}

