/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebRequest;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(AuthorizationEvent.class);
    static final long serialVersionUID = 5913573425167011435L;

    public AuthorizationEvent() {
        this.set("eventName", "SECURITY_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public AuthorizationEvent(WebRequest webreq, AuthenticationResult authResult, String uriName, Integer statusCode) {
        block12: {
            this();
            try {
                String agent;
                HttpServletRequest req = webreq.getHttpServletRequest();
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                this.set("target.credential.type", authResult.getAuditCredType());
                if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                this.set("target.method", AuditUtils.getRequestMethod(req));
                String sessionID = AuditUtils.getSessionID(req);
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (webreq.getRequiredRoles() != null) {
                    ArrayList<String> rolesList = new ArrayList<String>();
                    for (String role : webreq.getRequiredRoles()) {
                        rolesList.add(role);
                    }
                    if (!rolesList.isEmpty()) {
                        this.set("target.role.names", rolesList.toString());
                    }
                }
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.AuthorizationEvent", (String)"90", (Object)((Object)this), (Object[])new Object[]{webreq, authResult, uriName, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating AuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

