/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.filter.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.internal.FilterException;
import com.ibm.ws.security.authentication.filter.internal.IPAddressRange;
import com.ibm.ws.security.authentication.filter.internal.IValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValueIPAddress
implements IValue {
    InetAddress myIP;
    static final long serialVersionUID = -4588152461857850358L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public ValueIPAddress(String ip) throws FilterException {
        try {
            this.myIP = InetAddress.getByName(ip);
        }
        catch (UnknownHostException unknownHostException) {
            void e;
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.security.authentication.filter.internal.ValueIPAddress", (String)"29", (Object)this, (Object[])new Object[]{ip});
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_IP_STRING_CONVERT_ERROR", (Object[])new Object[]{ip}, (String)"CWWKS1756E: Cannot convert the IP string {0} to an IP address.");
            throw new FilterException(msg, (Throwable)e);
        }
    }

    @Override
    public boolean equals(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return ((ValueIPAddress)ip).getIP().equals(this.getIP());
    }

    @Override
    public boolean greaterThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.greaterThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    @Override
    public boolean lessThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.lessThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    @Override
    public boolean containedBy(IValue ip) {
        return this.equals(ip);
    }

    public String toString() {
        return this.getIP().toString();
    }

    protected InetAddress getIP() {
        return this.myIP;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ValueIPAddress.class, (String)"filter", (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages");
    }
}

