/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.monitor.meters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.Date;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class GaugeReading {
    final long timestamp = System.currentTimeMillis();
    final long currentValue;
    final long minimumValue;
    final long maximumValue;
    final boolean bounded;
    final long lowerBound;
    final long upperBound;
    final String unit;
    static final long serialVersionUID = -2877734249083666529L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GaugeReading(long currentValue, long minimumValue, long maximumValue, boolean bounded, long lowerBound, long upperBound, String unit) {
        this.currentValue = currentValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.bounded = bounded;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.unit = unit;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public long getMinimumValue() {
        return this.minimumValue;
    }

    public long getMaximumValue() {
        return this.maximumValue;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("current = ").append(this.currentValue);
        sb.append(" min = ").append(this.minimumValue);
        sb.append(" max = ").append(this.maximumValue);
        if (this.bounded) {
            sb.append(" lower bound = ").append(this.lowerBound);
            sb.append(" upper bound = ").append(this.upperBound);
        }
        sb.append(" ").append(this.unit);
        sb.append(" at ").append(new Date(this.timestamp).toString());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GaugeReading.class, null, null);
    }
}

