/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAtThrow;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeAtThrowMethodAdapter
extends ProbeMethodAdapter {
    private Set<ProbeListener> enabledListeners = new HashSet<ProbeListener>();
    static final long serialVersionUID = 5756674239358245379L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeAtThrowMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeAtThrow probeAtThrow = config.getProbeAtThrow();
            if (probeAtThrow == null) continue;
            this.enabledListeners.add(listener);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 191 && !this.enabledListeners.isEmpty()) {
            String key = this.createKey();
            ProbeImpl probe = this.getProbe(key);
            long probeId = probe.getIdentifier();
            this.setProbeInProgress(true);
            this.visitInsn(89);
            this.visitLdcInsn(probeId);
            this.visitInsn(93);
            this.visitInsn(88);
            if (this.isStatic()) {
                this.visitInsn(1);
            } else {
                this.visitVarInsn(25, 0);
            }
            this.visitInsn(95);
            this.visitInsn(1);
            this.visitInsn(95);
            this.visitFireProbeInvocation();
            this.setProbeInProgress(false);
            this.setProbeListeners(probe, this.enabledListeners);
        }
        super.visitInsn(opcode);
    }

    private String createKey() {
        StringBuilder sb = new StringBuilder("EXCEPTION_THROWN: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeAtThrowMethodAdapter.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

