/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RangeStatisticImpl
extends StatisticImpl
implements SPIRangeStatistic {
    private static final long serialVersionUID = -855214334683355657L;
    protected long highWaterMark = 0L;
    protected long lowWaterMark = 0L;
    protected long current = 0L;
    protected double integral = 0.0;
    protected boolean initWaterMark = false;
    protected RangeStatisticImpl baseValue = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RangeStatisticImpl(int dataId) {
        super(dataId);
    }

    public RangeStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    public RangeStatisticImpl(int id, long lowWaterMark, long highWaterMark, long current, double integral, long startTime, long lastSampleTime) {
        super(id, null, null, null, startTime, lastSampleTime);
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
        this.current = current;
        this.integral = integral;
    }

    @Override
    public int getStatisticType() {
        return 5;
    }

    @Override
    public WSStatistic copy() {
        RangeStatisticImpl copy = new RangeStatisticImpl(this.id, this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
        copy.baseValue = this.baseValue;
        return copy;
    }

    @Override
    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    @Override
    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    @Override
    public long getCurrent() {
        return this.current;
    }

    @Override
    public double getIntegral() {
        return this.integral;
    }

    @Override
    public double getMean() {
        long timeDiff = this.lastSampleTime - this.startTime;
        if (timeDiff > 0L) {
            return this.integral * 1.0 / (double)timeDiff;
        }
        return 0.0;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.integral = 0.0;
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    @Override
    public void setWaterMark(long val) {
        this.setWaterMark(System.currentTimeMillis(), val);
    }

    @Override
    public void setWaterMark(long curTime, long val) {
        this.lastSampleTime = curTime;
        if (!this.initWaterMark) {
            this.lowWaterMark = this.highWaterMark = val;
            this.initWaterMark = true;
        } else {
            if (val < this.lowWaterMark) {
                this.lowWaterMark = val;
            }
            if (val > this.highWaterMark) {
                this.highWaterMark = val;
            }
        }
        this.current = val;
    }

    private final void updateWaterMark() {
        if (this.initWaterMark) {
            if (this.current < this.lowWaterMark) {
                this.lowWaterMark = this.current;
            }
            if (this.current > this.highWaterMark) {
                this.highWaterMark = this.current;
            }
        } else {
            this.lowWaterMark = this.highWaterMark = this.current;
            this.initWaterMark = true;
        }
    }

    @Override
    public void set(long lowWaterMark, long highWaterMark, long current, double integral, long startTime, long lastSampleTime) {
        this.current = current;
        this.integral = integral;
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public void set(long val) {
        if (this.current == val) {
            this.lastSampleTime = System.currentTimeMillis();
            return;
        }
        if (this.enabled) {
            long curTime = this.updateIntegral();
            this.setWaterMark(curTime, val);
        } else {
            this.current = val;
        }
    }

    @Override
    public void set(long curTime, long val) {
        if (this.current == val) {
            this.lastSampleTime = curTime;
            return;
        }
        if (this.enabled) {
            this.updateIntegral(curTime);
            this.setWaterMark(curTime, val);
        } else {
            this.current = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment() {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                ++this.current;
            }
            this.updateWaterMark();
        } else {
            ++this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment(long incVal) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current += incVal;
            }
            this.updateWaterMark();
        } else {
            this.current += incVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment(long curTime, long incVal) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current += incVal;
            }
            this.updateWaterMark();
        } else {
            this.current += incVal;
        }
    }

    public final void incrementWithoutSync(long curTime, long val) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            this.current += val;
            this.updateWaterMark();
        } else {
            this.current += val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementWithSyncFlag(long curTime, long val) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            if (this.sync) {
                RangeStatisticImpl rangeStatisticImpl = this;
                synchronized (rangeStatisticImpl) {
                    this.current += val;
                }
            } else {
                this.current += val;
            }
            this.updateWaterMark();
        } else {
            this.current += val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement() {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                --this.current;
            }
            this.updateWaterMark();
        } else {
            --this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement(long decVal) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current -= decVal;
            }
            this.updateWaterMark();
        } else {
            this.current -= decVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement(long curTime, long decVal) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current -= decVal;
            }
            this.updateWaterMark();
        } else {
            this.current -= decVal;
        }
    }

    public final void decrementWithoutSync(long curTime, long val) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            this.current -= val;
            this.updateWaterMark();
        } else {
            this.current -= val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementWithSyncFlag(long curTime, long val) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(curTime);
            if (this.sync) {
                RangeStatisticImpl rangeStatisticImpl = this;
                synchronized (rangeStatisticImpl) {
                    this.current -= val;
                }
            } else {
                this.current -= val;
                if (this.current < 0L) {
                    this.current = 0L;
                }
            }
            this.updateWaterMark();
        } else {
            this.current -= val;
        }
    }

    @Override
    public final long updateIntegral() {
        long curTime = System.currentTimeMillis();
        this.integral += (double)((curTime - this.lastSampleTime) * this.current);
        return curTime;
    }

    @Override
    public final long updateIntegral(long curTime) {
        this.integral += (double)((curTime - this.lastSampleTime) * this.current);
        return curTime;
    }

    @Override
    public void setLastValue(long val) {
        this.current = val;
    }

    @Override
    public void combine(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        this.current += other.current;
        long curTime = other.updateIntegral();
        other.setLastSampleTime(curTime);
        if (this.lastSampleTime - this.startTime == 0L) {
            this.updateIntegral(curTime);
            this.setLastSampleTime(curTime);
        }
        double otherAvg = other.getIntegral() * 1.0 / (double)(curTime - other.getStartTime());
        this.integral += (double)((long)(otherAvg * (double)(this.lastSampleTime - this.startTime)));
        if (other.lowWaterMark < this.lowWaterMark) {
            this.lowWaterMark = other.lowWaterMark;
        }
        if (other.highWaterMark > this.highWaterMark) {
            this.highWaterMark = other.highWaterMark;
        }
    }

    @Override
    public void update(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.integral = other.integral;
            this.startTime = other.startTime;
        } else {
            this.integral = other.integral - this.baseValue.integral;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.current = other.current;
        this.lowWaterMark = other.lowWaterMark;
        this.highWaterMark = other.highWaterMark;
        this.lastSampleTime = other.lastSampleTime;
    }

    @Override
    public WSStatistic delta(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        RangeStatisticImpl newData = new RangeStatisticImpl(this.id);
        newData.current = this.current - other.current;
        newData.integral = this.integral - other.integral;
        newData.startTime = other.lastSampleTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        RangeStatisticImpl newData = new RangeStatisticImpl(this.id);
        long timeDiff = (this.lastSampleTime - other.lastSampleTime) / 1000L;
        if (timeDiff == 0L) {
            return null;
        }
        newData.current = (this.current - other.current) / timeDiff;
        newData.integral = (this.integral - other.integral) / (double)timeDiff;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        newData.lowWaterMark = this.lowWaterMark;
        newData.highWaterMark = this.highWaterMark;
        return newData;
    }

    @Override
    public void resetOnClient(WSStatistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new RangeStatisticImpl(this.id);
            }
            this.baseValue.set(this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(other)) {
            this.baseValue = (RangeStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RangeStatisticImpl)) {
            return false;
        }
        return other.getId() == this.id;
    }

    public void cleanup() {
        this.current = 0L;
        this.integral = 0.0;
        this.lastSampleTime = System.currentTimeMillis();
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("RangeStatistic");
        str.append(", lowWaterMark=");
        str.append(this.lowWaterMark);
        str.append(", highWaterMark=");
        str.append(this.highWaterMark);
        str.append(", current=");
        str.append(this.current);
        str.append(", integral=");
        str.append(this.integral);
        return str.toString();
    }

    public String toStringforBRS(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("BoundedRangeStatistic");
        str.append(", lowWaterMark=");
        str.append(this.lowWaterMark);
        str.append(", highWaterMark=");
        str.append(this.highWaterMark);
        str.append(", current=");
        str.append(this.current);
        str.append(", integral=");
        str.append(this.integral);
        return str.toString();
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<RS id=\"");
        res.append(this.id);
        res.append("\" sT=\"");
        res.append(this.startTime);
        res.append("\" lST=\"");
        res.append(this.lastSampleTime);
        res.append("\" lWM=\"");
        res.append(this.lowWaterMark);
        res.append("\" hWM=\"");
        res.append(this.highWaterMark);
        res.append("\" cur=\"");
        res.append(this.current);
        res.append("\" int=\"");
        res.append(this.integral);
        res.append("\"></RS>");
        return res.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RangeStatisticImpl.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

