/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.io.Serializable;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public abstract class StatisticImpl
implements SPIStatistic,
Serializable {
    static final long serialVersionUID = 1358353157061734347L;
    protected int id;
    long startTime = 0L;
    long lastSampleTime = 0L;
    protected transient boolean enabled = true;
    transient boolean sync = false;
    transient PmiDataInfo dataInfo = null;
    protected static final int TYPE = 0;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public int getStatisticType() {
        return 0;
    }

    public StatisticImpl(int id) {
        this.id = id;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public StatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        this.id = id;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public String getName() {
        if (this.dataInfo != null) {
            return this.dataInfo.getName();
        }
        return null;
    }

    @Override
    public String getUnit() {
        if (this.dataInfo != null) {
            return this.dataInfo.getUnit();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.dataInfo != null) {
            return this.dataInfo.getDescription();
        }
        return null;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void enable(int level) {
        this.sync = level >= 15;
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
        this.sync = false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void reset() {
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    @Override
    public void setDataInfo(PmiModuleConfig config) {
        if (config != null) {
            this.dataInfo = config.getDataInfo(this.id);
        }
    }

    @Override
    public void setDataInfo(PmiDataInfo info) {
        this.dataInfo = info;
    }

    public void mSetDataInfo(PmiModuleConfig config) {
        if (config != null && config.getDataInfo(this.id) != null) {
            this.dataInfo = config.getDataInfo(this.id);
        }
    }

    @Override
    public void setLastSampleTime(long lastSampleTime) {
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public PmiDataInfo getDataInfo() {
        return this.dataInfo;
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<Statistic id=\"");
        res.append(this.id);
        res.append("\" name=\"");
        res.append(this.getName());
        res.append("\" description=\"");
        res.append(this.getDescription());
        res.append("\" unit=\"");
        res.append(this.getUnit());
        res.append("\" startTime=\"");
        res.append(this.startTime);
        res.append("\" lastSampleTime=\"");
        res.append(this.lastSampleTime);
        res.append("</Statistic>");
        return res.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append("name=").append(this.getName());
        str.append(", ID=").append(this.id);
        str.append(", description=").append(this.getDescription());
        str.append(", unit=").append(this.getUnit());
        return str.toString();
    }

    @Override
    public abstract void update(WSStatistic var1);

    @Override
    public abstract WSStatistic delta(WSStatistic var1);

    @Override
    public abstract WSStatistic rateOfChange(WSStatistic var1);

    @Override
    public abstract WSStatistic copy();

    @Override
    public abstract void combine(WSStatistic var1);

    @Override
    public abstract void resetOnClient(WSStatistic var1);

    public abstract void reset(boolean var1);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(StatisticImpl.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

