/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.framework.ConnectRequestListener;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionTarget;
import com.ibm.ws.sib.jfapchannel.impl.JFapAddress;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnectionContext;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import java.net.InetSocketAddress;

public class CFWNetworkConnection
implements NetworkConnection {
    private static final TraceComponent tc = SibTr.register(CFWNetworkConnection.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private VirtualConnection vc = null;

    public CFWNetworkConnection(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)vc);
        }
        this.vc = vc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    VirtualConnection getVirtualConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getVirtualConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getVirtualConnection", (Object)this.vc);
        }
        return this.vc;
    }

    @Override
    public boolean requestPermissionToClose(long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestPermissionToClose", (Object)timeout);
        }
        boolean canProcess = this.vc.requestPermissionToClose(timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestPermissionToClose", (Object)canProcess);
        }
        return canProcess;
    }

    @Override
    public void connectAsynch(final NetworkConnectionTarget target, final ConnectRequestListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectAsynch", (Object)new Object[]{target, listener});
        }
        final CFWNetworkConnection readyConnection = this;
        TCPConnectRequestContext tcpTarget = new TCPConnectRequestContext(){

            public InetSocketAddress getLocalAddress() {
                return target.getLocalAddress();
            }

            public InetSocketAddress getRemoteAddress() {
                return target.getRemoteAddress();
            }

            public int getConnectTimeout() {
                return target.getConnectTimeout();
            }
        };
        ConnectionReadyCallback callback = new ConnectionReadyCallback(){

            public void ready(VirtualConnection conn) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ready", (Object)conn);
                }
                listener.connectRequestSucceededNotification(readyConnection);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"ready");
                }
            }

            public void destroy(Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"destroy", (Object)exception);
                }
                listener.connectRequestFailedNotification(exception);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
                }
            }
        };
        JFapAddress jfapAddress = (JFapAddress)target;
        if (jfapAddress != null && jfapAddress.getAttachType() == Conversation.CLIENT) {
            this.vc.getStateMap().put("protocol", "BUS_CLIENT");
        } else {
            this.vc.getStateMap().put("protocol", "BUS_TO_BUS");
        }
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Framework.isStopping() == true");
            }
            callback.destroy((Exception)new IllegalStateException("Framework stopped"));
        } else {
            ((OutboundVirtualConnection)this.vc).connectAsynch((Object)tcpTarget, callback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectAsynch");
        }
    }

    @Override
    public NetworkConnectionContext getNetworkConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNetworkConnectionContext");
        }
        ConnectionLink connLink = (ConnectionLink)((OutboundVirtualConnection)this.vc).getChannelAccessor();
        CFWNetworkConnectionContext context = new CFWNetworkConnectionContext(this, connLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNetworkConnectionContext", (Object)context);
        }
        return context;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/CFWNetworkConnection.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

