/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.mbeans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.channelfw.utils.HostNameUtils;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.SessionCookieConfig;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginGenerator {
    private static final TraceComponent tc;
    private static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:copy />                                                 \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";
    private static final String NOT_DEFINED = "NOT_DEFINED";
    private static final String DEFAULT_VIRTUAL_HOST = "default_host";
    private static final String PLUGIN_CFG_ALIAS = "pluginConfiguration";
    private static final String HTTP_ALLOWED_ENDPOINT = "allowFromEndpointRef";
    private static final String LOCALHOST = "localhost";
    private static final String TRANSFORMER_FACTORY_JVM_PROPERTY_NAME = "javax.xml.transform.TransformerFactory";
    private static final Object transformerLock;
    private final PluginConfigData pcd;
    private final BundleContext context;
    private boolean utilityRequest;
    private String appServerName;
    private String webServerName;
    private Integer previousConfigHash;
    private File cachedFile;
    private static final boolean CHANGE_TRANSFORMER;

    PluginGenerator(Map<String, Object> config, WsLocationAdmin locSvc, BundleContext context) {
        PluginConfigData newPcd;
        block5: {
            this.utilityRequest = true;
            this.appServerName = null;
            this.webServerName = null;
            this.previousConfigHash = null;
            this.context = context;
            newPcd = null;
            try {
                newPcd = new PluginConfigData(config);
                newPcd.print(tc);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)PluginGenerator.class.getName(), (String)"processConfig");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)("Error process Config: " + t.getMessage()), (Object[])new Object[0]);
            }
        }
        this.pcd = newPcd;
        this.appServerName = locSvc.getServerName();
        this.cachedFile = context.getBundle().getDataFile("cached-PluginCfg.xml");
        if (this.cachedFile.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.cachedFile);
                this.previousConfigHash = this.getHashValue(doc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(PluginGenerator.class).getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected synchronized void generateXML(String rootLoc, String serverName, WebContainer container, SessionManager smgr, DynamicVirtualHostManager vhostMgr, WsLocationAdmin locationService, boolean utilityReq, File writeDirectory) {
        block102: {
            block101: {
                block106: {
                    block107: {
                        block105: {
                            if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)PluginGenerator.tc, (String)"generateXML", (Object[])new Object[]{"server = " + serverName + ", Framework is stopping = " + FrameworkState.isStopping() + ", pcd = " + this.pcd + ", this = " + this});
                            }
                            if (this.pcd == null || FrameworkState.isStopping()) break block105;
                            if (!container.isServerStopping()) break block106;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isEntryEnabled()) break block107;
                        if (FrameworkState.isStopping()) ** GOTO lbl-1000
                        if (container.isServerStopping()) lbl-1000:
                        // 2 sources

                        {
                            v0 = "Server is stopping";
                        } else {
                            v0 = "pcd is null";
                        }
                        Tr.exit((TraceComponent)PluginGenerator.tc, (String)"generateXML", (Object)v0);
                    }
                    return;
                }
                this.utilityRequest = utilityReq;
                writeFile = true;
                if (!this.utilityRequest) {
                    this.appServerName = serverName;
                    this.webServerName = serverName;
                } else {
                    this.appServerName = locationService.getServerName();
                    this.webServerName = this.pcd.webServerName;
                }
                pluginCfgWriter = null;
                outFile = null;
                fOutputStream = null;
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Generating webserver plugin cfg for server=" + this.appServerName), (Object[])new Object[0]);
                }
                root = rootLoc;
                userOverrideLocation = true;
                if (root == null) {
                    root = this.pcd.PluginInstallRoot;
                    userOverrideLocation = false;
                }
                clusterUriGroups = new HashMap<String, HashMap<K, V>>();
                output = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                tmpDateFmt = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
                comment = output.createComment(String.format("HTTP server plugin config file for %s generated on %s", new Object[]{this.appServerName, tmpDateFmt.format(new Date())}));
                output.appendChild(comment);
                rootElement = output.createElement("Config");
                if (!this.pcd.extraConfigProperties.isEmpty()) {
                    if (this.pcd.TrustedProxyEnable != null) {
                        if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)PluginGenerator.tc, (String)"Overriding TrustedProxyEnable from extra config properties with the specified value", (Object[])new Object[0]);
                        }
                        this.pcd.extraConfigProperties.put("TrustedProxyEnable", this.pcd.TrustedProxyEnable.toString());
                    }
                    for (String key : this.pcd.extraConfigProperties.keySet()) {
                        value = this.pcd.extraConfigProperties.get(key);
                        rootElement.setAttribute(key, value);
                    }
                }
                output.appendChild(rootElement);
                elem = output.createElement("Log");
                name = null;
                name = userOverrideLocation != false ? root + this.addSlash(root) + "logs" + File.separatorChar + this.webServerName + File.separatorChar + this.pcd.LogFile : (this.pcd.LogFileName != null ? this.pcd.LogFileName : this.pcd.LogDirLocation + this.addSlash(this.pcd.LogDirLocation) + this.pcd.LogFile);
                name = name.charAt(1) == ':' ? name.replace('/', '\\') : name.replace('\\', '/');
                elem.setAttribute("Name", name);
                elem.setAttribute("LogLevel", this.pcd.LogLevel);
                rootElement.appendChild(elem);
                esiProp1 = output.createElement("Property");
                esiProp1.setAttribute("Name", "ESIEnable");
                esiProp1.setAttribute("Value", this.pcd.ESIEnable.toString());
                rootElement.appendChild(esiProp1);
                esiProp2 = output.createElement("Property");
                esiProp2.setAttribute("Name", "ESIMaxCacheSize");
                esiProp2.setAttribute("Value", this.pcd.ESIMaxCacheSize.toString());
                rootElement.appendChild(esiProp2);
                esiProp3 = output.createElement("Property");
                esiProp3.setAttribute("Name", "ESIInvalidationMonitor");
                esiProp3.setAttribute("Value", this.pcd.ESIInvalidationMonitor.toString());
                rootElement.appendChild(esiProp3);
                esiProp4 = output.createElement("Property");
                esiProp4.setAttribute("Name", "ESIEnableToPassCookies");
                esiProp4.setAttribute("Value", this.pcd.ESIEnableToPassCookies.toString());
                rootElement.appendChild(esiProp4);
                esiProp5 = output.createElement("Property");
                esiProp5.setAttribute("Name", "PluginInstallRoot");
                esiProp5.setAttribute("Value", root);
                rootElement.appendChild(esiProp5);
                httpEndpointInfo = new HttpEndpointInfo(this.context, output, this.pcd.httpEndpointPid);
                vhostAliasData = new HashMap<String, List<VHostData>>();
                virtualHostSet = this.processVirtualHosts(vhostMgr, vhostAliasData, httpEndpointInfo, rootElement);
                for (String[] vh : virtualHostSet) {
                    vhElem = output.createElement("VirtualHostGroup");
                    vhElem.setAttribute("Name", vh.getName());
                    rootElement.appendChild(vhElem);
                    if (!vhostAliasData.containsKey(vh.getName())) continue;
                    for (VHostData vh_aliasData : (List)vhostAliasData.get(vh.getName())) {
                        aliasElem = output.createElement("VirtualHost");
                        aliasElem.setAttribute("Name", vh_aliasData.host + ":" + vh_aliasData.port);
                        vhElem.appendChild(aliasElem);
                    }
                }
                if (this.pcd.TrustedProxyGroup != null) {
                    if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)PluginGenerator.tc, (String)"Adding custom property TrustedProxyGroup element and its associated proxy servers", (Object[])new Object[0]);
                    }
                    tproxyGroupElem = output.createElement("TrustedProxyGroup");
                    rootElement.appendChild(tproxyGroupElem);
                    for (String trustedProxy : this.pcd.TrustedProxyGroup) {
                        tproxyElem = output.createElement("TrustedProxy");
                        if (trustedProxy.indexOf(":") != -1) {
                            tproxyElem.setAttribute("Name", "[" + trustedProxy.trim() + "]");
                        } else {
                            tproxyElem.setAttribute("Name", trustedProxy.trim());
                        }
                        tproxyGroupElem.appendChild(tproxyElem);
                        if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Added proxy server " + trustedProxy + " TrustedProxyGroup element"), (Object[])new Object[0]);
                    }
                }
                serverID = smgr.getCloneID();
                singleServerConfig = true;
                if (serverID == null) {
                    serverID = "";
                }
                if (serverID.length() > 0) {
                    singleServerConfig = false;
                }
                cloneSep = smgr.getCloneSeparator();
                cloneSeparatorChange = null;
                if (':' == cloneSep) {
                    cloneSeparatorChange = Boolean.FALSE;
                } else if ('+' == cloneSep) {
                    cloneSeparatorChange = Boolean.TRUE;
                } else {
                    throw new IllegalStateException("The session manager is configured to use '" + cloneSep + "' as the clone separator, but " + this.pcd.PluginConfigFileName + " only supports ':' and '+'.");
                }
                this.pcd.cloneSeparatorChange = cloneSeparatorChange;
                pServersElem = null;
                bServersElem = null;
                numberOfPrimaryServers = 0;
                numberOfBackupServers = 0;
                scd = this.pcd.createServerCluster(this.appServerName + "_" + "default_node" + "_Cluster", singleServerConfig);
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Adding the ServerCluster " + scd.clusterName), (Object[])new Object[0]);
                }
                scd.print(PluginGenerator.tc);
                sgElem = output.createElement("ServerCluster");
                sgElem.setAttribute("Name", scd.clusterName);
                sgElem.setAttribute("LoadBalance", scd.loadBalance);
                if (this.pcd.ignoreAffinityRequests != null) {
                    sgElem.setAttribute("IgnoreAffinityRequests", this.pcd.ignoreAffinityRequests.toString());
                }
                sgElem.setAttribute("RetryInterval", scd.retryInterval.toString());
                sgElem.setAttribute("ServerIOTimeoutRetry", scd.serverIOTimeoutRetry.toString());
                sgElem.setAttribute("RemoveSpecialHeaders", scd.removeSpecialHeaders.toString());
                sgElem.setAttribute("CloneSeparatorChange", scd.cloneSeparatorChange.toString());
                sgElem.setAttribute("PostSizeLimit", scd.postSizeLimit.toString());
                sgElem.setAttribute("PostBufferSize", scd.postBufferSize.toString());
                sgElem.setAttribute("GetDWLMTable", scd.GetDWLMTable.toString());
                if (!scd.singleServerConfig.booleanValue()) {
                    pServersElem = output.createElement("PrimaryServers");
                    bServersElem = output.createElement("BackupServers");
                }
                if (!httpEndpointInfo.isValid()) {
                    comment = output.createComment(" The configured endpoint could not be found. httpEndpointRef=" + httpEndpointInfo.getEndpointId());
                    rootElement.appendChild(comment);
                } else {
                    this.buildServerTransportData(this.appServerName, serverID, httpEndpointInfo, scd.clusterServers, this.pcd.IPv6Preferred);
                    for (ServerData sd : scd.clusterServers) {
                        if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Adding the Server definition " + sd.nodeName + "_" + sd.serverName), (Object[])new Object[0]);
                        }
                        sd.print(PluginGenerator.tc);
                        serverElem = output.createElement("Server");
                        serverElem.setAttribute("Name", sd.nodeName + "_" + sd.serverName);
                        if (!scd.singleServerConfig.booleanValue()) {
                            serverElem.setAttribute("LoadBalanceWeight", sd.loadBalanceWeight.toString());
                            if (0 < sd.serverID.length()) {
                                serverElem.setAttribute("CloneID", sd.serverID);
                            }
                        }
                        serverElem.setAttribute("ConnectTimeout", sd.connectTimeout.toString());
                        serverElem.setAttribute("ServerIOTimeout", sd.serverIOTimeout.toString());
                        if (sd.wsServerIOTimeout != null) {
                            serverElem.setAttribute("wsServerIOTimeout", sd.wsServerIOTimeout.toString());
                        }
                        if (sd.wsServerIdleTimeout != null) {
                            serverElem.setAttribute("wsServerIdleTimeout", sd.wsServerIdleTimeout.toString());
                        }
                        serverElem.setAttribute("WaitForContinue", sd.waitForContinue.toString());
                        serverElem.setAttribute("MaxConnections", sd.maxConnections.toString());
                        serverElem.setAttribute("ExtendedHandshake", sd.extendedHandshake.toString());
                        sgElem.appendChild(serverElem);
                        if (sd.transports != null) {
                            for (TransportData currentTransport : sd.transports) {
                                tElem = output.createElement("Transport");
                                hostname = currentTransport.host;
                                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Adding the Transport definition " + hostname), (Object[])new Object[0]);
                                }
                                currentTransport.print(PluginGenerator.tc);
                                tElem.setAttribute("Hostname", hostname);
                                transportPort = Integer.toString(currentTransport.port);
                                tElem.setAttribute("Port", transportPort);
                                if (currentTransport.isSslEnabled) {
                                    tElem.setAttribute("Protocol", "https");
                                    sslProp1 = output.createElement("Property");
                                    sslProp1.setAttribute("Name", "keyring");
                                    sslProp1.setAttribute("Value", this.pcd.KeyringLocation);
                                    tElem.appendChild(sslProp1);
                                    sslProp2 = output.createElement("Property");
                                    sslProp2.setAttribute("Name", "stashfile");
                                    sslProp2.setAttribute("Value", this.pcd.StashfileLocation);
                                    tElem.appendChild(sslProp2);
                                    if (this.pcd.CertLabel != null) {
                                        sslProp3 = output.createElement("Property");
                                        sslProp3.setAttribute("Name", "certLabel");
                                        sslProp3.setAttribute("Value", this.pcd.CertLabel);
                                        tElem.appendChild(sslProp3);
                                    }
                                } else {
                                    tElem.setAttribute("Protocol", "http");
                                }
                                serverElem.appendChild(tElem);
                            }
                        }
                        rootElement.appendChild(sgElem);
                        if (scd.singleServerConfig.booleanValue()) continue;
                        psServerElem = output.createElement("Server");
                        psServerElem.setAttribute("Name", sd.nodeName + "_" + sd.serverName);
                        if (sd.roleKind == Role.PRIMARY) {
                            pServersElem.appendChild(psServerElem);
                            ++numberOfPrimaryServers;
                            continue;
                        }
                        bServersElem.appendChild(psServerElem);
                        ++numberOfBackupServers;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Number of primary servers: " + numberOfPrimaryServers + " Number of backup servers: " + numberOfBackupServers), (Object[])new Object[0]);
                }
                if (!scd.singleServerConfig.booleanValue()) {
                    if (numberOfPrimaryServers > 0) {
                        sgElem.appendChild(pServersElem);
                    }
                    if (numberOfBackupServers > 0) {
                        sgElem.appendChild(bServersElem);
                    }
                }
                defaultAffinityCookie = smgr.getDefaultAffinityCookie();
                affinityUrlIdentifier = smgr.getAffinityUrlIdentifier();
                for (DynamicVirtualHost vhost : virtualHostSet) {
                    apps = vhost.getWebApps();
                    while (apps.hasNext()) {
                        app = apps.next();
                        if (app == null) continue;
                        dmd = new DeployedModuleData(app, defaultAffinityCookie, affinityUrlIdentifier);
                        scd.deployedModules.add(dmd);
                    }
                }
                uriGroups = new HashMap<K, V>();
                webGroupIDs = new LinkedList<String>();
                if (!scd.deployedModules.isEmpty()) {
                    for (Iterator<DynamicVirtualHost> dmd : scd.deployedModules) {
                        dmd.print(PluginGenerator.tc);
                        if (dmd.moduleConfig == null) continue;
                        contextRoot = dmd.moduleConfig.getContextRoot();
                        if (!contextRoot.startsWith("/")) {
                            contextRoot = "/" + contextRoot;
                        }
                        if ((lvh = dmd.moduleConfig.getVirtualHostName()) == null || 0 == lvh.length()) {
                            lvh = "default_host";
                        }
                        if (!uriGroups.containsKey(lvh)) {
                            uriGroups.put(lvh, new LinkedHashSet<E>());
                        }
                        uriList = (Set)uriGroups.get(lvh);
                        wgIndex = lvh + contextRoot;
                        if (webGroupIDs.contains(wgIndex)) {
                            if (this.utilityRequest) {
                                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)"duplicate.context.root", (Object[])new Object[]{contextRoot});
                                }
                            } else {
                                Tr.warning((TraceComponent)PluginGenerator.tc, (String)"duplicate.context.root", (Object[])new Object[]{contextRoot});
                            }
                        }
                        webGroupIDs.add(wgIndex);
                        newContextRoot = PluginGenerator.appendWildCardString(contextRoot);
                        uriList.add(new URIData(newContextRoot, dmd.cookieName, dmd.urlCookieName));
                        if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Computed URIs for the module " + dmd.moduleConfig.getDisplayName()), (Object[])new Object[0]);
                    }
                }
                clusterUriGroups.put(scd.clusterName, uriGroups);
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)"Added the ServerCluster elements", (Object[])new Object[0]);
                }
                cUgsSet = new HashSet<ClusterUriGroup>();
                for (Map.Entry entry : clusterUriGroups.entrySet()) {
                    clusterName = (String)entry.getKey();
                    uriGroups = (Map)entry.getValue();
                    lvh = null;
                    uriList = null;
                    for (Map.Entry<K, V> ugEntry : uriGroups.entrySet()) {
                        lvh = (String)ugEntry.getKey();
                        uriList = (Set)ugEntry.getValue();
                        ugElem = output.createElement("UriGroup");
                        uriGroupName = lvh + "_" + (String)clusterName + "_URIs";
                        ugElem.setAttribute("Name", uriGroupName);
                        rootElement.appendChild(ugElem);
                        if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Adding the URIGroup " + uriGroupName), (Object[])new Object[0]);
                        }
                        if (uriList != null) {
                            for (URIData ud : uriList) {
                                ud.print(PluginGenerator.tc);
                                uriElem = output.createElement("Uri");
                                uriElem.setAttribute("Name", ud.uriName);
                                if (ud.cookieName != null && 0 < ud.cookieName.length()) {
                                    uriElem.setAttribute("AffinityCookie", ud.cookieName);
                                }
                                uriElem.setAttribute("AffinityURLIdentifier", ud.urlCookieName);
                                ugElem.appendChild(uriElem);
                            }
                        }
                        cUgsSet.add(new ClusterUriGroup(lvh, clusterName, uriGroupName));
                    }
                }
                for (DynamicVirtualHost vhost : virtualHostSet) {
                    for (ClusterUriGroup cug : cUgsSet) {
                        if (!vhost.getName().equals(cug.vhostName)) continue;
                        routeElem = output.createElement("Route");
                        routeElem.setAttribute("VirtualHostGroup", vhost.getName());
                        routeElem.setAttribute("UriGroup", cug.uriGroupName);
                        routeElem.setAttribute("ServerCluster", cug.clusterName);
                        rootElement.appendChild(routeElem);
                    }
                }
                fileExists = false;
                if (writeDirectory == null) {
                    outputDirectory = "";
                    if (this.utilityRequest) {
                        outputDirectory = "logs" + File.separatorChar + "state" + File.separatorChar;
                    }
                    fileExists = locationService.getServerOutputResource(outputDirectory + this.pcd.PluginConfigFileName).exists();
                    outFile = locationService.getServerOutputResource(outputDirectory + this.pcd.TempPluginConfigFileName);
                } else {
                    path = writeDirectory.getPath();
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        path = path + File.separatorChar;
                    }
                    pluginFile = new File(path + this.pcd.PluginConfigFileName);
                    fileExists = pluginFile.exists();
                    temPluginFile = new File(path + this.pcd.TempPluginConfigFileName);
                    if (temPluginFile.exists()) {
                        temPluginFile.delete();
                    }
                    outFile = locationService.asResource(temPluginFile, true);
                }
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)PluginGenerator.tc, (String)("Output file already exists : " + fileExists), (Object[])new Object[0]);
                }
                if ((writeFile = this.hasConfigChanged(output)) || !this.utilityRequest || !fileExists.booleanValue()) {
                    block100: {
                        try {
                            if (!this.cachedFile.exists() || writeFile) {
                                fOutputStream = new FileOutputStream(this.cachedFile);
                                pluginCfgWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fOutputStream, "ISO-8859-1"));
                                xsltSource = new StreamSource(new StringReader(" <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:copy />                                                 \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n"));
                                tfactory = PluginGenerator.getTransformerFactory();
                                serializer = tfactory.newTransformer(xsltSource);
                                oprops = new Properties();
                                oprops.put("method", "xml");
                                oprops.put("omit-xml-declaration", "no");
                                oprops.put("version", "1.0");
                                oprops.put("indent", "yes");
                                serializer.setOutputProperties(oprops);
                                serializer.transform(new DOMSource(output), new StreamResult(pluginCfgWriter));
                            }
                            if (pluginCfgWriter == null) break block100;
                        }
                        catch (Throwable var57_68) {
                            if (pluginCfgWriter != null) {
                                pluginCfgWriter.flush();
                                fOutputStream.getFD().sync();
                                pluginCfgWriter.close();
                            }
                            Files.copy(this.cachedFile.toPath(), outFile.asFile().toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            throw var57_68;
                        }
                        pluginCfgWriter.flush();
                        fOutputStream.getFD().sync();
                        pluginCfgWriter.close();
                    }
                    Files.copy(this.cachedFile.toPath(), outFile.asFile().toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    break block101;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isDebugEnabled()) break block101;
                Tr.debug((TraceComponent)PluginGenerator.tc, (String)"A new plugin configuration file was not written: the configuration did not change.", (Object[])new Object[0]);
            }
            try {
                if (!outFile.exists()) {
                    throw new FileNotFoundException("File " + outFile.asFile().getAbsolutePath() + " could not be found");
                }
                pluginFile = new File(outFile.asFile().getParentFile(), this.pcd.PluginConfigFileName);
                if (pluginFile.exists()) {
                    FileUtils.forceDelete((File)pluginFile);
                }
                outFile.asFile().renameTo(pluginFile);
                fullFilePath = pluginFile.getAbsolutePath();
                if (this.utilityRequest) {
                    Tr.info((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.info", (Object[])new Object[]{fullFilePath});
                    break block102;
                }
                Tr.audit((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.audit", (Object[])new Object[]{fullFilePath});
            }
            catch (Throwable t) {
                if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)PluginGenerator.tc, (String)("Error renaming the plugin config xml; " + t.getMessage()), (Object[])new Object[0]);
                }
                break block102;
            }
            catch (Throwable t) {
                block103: {
                    try {
                        FFDCFilter.processException((Throwable)t, (String)PluginGenerator.class.getName(), (String)"generateXML", (Object[])new Object[]{container});
                        if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isEventEnabled()) break block103;
                        Tr.event((TraceComponent)PluginGenerator.tc, (String)("Error creating plugin config xml; " + t.getMessage()), (Object[])new Object[0]);
                    }
                    catch (Throwable var58_69) {
                        block104: {
                            try {
                                if (!outFile.exists()) {
                                    throw new FileNotFoundException("File " + outFile.asFile().getAbsolutePath() + " could not be found");
                                }
                                pluginFile = new File(outFile.asFile().getParentFile(), this.pcd.PluginConfigFileName);
                                if (pluginFile.exists()) {
                                    FileUtils.forceDelete((File)pluginFile);
                                }
                                outFile.asFile().renameTo(pluginFile);
                                fullFilePath = pluginFile.getAbsolutePath();
                                if (this.utilityRequest) {
                                    Tr.info((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.info", (Object[])new Object[]{fullFilePath});
                                } else {
                                    Tr.audit((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.audit", (Object[])new Object[]{fullFilePath});
                                }
                            }
                            catch (Throwable t) {
                                if (!TraceComponent.isAnyTracingEnabled() || !PluginGenerator.tc.isEventEnabled()) break block104;
                                Tr.event((TraceComponent)PluginGenerator.tc, (String)("Error renaming the plugin config xml; " + t.getMessage()), (Object[])new Object[0]);
                            }
                        }
                        throw var58_69;
                    }
                }
                try {
                    if (!outFile.exists()) {
                        throw new FileNotFoundException("File " + outFile.asFile().getAbsolutePath() + " could not be found");
                    }
                    pluginFile = new File(outFile.asFile().getParentFile(), this.pcd.PluginConfigFileName);
                    if (pluginFile.exists()) {
                        FileUtils.forceDelete((File)pluginFile);
                    }
                    outFile.asFile().renameTo(pluginFile);
                    fullFilePath = pluginFile.getAbsolutePath();
                    if (this.utilityRequest) {
                        Tr.info((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.info", (Object[])new Object[]{fullFilePath});
                    }
                    Tr.audit((TraceComponent)PluginGenerator.tc, (String)"plugin.file.generated.audit", (Object[])new Object[]{fullFilePath});
                }
                catch (Throwable t) {
                    if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isEventEnabled()) {
                        Tr.event((TraceComponent)PluginGenerator.tc, (String)("Error renaming the plugin config xml; " + t.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && PluginGenerator.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)PluginGenerator.tc, (String)"generateXML");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransformerFactory getTransformerFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransformerFactory", (Object[])new Object[]{"CHANGE_TRANSORMER = " + CHANGE_TRANSFORMER});
        }
        TransformerFactory tf = null;
        if (CHANGE_TRANSFORMER) {
            Object object = transformerLock;
            synchronized (object) {
                final String defaultTransformerFactory = PluginGenerator.getJVMProperty(TRANSFORMER_FACTORY_JVM_PROPERTY_NAME);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JDK = " + JavaInfo.vendor() + ", JDK level = " + JavaInfo.majorVersion() + "." + JavaInfo.minorVersion() + ", current TF jvm property value = " + defaultTransformerFactory), (Object[])new Object[0]);
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty(PluginGenerator.TRANSFORMER_FACTORY_JVM_PROPERTY_NAME, "org.apache.xalan.processor.TransformerFactoryImpl");
                        return null;
                    }
                });
                tf = TransformerFactory.newInstance();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IBM JDK : Use transformer factory: " + tf.getClass().getName()), (Object[])new Object[0]);
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        if (defaultTransformerFactory != null) {
                            System.setProperty(PluginGenerator.TRANSFORMER_FACTORY_JVM_PROPERTY_NAME, defaultTransformerFactory);
                        } else {
                            System.clearProperty(PluginGenerator.TRANSFORMER_FACTORY_JVM_PROPERTY_NAME);
                        }
                        return null;
                    }
                });
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IBM JDK : TF jvm property value restored: " + PluginGenerator.getJVMProperty(TRANSFORMER_FACTORY_JVM_PROPERTY_NAME)), (Object[])new Object[0]);
                }
            }
        } else {
            tf = TransformerFactory.newInstance();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not IBM JDK : Use transformer factory: " + tf.getClass().getName()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransformerFactory");
        }
        return tf;
    }

    private static String getJVMProperty(final String propertyName) {
        String propValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
        return propValue;
    }

    private boolean hasConfigChanged(Document newConfig) {
        NodeList list = newConfig.getElementsByTagName("*");
        int currentHash = this.nodeListHashValue(list);
        if (this.previousConfigHash == null || currentHash != this.previousConfigHash) {
            this.previousConfigHash = currentHash;
            this.storeHashValue(newConfig, this.previousConfigHash);
            return true;
        }
        return false;
    }

    private void storeHashValue(Document newConfig, Integer configHashValue) {
        Element root = newConfig.getDocumentElement();
        Node configHash = newConfig.getElementsByTagName("ConfigHash").item(0);
        if (configHash == null) {
            configHash = newConfig.createElement("ConfigHash");
            root.appendChild(configHash);
        } else {
            configHash.removeChild(configHash.getFirstChild());
        }
        configHash.appendChild(newConfig.createTextNode(configHashValue.toString()));
    }

    private Integer nodeListHashValue(NodeList list) {
        if (list == null) {
            return null;
        }
        int currentHash = 0;
        int listLength = list.getLength();
        for (int iterator = 0; iterator < listLength; ++iterator) {
            NamedNodeMap map = list.item(iterator).getAttributes();
            int numAttrs = map.getLength();
            for (int i = 0; i < numAttrs; ++i) {
                Attr attr = (Attr)map.item(i);
                int hash1 = attr.getNodeName().hashCode();
                int hash2 = attr.getNodeValue().hashCode();
                currentHash += hash1 + hash2;
            }
        }
        return currentHash;
    }

    private Integer getHashValue(Document doc) {
        String hash;
        if (doc == null) {
            return null;
        }
        Node hashElement = doc.getElementsByTagName("ConfigHash").item(0);
        if (hashElement != null && (hash = hashElement.getTextContent()) != null) {
            return new Integer(hash);
        }
        return null;
    }

    Set<DynamicVirtualHost> processVirtualHosts(DynamicVirtualHostManager vhostMgr, Map<String, List<VHostData>> vhostAliasData, HttpEndpointInfo httpEndpointInfo, Element rootElement) throws Exception {
        Document doc = rootElement.getOwnerDocument();
        Map<String, ServiceReference<?>> vhostConfigRefs = this.getVirtualHostRefs();
        HashSet<DynamicVirtualHost> virtualHostSet = new HashSet<DynamicVirtualHost>();
        HashMap<Integer, List<String>> portToVHostNameMap = new HashMap<Integer, List<String>>();
        boolean findVirtualHosts = true;
        ServiceReference<?> defaultHost = vhostConfigRefs.get(DEFAULT_VIRTUAL_HOST);
        boolean defaultHostIsCatchAll = true;
        if (defaultHost == null || defaultHost.getProperty("hostAlias") != null) {
            defaultHostIsCatchAll = false;
        }
        if (vhostConfigRefs.size() == 1 && defaultHostIsCatchAll) {
            DynamicVirtualHost vh;
            Iterator<DynamicVirtualHost> vHosts = vhostMgr.getVirtualHosts();
            DynamicVirtualHost dynamicVirtualHost = vh = vHosts.hasNext() ? vHosts.next() : null;
            if (!this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                if (vh == null) {
                    if (!this.utilityRequest) {
                        Tr.warning((TraceComponent)tc, (String)"warn.check.applications", (Object[])new Object[0]);
                    }
                    Comment comment = doc.createComment(String.format(" No Virtual Hosts were found, possibly because no applications are defined. %n\t Verify that at least one application is defined in the server configuration. ", new Object[0]));
                    rootElement.appendChild(comment);
                    return Collections.emptySet();
                }
                findVirtualHosts = false;
                virtualHostSet.add(vh);
                Comment comment = doc.createComment(String.format(" The default_host contained only aliases for endpoint %s.%n\t The generated VirtualHostGroup will contain only configured web server ports:%n\t\t%s%s%s ", httpEndpointInfo.getEndpointId(), this.pcd.webServerHttpPort > 0 ? "webserverPort=" + this.pcd.webServerHttpPort : "", this.pcd.webServerHttpPort > 0 && this.pcd.webServerHttpsPort > 0 ? "\n\t\t" : "", this.pcd.webServerHttpsPort > 0 ? "webserverSecurePort=" + this.pcd.webServerHttpsPort : ""));
                rootElement.appendChild(comment);
                ArrayList<VHostData> vh_aliasData = new ArrayList<VHostData>();
                if (this.pcd.webServerHttpPort > 0) {
                    VHostData webServerHttpPort = new VHostData("*", this.pcd.webServerHttpPort);
                    vh_aliasData.add(webServerHttpPort);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, webServerHttpPort);
                }
                if (this.pcd.webServerHttpsPort > 0) {
                    VHostData webServerHttpsPort = new VHostData("*", this.pcd.webServerHttpsPort);
                    vh_aliasData.add(webServerHttpsPort);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, webServerHttpsPort);
                }
                vhostAliasData.put(DEFAULT_VIRTUAL_HOST, vh_aliasData);
            }
        }
        if (findVirtualHosts) {
            Comment comment;
            VHostData vhostData;
            boolean foundWildcardWebserverHttp = false;
            boolean foundWildcardWebserverHttps = false;
            Iterator<DynamicVirtualHost> i = vhostMgr.getVirtualHosts();
            while (i.hasNext()) {
                DynamicVirtualHost vh = i.next();
                String vh_name = vh.getName();
                ServiceReference<?> vhostConfig = vhostConfigRefs.get(vh_name);
                if (vhostConfig == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " has no configuration"), (Object[])new Object[0]);
                    continue;
                }
                if (this.blockedByRestrictions(vhostConfig.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " is not accessible from configured endpoint"), (Object[])new Object[]{"plugin endpoint = " + this.pcd.httpEndpointPid, "vhost required endpoints = " + this.getList((String[])vhostConfig.getProperty(HTTP_ALLOWED_ENDPOINT))});
                    continue;
                }
                virtualHostSet.add(vh);
                List<String> vh_aliases = vh.getAliases();
                if (vh_aliases.isEmpty()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Virtual host " + vh.getName() + " has no defined host aliases"), (Object[])new Object[0]);
                    continue;
                }
                ArrayList<VHostData> vh_aliasData = new ArrayList<VHostData>();
                for (String alias : vh_aliases) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding " + vh.getName() + " -> " + alias), (Object[])new Object[0]);
                    }
                    VHostData vh_alias = new VHostData(alias);
                    vh_aliasData.add(vh_alias);
                    this.mapPortUsage(portToVHostNameMap, vh_name, vh_alias);
                    if (!vh_alias.host.equals("*")) continue;
                    if (vh_alias.port == this.pcd.webServerHttpPort) {
                        foundWildcardWebserverHttp = true;
                    }
                    if (vh_alias.port != this.pcd.webServerHttpsPort) continue;
                    foundWildcardWebserverHttps = true;
                }
                vhostAliasData.put(vh_name, vh_aliasData);
            }
            List<VHostData> vh_aliasData = vhostAliasData.get(DEFAULT_VIRTUAL_HOST);
            if (this.pcd.webServerHttpPort > 0 && !foundWildcardWebserverHttp) {
                if (defaultHostIsCatchAll && vh_aliasData != null && !this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    vhostData = new VHostData("*", this.pcd.webServerHttpPort);
                    vh_aliasData.add(vhostData);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, vhostData);
                } else {
                    comment = doc.createComment(String.format(" No virtual hosts are configured to accept requests from the webserver http port (*:%s).%n\t Verify that virtualHost elements in server.xml have appropriate hostAlias attributes to support the webserver. ", this.pcd.webServerHttpPort));
                    rootElement.appendChild(comment);
                }
            }
            if (this.pcd.webServerHttpsPort > 0 && !foundWildcardWebserverHttps) {
                if (defaultHostIsCatchAll && vh_aliasData != null && !this.blockedByRestrictions(defaultHost.getProperty(HTTP_ALLOWED_ENDPOINT))) {
                    vhostData = new VHostData("*", this.pcd.webServerHttpsPort);
                    vh_aliasData.add(vhostData);
                    this.mapPortUsage(portToVHostNameMap, DEFAULT_VIRTUAL_HOST, vhostData);
                } else {
                    comment = doc.createComment(String.format(" No virtual hosts are configured to accept requests from the webserver https port (*:%s).%n\t Verify that virtualHost elements in server.xml have appropriate hostAlias attributes to support the webserver. ", this.pcd.webServerHttpsPort));
                    rootElement.appendChild(comment);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Finished finding vhosts and aliases", (Object[])new Object[]{portToVHostNameMap, vhostAliasData});
            }
        }
        if (virtualHostSet.isEmpty()) {
            Comment comment = doc.createComment(String.format(" No virtual hosts are accessible from the configured endpoint (%s).%n\t Verify the allowed endpoints for the virtualHost elements in server.xml. ", httpEndpointInfo.getEndpointId()));
            rootElement.appendChild(comment);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finished finding/pruning vhosts and aliases", (Object[])new Object[]{portToVHostNameMap, vhostAliasData, virtualHostSet});
        }
        return virtualHostSet;
    }

    private boolean blockedByRestrictions(Object restrictions) {
        if (restrictions == null) {
            return false;
        }
        List<String> endpoints = this.getList((String[])restrictions);
        if (endpoints.isEmpty()) {
            return false;
        }
        return !endpoints.contains(this.pcd.httpEndpointPid);
    }

    private void mapPortUsage(Map<Integer, List<String>> portToVHostNameMap, String vh_name, VHostData vh_alias) throws UnknownHostException {
        List<String> port_vhostName = portToVHostNameMap.get(vh_alias.port);
        if (port_vhostName == null) {
            port_vhostName = new ArrayList<String>();
            portToVHostNameMap.put(vh_alias.port, port_vhostName);
        }
        port_vhostName.add(vh_name);
    }

    Map<String, ServiceReference<?>> getVirtualHostRefs() throws Exception {
        String filter = "(&(service.factoryPid=com.ibm.ws.http.virtualhost)(|(enabled=true)(id=default_host)))";
        ServiceReference[] refs = this.context.getAllServiceReferences(null, filter);
        if (refs == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"getVirtualHostRefs -- no configured virtual hosts found", (Object[])new Object[0]);
            }
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        for (ServiceReference ref : refs) {
            String id = (String)ref.getProperty("id");
            result.put(id, ref);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"getVirtualHostRefs", (Object[])new Object[]{id, ref});
        }
        return result;
    }

    List<String> getList(String[] property) {
        if (property == null || property.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(property);
    }

    void buildServerTransportData(String appServerName, String serverID, HttpEndpointInfo httpEndpointInfo, List<ServerData> serverDataList, boolean preferIPv6) throws Exception {
        Integer httpsPort;
        String defaultHostName = (String)httpEndpointInfo.getProperty("_defaultHostName");
        String host = (String)httpEndpointInfo.getProperty("host");
        Integer httpPort = (Integer)httpEndpointInfo.getProperty("httpPort");
        if (httpPort == null) {
            httpPort = -1;
        }
        if ((httpsPort = (Integer)httpEndpointInfo.getProperty("httpsPort")) == null) {
            httpsPort = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("buildServerTransportData: adding " + httpEndpointInfo.getEndpointId()), (Object[])new Object[]{host, defaultHostName, httpPort, httpsPort});
        }
        ServerData sd = new ServerData(appServerName, serverID, this.pcd);
        serverDataList.add(sd);
        sd.nodeName = "default_node";
        sd.hostName = PluginGenerator.tryDetermineHostName(host, defaultHostName, preferIPv6);
        if (!this.utilityRequest && sd.hostName.equals(LOCALHOST)) {
            Tr.warning((TraceComponent)tc, (String)"collocated.appserver", (Object[])new Object[]{sd.nodeName, sd.serverName});
        }
        if (httpPort > 0) {
            sd.addTransportData(sd.hostName, httpPort, false);
        }
        if (httpsPort > 0) {
            sd.addTransportData(sd.hostName, httpsPort, true);
        }
    }

    private static String appendWildCardString(String rootURI) {
        String rc = rootURI;
        if (!rc.startsWith("*.")) {
            if (rc.endsWith("/")) {
                rc = rc + "*";
            } else if (!rc.endsWith("/*")) {
                rc = rc + "/*";
            }
        }
        return rc;
    }

    protected static String tryDetermineHostName(String host, String defaultHostName, boolean preferIPv6) {
        String hostName = null;
        hostName = "*".equals(host) && !LOCALHOST.equals(defaultHostName) && !defaultHostName.isEmpty() ? (HostNameUtils.validLocalHostName((String)defaultHostName, (boolean)preferIPv6) ? defaultHostName : LOCALHOST) : HostNameUtils.tryResolveHostName((String)host, (boolean)preferIPv6);
        return hostName == null ? LOCALHOST : hostName;
    }

    @Trivial
    private String addSlash(String input) {
        if (input.endsWith("/") || input.endsWith("\\")) {
            return "";
        }
        return File.separator;
    }

    static {
        int majorVersion;
        tc = Tr.register(PluginGenerator.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
        transformerLock = new Object();
        CHANGE_TRANSFORMER = !JavaInfo.vendor().equals((Object)JavaInfo.Vendor.IBM) ? false : (majorVersion = JavaInfo.majorVersion()) == 7 || majorVersion == 8;
    }

    protected static class HttpEndpointInfo {
        private final String httpEndpointId;
        private final ServiceReference<?> httpEndpointRef;

        HttpEndpointInfo(BundleContext context, Document doc, String pid) {
            ServiceReference<?> serviceRef = null;
            String idFilter = "(service.pid=" + pid + ")";
            if (pid == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- no endpoint specified in config", (Object[])new Object[0]);
                }
                idFilter = "(id=defaultHttpEndpoint)";
            }
            String filter = "(&(enabled=true)(|(httpPort>=1)(httpsPort>=1))" + idFilter + ")";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("HttpEndpointInfo -- looking for configured endpoints matching " + filter), (Object[])new Object[0]);
            }
            if ((serviceRef = this.getService(context, filter)) == null) {
                ServiceReference<?> ref;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- no enabled/listening endpoints found", (Object[])new Object[0]);
                }
                if ((ref = this.getService(context, idFilter)) != null) {
                    String id = (String)ref.getProperty("id");
                    Comment comment = doc.createComment(String.format(" The endpoint %s was not found or is not enabled", id));
                    doc.getDocumentElement().appendChild(comment);
                } else {
                    Comment comment = doc.createComment(String.format(" No endpoint could be found with pid %s.", pid));
                    doc.getDocumentElement().appendChild(comment);
                }
            }
            if (serviceRef == null && (serviceRef = this.getService(context, "(&(enabled=true)(httpPort>=1)(httpsPort>=1))")) == null) {
                serviceRef = this.getService(context, "(&(enabled=true)(|(httpPort>=1)(httpsPort>=1)))");
            }
            if (serviceRef != null) {
                this.httpEndpointRef = serviceRef;
                this.httpEndpointId = (String)serviceRef.getProperty("id");
                Comment comment = doc.createComment(" Configuration generated using httpEndpointRef=" + this.httpEndpointId);
                doc.getDocumentElement().appendChild(comment);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"HttpEndpointInfo -- could not find a valid endpoint", (Object[])new Object[0]);
                }
                this.httpEndpointRef = null;
                this.httpEndpointId = "defaultHttpEndpoint";
            }
        }

        public Object getProperty(String key) {
            if (this.httpEndpointRef != null) {
                return this.httpEndpointRef.getProperty(key);
            }
            return null;
        }

        public boolean isValid() {
            return this.httpEndpointRef != null;
        }

        public Object getEndpointId() {
            return this.httpEndpointId;
        }

        @FFDCIgnore(value={InvalidSyntaxException.class})
        ServiceReference<?> getService(BundleContext context, String filter) {
            ServiceReference[] refs = null;
            try {
                refs = context.getAllServiceReferences(null, filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (refs == null || refs.length == 0) {
                return null;
            }
            return refs[0];
        }
    }

    protected static class DeployedModuleData {
        protected WebApp app = null;
        protected WebAppConfiguration moduleConfig;
        protected String cookieName = "JSESSIONID";
        protected String urlCookieName = "jsessionid";
        protected List<String> additionalPatterns = null;

        protected DeployedModuleData(WebApp application, String defaultAffinityCookie, String affinityUrlIdentifier) {
            this.app = application;
            this.moduleConfig = application.getConfiguration();
            SessionCookieConfig cookieConfig = null;
            try {
                cookieConfig = application.getSessionCookieConfig();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (cookieConfig == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The application named " + application.getName() + " has not been initialized yet, so the plugin configuration will use the default (server-level) affinity cookie. If this application programmatically modifies the affinity cookie's name during initialization, that change will not be reflected in the plugin configuration unless the plugin configuration is regenerated after application initialization."), (Object[])new Object[0]);
                }
                if (defaultAffinityCookie != null) {
                    this.cookieName = defaultAffinityCookie;
                }
            } else {
                String cookieName = cookieConfig.getName();
                if (cookieName != null) {
                    this.cookieName = cookieName;
                }
            }
            if (affinityUrlIdentifier != null) {
                this.urlCookieName = affinityUrlIdentifier;
            }
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"DeploymentModuleData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   moduleConfig         : " + this.moduleConfig), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cookieName           : " + this.cookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   urlCookieName        : " + this.urlCookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   additionalPatterns   : " + this.additionalPatterns), (Object[])new Object[0]);
            }
        }
    }

    protected static class TransportData {
        protected String host;
        protected int port;
        protected boolean isSslEnabled;

        public TransportData(String hostName, int portNumber, boolean sslEnabled) {
            this.host = hostName;
            this.port = portNumber;
            this.isSslEnabled = sslEnabled;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"TransportData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   host        : " + this.host), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   port        : " + this.port), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sslEnabled  : " + this.isSslEnabled), (Object[])new Object[0]);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (null == o || !(o instanceof TransportData)) {
                return false;
            }
            TransportData td = (TransportData)o;
            return td.host.equals(this.host) && td.port == this.port && td.isSslEnabled == this.isSslEnabled;
        }

        public int hashCode() {
            return this.host.hashCode() + this.port;
        }

        public String toString() {
            return "transportData(host=" + this.host + ", port=" + this.port + ", isSSL=" + this.isSslEnabled + ")";
        }
    }

    protected static class ServerData {
        protected String serverName = null;
        protected String serverID = "";
        protected String cellName = null;
        protected String nodeName = null;
        protected String hostName = null;
        protected List<TransportData> transports = new LinkedList<TransportData>();
        protected Long connectTimeout = 5L;
        protected Long serverIOTimeout = 0L;
        protected Long wsServerIOTimeout = null;
        protected Long wsServerIdleTimeout = null;
        protected Boolean waitForContinue = Boolean.FALSE;
        protected Integer maxConnections = -1;
        protected Boolean extendedHandshake = Boolean.FALSE;
        protected Role roleKind = Role.PRIMARY;
        protected String sessionManagerCookieName = "JSESSIONID";
        protected String sessionURLIdentifier = "jsessionid";
        protected String cloneSeparator = null;
        protected String fileServingEnabled = "NOT_DEFINED";
        protected String serveServletsByClassnameEnabled = "NOT_DEFINED";
        protected Integer loadBalanceWeight = 20;

        public ServerData(String name, String serverID, PluginConfigData pcd) {
            this.serverName = name;
            if (serverID != null) {
                this.serverID = serverID;
            }
            this.nodeName = null;
            this.serverIOTimeout = pcd.serverIOTimeout;
            this.wsServerIOTimeout = pcd.wsServerIOTimeout;
            this.wsServerIdleTimeout = pcd.wsServerIdleTimeout;
            this.connectTimeout = pcd.connectTimeout;
            this.waitForContinue = pcd.waitForContinue;
            this.maxConnections = pcd.maxConnections;
            this.extendedHandshake = pcd.extendedHandshake;
            this.loadBalanceWeight = pcd.loadBalanceWeight;
            this.roleKind = pcd.roleKind;
        }

        protected TransportData addTransportData(String hostName, int port, boolean isSecurity) {
            TransportData td = new TransportData(hostName, port, isSecurity);
            this.transports.add(td);
            return td;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"ServerData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cellName                        : " + this.cellName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   nodeName                        : " + this.nodeName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverName                      : " + this.serverName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverID                        : " + this.serverID), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   hostName                        : " + this.hostName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   transports                      : " + this.transports), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   connectTimeout                  : " + this.connectTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeout                 : " + this.serverIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIOTimeout               : " + this.wsServerIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIdleTimeout             : " + this.wsServerIdleTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   waitForContinue                 : " + this.waitForContinue), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   maxConnections                  : " + this.maxConnections), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   extendedHandshake               : " + this.extendedHandshake), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   roleKind                        : " + (Object)((Object)this.roleKind)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sessionManagerCookieName        : " + this.sessionManagerCookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   sessionURLIdentifier            : " + this.sessionURLIdentifier), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparator                  : " + this.cloneSeparator), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   fileServingEnabled              : " + this.fileServingEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalanceWeight               : " + this.loadBalanceWeight), (Object[])new Object[0]);
            }
        }
    }

    protected static class ServerClusterData {
        protected String clusterName;
        protected String loadBalance;
        protected Integer retryInterval;
        protected Integer serverIOTimeoutRetry;
        protected Boolean removeSpecialHeaders;
        protected Boolean cloneSeparatorChange;
        protected Boolean GetDWLMTable;
        protected Integer postSizeLimit;
        protected Integer postBufferSize;
        protected List<ServerData> clusterServers = new LinkedList<ServerData>();
        protected List<DeployedModuleData> deployedModules = new ArrayList<DeployedModuleData>();
        protected String fileServingEnabled = "NOT_DEFINED";
        protected String serveServletsByClassnameEnabled = "NOT_DEFINED";
        protected Boolean singleServerConfig;

        public ServerClusterData(String cName, boolean singleServerConfig) {
            this.clusterName = cName;
            this.singleServerConfig = singleServerConfig;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"ServerClusterData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   clusterName                     : " + this.clusterName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalance                     : " + this.loadBalance), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   retryInterval                   : " + this.retryInterval), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeoutRetry            : " + this.serverIOTimeoutRetry), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   removeSpecialHeaders            : " + this.removeSpecialHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparatorChange            : " + this.cloneSeparatorChange), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postSizeLimit                   : " + this.postSizeLimit), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postBufferSize                  : " + this.postBufferSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   clusterServers                  : " + this.clusterServers), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   deployedModules                 : " + this.deployedModules), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   fileServingEnabled              : " + this.fileServingEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serveServletsByClassnameEnabled : " + this.serveServletsByClassnameEnabled), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   singleServerConfig              : " + this.singleServerConfig), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   getDWLMTable                    : " + this.GetDWLMTable), (Object[])new Object[0]);
            }
        }
    }

    protected static class PluginConfigData {
        public Integer maxConnections = -1;
        protected String LogFile = "http_plugin.log";
        protected String LogLevel = "Error";
        protected Boolean ESIEnable = Boolean.TRUE;
        protected Integer ESIMaxCacheSize = 1024;
        protected Boolean ESIInvalidationMonitor = Boolean.FALSE;
        protected Boolean ESIEnableToPassCookies = Boolean.FALSE;
        protected String TempPluginConfigFileName = ".plugin-cfg.xml";
        protected String PluginConfigFileName = "plugin-cfg.xml";
        protected String loadBalance = "Round Robin";
        protected Boolean ignoreAffinityRequests = Boolean.TRUE;
        protected Integer retryInterval = 60;
        protected Boolean removeSpecialHeaders = Boolean.TRUE;
        protected Boolean cloneSeparatorChange = Boolean.FALSE;
        protected Integer postSizeLimit = -1;
        protected Integer postBufferSize = 0;
        protected Boolean GetDWLMTable = Boolean.FALSE;
        protected Integer HTTPMaxHeaders = 300;
        protected Boolean TrustedProxyEnable = null;
        protected String[] TrustedProxyGroup = null;
        protected String PluginInstallRoot = null;
        protected String webServerName = null;
        protected Integer webServerHttpPort = 70;
        protected Integer webServerHttpsPort = 343;
        protected String KeyringLocation = null;
        protected String StashfileLocation = null;
        protected String CertLabel = null;
        protected Boolean IPv6Preferred = null;
        protected String httpEndpointPid = null;
        protected Long serverIOTimeout = null;
        protected Long wsServerIOTimeout = null;
        protected Long wsServerIdleTimeout = null;
        public Long connectTimeout = null;
        public Boolean extendedHandshake = null;
        public Boolean waitForContinue = null;
        protected String LogFileName = null;
        protected String LogDirLocation = null;
        protected Integer serverIOTimeoutRetry = null;
        protected Hashtable<String, String> extraConfigProperties = new Hashtable();
        protected Integer loadBalanceWeight = null;
        protected Role roleKind = null;

        protected PluginConfigData() {
        }

        protected PluginConfigData(Map<String, Object> config) {
            this.PluginInstallRoot = (String)config.get("pluginInstallRoot");
            this.webServerName = (String)config.get("webserverName");
            this.webServerHttpPort = MetatypeUtils.parseInteger((Object)PluginGenerator.PLUGIN_CFG_ALIAS, (String)"webserverPort", (Object)config.get("webserverPort"), (int)this.webServerHttpPort);
            this.webServerHttpsPort = MetatypeUtils.parseInteger((Object)PluginGenerator.PLUGIN_CFG_ALIAS, (String)"webserverSecurePort", (Object)config.get("webserverSecurePort"), (int)this.webServerHttpsPort);
            this.KeyringLocation = (String)config.get("sslKeyringLocation");
            this.StashfileLocation = (String)config.get("sslStashfileLocation");
            this.CertLabel = (String)config.get("sslCertlabel");
            this.IPv6Preferred = (Boolean)config.get("ipv6Preferred");
            this.httpEndpointPid = (String)config.get("httpEndpointRef");
            this.serverIOTimeout = (Long)config.get("serverIOTimeout");
            this.wsServerIOTimeout = (Long)config.get("wsServerIOTimeout");
            this.wsServerIdleTimeout = (Long)config.get("wsServerIdleTimeout");
            this.connectTimeout = (Long)config.get("connectTimeout");
            this.extendedHandshake = (Boolean)config.get("extendedHandshake");
            this.waitForContinue = (Boolean)config.get("waitForContinue");
            this.LogFileName = (String)config.get("logFileName");
            this.LogDirLocation = (String)config.get("logDirLocation");
            this.serverIOTimeoutRetry = (Integer)config.get("serverIOTimeoutRetry");
            this.loadBalanceWeight = (Integer)config.get("loadBalanceWeight");
            Role role = this.roleKind = config.get("serverRole") != null && ((String)config.get("serverRole")).equals("BACKUP") ? Role.SECONDARY : Role.PRIMARY;
            if (config.get("ESIEnable") != null) {
                this.ESIEnable = (Boolean)config.get("ESIEnable");
            }
            if (config.get("ESIMaxCacheSize") != null) {
                this.ESIMaxCacheSize = (Integer)config.get("ESIMaxCacheSize");
            }
            if (config.get("ESIInvalidationMonitor") != null) {
                this.ESIInvalidationMonitor = (Boolean)config.get("ESIInvalidationMonitor");
            }
            if (config.get("ESIEnableToPassCookies") != null) {
                this.ESIEnableToPassCookies = (Boolean)config.get("ESIEnableToPassCookies");
            }
            this.TrustedProxyEnable = (Boolean)config.get("trustedProxyEnable");
            String proxyList = (String)config.get("trustedProxyGroup");
            if (proxyList != null) {
                this.TrustedProxyGroup = proxyList.split(",");
            }
            this.extraConfigProperties.put("ASDisableNagle", "false");
            this.extraConfigProperties.put("AcceptAllContent", "false");
            this.extraConfigProperties.put("AppServerPortPreference", "HostHeader");
            this.extraConfigProperties.put("ChunkedResponse", "false");
            this.extraConfigProperties.put("FIPSEnable", "false");
            this.extraConfigProperties.put("IISDisableNagle", "false");
            this.extraConfigProperties.put("IISPluginPriority", "High");
            this.extraConfigProperties.put("IgnoreDNSFailures", "false");
            this.extraConfigProperties.put("RefreshInterval", "60");
            this.extraConfigProperties.put("ResponseChunkSize", "64");
            this.extraConfigProperties.put("SSLConsolidate", "false");
            this.extraConfigProperties.put("TrustedProxyEnable", "false");
            this.extraConfigProperties.put("VHostMatchingCompat", "false");
            if (config.get("extraConfigProperties.0.config.referenceType") != null) {
                for (Map.Entry<String, Object> entry : config.entrySet()) {
                    if (!entry.getKey().startsWith("extraConfigProperties.0") || entry.getKey().equals("extraConfigProperties.0.config.referenceType")) continue;
                    String value = (String)config.get(entry.getKey());
                    String key = entry.getKey().substring(24);
                    this.extraConfigProperties.put(key, value);
                }
            }
        }

        protected ServerClusterData createServerCluster(String cName, boolean singleServerConfig) {
            ServerClusterData scd = new ServerClusterData(cName, singleServerConfig);
            scd.loadBalance = this.loadBalance;
            scd.retryInterval = this.retryInterval;
            scd.serverIOTimeoutRetry = this.serverIOTimeoutRetry;
            scd.removeSpecialHeaders = this.removeSpecialHeaders;
            scd.cloneSeparatorChange = this.cloneSeparatorChange;
            scd.postSizeLimit = this.postSizeLimit;
            scd.postBufferSize = this.postBufferSize;
            scd.GetDWLMTable = this.GetDWLMTable;
            return scd;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"PluginConfigData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   PluginInstallRoot       : " + this.PluginInstallRoot), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   PluginConfigFileName    : " + this.PluginConfigFileName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   httpEndpointRef         : " + this.httpEndpointPid), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   webserver http port     : " + this.webServerHttpPort), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   webserver https port    : " + this.webServerHttpsPort), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogFile                 : " + this.LogFile), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogLevel                : " + this.LogLevel), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   LogDirLocation         : " + this.LogDirLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIEnable               : " + this.ESIEnable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIMaxCacheSize         : " + this.ESIMaxCacheSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIInvalidationMonitor  : " + this.ESIInvalidationMonitor), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   ESIEnableToPassCookies  : " + this.ESIEnableToPassCookies), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   loadBalance             : " + this.loadBalance), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   IgnoreAffinityRequests  : " + this.ignoreAffinityRequests), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   retryInterval           : " + this.retryInterval), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeoutRetry    : " + this.serverIOTimeoutRetry), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   removeSpecialHeaders    : " + this.removeSpecialHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cloneSeparatorChange    : " + this.cloneSeparatorChange), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postSizeLimit           : " + this.postSizeLimit), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   postBufferSize          : " + this.postBufferSize), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   serverIOTimeout         : " + this.serverIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIOTimeout       : " + this.wsServerIOTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   wsServerIdleTimeout     : " + this.wsServerIdleTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   GetDWLMTable            : " + this.GetDWLMTable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   HTTPMaxHeaders          : " + this.HTTPMaxHeaders), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   CertLabel               : " + this.CertLabel), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   KeyringLocation         : " + this.KeyringLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   StashfileLocation       : " + this.StashfileLocation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   TrustedProxyEnable      : " + this.TrustedProxyEnable), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   TrustedProxyGroup       : " + this.traceList(this.TrustedProxyGroup)), (Object[])new Object[0]);
                if (!this.extraConfigProperties.isEmpty()) {
                    Tr.debug((TraceComponent)trace, (String)("   AdditionalConfigProps   : " + this.extraConfigProperties.toString()), (Object[])new Object[0]);
                }
            }
        }

        private String traceList(String[] list) {
            if (list == null || list.length == 0) {
                return "none";
            }
            StringBuilder sb = new StringBuilder();
            for (String element : list) {
                sb.append("\n\t").append(element);
            }
            return sb.toString();
        }
    }

    protected static class URIData {
        protected String uriName;
        protected String cookieName;
        protected String urlCookieName;

        public URIData(String uName, String cName, String urlName) {
            this.uriName = uName;
            this.cookieName = cName;
            this.urlCookieName = urlName;
        }

        public void print(TraceComponent trace) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)trace, (String)"URIData details:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   uriName       : " + this.uriName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   cookieName    : " + this.cookieName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)trace, (String)("   urlCookieName : " + this.urlCookieName), (Object[])new Object[0]);
            }
        }

        public int hashCode() {
            int result = this.uriName.hashCode();
            result = 31 * result + this.cookieName.hashCode();
            result = 31 * result + this.urlCookieName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !(obj instanceof URIData)) {
                return false;
            }
            URIData that = (URIData)obj;
            return this.uriName.equals(that.uriName);
        }
    }

    protected static class VHostData {
        protected final String host;
        protected final int port;

        protected VHostData(String inHost, int inPort) throws UnknownHostException {
            this.host = inHost;
            this.port = inPort;
        }

        protected VHostData(String alias) throws UnknownHostException {
            int lastIndex = alias.lastIndexOf(58);
            this.host = alias.substring(0, lastIndex);
            this.port = Integer.valueOf(alias.substring(lastIndex + 1));
        }

        public String toString() {
            return "vhost(http=" + this.host + ':' + this.port + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VHostData other = (VHostData)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }
    }

    protected static class ClusterUriGroup {
        protected String clusterName;
        protected String uriGroupName;
        protected String vhostName;

        protected ClusterUriGroup(String vhostName, String clusterName, String uriGroupName) {
            this.vhostName = vhostName;
            this.clusterName = clusterName;
            this.uriGroupName = uriGroupName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
            result = 31 * result + (this.uriGroupName == null ? 0 : this.uriGroupName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClusterUriGroup other = (ClusterUriGroup)obj;
            if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            return !(this.uriGroupName == null ? other.uriGroupName != null : !this.uriGroupName.equals(other.uriGroupName));
        }
    }

    protected static enum Role {
        PRIMARY,
        SECONDARY;

    }
}

