/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.cxf.common.util.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ConfigFacade {
    static final long serialVersionUID = 7901251124437548518L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ConfigFacade() {
    }

    private static Optional<Config> config() {
        Config c;
        try {
            c = ConfigProvider.getConfig();
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.microprofile.client.config.ConfigFacade", (String)"41", null, (Object[])new Object[0]);
            c = null;
        }
        return Optional.ofNullable(c);
    }

    public static <T> Optional<T> getOptionalValue(String propertyName, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        return c.isPresent() ? c.get().getOptionalValue(propertyName, clazz) : Optional.empty();
    }

    public static <T> Optional<T> getOptionalValue(String propertyNameFormat, Class<?> clientIntf, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        if (c.isPresent()) {
            String propertyName = String.format(propertyNameFormat, clientIntf.getName());
            Object value = c.get().getOptionalValue(propertyName, clazz).orElseGet(() -> {
                RegisterRestClient anno = clientIntf.getAnnotation(RegisterRestClient.class);
                if (anno != null && !StringUtils.isEmpty((String)ConfigFacade.getConfigKey(anno))) {
                    String configKeyPropName = String.format(propertyNameFormat, ConfigFacade.getConfigKey(anno));
                    return ((Config)c.get()).getOptionalValue(configKeyPropName, clazz).orElse(null);
                }
                return null;
            });
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    public static <T> T getValue(String propertyName, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        return (T)(c.isPresent() ? c.get().getValue(propertyName, clazz) : null);
    }

    public static <T> T getValue(String propertyNameFormat, Class<?> clientIntf, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        Object value = null;
        if (c.isPresent()) {
            String propertyName = String.format(propertyNameFormat, clientIntf.getName());
            value = c.get().getOptionalValue(propertyName, clazz).orElseGet(() -> {
                RegisterRestClient anno = clientIntf.getAnnotation(RegisterRestClient.class);
                if (anno != null && !StringUtils.isEmpty((String)ConfigFacade.getConfigKey(anno))) {
                    String configKeyPropName = String.format(propertyNameFormat, ConfigFacade.getConfigKey(anno));
                    return ((Config)c.get()).getValue(configKeyPropName, clazz);
                }
                return null;
            });
        }
        return (T)value;
    }

    public static OptionalLong getOptionalLong(String propName) {
        Optional<Config> c = ConfigFacade.config();
        Optional opt = c.isPresent() ? c.get().getOptionalValue(propName, Long.class) : Optional.empty();
        return opt.isPresent() ? OptionalLong.of((Long)opt.get()) : OptionalLong.empty();
    }

    public static OptionalLong getOptionalLong(String propNameFormat, Class<?> clientIntf) {
        Optional<Config> c = ConfigFacade.config();
        if (c.isPresent()) {
            String propertyName = String.format(propNameFormat, clientIntf.getName());
            Long value = c.get().getOptionalValue(propertyName, Long.class).orElseGet(() -> {
                RegisterRestClient anno = clientIntf.getAnnotation(RegisterRestClient.class);
                if (anno != null && !StringUtils.isEmpty((String)ConfigFacade.getConfigKey(anno))) {
                    String configKeyPropName = String.format(propNameFormat, ConfigFacade.getConfigKey(anno));
                    return ((Config)c.get()).getOptionalValue(configKeyPropName, Long.class).orElse(null);
                }
                return null;
            });
            return value == null ? OptionalLong.empty() : OptionalLong.of(value);
        }
        return OptionalLong.empty();
    }

    @FFDCIgnore(value={Throwable.class})
    private static String getConfigKey(RegisterRestClient anno) {
        try {
            return anno.configKey();
        }
        catch (Throwable t) {
            return "";
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConfigFacade.class, null, null);
    }
}

