/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.context.service.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.context.service.serializable.ContextualCallable;
import com.ibm.ws.context.service.serializable.ContextualInvocationHandler;
import com.ibm.ws.context.service.serializable.ContextualRunnable;
import com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.context.manager", configurationPolicy=ConfigurationPolicy.IGNORE, service={WSContextService.class}, property={"service.pid=com.ibm.ws.context.manager", "default.for=contextService", "service.ranking:Integer=100"})
public class ThreadContextManager
implements WSContextService {
    private static final String COMPONENT_NAME = "component.name";
    private final Set<String> alwaysEnabled = Collections.newSetFromMap(new ConcurrentHashMap());
    MetaDataIdentifierService metadataIdentifierService;
    final ConcurrentServiceReferenceMap<String, ThreadContextProvider> threadContextProviders = new ConcurrentServiceReferenceMap("threadContextProvider");
    static final long serialVersionUID = 3513608484245697656L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext context) {
        this.threadContextProviders.activate(context);
    }

    @Override
    public ThreadContextDescriptor captureThreadContext(Map<String, String> executionProperties, Map<String, ?> ... additionalThreadContextConfig) {
        Map<String, Map<String, ?>> threadContextConfigurations;
        Map<String, String> map = executionProperties = executionProperties == null ? new TreeMap<String, String>() : new TreeMap<String, String>(executionProperties);
        if (additionalThreadContextConfig.length > 0) {
            threadContextConfigurations = new HashMap();
            for (Map<String, ?> config : additionalThreadContextConfig) {
                String providerName = (String)config.get("threadContextProvider");
                if (providerName == null) {
                    throw new IllegalArgumentException("additionalThreadContextConfig: " + config);
                }
                threadContextConfigurations.put(providerName, config);
            }
        } else {
            threadContextConfigurations = Collections.emptyMap();
        }
        return this.captureThreadContext(threadContextConfigurations, executionProperties);
    }

    public ThreadContextDescriptor captureThreadContext(final Map<String, Map<String, ?>> threadContextConfigurations, Map<String, String> execProps) {
        int initialCapacity = threadContextConfigurations == null ? 5 : threadContextConfigurations.size() + 5;
        final ThreadContextDescriptorImpl capturedThreadContext = new ThreadContextDescriptorImpl(execProps, initialCapacity, this);
        if (!"ALL_CONTEXT_TYPES".equals(execProps.get("com.ibm.ws.concurrent.DEFAULT_CONTEXT"))) {
            ThreadContextProvider provider;
            int i;
            final ArrayList configuredProviders = new ArrayList(threadContextConfigurations.size());
            final ArrayList configuredProviderProps = new ArrayList(threadContextConfigurations.size());
            final ArrayList alwaysEnabledProviders = new ArrayList(this.alwaysEnabled.size());
            final ArrayList alwaysEnabledProviderNames = new ArrayList(this.alwaysEnabled.size());
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 7405486040208608117L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    if (threadContextConfigurations != null) {
                        for (Map.Entry threadContextConfig : threadContextConfigurations.entrySet()) {
                            ThreadContextProvider provider;
                            String threadContextProviderName = (String)threadContextConfig.getKey();
                            if (capturedThreadContext.providerNamesToSkip.contains(threadContextProviderName) || (provider = (ThreadContextProvider)ThreadContextManager.this.threadContextProviders.getService((Object)threadContextProviderName)) == null) continue;
                            configuredProviders.add(provider);
                            configuredProviderProps.add(threadContextConfig);
                        }
                    }
                    for (String threadContextProviderName : ThreadContextManager.this.alwaysEnabled) {
                        if (capturedThreadContext.providerNamesToSkip.contains(threadContextProviderName)) continue;
                        ThreadContextProvider provider = (ThreadContextProvider)ThreadContextManager.this.threadContextProviders.getServiceWithException((Object)threadContextProviderName);
                        alwaysEnabledProviders.add(provider);
                        alwaysEnabledProviderNames.add(threadContextProviderName);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
                }
            });
            for (i = 0; i < configuredProviders.size(); ++i) {
                provider = (ThreadContextProvider)configuredProviders.get(i);
                Map.Entry threadContextConfig = (Map.Entry)configuredProviderProps.get(i);
                ThreadContext context = provider.captureThreadContext(execProps, (Map)threadContextConfig.getValue());
                capturedThreadContext.add((String)threadContextConfig.getKey(), context);
            }
            for (i = 0; i < alwaysEnabledProviders.size(); ++i) {
                provider = (ThreadContextProvider)alwaysEnabledProviders.get(i);
                ThreadContext context = provider.captureThreadContext(execProps, null);
                capturedThreadContext.add((String)alwaysEnabledProviderNames.get(i), context);
            }
        }
        return capturedThreadContext;
    }

    @Override
    public <T> T createContextualProxy(ThreadContextDescriptor threadContextDescriptor, T instance, final Class<T> intf) {
        if (intf == null || !intf.isInstance(instance)) {
            throw new IllegalArgumentException(instance + ", " + (intf == null ? null : intf.getName()));
        }
        if (Callable.class.equals(intf)) {
            Callable callable = (Callable)instance;
            instance = intf.cast(new ContextualCallable(threadContextDescriptor, callable, null));
        } else if (Runnable.class.equals(intf)) {
            instance = intf.cast(new ContextualRunnable(threadContextDescriptor, (Runnable)instance, null));
        } else {
            final ContextualInvocationHandler handler = new ContextualInvocationHandler(threadContextDescriptor, instance, null);
            instance = AccessController.doPrivileged(new PrivilegedAction<T>(){
                static final long serialVersionUID = 5257565129821746454L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public T run() {
                    return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, handler));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
                }
            });
        }
        return instance;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.threadContextProviders.deactivate(context);
    }

    @Modified
    protected void modified(ComponentContext context) {
    }

    @Reference(service=MetaDataIdentifierService.class)
    protected void setMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = svc;
    }

    @Reference(name="threadContextProvider", service=ThreadContextProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setThreadContextProvider(ServiceReference<ThreadContextProvider> ref) {
        String threadContextProviderName = (String)ref.getProperty(COMPONENT_NAME);
        this.threadContextProviders.putReference((Object)threadContextProviderName, ref);
        if (Boolean.TRUE.equals(ref.getProperty("alwaysCaptureThreadContext"))) {
            this.alwaysEnabled.add(threadContextProviderName);
        }
    }

    protected void unsetMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = null;
    }

    protected void unsetThreadContextProvider(ServiceReference<ThreadContextProvider> ref) {
        String threadContextProviderName = (String)ref.getProperty(COMPONENT_NAME);
        if (this.threadContextProviders.removeReference((Object)threadContextProviderName, ref) && Boolean.TRUE.equals(ref.getProperty("alwaysCaptureThreadContext"))) {
            this.alwaysEnabled.remove(threadContextProviderName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ThreadContextManager.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
    }
}

