/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceChangeListener;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChangeWatcher
extends TimerTask {
    public static final long DEFAULT_POLL_FREQUENCY = 43200000L;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 0;
    private final Logger log;
    private Resource watchedResource;
    private long pollFrequency;
    private int maxRetryAttempts;
    private int currentRetryAttempts;
    private boolean resourceExist;
    private DateTime lastModification;
    private List<ResourceChangeListener> resourceListeners;

    public ResourceChangeWatcher(Resource resource) throws ResourceException {
        this(resource, 43200000L, 0);
    }

    public ResourceChangeWatcher(Resource resource, long pollingFrequency) throws ResourceException {
        this(resource, pollingFrequency, 0);
    }

    public ResourceChangeWatcher(Resource resource, long pollingFrequency, int retryAttempts) throws ResourceException {
        block7: {
            this.log = LoggerFactory.getLogger(ResourceChangeWatcher.class);
            if (resource == null) {
                throw new NullPointerException("Watched resource is null");
            }
            if (pollingFrequency <= 0L) {
                throw new IllegalArgumentException("Polling frequency must be greater than zero");
            }
            if (retryAttempts < 0) {
                throw new IllegalArgumentException("Max retry attempts must be greater than, or equal to, zero");
            }
            this.watchedResource = resource;
            this.pollFrequency = pollingFrequency;
            this.maxRetryAttempts = retryAttempts;
            this.currentRetryAttempts = 0;
            this.resourceListeners = new ArrayList<ResourceChangeListener>(5);
            this.log.debug("Watching resource: " + this.watchedResource.getLocation() + ", polling frequency: {}ms, max retry attempts: {}", (Object)this.pollFrequency, (Object)this.maxRetryAttempts);
            try {
                if (this.watchedResource.exists()) {
                    this.resourceExist = true;
                    this.lastModification = this.watchedResource.getLastModifiedTime();
                } else {
                    this.resourceExist = false;
                }
            }
            catch (ResourceException e) {
                this.log.warn("Resource " + this.watchedResource.getLocation() + " could not be accessed", (Throwable)e);
                ++this.currentRetryAttempts;
                if (this.currentRetryAttempts < this.maxRetryAttempts) break block7;
                this.log.error("Resource {} was not accessible at time of ResourceChangeWatcher construction and max retrys are exceeded", (Object)this.watchedResource.getLocation());
                throw e;
            }
        }
    }

    public long getPollingFrequency() {
        return this.pollFrequency;
    }

    public List<ResourceChangeListener> getResourceListeners() {
        return this.resourceListeners;
    }

    @Override
    public void run() {
        block8: {
            try {
                this.log.trace("Checking resource for changes: {}", (Object)this.watchedResource.getLocation());
                if (this.watchedResource.exists()) {
                    if (!this.resourceExist) {
                        this.resourceExist = true;
                        this.signalListeners(ResourceChangeListener.ResourceChange.CREATION);
                        this.lastModification = this.watchedResource.getLastModifiedTime();
                    } else if (this.lastModification.isBefore((ReadableInstant)this.watchedResource.getLastModifiedTime())) {
                        this.signalListeners(ResourceChangeListener.ResourceChange.UPDATE);
                        this.lastModification = this.watchedResource.getLastModifiedTime();
                    }
                } else if (this.resourceExist) {
                    this.resourceExist = false;
                    this.signalListeners(ResourceChangeListener.ResourceChange.DELETE);
                }
                this.currentRetryAttempts = 0;
            }
            catch (ResourceException e) {
                this.log.warn("Resource " + this.watchedResource.getLocation() + " could not be accessed", (Throwable)e);
                ++this.currentRetryAttempts;
                if (this.currentRetryAttempts < this.maxRetryAttempts) break block8;
                this.cancel();
                this.log.error("Resource {} was not accessible for max number of retry attempts.  This resource will no longer be watched", (Object)this.watchedResource.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalListeners(ResourceChangeListener.ResourceChange changeType) {
        List<ResourceChangeListener> list = this.resourceListeners;
        synchronized (list) {
            switch (changeType) {
                case CREATION: {
                    this.log.debug("Publishing creation event for resource: {}", (Object)this.watchedResource.getLocation());
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceCreate(this.watchedResource);
                    }
                    break;
                }
                case UPDATE: {
                    this.log.debug("Publishing update event for resource: {}", (Object)this.watchedResource.getLocation());
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceUpdate(this.watchedResource);
                    }
                    break;
                }
                case DELETE: {
                    this.log.debug("Publishing delete event for resource: {}", (Object)this.watchedResource.getLocation());
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceDelete(this.watchedResource);
                    }
                    break;
                }
            }
        }
    }
}

