/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class Filter {
    static final String delimiters = " \t\r\n";
    private final ArrayList<Object> expression = new ArrayList(3);
    private String filterString = null;
    static final long serialVersionUID = 2731541258680266210L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Filter(String filter) {
        if (filter == null) {
            return;
        }
        this.filterString = filter;
        int idx = 0;
        while (idx != -1 && idx < filter.length()) {
            int begin = idx;
            if ((idx = filter.indexOf("%v", idx)) != -1) {
                this.expression.add(filter.substring(begin, idx));
                SubExpr tok = new SubExpr();
                this.expression.add(tok);
                idx += 2;
                int digit = 0;
                while (idx < filter.length() && Character.isDigit(filter.charAt(idx))) {
                    digit = 10 * digit + Character.digit(filter.charAt(idx), 10);
                    ++idx;
                }
                if (digit != 0) {
                    tok.end = --digit;
                }
                tok.start = digit;
                if (idx >= filter.length() || filter.charAt(idx) != '-') continue;
                tok.end = -1;
                ++idx;
                digit = 0;
                while (idx < filter.length() && Character.isDigit(filter.charAt(idx))) {
                    digit = 10 * digit + Character.digit(filter.charAt(idx), 10);
                    ++idx;
                }
                if (digit == 0) continue;
                tok.end = digit - 1;
                continue;
            }
            this.expression.add(filter.substring(begin));
        }
    }

    public String prepare(String toks) {
        ArrayList<SubExpr> tokens = new ArrayList<SubExpr>(3);
        int idx = 0;
        while (idx != -1 && (idx = this.skipDelimiters(toks, idx)) != -1) {
            SubExpr se = new SubExpr();
            se.start = idx;
            tokens.add(se);
            idx = this.skipNonDelimiters(toks, idx);
            if (idx == -1) {
                idx = toks.length();
            }
            se.end = idx;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.expression.size(); ++i) {
            Object o = this.expression.get(i);
            if (o instanceof SubExpr) {
                SubExpr t = (SubExpr)o;
                if (t.start >= tokens.size()) continue;
                int endIdx = t.end;
                if (endIdx == -1 || endIdx >= tokens.size()) {
                    endIdx = tokens.size() - 1;
                }
                SubExpr begin = (SubExpr)tokens.get(t.start);
                SubExpr end = (SubExpr)tokens.get(endIdx);
                sb.append(toks, begin.start, end.end);
                continue;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    private int skipDelimiters(String token, int idx) {
        if (token == null) {
            return -1;
        }
        int len = token.length();
        while (idx < token.length() && delimiters.indexOf(token.charAt(idx)) >= 0) {
            ++idx;
        }
        if (idx == len) {
            idx = -1;
        }
        return idx;
    }

    private int skipNonDelimiters(String token, int idx) {
        int len = token.length();
        while (idx < token.length() && delimiters.indexOf(token.charAt(idx)) < 0) {
            ++idx;
        }
        if (idx == len) {
            idx = -1;
        }
        return idx;
    }

    public String toString() {
        return this.filterString;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Filter.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SubExpr {
        static final int ALL = -1;
        public int start = 0;
        public int end = -1;
        static final long serialVersionUID = 9141674284378656528L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SubExpr() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SubExpr.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
        }
    }
}

