/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Comparator;

public class ExpiryIndex {
    private static TraceComponent tc = SibTr.register(ExpiryIndex.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private GBSTree tree = null;
    private GBSTree.Iterator iterator = null;
    private int size = 0;

    public ExpiryIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.tree = new GBSTree(2, 10, (Comparator)new ExpiryComparator(), (Comparator)new ExpiryComparator());
        this.iterator = this.tree.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean put(ExpirableReference expirable) {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)("ObjId=" + expirable.getID() + " ET=" + expirable.getExpiryTime()));
        }
        if (reply = this.tree.insert((Object)expirable)) {
            ++this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)("reply=" + reply));
        }
        return reply;
    }

    public boolean remove() {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove");
        }
        if (reply = this.iterator.remove()) {
            --this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("reply=" + reply));
        }
        return reply;
    }

    public boolean remove(ExpirableReference expirable) {
        boolean reply;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)(expirable == null ? "null" : "ObjId=" + expirable.getID() + " ET=" + expirable.getExpiryTime()));
        }
        if (reply = this.tree.delete((Object)expirable)) {
            --this.size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("reply=" + reply));
        }
        return reply;
    }

    public void resetIterator() {
        this.iterator.reset();
    }

    public int size() {
        return this.size;
    }

    public ExpirableReference next() {
        return (ExpirableReference)this.iterator.next();
    }

    private static class ExpiryComparator
    implements Comparator {
        private ExpiryComparator() {
        }

        public int compare(Object o1, Object o2) {
            long time2;
            ExpirableReference ref1 = (ExpirableReference)o1;
            ExpirableReference ref2 = (ExpirableReference)o2;
            long time1 = ref1.getExpiryTime();
            if (time1 == (time2 = ref2.getExpiryTime())) {
                long id2;
                long id1 = ref1.getID();
                if (id1 == (id2 = ref2.getID())) {
                    return 0;
                }
                if (id1 < id2) {
                    return -1;
                }
                return 1;
            }
            if (time1 < time2) {
                return -1;
            }
            return 1;
        }
    }
}

