/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld.injection;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.impl.weld.injection.EEValidationUtils;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionServices;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionTargetListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.jboss.weld.injection.spi.InjectionContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSphereInjectionServicesImpl
implements WebSphereInjectionServices {
    static final TraceComponent tc = Tr.register(WebSphereInjectionServicesImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private static final Set<Class<?>> ANNOTATIONS_KNOWN_TO_WELD = new HashSet<Class>(Arrays.asList(Inject.class));
    private final Map<Class<?>, ReferenceContext> referenceContextMap = new HashMap();
    private final Set<ReferenceContext> referenceContexts = new HashSet<ReferenceContext>();
    private final Map<Object, WebSphereInjectionTargetListener<?>> injectionTargetListeners = new ConcurrentHashMap();
    private final WebSphereCDIDeployment deployment;
    static final long serialVersionUID = 2515575801175940133L;

    public WebSphereInjectionServicesImpl(WebSphereCDIDeployment webSphereCDIDeployment) {
        this.deployment = webSphereCDIDeployment;
    }

    public void addReferenceContext(ReferenceContext referenceContext) {
        this.referenceContexts.add(referenceContext);
        Set classes = referenceContext.getProcessedInjectionClasses();
        for (Class clazz : classes) {
            this.referenceContextMap.put(clazz, referenceContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void injectJavaEEResources(InjectionContext<?> injectionContext) {
        block6: {
            if (injectionContext != null) {
                try {
                    Boolean hasTarget = this.callInject(injectionContext);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"hasTarget [" + hasTarget + "]"});
                    }
                    break block6;
                }
                catch (PrivilegedActionException hasTarget) {
                    void pae;
                    FFDCFilter.processException((Throwable)hasTarget, (String)"com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl", (String)"115", (Object)this, (Object[])new Object[]{injectionContext});
                    Exception e = pae.getException();
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"cdi.resource.injection.error.CWOWB1000E", (Object[])new Object[]{e.getLocalizedMessage()});
                    }
                    break block6;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inject - null mbInstance", (Object[])new Object[0]);
            }
        }
    }

    private Boolean callInject(final InjectionContext<?> injectionContext) throws PrivilegedActionException {
        Boolean hasTargets = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
            static final long serialVersionUID = -5419228756370803152L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() throws Exception {
                Boolean hasTargets = WebSphereInjectionServicesImpl.this.inject(injectionContext);
                return hasTargets;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
        return hasTargets;
    }

    @ManualTrace
    private Boolean inject(InjectionContext<?> injectionContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inject", (Object[])new Object[]{Util.identity(injectionContext)});
        }
        Boolean hasTargets = Boolean.FALSE;
        Object toInject = injectionContext.getTarget();
        Class toInjectClass = injectionContext.getAnnotatedType().getJavaClass();
        hasTargets = this.inject(toInject, toInjectClass, injectionContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject", (Object)hasTargets);
        }
        return hasTargets;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private Boolean inject(Object toInject, Class<?> toInjectClass, InjectionContext<?> injectionContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inject", (Object[])new Object[]{Util.identity((Object)toInject), Util.identity(injectionContext)});
        }
        Boolean hasTargets = Boolean.FALSE;
        InjectionTarget[] targets = this.getInjectionTargets(toInjectClass, toInject);
        if (null != targets && targets.length > 0) {
            hasTargets = Boolean.TRUE;
            WebSphereInjectionTargetListener<?> listener = null;
            if (toInject != null) {
                listener = this.injectionTargetListeners.get(toInject);
            }
            for (InjectionTarget target : targets) {
                if (ANNOTATIONS_KNOWN_TO_WELD.contains(target.getInjectionBinding().getAnnotationType())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"skipping --> [" + target + "]"});
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"about to inject resource --> [" + target + "]"});
                    }
                    try {
                        InjectionTargetContext ctx = listener != null ? listener.getCurrentInjectionTargetContext() : new InjectionTargetContext(){
                            static final long serialVersionUID = -1685014250234261546L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            public <T> T getInjectionTargetContextData(Class<T> arg0) {
                                return null;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(2.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
                            }
                        };
                        target.inject(toInject, ctx);
                    }
                    catch (Exception ctx) {
                        void e;
                        FFDCFilter.processException((Throwable)ctx, (String)"com.ibm.ws.cdi.impl.weld.injection.WebSphereInjectionServicesImpl", (String)"198", (Object)this, (Object[])new Object[]{toInject, toInjectClass, injectionContext});
                        if (tc.isErrorEnabled()) {
                            Tr.error((TraceComponent)tc, (String)"cdi.resource.injection.error.CWOWB1000E", (Object[])new Object[]{e.getMessage()});
                        }
                        FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".inject"), (String)"248", (Object)this);
                        throw e;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injected resource --> [" + target + "]"});
                    }
                }
                if (listener == null) continue;
                listener.injectionTargetProcessed(target);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject");
        }
        return hasTargets;
    }

    public InjectionTarget[] getInjectionTargets(Class<?> clazz) throws InjectionException {
        return this.getInjectionTargets(clazz, null);
    }

    private InjectionTarget[] getInjectionTargets(Class<?> clazz, Object toInject) throws InjectionException {
        ReferenceContext referenceContext;
        Class<?> injectionClass = null;
        if (toInject != null) {
            injectionClass = toInject.getClass();
            if (CDIUtils.isWeldProxy((Object)toInject)) {
                injectionClass = injectionClass.getSuperclass();
            }
        } else {
            injectionClass = clazz;
        }
        if ((referenceContext = this.referenceContextMap.get(injectionClass)) == null) {
            referenceContext = this.findReferenceContext(injectionClass);
        }
        InjectionTarget[] targets = null;
        if (referenceContext != null) {
            targets = referenceContext.getInjectionTargets(injectionClass);
            if (targets != null && targets.length > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " injection targets found " + Arrays.asList(targets)});
                }
                for (InjectionTarget target : targets) {
                    Class<?> declaringClass = target.getMember().getDeclaringClass();
                    if (declaringClass == injectionClass || this.referenceContextMap.containsKey(declaringClass)) continue;
                    this.referenceContextMap.put(declaringClass, referenceContext);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " no injection targets found"});
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInjectionTargets", (Object[])new Object[]{injectionClass + " ReferenceContext not found"});
        }
        return targets;
    }

    private ReferenceContext findReferenceContext(Class<?> injectionClass) {
        ReferenceContext referenceContext = null;
        for (ReferenceContext ctx : this.referenceContexts) {
            Set clazzes = ctx.getProcessedInjectionClasses();
            if (!clazzes.contains(injectionClass)) continue;
            referenceContext = ctx;
            this.addReferenceContext(referenceContext);
        }
        return referenceContext;
    }

    public void cleanup() {
        this.injectionTargetListeners.clear();
    }

    public <T> void aroundInject(final InjectionContext<T> injectionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Annotations: " + injectionContext.getAnnotatedType()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Perform EE injection.", (Object[])new Object[0]);
        }
        this.injectJavaEEResources(injectionContext);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 962337104050454235L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                injectionContext.proceed();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
    }

    @ManualTrace
    public <T> void registerInjectionTarget(javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType) {
        Class declaringClass;
        WebSphereBeanDeploymentArchive wbda;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerInjectionTarget", (Object[])new Object[]{injectionTarget, Util.identity(annotatedType)});
        }
        if ((wbda = this.deployment.getBeanDeploymentArchiveFromClass(declaringClass = annotatedType.getJavaClass())) != null) {
            CDIArchive cdiArchive = wbda.getArchive();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Injection Target Annotations: " + annotatedType.getAnnotations()), (Object[])new Object[0]);
            }
            for (Annotated annotated : annotatedType.getFields()) {
                this.validateAnnotatedMember(annotated, annotatedType.getJavaClass(), cdiArchive);
            }
            for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
                this.validateAnnotatedMethod(annotatedMethod, declaringClass, cdiArchive);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerInjectionTarget");
        }
    }

    @ManualTrace
    private <T> void validateAnnotatedMethod(AnnotatedMethod<T> annotatedMethod, Class<?> declaringClass, CDIArchive cdiArchive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateAnnotatedMethod", (Object[])new Object[]{Util.identity(annotatedMethod), declaringClass, cdiArchive});
        }
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter injectedParameter : parameters) {
            this.validateAnnotatedMember((Annotated)injectedParameter, declaringClass, cdiArchive);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateAnnotatedMethod");
        }
    }

    @ManualTrace
    private void validateAnnotatedMember(Annotated annotated, Class<?> declaringClass, CDIArchive cdiArchive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateAnnotatedMember", (Object[])new Object[]{Util.identity((Object)annotated), declaringClass, cdiArchive});
        }
        for (Annotation annotation : annotated.getAnnotations()) {
            if (annotation instanceof EJB) {
                EEValidationUtils.validateEjb((EJB)annotation, declaringClass, annotated, cdiArchive);
                continue;
            }
            if (annotation instanceof Resource) {
                EEValidationUtils.validateResource((Resource)annotation, declaringClass, annotated, cdiArchive);
                continue;
            }
            if (annotation instanceof WebServiceRef) {
                EEValidationUtils.validateWebServiceRef((WebServiceRef)annotation, declaringClass, annotated);
                continue;
            }
            if (annotation instanceof PersistenceContext) {
                EEValidationUtils.validatePersistenceContext((PersistenceContext)annotation, declaringClass, annotated);
                continue;
            }
            if (!(annotation instanceof PersistenceUnit)) continue;
            EEValidationUtils.validatePersistenceUnit((PersistenceUnit)annotation, declaringClass, annotated);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateAnnotatedMember");
        }
    }

    public void registerInjectionTargetListener(WebSphereInjectionTargetListener<?> listener) {
        Object instance = listener.getObject();
        this.injectionTargetListeners.put(instance, listener);
    }

    public void deregisterInjectionTargetListener(WebSphereInjectionTargetListener<?> listener) {
        Object instance = listener.getObject();
        this.injectionTargetListeners.remove(instance);
    }
}

