/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.wsbnd.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.wsbnd.Port;
import com.ibm.ws.javaee.ddmodel.wsbnd.ServiceRef;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.PortType;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.PropertiesType;
import com.ibm.ws.javaee.ddmodel.wsbnd.internal.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServiceRefType
extends DDParser.ElementContentParsable
implements ServiceRef {
    private StringType name;
    private StringType componentName;
    private StringType portAddress;
    private StringType wsdlLocation;
    private Map<QName, PortType> portMap;
    private PropertiesType properties;
    static final long serialVersionUID = -4003650703281550365L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public String getName() {
        return this.name != null ? this.name.getValue() : null;
    }

    @Override
    public String getComponentName() {
        return this.componentName != null ? this.componentName.getValue() : null;
    }

    @Override
    public String getPortAddress() {
        return this.portAddress != null ? this.portAddress.getValue() : null;
    }

    @Override
    public String getWsdlLocation() {
        return this.wsdlLocation != null ? this.wsdlLocation.getValue() : null;
    }

    @Override
    public List<Port> getPorts() {
        ArrayList<PortType> portList = null;
        if (null != this.portMap) {
            portList = new ArrayList<PortType>(this.portMap.values());
        }
        return portList;
    }

    @Override
    public Map<String, String> getProperties() {
        return null != this.properties ? this.properties.getAttributes() : null;
    }

    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        boolean result = false;
        if (nsURI != null) {
            return result;
        }
        if ("name".equals(localName)) {
            this.name = parser.parseStringAttributeValue(index);
            result = true;
        } else if ("component-name".equals(localName)) {
            this.componentName = parser.parseStringAttributeValue(index);
            result = true;
        } else if ("port-address".equals(localName)) {
            this.portAddress = parser.parseStringAttributeValue(index);
            result = true;
        } else if ("wsdl-location".equals(localName)) {
            this.wsdlLocation = parser.parseStringAttributeValue(index);
            result = true;
        }
        return result;
    }

    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if ("port".equals(localName)) {
            PortType port = new PortType();
            parser.parse((DDParser.ParsableElement)port);
            String portName = port.getName();
            if (StringUtils.isEmpty(portName)) {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("name"));
            }
            this.addEndpoint(port);
            return true;
        }
        if ("properties".equals(localName)) {
            this.properties = new PropertiesType();
            parser.parse((DDParser.ParsableElement)this.properties);
            return true;
        }
        return false;
    }

    private void addEndpoint(PortType port) {
        String nameSpace = port.getNamespace();
        String portName = port.getName();
        if (null == this.portMap) {
            this.portMap = new HashMap<QName, PortType>();
        }
        QName portQName = StringUtils.buildQName(nameSpace, portName);
        this.portMap.put(portQName, port);
    }

    public void describe(DDParser.Diagnostics diag) {
        diag.describeIfSet("name", (DDParser.ParsableElement)this.name);
        diag.describeIfSet("component-name", (DDParser.ParsableElement)this.componentName);
        diag.describeIfSet("port-address", (DDParser.ParsableElement)this.portAddress);
        diag.describeIfSet("wsdl-location", (DDParser.ParsableElement)this.wsdlLocation);
        diag.describeIfSet("properties", (DDParser.ParsableElement)this.properties);
        diag.append("[port<");
        if (null != this.portMap) {
            String prefix = "";
            for (PortType port : this.portMap.values()) {
                diag.append(prefix);
                port.describe(diag);
                prefix = ",";
            }
        }
        diag.append(">]");
    }

    public static ServiceRefType createServiceRefType(StringType name, Map<QName, PortType> portMap) {
        ServiceRefType serviceRefType = new ServiceRefType();
        serviceRefType.name = name;
        serviceRefType.portMap = portMap;
        return serviceRefType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceRefType.class, null, null);
    }
}

