/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpServletResponseInjectionProxy
extends HttpServletResponseWrapper {
    private static final TraceComponent tc = Tr.register(HttpServletResponseInjectionProxy.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final Class<?> contextClass = HttpServletResponse.class;
    static final long serialVersionUID = -6359203209145065864L;

    public HttpServletResponseInjectionProxy() {
        super((HttpServletResponse)Proxy.newProxyInstance(priv.getClassLoader(contextClass), new Class[]{contextClass}, new InvocationHandler(){
            static final long serialVersionUID = -8147801969533687263L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @ManualTrace
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"invoke", (Object[])new Object[0]);
                }
                if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    String result = "Injection Proxy for " + contextClass.getName();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"invoke", (Object)result);
                    }
                    return result;
                }
                Object result = method.invoke((Object)HttpServletResponseInjectionProxy.getHttpServletResponse(), args);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"invoke", (Object)result);
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
            }
        }));
    }

    @ManualTrace
    private static HttpServletResponse getHttpServletResponse() {
        String methodName = "getHttpServletResponse";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHttpServletResponse", (Object[])new Object[0]);
        }
        InjectionRuntimeContext runtimeContext = InjectionRuntimeContextHelper.getRuntimeContext();
        Object context = runtimeContext.getRuntimeCtxObject(contextClass.getName());
        return (HttpServletResponse)context;
    }

    public String toString() {
        return "Injection Proxy for " + contextClass.getName();
    }

    public ServletResponse getResponse() {
        return HttpServletResponseInjectionProxy.getHttpServletResponse();
    }

    public boolean isWrapperFor(Class wrappedType) {
        if (!ServletResponse.class.isAssignableFrom(wrappedType)) {
            throw new IllegalArgumentException("Given class " + wrappedType.getName() + " not a subinterface of " + ServletResponse.class.getName());
        }
        Class wrappedServletType = wrappedType;
        HttpServletResponse response = HttpServletResponseInjectionProxy.getHttpServletResponse();
        if (wrappedServletType.isAssignableFrom(response.getClass())) {
            return true;
        }
        if (response instanceof ServletResponseWrapper) {
            return ((ServletResponseWrapper)response).isWrapperFor(wrappedType);
        }
        return false;
    }

    public boolean isWrapperFor(ServletResponse wrapped) {
        HttpServletResponse response = HttpServletResponseInjectionProxy.getHttpServletResponse();
        if (response == wrapped) {
            return true;
        }
        if (response instanceof ServletResponseWrapper) {
            return ((ServletResponseWrapper)response).isWrapperFor(wrapped);
        }
        return false;
    }

    public void setResponse(ServletResponse response) {
        throw new UnsupportedOperationException("ServletResponse may not be set on this proxy");
    }
}

