/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class UriEncoder {
    private static final Charset CHARSET_UTF_8;
    private static final char[] hexDigits;
    private static final byte[] normalizedHexDigits;
    private static final boolean[] isHexDigit;
    private static final boolean[] unreservedChars;
    private static final boolean[] userInfoChars;
    private static final boolean[] segmentChars;
    private static final boolean[] matrixChars;
    private static final boolean[] pathChars;
    private static final boolean[] queryChars;
    private static final boolean[] queryParamChars;
    private static final boolean[] fragmentChars;
    private static final boolean[] uriChars;
    private static final boolean[] uriTemplateChars;
    static final long serialVersionUID = -7532710359972937831L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private UriEncoder() {
    }

    private static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public static String encodeString(String string) {
        return UriEncoder.encode(string, false, unreservedChars);
    }

    public static String encodeUserInfo(String userInfo, boolean relax) {
        return UriEncoder.encode(userInfo, relax, userInfoChars);
    }

    public static String encodePathSegment(String segment, boolean relax) {
        return UriEncoder.encode(segment, relax, segmentChars);
    }

    public static String encodeMatrix(String matrix, boolean relax) {
        return UriEncoder.encode(matrix, relax, matrixChars);
    }

    public static String encodePath(String path, boolean relax) {
        return UriEncoder.encode(path, relax, pathChars);
    }

    public static String encodeQueryParam(String queryParam, boolean relax) {
        boolean[] unreserved = queryParamChars;
        String string = queryParam;
        if (queryParam == null) {
            return null;
        }
        if (!UriEncoder.needsEncoding(queryParam, false, unreserved)) {
            return string;
        }
        ByteBuffer buffer = CHARSET_UTF_8.encode(string);
        StringBuilder sb = new StringBuilder(buffer.remaining());
        while (buffer.hasRemaining()) {
            int position;
            byte c = buffer.get();
            if (c == 37 && relax && buffer.remaining() >= 2 && UriEncoder.isHex(buffer.get(position = buffer.position())) && UriEncoder.isHex(buffer.get(position + 1))) {
                sb.append((char)c);
                continue;
            }
            if (c >= 32 && unreserved[c]) {
                sb.append((char)c);
                continue;
            }
            if (c == 32) {
                sb.append('+');
                continue;
            }
            sb.append('%');
            sb.append(hexDigits[(c & 0xF0) >> 4]);
            sb.append(hexDigits[c & 0xF]);
        }
        return sb.toString();
    }

    public static String encodeQuery(String query, boolean relax) {
        return UriEncoder.encode(query, relax, queryChars);
    }

    public static String encodeFragment(String fragment, boolean relax) {
        return UriEncoder.encode(fragment, relax, fragmentChars);
    }

    public static String encodeUri(String uri, boolean relax) {
        return UriEncoder.encode(uri, relax, uriChars);
    }

    public static String encodeUriTemplate(String uriTemplate, boolean relax) {
        return UriEncoder.encode(uriTemplate, relax, uriTemplateChars);
    }

    private static String encode(String string, boolean relax, boolean[] unreserved) {
        if (string == null) {
            return null;
        }
        if (!UriEncoder.needsEncoding(string, false, unreserved)) {
            return string;
        }
        ByteBuffer buffer = CHARSET_UTF_8.encode(string);
        StringBuilder sb = new StringBuilder(buffer.remaining());
        while (buffer.hasRemaining()) {
            int position;
            byte c = buffer.get();
            if (c == 37 && relax && buffer.remaining() >= 2 && UriEncoder.isHex(buffer.get(position = buffer.position())) && UriEncoder.isHex(buffer.get(position + 1))) {
                sb.append((char)c);
                continue;
            }
            if (c >= 32 && unreserved[c]) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            sb.append(hexDigits[(c & 0xF0) >> 4]);
            sb.append(hexDigits[c & 0xF]);
        }
        return sb.toString();
    }

    private static boolean isHex(int c) {
        return isHexDigit[c];
    }

    private static boolean needsEncoding(String s, boolean relax, boolean[] unreserved) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%' && relax) continue;
            if (c > unreserved.length) {
                return true;
            }
            if (unreserved[c]) continue;
            return true;
        }
        return false;
    }

    public static String decodeQuery(String string) {
        return UriEncoder.decodeString(string, true, null);
    }

    public static String decodeString(String string) {
        return UriEncoder.decodeString(string, false, null);
    }

    public static String normalize(String string) {
        return UriEncoder.decodeString(string, false, unreservedChars);
    }

    private static String decodeString(String string, boolean query, boolean[] decodeChars) {
        if (string == null) {
            return null;
        }
        if (!UriEncoder.needsDecoding(string, query)) {
            return string;
        }
        int len = string.length();
        ByteBuffer buffer = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            int c = string.charAt(i);
            if (c == 37 && i + 2 < len) {
                int v = 0;
                int d1 = UriEncoder.decodeHexDigit(string.charAt(i + 1));
                int d2 = UriEncoder.decodeHexDigit(string.charAt(i + 2));
                if (d1 >= 0 && d2 >= 0) {
                    v = d1;
                    v = v << 4 | d2;
                    if (!(decodeChars == null || v < decodeChars.length && decodeChars[v])) {
                        buffer.put((byte)string.charAt(i));
                        buffer.put(normalizedHexDigits[string.charAt(i + 1)]);
                        buffer.put(normalizedHexDigits[string.charAt(i + 2)]);
                    } else {
                        buffer.put((byte)v);
                    }
                    i += 2;
                    continue;
                }
                buffer.put((byte)c);
                continue;
            }
            if (query && c == 43) {
                c = 32;
            }
            buffer.put((byte)c);
        }
        buffer.flip();
        return CHARSET_UTF_8.decode(buffer).toString();
    }

    private static boolean needsDecoding(String s, boolean query) {
        boolean needs;
        boolean bl = needs = s.indexOf(37) != -1;
        if (!needs && query) {
            needs = s.indexOf(43) != -1;
        }
        return needs;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UriEncoder.class, null, null);
        CHARSET_UTF_8 = Charset.forName("UTF-8");
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        normalizedHexDigits = new byte[128];
        isHexDigit = new boolean[128];
        unreservedChars = new boolean[128];
        userInfoChars = new boolean[128];
        segmentChars = new boolean[128];
        matrixChars = new boolean[128];
        pathChars = new boolean[128];
        queryChars = new boolean[128];
        queryParamChars = new boolean[128];
        fragmentChars = new boolean[128];
        uriChars = new boolean[128];
        uriTemplateChars = new boolean[128];
        Arrays.fill(unreservedChars, false);
        Arrays.fill(unreservedChars, 97, 123, true);
        Arrays.fill(unreservedChars, 65, 91, true);
        Arrays.fill(unreservedChars, 48, 58, true);
        UriEncoder.unreservedChars[45] = true;
        UriEncoder.unreservedChars[95] = true;
        UriEncoder.unreservedChars[46] = true;
        UriEncoder.unreservedChars[126] = true;
        System.arraycopy(unreservedChars, 0, userInfoChars, 0, 128);
        UriEncoder.userInfoChars[33] = true;
        UriEncoder.userInfoChars[36] = true;
        UriEncoder.userInfoChars[38] = true;
        UriEncoder.userInfoChars[39] = true;
        UriEncoder.userInfoChars[40] = true;
        UriEncoder.userInfoChars[41] = true;
        UriEncoder.userInfoChars[42] = true;
        UriEncoder.userInfoChars[43] = true;
        UriEncoder.userInfoChars[44] = true;
        UriEncoder.userInfoChars[59] = true;
        UriEncoder.userInfoChars[61] = true;
        UriEncoder.userInfoChars[58] = true;
        System.arraycopy(userInfoChars, 0, segmentChars, 0, 128);
        UriEncoder.segmentChars[64] = true;
        System.arraycopy(segmentChars, 0, matrixChars, 0, 128);
        UriEncoder.matrixChars[61] = false;
        UriEncoder.matrixChars[59] = false;
        System.arraycopy(segmentChars, 0, pathChars, 0, 128);
        UriEncoder.pathChars[47] = true;
        System.arraycopy(pathChars, 0, queryChars, 0, 128);
        UriEncoder.queryChars[63] = true;
        System.arraycopy(queryChars, 0, fragmentChars, 0, 128);
        System.arraycopy(queryChars, 0, queryParamChars, 0, 128);
        UriEncoder.queryParamChars[38] = false;
        UriEncoder.queryParamChars[61] = false;
        System.arraycopy(queryChars, 0, uriChars, 0, 128);
        UriEncoder.uriChars[35] = true;
        UriEncoder.uriChars[91] = true;
        UriEncoder.uriChars[93] = true;
        System.arraycopy(uriChars, 0, uriTemplateChars, 0, 128);
        UriEncoder.uriTemplateChars[123] = true;
        UriEncoder.uriTemplateChars[125] = true;
        Arrays.fill(isHexDigit, false);
        Arrays.fill(isHexDigit, 48, 58, true);
        Arrays.fill(isHexDigit, 97, 103, true);
        Arrays.fill(isHexDigit, 65, 71, true);
        UriEncoder.normalizedHexDigits[48] = 48;
        UriEncoder.normalizedHexDigits[49] = 49;
        UriEncoder.normalizedHexDigits[50] = 50;
        UriEncoder.normalizedHexDigits[51] = 51;
        UriEncoder.normalizedHexDigits[52] = 52;
        UriEncoder.normalizedHexDigits[53] = 53;
        UriEncoder.normalizedHexDigits[54] = 54;
        UriEncoder.normalizedHexDigits[55] = 55;
        UriEncoder.normalizedHexDigits[56] = 56;
        UriEncoder.normalizedHexDigits[57] = 57;
        UriEncoder.normalizedHexDigits[65] = 65;
        UriEncoder.normalizedHexDigits[66] = 66;
        UriEncoder.normalizedHexDigits[67] = 67;
        UriEncoder.normalizedHexDigits[68] = 68;
        UriEncoder.normalizedHexDigits[69] = 69;
        UriEncoder.normalizedHexDigits[70] = 70;
        UriEncoder.normalizedHexDigits[97] = 65;
        UriEncoder.normalizedHexDigits[98] = 66;
        UriEncoder.normalizedHexDigits[99] = 67;
        UriEncoder.normalizedHexDigits[100] = 68;
        UriEncoder.normalizedHexDigits[101] = 69;
        UriEncoder.normalizedHexDigits[102] = 70;
    }
}

