/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ClientProxyImpl
extends AbstractClient
implements InvocationHandlerAware,
InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    private static final String SLASH = "/";
    private static final String BUFFER_PROXY_RESPONSE = "buffer.proxy.response";
    private static final String PROXY_METHOD_PARAM_BODY_INDEX = "proxy.method.parameter.body.index";
    private final ClassResourceInfo cri;
    private final ClassLoader proxyLoader;
    private final boolean inheritHeaders;
    private final boolean isRoot;
    private Map<String, Object> valuesMap;
    private final BodyWriter bodyWriter;
    private Client proxy;
    static final long serialVersionUID = 676175704788399104L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        this(new LocalClientState(baseURI), loader, cri, isRoot, inheritHeaders, varValues);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "<init>", new Object[]{baseURI, loader, cri, isRoot, inheritHeaders, varValues});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(initialState);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "<init>", new Object[]{initialState, loader, cri, isRoot, inheritHeaders, varValues});
        }
        this.valuesMap = Collections.emptyMap();
        this.bodyWriter = new BodyWriter();
        this.proxyLoader = loader;
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
        this.cfg.getInInterceptors().add(new ClientAsyncResponseInterceptor());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setProxyClient(Client client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "setProxyClient", new Object[]{client});
        }
        this.proxy = client;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "setProxyClient");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initValuesMap(Object ... varValues) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "initValuesMap", new Object[]{varValues});
        }
        if (this.isRoot) {
            List<String> vars = this.cri.getURITemplate().getVariables();
            this.valuesMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < vars.size(); ++i) {
                if (varValues.length > 0) {
                    if (i < varValues.length) {
                        this.valuesMap.put(vars.get(i), varValues[i]);
                        continue;
                    }
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, vars.size(), varValues.length);
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put(vars.get(i), "");
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "initValuesMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = this.getParametersInfo(m, params, ori);
        List<Parameter> beanParamsList = ClientProxyImpl.getParameters(types, ParameterType.BEAN);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        List<Object> pathParams = this.getPathParamValues(m, params, types, beanParamsList, ori, bodyIndex);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            this.addNonEmptyPath(builder, ori.getClassResourceInfo().getURITemplate().getValue());
        }
        this.addNonEmptyPath(builder, ori.getURITemplate().getValue());
        this.handleMatrixes(m, params, types, beanParamsList, builder);
        this.handleQueries(m, params, types, beanParamsList, builder);
        URI uri = builder.buildFromEncoded(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap<String, String> paramHeaders = new MetadataMap<String, String>();
        this.handleHeaders(m, params, paramHeaders, beanParamsList, types);
        this.handleCookies(m, params, paramHeaders, beanParamsList, types);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            MetadataMap<String, String> subHeaders = paramHeaders;
            if (this.inheritHeaders) {
                subHeaders.putAll((Map)headers);
            }
            ClientState newState = this.getState().newState(uri, subHeaders, this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
            ClientProxyImpl proxyImpl = new ClientProxyImpl(newState, this.proxyLoader, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setConfiguration(this.getConfiguration());
            return JAXRSClientFactory.createProxy(m.getReturnType(), this.proxyLoader, proxyImpl);
        }
        headers.putAll(paramHeaders);
        this.getState().setTemplates(this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
        Object body = null;
        if (bodyIndex != -1) {
            body = params[bodyIndex];
            if (body == null) {
                bodyIndex = -1;
            }
        } else if (types.containsKey((Object)ParameterType.FORM)) {
            body = this.handleForm(m, params, types, beanParamsList);
        } else if (types.containsKey((Object)ParameterType.REQUEST_BODY)) {
            body = this.handleMultipart(types, ori, params);
        }
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), body == null ? null : body.getClass(), m.getReturnType());
        try {
            Object object = this.doChainedInvocation(uri, headers, ori, params, body, bodyIndex, null, null);
            return object;
        }
        finally {
            this.resetResponseStateImmediatelyIfNeeded();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addNonEmptyPath(UriBuilder builder, String pathValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "addNonEmptyPath", new Object[]{builder, pathValue});
        }
        if (!SLASH.equals(pathValue)) {
            builder.path(pathValue);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "addNonEmptyPath");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MultivaluedMap<ParameterType, Parameter> getParametersInfo(Method m, Object[] params, OperationResourceInfo ori) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParametersInfo", new Object[]{m, params, ori});
        }
        MetadataMap<ParameterType, Parameter> map = new MetadataMap<ParameterType, Parameter>();
        List<Parameter> parameters = ori.getParameters();
        if (parameters.size() == 0) {
            MetadataMap<ParameterType, Parameter> metadataMap = map;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                metadataMap = metadataMap;
                LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParametersInfo", metadataMap);
            }
            return metadataMap;
        }
        int requestBodyParam = 0;
        int multipartParam = 0;
        for (Parameter p : parameters) {
            if (this.isIgnorableParameter(m, p)) continue;
            if (p.getType() == ParameterType.REQUEST_BODY) {
                ++requestBodyParam;
                if (ClientProxyImpl.getMultipart(ori, p.getIndex()) != null) {
                    ++multipartParam;
                }
            }
            map.add((Object)p.getType(), p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (requestBodyParam > 1 && requestBodyParam != multipartParam) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "ONLY_FORM_ALLOWED");
            }
        }
        MetadataMap<ParameterType, Parameter> metadataMap = map;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParametersInfo", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isIgnorableParameter(Method m, Parameter p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "isIgnorableParameter", new Object[]{m, p});
        }
        if (p.getType() == ParameterType.CONTEXT) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "isIgnorableParameter", bl);
            }
            return bl;
        }
        boolean bl = p.getType() == ParameterType.REQUEST_BODY && m.getParameterTypes()[p.getIndex()] == AsyncResponse.class;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "isIgnorableParameter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getBodyIndex", new Object[]{map, ori});
        }
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null || list.size() > 1 ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        int n2 = index;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n2 = n2;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getBodyIndex", n2);
        }
        return n2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkResponse", new Object[]{m, r, inMessage});
        }
        WebApplicationException t = null;
        int status = r.getStatus();
        if (status >= 300) {
            Class<?>[] exTypes = m.getExceptionTypes();
            if (exTypes.length == 0) {
                exTypes = new Class[]{WebApplicationException.class};
            }
            for (Class<?> exType : exTypes) {
                ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(inMessage, exType);
                if (mapper == null || (t = mapper.fromResponse(r)) == null) continue;
                throw t;
            }
            if (t == null && m.getReturnType() == Response.class && m.getExceptionTypes().length == 0) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkResponse");
                }
                return;
            }
            t = this.convertToWebApplicationException(r);
            if (inMessage.getExchange().get(Message.RESPONSE_CODE) == null) {
                throw t;
            }
            Endpoint ep = inMessage.getExchange().getEndpoint();
            inMessage.getExchange().put(InterceptorProvider.class, this.getConfiguration());
            inMessage.setContent(Exception.class, new Fault(t));
            inMessage.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(inMessage);
            }
            throw t;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static ResponseExceptionMapper<?> findExceptionMapper(Message message, Class<?> exType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "findExceptionMapper", new Object[]{message, exType});
        }
        ClientProviderFactory pf = ClientProviderFactory.getInstance(message);
        ResponseExceptionMapper responseExceptionMapper = pf.createResponseExceptionMapper(message, exType);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            responseExceptionMapper = responseExceptionMapper;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "findExceptionMapper", responseExceptionMapper);
        }
        return responseExceptionMapper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<MediaType> accepts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "setRequestHeaders", new Object[]{headers, ori, formParams, bodyClass, responseClass});
        }
        if (headers.getFirst((Object)"Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            } else {
                String ctType = null;
                List<MediaType> consumeTypes = ori.getConsumeTypes();
                if (!consumeTypes.isEmpty() && !consumeTypes.get(0).equals((Object)MediaType.WILDCARD_TYPE)) {
                    ctType = JAXRSUtils.mediaTypeToString(ori.getConsumeTypes().get(0), new String[0]);
                }
                if (ctType != null) {
                    headers.putSingle((Object)"Content-Type", ctType);
                }
            }
        }
        if ((accepts = this.getAccept(headers)) == null) {
            boolean produceWildcard;
            boolean bl = produceWildcard = ori.getProduceTypes().size() == 0 || ori.getProduceTypes().get(0).equals((Object)MediaType.WILDCARD_TYPE);
            accepts = produceWildcard ? (InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : Collections.singletonList(MediaType.APPLICATION_XML_TYPE)) : (responseClass == Void.class || responseClass == Void.TYPE ? Collections.singletonList(MediaType.WILDCARD_TYPE) : ori.getProduceTypes());
            for (MediaType mt : accepts) {
                headers.add((Object)"Accept", (Object)JAXRSUtils.mediaTypeToString(mt, new String[0]));
            }
        }
        MultivaluedMap<String, String> multivaluedMap = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "setRequestHeaders", multivaluedMap);
        }
        return multivaluedMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<MediaType> getAccept(MultivaluedMap<String, String> allHeaders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getAccept", new Object[]{allHeaders});
        }
        List headers = (List)allHeaders.get((Object)"Accept");
        if (headers == null || headers.size() == 0) {
            List<MediaType> list = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getAccept", list);
            }
            return list;
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String s : headers) {
            types.addAll(JAXRSUtils.parseMediaTypes(s));
        }
        ArrayList<MediaType> arrayList = types;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getAccept", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<Object> getPathParamValues(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, OperationResourceInfo ori, int bodyIndex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getPathParamValues", new Object[]{m, params, map, beanParams, ori, bodyIndex});
        }
        LinkedList<Object> list = new LinkedList<Object>();
        List<String> methodVars = ori.getURITemplate().getVariables();
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        HashMap<String, BeanPair> beanParamValues = new HashMap<String, BeanPair>(beanParams.size());
        for (Parameter parameter : beanParams) {
            beanParamValues.putAll(this.getValuesFromBeanParam(params[parameter.getIndex()], PathParam.class));
        }
        if (!beanParamValues.isEmpty() && !methodVars.containsAll(beanParamValues.keySet())) {
            List<String> classVars = ori.getClassResourceInfo().getURITemplate().getVariables();
            for (String classVar : classVars) {
                BeanPair pair = (BeanPair)beanParamValues.get(classVar);
                if (pair == null) continue;
                String paramValue = this.convertParamValue(pair.getValue(), pair.getAnns());
                if (this.isRoot) {
                    this.valuesMap.put(classVar, paramValue);
                    continue;
                }
                list.add(paramValue);
            }
        }
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        LinkedHashMap<String, Parameter> paramsMap = new LinkedHashMap<String, Parameter>();
        for (Parameter p : paramsList) {
            if (p.getName().length() == 0) {
                MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(params[p.getIndex()], "");
                for (String var : methodVars) {
                    list.addAll((Collection)values.get((Object)var));
                }
                continue;
            }
            paramsMap.put(p.getName(), p);
        }
        Object object = bodyIndex == -1 ? null : params[bodyIndex];
        for (String varName : methodVars) {
            Parameter p = (Parameter)paramsMap.remove(varName);
            if (p != null) {
                list.add(this.convertParamValue(params[p.getIndex()], m.getParameterTypes()[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
                continue;
            }
            if (beanParamValues.containsKey(varName)) {
                BeanPair pair = (BeanPair)beanParamValues.get(varName);
                list.add(this.convertParamValue(pair.getValue(), pair.getAnns()));
                continue;
            }
            if (object == null) continue;
            try {
                Method getter = object.getClass().getMethod("get" + StringUtils.capitalize(varName), new Class[0]);
                list.add(getter.invoke(object, new Object[0]));
            }
            catch (Exception getter) {
                FFDCFilter.processException((Throwable)getter, (String)"org.apache.cxf.jaxrs.client.ClientProxyImpl", (String)"463", (Object)this, (Object[])new Object[]{m, params, map, beanParams, ori, bodyIndex});
            }
        }
        block7: for (Parameter p : paramsMap.values()) {
            if (!this.valuesMap.containsKey(p.getName())) continue;
            int index = 0;
            Iterator<String> it = this.valuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().equals(p.getName()) && index < list.size()) {
                    list.remove(index);
                    list.add(index, this.convertParamValue(params[p.getIndex()], null));
                    continue block7;
                }
                ++index;
            }
        }
        LinkedList<Object> linkedList = list;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getPathParamValues", linkedList);
        }
        return linkedList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Annotation[] getParamAnnotations(Method m, Parameter p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParamAnnotations", new Object[]{m, p});
        }
        Annotation[] annotationArray = m.getParameterAnnotations()[p.getIndex()];
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParamAnnotations", annotationArray);
        }
        return annotationArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParameters", new Object[]{map, key});
        }
        List list = map.get((Object)key) == null ? Collections.EMPTY_LIST : (List)map.get((Object)key);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getParameters", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleQueries(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleQueries", new Object[]{m, params, map, beanParams, ub});
        }
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        for (Parameter p : qs) {
            if (params[p.getIndex()] == null) continue;
            this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.QUERY, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]);
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], QueryParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                this.addMatrixQueryParamsToBuilder(ub, entry.getKey(), ParameterType.QUERY, entry.getValue().getAnns(), entry.getValue().getValue());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleQueries");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, BeanPair> getValuesFromBeanParam(Object bean, Class<? extends Annotation> annClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParam", new Object[]{bean, annClass});
        }
        HashMap<String, BeanPair> values = new HashMap<String, BeanPair>();
        this.getValuesFromBeanParam(bean, annClass, values);
        HashMap<String, BeanPair> hashMap = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParam", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, BeanPair> getValuesFromBeanParam(Object bean, Class<? extends Annotation> annClass, Map<String, BeanPair> values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParam", new Object[]{bean, annClass, values});
        }
        boolean completeFieldIntrospectionNeeded = false;
        for (Method m : bean.getClass().getMethods()) {
            if (m.getName().startsWith("set")) {
                try {
                    boolean beanParam;
                    String propertyName = m.getName().substring(3);
                    Annotation methodAnnotation = m.getAnnotation(annClass);
                    boolean bl = beanParam = m.getAnnotation(BeanParam.class) != null;
                    if (methodAnnotation != null || beanParam) {
                        Method getter = bean.getClass().getMethod("get" + propertyName, new Class[0]);
                        Object value = getter.invoke(bean, new Object[0]);
                        if (value != null) {
                            if (methodAnnotation != null) {
                                String annotationValue = AnnotationUtils.getAnnotationValue(methodAnnotation);
                                values.put(annotationValue, new BeanPair(value, m.getParameterAnnotations()[0]));
                            } else {
                                this.getValuesFromBeanParam(value, annClass, values);
                            }
                        }
                    } else {
                        Object value;
                        String fieldName = StringUtils.uncapitalize(propertyName);
                        Field f = InjectionUtils.getDeclaredField(bean.getClass(), fieldName);
                        if (f == null) {
                            completeFieldIntrospectionNeeded = true;
                            continue;
                        }
                        boolean jaxrsParamAnnAvailable = this.getValuesFromBeanParamField(bean, f, annClass, values);
                        if (!jaxrsParamAnnAvailable && f.getAnnotation(BeanParam.class) != null && (value = ReflectionUtil.accessDeclaredField(f, bean, Object.class)) != null) {
                            this.getValuesFromBeanParam(value, annClass, values);
                        }
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.client.ClientProxyImpl", (String)"560", (Object)this, (Object[])new Object[]{bean, annClass, values});
                }
            }
            if (!completeFieldIntrospectionNeeded) continue;
            for (Field f : bean.getClass().getDeclaredFields()) {
                Object value;
                boolean jaxrsParamAnnAvailable = this.getValuesFromBeanParamField(bean, f, annClass, values);
                if (jaxrsParamAnnAvailable || f.getAnnotation(BeanParam.class) == null || (value = ReflectionUtil.accessDeclaredField(f, bean, Object.class)) == null) continue;
                this.getValuesFromBeanParam(value, annClass, values);
            }
        }
        Map<String, BeanPair> map = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParam", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean getValuesFromBeanParamField(Object bean, Field f, Class<? extends Annotation> annClass, Map<String, BeanPair> values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParamField", new Object[]{bean, f, annClass, values});
        }
        boolean jaxrsParamAnnAvailable = false;
        Annotation fieldAnnotation = f.getAnnotation(annClass);
        if (fieldAnnotation != null) {
            jaxrsParamAnnAvailable = true;
            Object value = ReflectionUtil.accessDeclaredField(f, bean, Object.class);
            if (value != null) {
                String annotationValue = AnnotationUtils.getAnnotationValue(fieldAnnotation);
                values.put(annotationValue, new BeanPair(value, f.getAnnotations()));
            }
        }
        boolean bl = jaxrsParamAnnAvailable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getValuesFromBeanParamField", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleMatrixes(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleMatrixes", new Object[]{m, params, map, beanParams, ub});
        }
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        for (Parameter p : mx) {
            if (params[p.getIndex()] == null) continue;
            this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.MATRIX, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]);
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], MatrixParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                this.addMatrixQueryParamsToBuilder(ub, entry.getKey(), ParameterType.MATRIX, entry.getValue().getAnns(), entry.getValue().getValue());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleMatrixes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MultivaluedMap<String, String> handleForm(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleForm", new Object[]{m, params, map, beanParams});
        }
        MetadataMap<String, String> form = new MetadataMap<String, String>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        for (Parameter p : fm) {
            this.addFormValue(form, p.getName(), params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], FormParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                this.addFormValue(form, entry.getKey(), entry.getValue().getValue(), entry.getValue().getAnns());
            }
        }
        MetadataMap<String, String> metadataMap = form;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleForm", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addFormValue(MultivaluedMap<String, String> form, String name, Object pValue, Annotation[] anns) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "addFormValue", new Object[]{form, name, pValue, anns});
        }
        if (pValue != null) {
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    FormUtils.addPropertyToForm(form, name, this.convertParamValue(it.next(), anns));
                }
            } else {
                FormUtils.addPropertyToForm(form, name, name.isEmpty() ? pValue : this.convertParamValue(pValue, anns));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "addFormValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<Attachment> handleMultipart(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori, Object[] params) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleMultipart", new Object[]{map, ori, params});
        }
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.REQUEST_BODY);
        for (Parameter p : fm) {
            Object partObject;
            Multipart part = ClientProxyImpl.getMultipart(ori, p.getIndex());
            if (part == null || (partObject = params[p.getIndex()]) == null) continue;
            atts.add(new Attachment(part.value(), part.type(), partObject));
        }
        LinkedList<Attachment> linkedList = atts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleMultipart", linkedList);
        }
        return linkedList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleHeaders(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleHeaders", new Object[]{m, params, headers, beanParams, map});
        }
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        for (Parameter p : hs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)p.getName(), (Object)this.convertParamValue(params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], HeaderParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                headers.add((Object)entry.getKey(), (Object)this.convertParamValue(entry.getValue().getValue(), entry.getValue().getAnns()));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Multipart getMultipart(OperationResourceInfo ori, int index) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getMultipart", new Object[]{ori, index});
        }
        Method aMethod = ori.getAnnotatedMethod();
        Multipart multipart = aMethod != null ? AnnotationUtils.getAnnotation(aMethod.getParameterAnnotations()[index], Multipart.class) : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multipart = multipart;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getMultipart", multipart);
        }
        return multipart;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleCookies(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleCookies", new Object[]{m, params, headers, beanParams, map});
        }
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        for (Parameter p : cs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)"Cookie", (Object)(p.getName() + '=' + this.convertParamValue(params[p.getIndex()].toString(), ClientProxyImpl.getParamAnnotations(m, p))));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], CookieParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                headers.add((Object)"Cookie", (Object)(entry.getKey() + "=" + this.convertParamValue(entry.getValue().getValue(), entry.getValue().getAnns())));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleCookies");
        }
    }

    /*
     * Exception decompiling
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object[] methodParams, Object body, int bodyIndex, Exchange exchange, Map<String, Object> invocationContext) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Message createMessage(Object body, OperationResourceInfo ori, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean isProxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "createMessage", new Object[]{body, ori, headers, currentURI, exchange, invocationContext, isProxy});
        }
        Message message = this.createMessage(body, ori.getHttpMethod(), headers, currentURI, exchange, invocationContext, isProxy);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "createMessage", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InvocationCallback<Object> checkAsyncCallback(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkAsyncCallback", new Object[]{ori, reqContext, outMessage});
        }
        Object callbackProp = reqContext.get(InvocationCallback.class.getName());
        if (callbackProp != null) {
            if (callbackProp instanceof Collection) {
                Collection callbacks = (Collection)callbackProp;
                for (InvocationCallback callback : callbacks) {
                    if (this.doCheckAsyncCallback(ori, (InvocationCallback<Object>)callback) == null) continue;
                    InvocationCallback invocationCallback = callback;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        invocationCallback = invocationCallback;
                        LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkAsyncCallback", invocationCallback);
                    }
                    return invocationCallback;
                }
            } else {
                InvocationCallback callback = (InvocationCallback)callbackProp;
                InvocationCallback<Object> invocationCallback = this.doCheckAsyncCallback(ori, (InvocationCallback<Object>)callback);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    invocationCallback = invocationCallback;
                    LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkAsyncCallback", invocationCallback);
                }
                return invocationCallback;
            }
        }
        InvocationCallback<Object> invocationCallback = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            invocationCallback = invocationCallback;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "checkAsyncCallback", invocationCallback);
        }
        return invocationCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private InvocationCallback<Object> doCheckAsyncCallback(OperationResourceInfo ori, InvocationCallback<Object> callback) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "doCheckAsyncCallback", new Object[]{ori, callback});
        }
        Type callbackOutType = ClientProxyImpl.getCallbackType(callback);
        Class<?> callbackRespClass = ClientProxyImpl.getCallbackClass(callbackOutType);
        Class<?> methodReturnType = ori.getMethodToInvoke().getReturnType();
        if (Object.class == callbackRespClass || callbackRespClass.isAssignableFrom(methodReturnType) || PrimitiveUtils.canPrimitiveTypeBeAutoboxed(methodReturnType, callbackRespClass)) {
            InvocationCallback<Object> invocationCallback = callback;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                invocationCallback = invocationCallback;
                LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "doCheckAsyncCallback", invocationCallback);
            }
            return invocationCallback;
        }
        InvocationCallback<Object> invocationCallback = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            invocationCallback = invocationCallback;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "doCheckAsyncCallback", invocationCallback);
        }
        return invocationCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object doInvokeAsync(OperationResourceInfo ori, Message outMessage, InvocationCallback<Object> asyncCallback) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "doInvokeAsync", new Object[]{ori, outMessage, asyncCallback});
        }
        outMessage.getExchange().setSynchronous(false);
        this.setAsyncMessageObserverIfNeeded(outMessage.getExchange());
        JaxrsClientCallback<?> cb = this.newJaxrsClientCallback(asyncCallback, outMessage, ori.getMethodToInvoke().getReturnType(), ori.getMethodToInvoke().getGenericReturnType());
        outMessage.getExchange().put(JaxrsClientCallback.class, cb);
        this.doRunInterceptorChain(outMessage);
        Object v0 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            v0 = v0;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "doInvokeAsync", v0);
        }
        return v0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected JaxrsClientCallback<?> newJaxrsClientCallback(InvocationCallback<Object> asyncCallback, Message outMessage, Class<?> responseClass, Type outGenericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "newJaxrsClientCallback", new Object[]{asyncCallback, outMessage, responseClass, outGenericType});
        }
        JaxrsClientCallback<Object> jaxrsClientCallback = new JaxrsClientCallback<Object>(asyncCallback, responseClass, outGenericType);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jaxrsClientCallback = jaxrsClientCallback;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "newJaxrsClientCallback", jaxrsClientCallback);
        }
        return jaxrsClientCallback;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "retryInvoke", new Object[]{newRequestURI, headers, body, exchange, invContext});
        }
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        int bodyIndex = body != null ? (Integer)reqContext.get(PROXY_METHOD_PARAM_BODY_INDEX) : -1;
        OperationResourceInfo ori = (OperationResourceInfo)reqContext.get(OperationResourceInfo.class.getName());
        Object object = this.doChainedInvocation(newRequestURI, headers, ori, null, body, bodyIndex, exchange, invContext);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "retryInvoke", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object handleResponse(Message outMessage, Class<?> serviceCls) throws Throwable {
        Object obj;
        block11: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleResponse", new Object[]{outMessage, serviceCls});
            }
            Response r = this.setResponseBuilder(outMessage, outMessage.getExchange()).build();
            ((ResponseImpl)r).setOutMessage(outMessage);
            this.getState().setResponse(r);
            Method method = outMessage.getExchange().get(Method.class);
            this.checkResponse(method, r, outMessage);
            if (method.getReturnType() == Void.class || method.getReturnType() == Void.TYPE) {
                Object var5_5 = null;
                Object v0 = var5_5;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    v0 = v0;
                    LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleResponse", v0);
                }
                return v0;
            }
            if (method.getReturnType() == Response.class && (r.getEntity() == null || InputStream.class.isAssignableFrom(r.getEntity().getClass()) && ((InputStream)r.getEntity()).available() == 0)) {
                Response response = r;
                Response response2 = response;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    response2 = response2;
                    LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleResponse", response2);
                }
                return response2;
            }
            if (PropertyUtils.isTrue(super.getConfiguration().getResponseContext().get(BUFFER_PROXY_RESPONSE))) {
                r.bufferEntity();
            }
            Class<?> returnType = this.getReturnType(method, outMessage);
            Type genericType = InjectionUtils.processGenericTypeIfNeeded(serviceCls, returnType, method.getGenericReturnType());
            returnType = InjectionUtils.updateParamClassToTypeIfNeeded(returnType, genericType);
            Object obj2 = this.readBody(r, outMessage, returnType, genericType, method.getDeclaredAnnotations());
            obj = obj2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
            obj = obj;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "handleResponse", obj);
        }
        return obj;
        finally {
            ClientProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Class<?> getReturnType(Method method, Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getReturnType", new Object[]{method, outMessage});
        }
        Class<?> clazz = method.getReturnType();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getReturnType", clazz);
        }
        return clazz;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getInvocationHandler() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getInvocationHandler", new Object[0]);
        }
        ClientProxyImpl clientProxyImpl = this;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clientProxyImpl = clientProxyImpl;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getInvocationHandler", clientProxyImpl);
        }
        return clientProxyImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void reportInvalidResourceMethod(Method m, String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "reportInvalidResourceMethod", new Object[]{m, name});
        }
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, m.getDeclaringClass().getName(), m.getName());
        LOG.severe(errorMsg.toString());
        throw new ProcessingException(errorMsg.toString());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static Annotation[] getMethodAnnotations(Method aMethod, int bodyIndex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getMethodAnnotations", new Object[]{aMethod, bodyIndex});
        }
        Annotation[] annotationArray = aMethod == null || bodyIndex == -1 ? new Annotation[]{} : aMethod.getParameterAnnotations()[bodyIndex];
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.jaxrs.client.ClientProxyImpl", "getMethodAnnotations", annotationArray);
        }
        return annotationArray;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ClientAsyncResponseInterceptor
    extends AbstractClient.AbstractClientAsyncResponseInterceptor {
        static final long serialVersionUID = 4655091601759093467L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClientAsyncResponseInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @FFDCIgnore(value={Throwable.class})
        protected void doHandleAsyncResponse(Message message, Response r, JaxrsClientCallback<?> cb) {
            try {
                Object entity = ClientProxyImpl.this.handleResponse(message.getExchange().getOutMessage(), cb.getResponseClass());
                cb.handleResponse(message, new Object[]{entity});
            }
            catch (Throwable t) {
                cb.handleException(message, t);
            }
            finally {
                ClientProxyImpl.this.completeExchange(message.getExchange(), false);
                this.closeAsyncResponseIfPossible(r, message, cb);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClientAsyncResponseInterceptor.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BeanPair {
        private final Object value;
        private final Annotation[] anns;
        static final long serialVersionUID = 9127840175637395188L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BeanPair(Object value, Annotation[] anns) {
            this.value = value;
            this.anns = anns;
        }

        public Object getValue() {
            return this.value;
        }

        public Annotation[] getAnns() {
            return this.anns;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BeanPair.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class BodyWriter
    extends AbstractClient.AbstractBodyWriter {
        static final long serialVersionUID = -7311158038355933660L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BodyWriter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doWriteBody(Message outMessage, Object body, Type bodyType, Annotation[] customAnns, OutputStream os) throws Fault {
            OperationResourceInfo ori = outMessage.getContent(OperationResourceInfo.class);
            if (ori == null) {
                return;
            }
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)outMessage.get(ClientProxyImpl.PROXY_METHOD_PARAM_BODY_INDEX);
            Annotation[] anns = customAnns != null ? customAnns : ClientProxyImpl.getMethodAnnotations(ori.getAnnotatedMethod(), bodyIndex);
            try {
                if (bodyIndex != -1) {
                    Class<?> paramClass = method.getParameterTypes()[bodyIndex];
                    Class<?> bodyClass = paramClass.isAssignableFrom(body.getClass()) ? paramClass : body.getClass();
                    Type genericType = method.getGenericParameterTypes()[bodyIndex];
                    if (bodyType != null) {
                        genericType = bodyType;
                    }
                    genericType = InjectionUtils.processGenericTypeIfNeeded(ori.getClassResourceInfo().getServiceClass(), bodyClass, genericType);
                    bodyClass = InjectionUtils.updateParamClassToTypeIfNeeded(bodyClass, genericType);
                    ClientProxyImpl.this.writeBody(body, outMessage, bodyClass, genericType, anns, os);
                } else {
                    Type paramType = body.getClass();
                    if (bodyType != null) {
                        paramType = bodyType;
                    }
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), paramType, anns, os);
                }
            }
            catch (Exception paramType) {
                void ex;
                FFDCFilter.processException((Throwable)paramType, (String)"org.apache.cxf.jaxrs.client.ClientProxyImpl$BodyWriter", (String)"977", (Object)this, (Object[])new Object[]{outMessage, body, bodyType, customAnns, os});
                throw new Fault((Throwable)ex);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BodyWriter.class, null, null);
        }
    }
}

